/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.CommdSpecBo;
import com.tydic.commodity.base.bo.SkuInfoSpecBo;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSearchDisableWordscheckAtomService;
import com.tydic.commodity.busibase.busi.api.UccOrgAgrWhiteRestrictionBusiService;
import com.tydic.commodity.busibase.busi.bo.UccOrgSkuWhiteRestrictionBo;
import com.tydic.commodity.busibase.busi.bo.UccOrgSkuWhiteRestrictionBusiReqBo;
import com.tydic.commodity.busibase.comb.api.UccCodegenerationCombService;
import com.tydic.commodity.busibase.comb.bo.UccCodegenerationCombReqBO;
import com.tydic.commodity.busibase.comb.bo.UccCodegenerationCombRspBO;
import com.tydic.commodity.dao.SupplierMapper;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityDetailMapper;
import com.tydic.commodity.dao.UccCommodityExpandMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPackageMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccCommodityPropDefMapper;
import com.tydic.commodity.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.dao.UccCommodityServiceMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccPropValueListMapper;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSkuAnnexExtMapper;
import com.tydic.commodity.dao.UccSkuDetailMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.dao.UccSkuSpecMapper;
import com.tydic.commodity.dao.UccSpuSpecMapper;
import com.tydic.commodity.dao.UccTemporaryPropDefMapper;
import com.tydic.commodity.dao.UccTemporaryPropValueMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.po.UccCommdPropDefPo;
import com.tydic.commodity.po.UccCommodityDetailPO;
import com.tydic.commodity.po.UccCommodityExpandPO;
import com.tydic.commodity.po.UccCommodityPackagePo;
import com.tydic.commodity.po.UccCommodityPicPo;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccCommodityServicePO;
import com.tydic.commodity.po.UccGrpRelDefValuePO;
import com.tydic.commodity.po.UccPropValueListPo;
import com.tydic.commodity.po.UccSaleNumPo;
import com.tydic.commodity.po.UccSkuPicPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.po.UccSkuPutCirPo;
import com.tydic.commodity.po.UccSkuSpecPo;
import com.tydic.commodity.po.UccSpuSpecPo;
import com.tydic.commodity.po.UccTemporaryPropDefPO;
import com.tydic.commodity.po.UccTemporaryPropValuePO;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.commodity.zone.ability.api.UccSpuAttributeImportServiceAbilityService;
import com.tydic.commodity.zone.ability.bo.UccExcelCommodityAttrButesBO;
import com.tydic.commodity.zone.ability.bo.UccSpuAttributeImportServiceAbilityReqBo;
import com.tydic.commodity.zone.ability.bo.UccSpuAttributeImportServiceAbilityRspBo;
import com.tydic.commodity.zone.ability.bo.UccZoneCommodityCreateBusiReqBO;
import com.tydic.commodity.zone.ability.bo.UccZoneCommodityCreateBusiRspBO;
import com.tydic.commodity.zone.ability.bo.UccZoneSkuBO;
import com.tydic.commodity.zone.busi.api.UccZoneCommodityCreateBusiService;
import com.tydic.smcsdk.api.SmcsdkOperateStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumRspBO;
import com.tydic.smcsdk.api.bo.SmcsdkStockNumInfoBO;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class UccZoneCommodityCreateBusiServiceImpl
implements UccZoneCommodityCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccZoneCommodityCreateBusiServiceImpl.class);
    @Autowired
    private UccOrgAgrWhiteRestrictionBusiService uccOrgAgrWhiteRestrictionBusiService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSearchDisableWordscheckAtomService uccSearchDisableWordscheckAtomService;
    @Autowired
    private UccCodegenerationCombService uccCodegenerationAbilityService;
    @Autowired
    private UccPropValueListMapper uccPropValueListMapper;
    @Autowired
    private UccCommodityPropDefMapper uccCommodityPropDefMapper;
    private Sequence uccBrandSequence = Sequence.getInstance();
    @Autowired
    private UccTemporaryPropValueMapper uccTemporaryPropValueMapper;
    private Sequence sequence = Sequence.getInstance();
    @Autowired
    private SupplierMapper supplierMapper;
    @Autowired
    private UccVendorMapper uccVendorMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private UccSpuSpecMapper uccSpuSpecMapper;
    @Autowired
    private UccCommodityPackageMapper uccCommodityPackageMapper;
    @Autowired
    private UccCommodityExpandMapper uccCommodityExpandMapper;
    @Autowired
    private UccCommodityServiceMapper uccCommodityServiceMapper;
    @Autowired
    private UccSkuAnnexExtMapper uccSkuAnnexExtMapper;
    @Autowired
    private UccCommodityDetailMapper uccCommodityDetailMapper;
    @Resource(name="uccCommodityIdSequence")
    private OrderSequence orderSequence;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuDetailMapper uccSkuDetailMapper;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSaleNumMapper uccSaleNumMapper;
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private SmcsdkOperateStockNumService smcsdkOperateStockNumService;
    @Resource(name="uccSkuIdSequence")
    private OrderSequence orderSequence2;
    @Autowired
    private UccTemporaryPropDefMapper uccTemporaryPropDefMapper;
    @Autowired
    private UccSpuAttributeImportServiceAbilityService uccSpuAttributeImportServiceAbilityService;

    @Override
    public UccZoneCommodityCreateBusiRspBO createCommodity(UccZoneCommodityCreateBusiReqBO reqBO) {
        UccZoneCommodityCreateBusiRspBO rspBO = new UccZoneCommodityCreateBusiRspBO();
        String commodityCode = reqBO.getCommd().getCommodityCode();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCommd().getCommdAttrGroups())) {
            for (UccExcelCommodityAttrButesBO commdAttrGroup : reqBO.getCommd().getCommdAttrGroups()) {
                if (ObjectUtil.isEmpty((Object)commdAttrGroup.getPropScope()) || commdAttrGroup.getPropScope() != 1) continue;
                Long attrValueListId = this.dealAddAttrValues(reqBO, commdAttrGroup, commodityCode);
                commdAttrGroup.setPropValueListId(attrValueListId);
                commdAttrGroup.setPropScope(Integer.valueOf(0));
            }
            String skuJsonString = JSONArray.toJSONString((Object)reqBO.getCommd().getCommdAttrGroups());
            List spuSpec = JSONArray.parseArray((String)skuJsonString, CommdSpecBo.class);
            String checkStr = this.checkSpuProp(spuSpec, reqBO.getCommd().getCommodityTypeId(), reqBO.getCommd().getVendorId(), commodityCode);
            if (!StringUtils.isEmpty((Object)checkStr)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(checkStr);
                return rspBO;
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCommd().getSkuBOS())) {
            int i = 0;
            HashMap<String, Long> defValueMap = new HashMap<String, Long>();
            for (UccZoneSkuBO each2 : reqBO.getCommd().getSkuBOS()) {
                for (UccExcelCommodityAttrButesBO commdAttrGroup : each2.getSkuAttrGroups()) {
                    UccPropValueListPo propValueListPo = this.uccPropValueListMapper.getBySup(commdAttrGroup.getCommodityPropDefId(), reqBO.getCommd().getVendorId().toString(), commdAttrGroup.getPropValue());
                    if (!ObjectUtils.isEmpty((Object)propValueListPo)) {
                        commdAttrGroup.setPropValueListId(propValueListPo.getPropValueListId());
                        commdAttrGroup.setPropScope(Integer.valueOf(0));
                    }
                    if (ObjectUtil.isEmpty((Object)commdAttrGroup.getPropScope()) || commdAttrGroup.getPropScope() != 1) continue;
                    String defValueKey = commdAttrGroup.getCommodityPropDefId() + "-" + commdAttrGroup.getPropValue();
                    if (!MapUtils.isEmpty(defValueMap) && defValueMap.containsKey(defValueKey)) {
                        commdAttrGroup.setPropValueListId((Long)defValueMap.get(defValueKey));
                        commdAttrGroup.setPropScope(Integer.valueOf(0));
                        continue;
                    }
                    Long attrListId = this.dealAddAttrValues(reqBO, commdAttrGroup, commodityCode);
                    commdAttrGroup.setPropValueListId(attrListId);
                    commdAttrGroup.setPropScope(Integer.valueOf(0));
                    if (!MapUtils.isEmpty(defValueMap) && defValueMap.containsKey(defValueKey)) continue;
                    defValueMap.put(defValueKey, attrListId);
                }
                ++i;
            }
        }
        UccCommodityPo uccCommodityPo = new UccCommodityPo();
        BeanUtils.copyProperties((Object)reqBO.getCommd(), (Object)uccCommodityPo);
        uccCommodityPo.setOtherSourceId(reqBO.getCommd().getAgreementId());
        uccCommodityPo.setCreateOperId(reqBO.getUserId().toString());
        uccCommodityPo.setCreateOperName(reqBO.getUsername());
        uccCommodityPo.setOrgId(reqBO.getCommd().getVendorId().toString());
        uccCommodityPo.setOrgName(reqBO.getCommd().getVendorName());
        uccCommodityPo.setCommodityStatus(Integer.valueOf(0));
        uccCommodityPo.setCommoditySource(Integer.valueOf(3));
        uccCommodityPo.setCommodityCode(commodityCode);
        uccCommodityPo.setSupplierShopId(reqBO.getCommd().getVendorId());
        uccCommodityPo.setShopName(reqBO.getCommd().getVendorName());
        uccCommodityPo.setTaxCatCode(reqBO.getCommd().getTaxCode());
        uccCommodityPo.setStoreGetType(Integer.valueOf(1));
        try {
            uccCommodityPo.setCommodityId(Long.valueOf(this.orderSequence.nextId()));
        }
        catch (SQLException e) {
            throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), "\u5e8f\u5217\u751f\u6210\u5931\u8d25\uff01");
        }
        if (reqBO.getCommd().getAgreementId() != null) {
            uccCommodityPo.setAgreementId(reqBO.getCommd().getAgreementId().toString());
        }
        this.uccCommodityMapper.addcommodity(uccCommodityPo);
        rspBO.setCommodityId(uccCommodityPo.getCommodityId());
        uccCommodityPo.setCreateOperId(reqBO.getUserId().toString());
        uccCommodityPo.setCreateOperName(reqBO.getUsername());
        for (int i = 1; i < 6; ++i) {
            UccCommodityPicPo uccCommodityPicPo = new UccCommodityPicPo();
            if (i == 1) {
                uccCommodityPicPo.setCommodityPicType(Integer.valueOf(1));
            } else {
                uccCommodityPicPo.setCommodityPicType(Integer.valueOf(2));
            }
            uccCommodityPicPo.setCommodityPicId(Long.valueOf(this.sequence.nextId()));
            uccCommodityPicPo.setCommodityId(uccCommodityPo.getCommodityId());
            uccCommodityPicPo.setSupplierShopId(uccCommodityPo.getSupplierShopId());
            uccCommodityPicPo.setCreateOperId(reqBO.getUserId().toString());
            uccCommodityPicPo.setCreateTime(new Date(System.currentTimeMillis()));
            uccCommodityPicPo.setPicOrder(Integer.valueOf(i));
            this.uccCommodityPicMapper.addcommodityPic(uccCommodityPicPo);
        }
        if (!StringUtils.isEmpty((Object)reqBO.getCommd().getCommodityPcDetailChar())) {
            UccCommodityDetailPO uccCommodityDetailPO = new UccCommodityDetailPO();
            BeanUtils.copyProperties((Object)reqBO.getCommd(), (Object)uccCommodityDetailPO);
            uccCommodityDetailPO.setCommodityPcDetailUrl(reqBO.getCommd().getCommodityPcDetailChar());
            uccCommodityDetailPO.setCommodityId(uccCommodityPo.getCommodityId());
            uccCommodityDetailPO.setSupplierShopId(reqBO.getCommd().getVendorId());
            try {
                this.uccCommodityDetailMapper.insert(uccCommodityDetailPO);
            }
            catch (Exception e) {
                log.error("\u5546\u54c1\u6570\u636e\u5f02\u5e38\uff1a" + e.getMessage());
                throw new BusinessException(RspConstantEnums.GOODS_SUBJECTTOC_CREATE_FAIL.code(), e.getMessage());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCommd().getCommdAttrGroups())) {
            List spuSpecPos = null;
            spuSpecPos = JSONObject.parseArray((String)JSONObject.toJSONString((Object)reqBO.getCommd().getCommdAttrGroups()), UccSpuSpecPo.class);
            spuSpecPos.stream().forEach(each -> {
                each.setCommodityId(uccCommodityPo.getCommodityId());
                each.setSupplierShopId(reqBO.getCommd().getVendorId());
                each.setCreateOperId(reqBO.getUserId().toString());
                each.setCommoditySpecId(Long.valueOf(this.sequence.nextId()));
                each.setPropShowName(each.getPropName());
            });
            try {
                this.uccSpuSpecMapper.batchInsert(spuSpecPos);
            }
            catch (Exception e) {
                log.error("\u5546\u54c1\u6570\u636e\u5f02\u5e38\uff1a" + e.getMessage());
                throw new BusinessException(RspConstantEnums.GOODS_SUBJECTTOC_CREATE_FAIL.code(), e.getMessage());
            }
        }
        UccCommodityPackagePo uccCommodityPackagePo = new UccCommodityPackagePo();
        BeanUtils.copyProperties((Object)reqBO.getCommd(), (Object)uccCommodityPackagePo);
        uccCommodityPackagePo.setCommodityId(uccCommodityPo.getCommodityId());
        uccCommodityPackagePo.setSupplierShopId(uccCommodityPo.getSupplierShopId());
        uccCommodityPackagePo.setCreateOperId(uccCommodityPo.getCreateOperId());
        uccCommodityPackagePo.setPackageId(Long.valueOf(this.sequence.nextId()));
        try {
            this.uccCommodityPackageMapper.addcommodityPackage(uccCommodityPackagePo);
        }
        catch (Exception e) {
            log.error("\u5546\u54c1\u6570\u636e\u5f02\u5e38\uff1a" + e.getMessage());
            throw new BusinessException(RspConstantEnums.GOODS_SUBJECTTOC_CREATE_FAIL.code(), e.getMessage());
        }
        UccCommodityServicePO uccCommodityServicePO = new UccCommodityServicePO();
        if (reqBO.getCommd().getRejectAllow() != null || reqBO.getCommd().getExchangeAllow() != null || reqBO.getCommd().getMaintainAllow() != null) {
            BeanUtils.copyProperties((Object)reqBO.getCommd(), (Object)uccCommodityServicePO);
            if (reqBO.getCommd().getRejectAllow() != null && "\u662f".equals(reqBO.getCommd().getRejectAllow())) {
                uccCommodityServicePO.setRejectAllow(Integer.valueOf(1));
            }
            if (reqBO.getCommd().getExchangeAllow() != null && "\u662f".equals(reqBO.getCommd().getExchangeAllow())) {
                uccCommodityServicePO.setExchangeAllow(Integer.valueOf(1));
            }
            if (reqBO.getCommd().getMaintainAllow() != null && "\u662f".equals(reqBO.getCommd().getMaintainAllow())) {
                uccCommodityServicePO.setMaintainAllow(Integer.valueOf(1));
            }
        } else {
            uccCommodityServicePO.setExchangeAllow(Integer.valueOf(0));
            uccCommodityServicePO.setRejectAllow(Integer.valueOf(0));
            uccCommodityServicePO.setMaintainAllow(Integer.valueOf(0));
        }
        uccCommodityServicePO.setCommodityId(uccCommodityPo.getCommodityId());
        uccCommodityServicePO.setSupplierShopId(uccCommodityPo.getSupplierShopId());
        uccCommodityServicePO.setCreateOperId(uccCommodityPo.getCreateOperId());
        uccCommodityServicePO.setServiceId(Long.valueOf(this.sequence.nextId()));
        try {
            this.uccCommodityServiceMapper.insert(uccCommodityServicePO);
        }
        catch (Exception e) {
            log.error("\u5546\u54c1\u6570\u636e\u5f02\u5e38\uff1a" + e.getMessage());
            throw new BusinessException(RspConstantEnums.GOODS_SUBJECTTOC_CREATE_FAIL.code(), e.getMessage());
        }
        UccCommodityExpandPO uccCommodityExpandPO = new UccCommodityExpandPO();
        uccCommodityExpandPO.setExpand1(reqBO.getCommd().getCommodityExpand1());
        uccCommodityExpandPO.setCommodityId(uccCommodityPo.getCommodityId());
        uccCommodityExpandPO.setSupplierShopId(uccCommodityPo.getSupplierShopId());
        try {
            this.uccCommodityExpandMapper.insertCommdExpand(uccCommodityExpandPO);
        }
        catch (Exception e) {
            log.error("\u5546\u54c1\u6570\u636e\u5f02\u5e38\uff1a" + e.getMessage());
            throw new BusinessException(RspConstantEnums.GOODS_SUBJECTTOC_CREATE_FAIL.code(), e.getMessage());
        }
        List skuBOS = reqBO.getCommd().getSkuBOS();
        int j = 0;
        for (UccZoneSkuBO skuBO : skuBOS) {
            UccSkuPo uccSkuPo = new UccSkuPo();
            BeanUtils.copyProperties((Object)skuBO, (Object)uccSkuPo);
            log.info("\u8c03\u8bd5\u968f\u65f6\u5220\u966412\uff1askuBOS==>{},uccSkuPo==>{}", (Object)JSON.toJSONString((Object)skuBOS), (Object)JSON.toJSONString((Object)uccSkuPo));
            uccSkuPo.setCommodityId(uccCommodityPo.getCommodityId());
            uccSkuPo.setSupplierShopId(uccCommodityPo.getSupplierShopId());
            uccSkuPo.setShopName(uccCommodityPo.getShopName());
            uccSkuPo.setBrandName(uccCommodityPo.getBrandName());
            uccSkuPo.setCreateOperId(reqBO.getUserId().toString());
            uccSkuPo.setCreateOperName(reqBO.getUsername());
            uccSkuPo.setOrgId(uccCommodityPo.getVendorId());
            uccSkuPo.setOrgName(uccCommodityPo.getOrgName());
            uccSkuPo.setSalesUnitId(skuBO.getSaleUnitId());
            uccSkuPo.setSalesUnitName(skuBO.getSaleUnitName());
            uccSkuPo.setSettlementUnit(skuBO.getSaleUnitName());
            uccSkuPo.setSkuStatus(Integer.valueOf(0));
            uccSkuPo.setSkuSource(Integer.valueOf(3));
            uccSkuPo.setSupplierShopId(uccCommodityPo.getSupplierShopId());
            uccSkuPo.setShopName(uccCommodityPo.getShopName());
            uccSkuPo.setSkuCode(skuBO.getSkuCode());
            uccSkuPo.setOnShelveWay(reqBO.getCommd().getOnShelveWay());
            uccSkuPo.setOnShelveTime(reqBO.getCommd().getAutoShelveWayTime());
            uccSkuPo.setModel(skuBO.getModel());
            uccSkuPo.setSpec(skuBO.getSpec());
            uccSkuPo.setSkuPrice(skuBO.getSalePrice());
            uccSkuPo.setPreDeliverDay(skuBO.getPreDeliverDay());
            ++j;
            uccSkuPo.setMeasureId(skuBO.getSaleUnitId());
            uccSkuPo.setMeasureName(skuBO.getSaleUnitName());
            if (reqBO.getCommd().getMaterialId() != null) {
                uccSkuPo.setMaterialId(reqBO.getCommd().getMaterialId().toString());
            }
            if (skuBO.getSaleUnitRate() != null) {
                uccSkuPo.setSalesUnitRate(skuBO.getSaleUnitRate());
            }
            try {
                uccSkuPo.setSkuId(Long.valueOf(this.orderSequence2.nextId()));
            }
            catch (SQLException e) {
                throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), "\u5e8f\u5217\u751f\u6210\u5931\u8d25\uff01");
            }
            log.info("\u8c03\u8bd5\u968f\u65f6\u5220\u966413\uff1askuBOS==>{},uccSkuPo==>{}", (Object)JSON.toJSONString((Object)skuBOS), (Object)JSON.toJSONString((Object)uccSkuPo));
            try {
                this.uccSkuMapper.addsku(uccSkuPo);
            }
            catch (Exception e) {
                throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u5355\u54c1\u65b0\u589e\u5931\u8d25" + e.getMessage());
            }
            for (int i = 1; i < 6; ++i) {
                UccSkuPicPo uccSkuPicPo = new UccSkuPicPo();
                if (i == 1) {
                    uccSkuPicPo.setCommodityPicType(Integer.valueOf(1));
                } else {
                    uccSkuPicPo.setCommodityPicType(Integer.valueOf(2));
                }
                uccSkuPicPo.setSkuPicId(Long.valueOf(this.sequence.nextId()));
                uccSkuPicPo.setSkuId(uccSkuPo.getSkuId());
                uccSkuPicPo.setSupplierShopId(uccCommodityPo.getSupplierShopId());
                uccSkuPicPo.setCreateOperId(reqBO.getUserId().toString());
                uccSkuPicPo.setCreateTime(new Date(System.currentTimeMillis()));
                uccSkuPicPo.setPicOrder(Integer.valueOf(i));
                this.uccSkuPicMapper.addskuPic(uccSkuPicPo);
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)skuBO.getSkuAttrGroups())) {
                for (UccExcelCommodityAttrButesBO each3 : skuBO.getSkuAttrGroups()) {
                    if (each3.getPropScope() != 1) continue;
                    UccPropValueListPo uccPropValueListPo = new UccPropValueListPo();
                    uccPropValueListPo.setPropValueListId(Long.valueOf(this.uccBrandSequence.nextId()));
                    uccPropValueListPo.setPropValue(each3.getPropValue());
                    uccPropValueListPo.setCommodityPropDefId(each3.getCommodityPropDefId());
                    uccPropValueListPo.setCreateOperName(reqBO.getUsername());
                    uccPropValueListPo.setCreateOperId(reqBO.getUserId().toString());
                    uccPropValueListPo.setPropScope(Integer.valueOf(1));
                    UccCommdPropDefPo uccCommdPropDefPo = new UccCommdPropDefPo();
                    uccCommdPropDefPo.setCommodityPropDefId(each3.getCommodityPropDefId());
                    UccCommdPropDefPo uccCommdPropDefPo1 = this.uccCommodityPropDefMapper.queryBycommodityPropDefId(uccCommdPropDefPo);
                    UccCodegenerationCombReqBO UccCodegenerationCombReqBO1 = new UccCodegenerationCombReqBO();
                    UccCodegenerationCombReqBO1.setCodeType("08");
                    UccCodegenerationCombReqBO1.setCount(Integer.valueOf(1));
                    UccCodegenerationCombReqBO1.setUpperCode(uccCommdPropDefPo1.getPropCode());
                    UccCodegenerationCombRspBO UccCodegenerationCombRspBO1 = this.generateCode(UccCodegenerationCombReqBO1);
                    uccPropValueListPo.setPropValueListCode((String)UccCodegenerationCombRspBO1.getCodeList().get(0));
                    this.uccPropValueListMapper.addAttrValues(uccPropValueListPo);
                    each3.setPropValueListId(uccPropValueListPo.getPropValueListId());
                }
            }
            if (!CollectionUtils.isEmpty((Collection)skuBO.getSkuAttrGroups())) {
                List uccSkuSpecPos = JSONObject.parseArray((String)JSONObject.toJSONString((Object)skuBO.getSkuAttrGroups()), UccSkuSpecPo.class);
                uccSkuSpecPos.stream().forEach(each -> {
                    each.setSkuId(uccSkuPo.getSkuId());
                    each.setCommodityId(uccSkuPo.getCommodityId());
                    each.setSupplierShopId(uccSkuPo.getSupplierShopId());
                    each.setCreateOperId(uccSkuPo.getCreateOperId());
                    each.setSkuSpecId(Long.valueOf(this.sequence.nextId()));
                    each.setPropShowName(each.getPropName());
                });
                try {
                    this.uccSkuSpecMapper.addSkuSpecs(uccSkuSpecPos);
                }
                catch (Exception e) {
                    throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u5355\u54c1\u5c5e\u6027\u65b0\u589e\u5931\u8d25" + e.getMessage());
                }
            }
            UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
            BeanUtils.copyProperties((Object)skuBO, (Object)uccSkuPricePo);
            uccSkuPricePo.setSkuId(uccSkuPo.getSkuId());
            uccSkuPricePo.setSupplierShopId(uccSkuPo.getSupplierShopId());
            uccSkuPricePo.setCreateOperId(uccSkuPo.getCreateOperId());
            uccSkuPricePo.setSkuPriceId(Long.valueOf(this.sequence.nextId()));
            uccSkuPricePo.setSwitchOn(Integer.valueOf(0));
            log.info("\u8c03\u8bd5\u968f\u65f6\u5220\u966414\uff1askuBOS==>{},uccSkuPricePo==>{}", (Object)JSON.toJSONString((Object)skuBOS), (Object)JSON.toJSONString((Object)uccSkuPricePo));
            try {
                this.uccSkuPriceMapper.addskuPrice(uccSkuPricePo);
            }
            catch (Exception e) {
                throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u5355\u54c1\u4ef7\u683c\u65b0\u589e\u5931\u8d25" + e.getMessage());
            }
            UccSaleNumPo saleNumPo = new UccSaleNumPo();
            saleNumPo.setSkuId(uccSkuPo.getSkuId());
            saleNumPo.setSupplierShopId(uccSkuPo.getSupplierShopId());
            saleNumPo.setSoldNumber(new BigDecimal(0));
            saleNumPo.setSaleId(Long.valueOf(this.sequence.nextId()));
            try {
                this.uccSaleNumMapper.insertSaleNum(saleNumPo);
            }
            catch (Exception e) {
                throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u5355\u54c1\u9500\u91cf\u65b0\u589e\u5931\u8d25" + e.getMessage());
            }
            if (reqBO.getCommd().getOnShelveWay() != null) {
                UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
                uccSkuPutCirPo = new UccSkuPutCirPo();
                uccSkuPutCirPo.setSkuId(uccSkuPo.getSkuId());
                uccSkuPutCirPo.setSupplierShopId(uccCommodityPo.getSupplierShopId());
                uccSkuPutCirPo.setId(Long.valueOf(this.sequence.nextId()));
                uccSkuPutCirPo.setState(Integer.valueOf(1));
                if (0 == reqBO.getCommd().getOnShelveWay()) {
                    uccSkuPutCirPo.setUpType(Integer.valueOf(1));
                    uccSkuPutCirPo.setDownType(Integer.valueOf(1));
                } else {
                    uccSkuPutCirPo.setUpType(Integer.valueOf(2));
                    uccSkuPutCirPo.setDownType(Integer.valueOf(2));
                }
                try {
                    if (!StringUtils.isEmpty((Object)reqBO.getCommd().getAutoShelveWayTime())) {
                        uccSkuPutCirPo.setPreUpTime(reqBO.getCommd().getAutoShelveWayTime());
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new ZTBusinessException(RspConstantEnums.TYPE_CONVERSION_FAILED.code() + e.getMessage());
                }
                try {
                    this.uccSkuPutCirMapper.addSkuPutCir(uccSkuPutCirPo);
                }
                catch (Exception e) {
                    throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u4e0a\u4e0b\u67b6\u5468\u671f\u5f02\u5e38");
                }
            }
            try {
                SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO = new SmcsdkOperateStockNumReqBO();
                smcsdkOperateStockNumReqBO.setOperateType("10");
                smcsdkOperateStockNumReqBO.setOperateNo(uccSkuPo.getCreateOperId());
                ArrayList<SmcsdkStockNumInfoBO> smcsdkStockNumInfoBOS = new ArrayList<SmcsdkStockNumInfoBO>();
                SmcsdkStockNumInfoBO smcsdkStockNumInfoBO = new SmcsdkStockNumInfoBO();
                if (skuBO.getStockNum() != null) {
                    smcsdkStockNumInfoBO.setOperateNum(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)skuBO.getStockNum())));
                } else {
                    smcsdkStockNumInfoBO.setOperateNum(Long.valueOf(0L));
                }
                smcsdkStockNumInfoBO.setSkuId(String.valueOf(uccSkuPo.getSkuId()));
                smcsdkStockNumInfoBOS.add(smcsdkStockNumInfoBO);
                smcsdkOperateStockNumReqBO.setSmcsdkStockNumInfoBOs(smcsdkStockNumInfoBOS);
                smcsdkOperateStockNumReqBO.setObjectId(String.valueOf(uccCommodityPo.getCommodityId()));
                smcsdkOperateStockNumReqBO.setObjectType("10");
                log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5165\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
                SmcsdkOperateStockNumRspBO smcsdkOperateStockNumRspBO = this.smcsdkOperateStockNumService.operateStockNum(smcsdkOperateStockNumReqBO);
                if ("0000".equals(smcsdkOperateStockNumRspBO.getRespCode())) {
                    log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u51fa\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
                    continue;
                }
                throw new ZTBusinessException(RspConstantEnums.SMCSDKOPERATESTOCK_ADD_FAIL.code() + smcsdkOperateStockNumRspBO.getRespDesc());
            }
            catch (Exception e) {
                throw new ZTBusinessException(RspConstantEnums.SMCSDKOPERATESTOCK_ADD_FAIL.code() + e.getMessage());
            }
        }
        this.insertWhiteList(reqBO.getCommd().getWhilteRestrict(), uccCommodityPo, reqBO.getCommd().getAgreementId(), reqBO.getUsername());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Long dealAddAttrValues(UccZoneCommodityCreateBusiReqBO reqBO, UccExcelCommodityAttrButesBO commdAttrGroup, String spuCode) {
        try {
            UccPropValueListPo propValueListPo = this.uccPropValueListMapper.getBySup(commdAttrGroup.getCommodityPropDefId(), reqBO.getOrgId().toString(), commdAttrGroup.getPropValue());
            if (!ObjectUtils.isEmpty((Object)propValueListPo)) {
                return propValueListPo.getPropValueListId();
            }
            UccSpuAttributeImportServiceAbilityReqBo abilityReqBo = new UccSpuAttributeImportServiceAbilityReqBo();
            BeanUtils.copyProperties((Object)reqBO, (Object)abilityReqBo);
            abilityReqBo.setTemporarySource(spuCode);
            abilityReqBo.setPropValue(commdAttrGroup.getPropValue());
            abilityReqBo.setCommodityPropDefId(commdAttrGroup.getCommodityPropDefId());
            abilityReqBo.setPropScope(Integer.valueOf(1));
            abilityReqBo.setCreateOperId(reqBO.getCommd().getVendorId().toString());
            UccSpuAttributeImportServiceAbilityRspBo uccSpuAttributeImportServiceAbilityRspBo = this.uccSpuAttributeImportServiceAbilityService.attrButeImportAdd(abilityReqBo);
            return uccSpuAttributeImportServiceAbilityRspBo.getPropValueListId();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u5546\u54c1\u5bfc\u5165\u65b0\u589e\u4e34\u65f6\u5c5e\u6027\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    private String checkSpuProp(List<CommdSpecBo> spuSpec, Long commodityTypeId, Long vendorId, String code) {
        List qeryGrpRelDefValue = this.uccCommodityPropGrpMapper.qeryGrpRelDefValueImport(commodityTypeId, Integer.valueOf(1), Integer.valueOf(1));
        if (CollectionUtils.isEmpty((Collection)qeryGrpRelDefValue) && CollectionUtils.isEmpty(spuSpec)) {
            return "";
        }
        if (!CollectionUtils.isEmpty((Collection)qeryGrpRelDefValue)) {
            ArrayList mustInput = new ArrayList();
            qeryGrpRelDefValue.forEach(a -> {
                if (a.getRequiredFlag() == 1 && a.getDefPropScope() == 0) {
                    mustInput.add(a);
                }
            });
            List<Object> mustdefID = new ArrayList();
            List<Object> mustDefName = new ArrayList();
            if (!CollectionUtils.isEmpty(mustInput)) {
                mustdefID = mustInput.stream().map(UccGrpRelDefValuePO::getCommodityPropDefId).collect(Collectors.toList());
                mustDefName = mustInput.stream().map(UccGrpRelDefValuePO::getPropName).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty(spuSpec) && !CollectionUtils.isEmpty(mustDefName) && !CollectionUtils.isEmpty(mustDefName)) {
                return "\u5c5e\u6027" + ((Object)mustDefName).toString() + "\u5fc5\u4f20";
            }
            Map<Long, List<UccGrpRelDefValuePO>> groupDef = qeryGrpRelDefValue.stream().collect(Collectors.groupingBy(UccGrpRelDefValuePO::getCommodityPropDefId));
            if (!CollectionUtils.isEmpty(mustdefID)) {
                List listSpu = spuSpec.stream().map(CommdSpecBo::getCommodityPropDefId).collect(Collectors.toList());
                List mustPut = mustdefID.stream().filter(each -> !listSpu.contains(each)).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty((Collection)mustPut)) {
                    return "\u5c5e\u6027" + groupDef.get(mustPut.get(0)).get(0).getPropName() + "\u5fc5\u4f20";
                }
            }
            ArrayList<UccPropValueListPo> tempDef = new ArrayList<UccPropValueListPo>();
            for (CommdSpecBo each2 : spuSpec) {
                if (groupDef.containsKey(each2.getCommodityPropDefId())) {
                    List<UccGrpRelDefValuePO> tempList;
                    if (groupDef.get(each2.getCommodityPropDefId()).get(0).getDefPropScope() == 1) {
                        UccPropValueListPo po = new UccPropValueListPo();
                        po.setCommodityPropDefId(each2.getCommodityPropDefId());
                        if (each2.getPropValueListId() != null) {
                            po.setPropValueListId(each2.getPropValueListId());
                        }
                        tempDef.add(po);
                    }
                    if (CollectionUtils.isEmpty(tempList = groupDef.get(each2.getCommodityPropDefId()))) continue;
                    List collect = tempList.stream().map(UccGrpRelDefValuePO::getCommodityPropGrpId).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(collect) && !collect.contains(each2.getCommodityPropGrpId())) {
                        return "\u672a\u77e5\u5c5e\u6027\u7ec4" + each2.getCommodityPropGrpId();
                    }
                    List collect2 = tempList.stream().map(UccGrpRelDefValuePO::getPropName).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(collect2) || collect2.contains(each2.getPropName())) continue;
                    return "\u672a\u77e5\u5c5e\u6027\u540d\u79f0" + each2.getPropName();
                }
                return "\u5c5e\u6027\uff1a" + each2.getPropName() + "\u672a\u5173\u8054\u5c5e\u6027\u7ec4";
            }
            if (!CollectionUtils.isEmpty(tempDef)) {
                HashSet orgSet = new HashSet();
                ArrayList orgValueList = new ArrayList();
                tempDef.forEach(a -> {
                    orgSet.add(a.getCommodityPropDefId());
                    if (a.getPropValueListId() != null) {
                        orgValueList.add(a.getPropValueListId());
                    }
                });
                ArrayList orgDefsList = new ArrayList(orgSet);
                List defList = this.uccTemporaryPropDefMapper.queryTempInfoByDefs(orgDefsList, code);
                orgDefsList.removeAll(defList);
                if (!CollectionUtils.isEmpty(orgDefsList)) {
                    if (vendorId == null) {
                        return "\u5c5e\u6027ID " + orgValueList + "\u4e0d\u80fd\u5173\u8054\u6b64\u4f9b\u5e94\u5546\u521b\u5efa\u5546\u54c1";
                    }
                    List createByVenodr = this.uccCommodityPropDefMapper.filterDefRecords(orgDefsList, vendorId.toString());
                    orgDefsList.removeAll(createByVenodr);
                    if (!CollectionUtils.isEmpty(orgDefsList)) {
                        return "\u5c5e\u6027ID " + orgDefsList + "\u4e0d\u80fd\u5173\u8054\u6b64\u4f9b\u5e94\u5546\u521b\u5efa\u5546\u54c1";
                    }
                    ArrayList<UccTemporaryPropDefPO> propDefPOList = new ArrayList<UccTemporaryPropDefPO>();
                    for (Object each3 : createByVenodr) {
                        UccTemporaryPropDefPO defPO = new UccTemporaryPropDefPO();
                        defPO.setId(Long.valueOf(this.sequence.nextId()));
                        defPO.setCommodityPropDefId((Long)each3);
                        defPO.setRelType(Integer.valueOf(0));
                        defPO.setTemporarySource(code);
                        propDefPOList.add(defPO);
                    }
                    this.uccTemporaryPropDefMapper.insertBatch(propDefPOList);
                }
                if (!CollectionUtils.isEmpty(orgValueList)) {
                    List valueList = this.uccTemporaryPropValueMapper.queryTempInfoByValueIds(orgValueList, code);
                    orgValueList.removeAll(valueList);
                    if (!CollectionUtils.isEmpty(orgValueList)) {
                        if (vendorId == null) {
                            return "\u5c5e\u6027ID " + orgValueList + "\u4e0d\u80fd\u5173\u8054\u6b64\u4f9b\u5e94\u5546\u521b\u5efa\u5546\u54c1";
                        }
                        List createByVenodr = this.uccPropValueListMapper.filterValueIdRecords(orgValueList, vendorId.toString());
                        orgValueList.removeAll(createByVenodr);
                        if (!CollectionUtils.isEmpty(orgValueList)) {
                            orgValueList.removeAll(createByVenodr);
                            return "\u5c5e\u6027ID " + orgValueList + "\u4e0d\u80fd\u5173\u8054\u6b64\u4f9b\u5e94\u5546\u521b\u5efa\u5546\u54c1";
                        }
                        ArrayList<UccTemporaryPropValuePO> propDefPOList = new ArrayList<UccTemporaryPropValuePO>();
                        for (Long each4 : createByVenodr) {
                            UccTemporaryPropValuePO defPO = new UccTemporaryPropValuePO();
                            defPO.setId(Long.valueOf(this.sequence.nextId()));
                            defPO.setPropValueListId(each4);
                            defPO.setRelType(Integer.valueOf(0));
                            defPO.setTemporarySource(code);
                            propDefPOList.add(defPO);
                        }
                        try {
                            this.uccTemporaryPropValueMapper.insertBatch(propDefPOList);
                        }
                        catch (Exception e) {
                            throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
                        }
                    }
                }
            }
            return null;
        }
        if (!CollectionUtils.isEmpty(spuSpec)) {
            return "\u672a\u77e5\u5c5e\u6027\u5f55\u5165";
        }
        return null;
    }

    private String checkSkuProp(List<SkuInfoSpecBo> spuSpec, Long commodityTypeId, Long vendorId, String code) {
        List qeryGrpRelDefValue = this.uccCommodityPropGrpMapper.qeryGrpRelDefValueImport(commodityTypeId, Integer.valueOf(2), Integer.valueOf(1));
        if (CollectionUtils.isEmpty((Collection)qeryGrpRelDefValue) && CollectionUtils.isEmpty(spuSpec)) {
            return "";
        }
        if (!CollectionUtils.isEmpty((Collection)qeryGrpRelDefValue)) {
            Map<Long, List<UccGrpRelDefValuePO>> groupDef = qeryGrpRelDefValue.stream().collect(Collectors.groupingBy(UccGrpRelDefValuePO::getCommodityPropDefId));
            ArrayList<UccPropValueListPo> tempDef = new ArrayList<UccPropValueListPo>();
            for (SkuInfoSpecBo each : spuSpec) {
                if (groupDef.containsKey(each.getCommodityPropDefId())) {
                    if (groupDef.get(each.getCommodityPropDefId()).get(0).getDefPropScope() == 1) {
                        UccPropValueListPo po = new UccPropValueListPo();
                        po.setCommodityPropDefId(each.getCommodityPropDefId());
                        if (each.getPropValueListId() != null) {
                            po.setPropValueListId(each.getPropValueListId());
                        }
                        tempDef.add(po);
                    }
                    if (!each.getCommodityPropGrpId().equals(groupDef.get(each.getCommodityPropDefId()).get(0).getCommodityPropGrpId())) {
                        return "\u672a\u77e5\u5c5e\u6027\u7ec4" + each.getCommodityPropGrpId();
                    }
                    if (each.getPropName().equals(groupDef.get(each.getCommodityPropDefId()).get(0).getPropName())) continue;
                    return "\u672a\u77e5\u5c5e\u6027\u540d\u79f0" + each.getPropName();
                }
                return "\u5c5e\u6027\uff1a" + each.getPropName() + "\u672a\u5173\u8054\u5c5e\u6027\u7ec4";
            }
            if (!CollectionUtils.isEmpty(tempDef)) {
                HashSet orgSet = new HashSet();
                ArrayList orgValueList = new ArrayList();
                tempDef.forEach(a -> {
                    orgSet.add(a.getCommodityPropDefId());
                    if (a.getPropValueListId() != null) {
                        orgValueList.add(a.getPropValueListId());
                    }
                });
                ArrayList orgDefsList = new ArrayList(orgSet);
                List defList = this.uccTemporaryPropDefMapper.queryTempInfoByDefs(orgDefsList, code);
                orgDefsList.removeAll(defList);
                if (!CollectionUtils.isEmpty(orgDefsList)) {
                    if (vendorId == null) {
                        return "\u5c5e\u6027ID " + orgValueList + "\u4e0d\u80fd\u5173\u8054\u6b64\u4f9b\u5e94\u5546\u521b\u5efa\u5546\u54c1";
                    }
                    List createByVenodr = this.uccCommodityPropDefMapper.filterDefRecords(orgDefsList, vendorId.toString());
                    if (createByVenodr.size() != orgDefsList.size()) {
                        orgDefsList.removeAll(createByVenodr);
                        return "\u5c5e\u6027ID " + orgDefsList + "\u4e0d\u80fd\u5173\u8054\u6b64\u4f9b\u5e94\u5546\u521b\u5efa\u5546\u54c1";
                    }
                    ArrayList<UccTemporaryPropDefPO> propDefPOList = new ArrayList<UccTemporaryPropDefPO>();
                    for (Object each : createByVenodr) {
                        UccTemporaryPropDefPO defPO = new UccTemporaryPropDefPO();
                        defPO.setId(Long.valueOf(this.sequence.nextId()));
                        defPO.setCommodityPropDefId((Long)each);
                        defPO.setRelType(Integer.valueOf(0));
                        defPO.setTemporarySource(code);
                        propDefPOList.add(defPO);
                    }
                    this.uccTemporaryPropDefMapper.insertBatch(propDefPOList);
                }
                if (!CollectionUtils.isEmpty(orgValueList)) {
                    List valueList = this.uccTemporaryPropValueMapper.queryTempInfoByValueIds(orgValueList, code);
                    orgValueList.removeAll(valueList);
                    if (!CollectionUtils.isEmpty(orgValueList)) {
                        if (vendorId == null) {
                            return "\u5c5e\u6027ID " + orgValueList + "\u4e0d\u80fd\u5173\u8054\u6b64\u4f9b\u5e94\u5546\u521b\u5efa\u5546\u54c1";
                        }
                        List createByVenodr = this.uccPropValueListMapper.filterValueIdRecords(orgValueList, vendorId.toString());
                        orgValueList.removeAll(createByVenodr);
                        if (!CollectionUtils.isEmpty(orgValueList)) {
                            orgValueList.removeAll(createByVenodr);
                            return "\u5c5e\u6027ID " + orgValueList + "\u4e0d\u80fd\u5173\u8054\u6b64\u4f9b\u5e94\u5546\u521b\u5efa\u5546\u54c1";
                        }
                        ArrayList<UccTemporaryPropValuePO> propDefPOList = new ArrayList<UccTemporaryPropValuePO>();
                        for (Long each : createByVenodr) {
                            UccTemporaryPropValuePO defPO = new UccTemporaryPropValuePO();
                            defPO.setId(Long.valueOf(this.sequence.nextId()));
                            defPO.setPropValueListId(each);
                            defPO.setRelType(Integer.valueOf(0));
                            defPO.setTemporarySource(code);
                            propDefPOList.add(defPO);
                        }
                        try {
                            this.uccTemporaryPropValueMapper.insertBatch(propDefPOList);
                        }
                        catch (Exception e) {
                            throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
                        }
                    }
                }
            }
            return null;
        }
        if (!CollectionUtils.isEmpty(spuSpec)) {
            return "\u672a\u77e5\u5c5e\u6027\u5f55\u5165";
        }
        return null;
    }

    private void insertWhiteList(List<Long> whilteRestrict, UccCommodityPo uccSpuCreateaBusiRspBO, Long agreementId, String userName) {
        if (!CollectionUtils.isEmpty(whilteRestrict)) {
            ArrayList<UccOrgSkuWhiteRestrictionBo> uccOrgSkuWhiteRestrictionBos = new ArrayList<UccOrgSkuWhiteRestrictionBo>();
            for (Long each : whilteRestrict) {
                UccOrgSkuWhiteRestrictionBo uccOrgSkuWhiteRestrictionPo = new UccOrgSkuWhiteRestrictionBo();
                uccOrgSkuWhiteRestrictionPo.setAgreementId(Long.valueOf(agreementId));
                uccOrgSkuWhiteRestrictionPo.setSupplierShopId(uccSpuCreateaBusiRspBO.getSupplierShopId());
                uccOrgSkuWhiteRestrictionPo.setSkuSource(3);
                uccOrgSkuWhiteRestrictionPo.setCreateOperId(userName);
                uccOrgSkuWhiteRestrictionPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
                uccOrgSkuWhiteRestrictionPo.setOrgId(Long.valueOf(each));
                uccOrgSkuWhiteRestrictionPo.setOrgTreePath(each.toString());
                uccOrgSkuWhiteRestrictionPo.setStatus(1);
                uccOrgSkuWhiteRestrictionPo.setCommodityId(uccSpuCreateaBusiRspBO.getCommodityId());
                uccOrgSkuWhiteRestrictionBos.add(uccOrgSkuWhiteRestrictionPo);
            }
            if (CollectionUtils.isEmpty(uccOrgSkuWhiteRestrictionBos)) {
                return;
            }
            UccOrgSkuWhiteRestrictionBusiReqBo uccOrgSkuWhiteRestrictionBusiReqBo = new UccOrgSkuWhiteRestrictionBusiReqBo();
            uccOrgSkuWhiteRestrictionBusiReqBo.setWhites(uccOrgSkuWhiteRestrictionBos);
            try {
                this.uccOrgAgrWhiteRestrictionBusiService.dealWhite(uccOrgSkuWhiteRestrictionBusiReqBo);
            }
            catch (Exception e) {
                log.error("\u534f\u8bae\u53d1\u5e03\u8303\u56f4\u65b0\u589e\u5931\u8d25" + e.getMessage());
                throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
            }
        }
    }

    private UccCodegenerationCombRspBO generateCode(UccCodegenerationCombReqBO uccCodegenerationCombReqBO) {
        UccCodegenerationCombRspBO UccCodegenerationCombRspBO2 = this.uccCodegenerationAbilityService.dealUccCodegeneration(uccCodegenerationCombReqBO);
        if (!"0000".equals(UccCodegenerationCombRspBO2.getRespCode())) {
            throw new BusinessException("8888", UccCodegenerationCombRspBO2.getRespDesc());
        }
        return UccCodegenerationCombRspBO2;
    }
}

