/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.comb.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.base.bo.SkuChangePriceBO;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.busi.api.UccOrgAgrWhiteRestrictionBusiService;
import com.tydic.commodity.busibase.busi.bo.UccOrgSkuWhiteRestrictionBo;
import com.tydic.commodity.busibase.busi.bo.UccOrgSkuWhiteRestrictionBusiReqBo;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccGoodsPriceChangeLogMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccOrgSkuWhiteRestrictionMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.po.UccGoodsPriceChangeLogPO;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.ability.api.UccChangeStatusAbilityService;
import com.tydic.commodity.zone.ability.bo.AgrMessageBo;
import com.tydic.commodity.zone.ability.bo.UccAgrScopeSyncBO;
import com.tydic.commodity.zone.ability.bo.UccUpdateSaleNumBo;
import com.tydic.commodity.zone.ability.bo.UccUpdateSalesVolumeBO;
import com.tydic.commodity.zone.comb.api.UccDealAgrMessageService;
import com.tydic.smcsdk.api.SmcsdkOperateStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumRspBO;
import com.tydic.smcsdk.api.bo.SmcsdkStockNumInfoBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccDealAgrMessageServiceImpl
implements UccDealAgrMessageService {
    private static final Logger log = LoggerFactory.getLogger(UccDealAgrMessageServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(UccDealAgrMessageServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccGoodsPriceChangeLogMapper uccGoodsPriceChangeLogMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired(required=true)
    private SmcsdkOperateStockNumService smcsdkOperateStockNumService;
    private static final String allRange = "*";
    private static final String INNER_RANGE = "1";
    private static final String INNER_RANGE_V2 = "[1]";
    private static final String OUTER_RANGE = "5";
    private static final String OUTER_RANGE_V2 = "[5]";
    @Autowired
    private UccOrgAgrWhiteRestrictionBusiService uccOrgAgrWhiteRestrictionBusiService;
    @Autowired
    private UccOrgSkuWhiteRestrictionMapper uccOrgSkuWhiteRestrictionMapper;
    @Autowired
    private UccChangeStatusAbilityService uccChangeStatusAbilityService;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private CacheClient cacheClient;

    @Override
    public RspUccBo dealMessage(AgrMessageBo reqBO) {
        RspUccBo rspBO = new RspUccBo();
        LOGGER.info("\u5904\u7406\u534f\u8bae\u4e2d\u5fc3\u6d88\u606f\u6570\u636e\uff1a" + JSON.toJSONString((Object)reqBO));
        if (reqBO.getCommiditySkuStatus() != null) {
            this.uccChangeStatusAbilityService.changeCommod(reqBO);
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqBO.getAgrScopeSyncBOs())) {
            List uccOrgSkuWhiteRestrictionPos;
            List agrIds = reqBO.getAgrScopeSyncBOs().stream().map(a -> a.getAgreementId()).collect(Collectors.toList());
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(agrIds) && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(uccOrgSkuWhiteRestrictionPos = this.uccOrgSkuWhiteRestrictionMapper.batchQueryOrgWhiteWithAgr(agrIds, null, Integer.valueOf(1))))) {
                Set orgPaths = uccOrgSkuWhiteRestrictionPos.stream().filter(a -> !StringUtils.isEmpty((String)a.getOrgTreePath())).map(a -> a.getOrgTreePath()).collect(Collectors.toSet());
                Map<Long, List<UccAgrScopeSyncBO>> map = reqBO.getAgrScopeSyncBOs().stream().collect(Collectors.groupingBy(UccAgrScopeSyncBO::getAgreementId));
                ArrayList agrAllScopeIds = Lists.newArrayList();
                for (Long argId : agrIds) {
                    List<UccAgrScopeSyncBO> list = map.get(argId);
                    if (list.size() != 1 || !allRange.equals(list.get(0).getScopeCodes())) continue;
                    agrAllScopeIds.add(argId);
                }
                log.info("UccDealAgrMessageService agrAllScopeIds={},agrIds={}", (Object)JSONObject.toJSONString((Object)agrAllScopeIds), (Object)JSONObject.toJSONString(agrIds));
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)agrAllScopeIds)) {
                    this.uccOrgSkuWhiteRestrictionMapper.deleteListByAgr((List)agrAllScopeIds, null);
                    agrIds.removeAll(agrAllScopeIds);
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(agrIds)) {
                    this.uccOrgSkuWhiteRestrictionMapper.deleteScopeListByAgr(agrIds);
                }
                if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orgPaths)) {
                    Object orgPos;
                    List uccOrgSkuWhiteRestrictionPoList = this.uccOrgSkuWhiteRestrictionMapper.batchQueryOrgWhiteWithAgr(null, (List)Lists.newArrayList((Iterable)orgPaths), Integer.valueOf(1));
                    HashMap white = new HashMap();
                    if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccOrgSkuWhiteRestrictionPoList)) {
                        orgPos = uccOrgSkuWhiteRestrictionPoList.stream().filter(a -> a.getAgreementId() != null).collect(Collectors.groupingBy(a -> a.getOrgTreePath()));
                        for (Map.Entry each : orgPos.entrySet()) {
                            List agrIdList = ((List)each.getValue()).stream().filter(a -> a.getAgreementId() != null).map(a -> a.getAgreementId()).collect(Collectors.toList());
                            white.put(each.getKey(), agrIdList);
                        }
                    }
                    orgPos = orgPaths.iterator();
                    while (orgPos.hasNext()) {
                        String key = (String)orgPos.next();
                        if (white.containsKey(key)) {
                            this.cacheClient.set(new StringBuffer("UCC_ORG_AGR_WHITELIST_RESTRICTION").append(key).toString(), white.get(key));
                            continue;
                        }
                        this.cacheClient.delete(new StringBuffer("UCC_ORG_AGR_WHITELIST_RESTRICTION").append(key).toString());
                    }
                }
            }
            this.insertWhiteList(reqBO);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqBO.getSkuChangePriceBOs())) {
            List skuChangePriceBOS = reqBO.getSkuChangePriceBOs();
            ArrayList<SmcsdkStockNumInfoBO> smcsdkStockNumInfoBOS = new ArrayList<SmcsdkStockNumInfoBO>();
            for (SkuChangePriceBO skuChangePriceBO : skuChangePriceBOS) {
                List uccSkuPos;
                if (skuChangePriceBO.getCommiditySkuStatus() != null) {
                    this.uccSkuMapper.modifySkuByAgreement((List)Lists.newArrayList((Object[])new Long[]{skuChangePriceBO.getAgreementId()}), (List)Lists.newArrayList((Object[])new Long[]{skuChangePriceBO.getAgreementSkuId()}), skuChangePriceBO.getCommiditySkuStatus());
                    continue;
                }
                Long agreementId = null;
                Long agreementDetailId = null;
                if (skuChangePriceBO.getAgreementId() != null) {
                    agreementId = skuChangePriceBO.getAgreementId();
                }
                if (skuChangePriceBO.getAgreementSkuId() != null) {
                    agreementDetailId = skuChangePriceBO.getAgreementSkuId();
                }
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(uccSkuPos = this.uccSkuMapper.selectByAgreementDetailId(agreementId, agreementDetailId)))) continue;
                if (skuChangePriceBO.getBuyNumber() != null) {
                    SmcsdkStockNumInfoBO smcsdkStockNumInfoBO = new SmcsdkStockNumInfoBO();
                    smcsdkStockNumInfoBO.setOperateNum(Long.valueOf(skuChangePriceBO.getBuyNumber().longValue()));
                    smcsdkStockNumInfoBO.setSkuId(((UccSkuPo)uccSkuPos.get(0)).getSkuId().toString());
                    smcsdkStockNumInfoBOS.add(smcsdkStockNumInfoBO);
                }
                for (UccSkuPo uccSkuPo : uccSkuPos) {
                    try {
                        this.addAgrPriceChangeLog(uccSkuPo, skuChangePriceBO);
                        UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
                        uccSkuPricePo.setSkuId(uccSkuPo.getSkuId());
                        uccSkuPricePo.setSupplierShopId(uccSkuPo.getSupplierShopId());
                        uccSkuPricePo.setSalePrice(Long.valueOf(skuChangePriceBO.getSalePrice().longValue()));
                        uccSkuPricePo.setAgreementPrice(Long.valueOf(skuChangePriceBO.getBuyPrice().longValue()));
                        this.uccSkuPriceMapper.updateSkuPrice(uccSkuPricePo);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                        throw new BusinessException("8888", "\u4fee\u6539\u4fe1\u606f\u5931\u8d25");
                    }
                    try {
                        UccSkuPo uccSkuPo1 = new UccSkuPo();
                        uccSkuPo1.setSkuId(uccSkuPo.getSkuId());
                        uccSkuPo1.setSupplierShopId(uccSkuPo.getSupplierShopId());
                        if (skuChangePriceBO.getSalePrice() != null) {
                            uccSkuPo1.setSkuPrice(Long.valueOf(skuChangePriceBO.getSalePrice().longValue()));
                        }
                        this.uccSkuMapper.updateSku(uccSkuPo1);
                        BigDecimal salePrice = skuChangePriceBO.getSalePrice();
                        this.updateLadderPrice(uccSkuPo.getSkuId(), uccSkuPo.getSupplierShopId(), salePrice);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                        throw new BusinessException("8888", "\u4fee\u6539\u4ef7\u683c\u4fe1\u606f\u5931\u8d25");
                    }
                }
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(smcsdkStockNumInfoBOS)) {
                SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO = new SmcsdkOperateStockNumReqBO();
                smcsdkOperateStockNumReqBO.setSmcsdkStockNumInfoBOs(smcsdkStockNumInfoBOS);
                smcsdkOperateStockNumReqBO.setOperateType("11");
                if (((SkuChangePriceBO)reqBO.getSkuChangePriceBOs().get(0)).getAgreementId() == null) {
                    smcsdkOperateStockNumReqBO.setObjectId("111111");
                } else {
                    smcsdkOperateStockNumReqBO.setObjectId(((SkuChangePriceBO)reqBO.getSkuChangePriceBOs().get(0)).getAgreementId().toString());
                }
                smcsdkOperateStockNumReqBO.setObjectType("20");
                try {
                    log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5165\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
                    SmcsdkOperateStockNumRspBO smcsdkOperateStockNumRspBO = this.smcsdkOperateStockNumService.operateStockNum(smcsdkOperateStockNumReqBO);
                    if (!"0000".equals(smcsdkOperateStockNumRspBO.getRespCode())) {
                        throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25\uff1a" + smcsdkOperateStockNumRspBO.getRespDesc());
                    }
                    log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u51fa\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25:" + e.getMessage());
                }
            }
        }
        this.dealSkuSyncEs(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d88\u606f\u5904\u7406\u6210\u529f");
        LOGGER.info("\u5904\u7406\u534f\u8bae\u4e2d\u5fc3\u6d88\u606f\u6210\u529f");
        return rspBO;
    }

    private void addAgrPriceChangeLog(UccSkuPo uccSkuPo, SkuChangePriceBO skuChangePriceBO) {
        try {
            UccGoodsPriceChangeLogPO insertChangeLogPO = new UccGoodsPriceChangeLogPO();
            insertChangeLogPO.setPriceChangeLogId(Long.valueOf(Sequence.getInstance().nextId()));
            insertChangeLogPO.setSkuId(uccSkuPo.getSkuId());
            insertChangeLogPO.setCommodityId(uccSkuPo.getCommodityId());
            insertChangeLogPO.setSupplierShopId(uccSkuPo.getSupplierShopId());
            insertChangeLogPO.setChangeTime(new Date());
            insertChangeLogPO.setCurrentPrice(Long.valueOf(skuChangePriceBO.getSalePrice().longValue()));
            UccSkuPricePo select = new UccSkuPricePo();
            select.setSkuId(uccSkuPo.getSkuId());
            UccSkuPricePo oldSkuPrice = this.uccSkuPriceMapper.querySkuPrice(select);
            if (!ObjectUtil.isEmpty((Object)oldSkuPrice)) {
                insertChangeLogPO.setOldPrice(oldSkuPrice.getSalePrice());
            }
            this.uccGoodsPriceChangeLogMapper.insert(insertChangeLogPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u65b0\u589e\u534f\u8bae\u4ef7\u683c\u65e5\u5fd7\u53d8\u5316\u8bb0\u5f55\u5f02\u5e38\uff01" + e.getMessage());
        }
    }

    private void dealSkuSyncEs(AgrMessageBo reqBO) {
        List uccSkuPos;
        Map<Object, Object> groupBySupplier = new HashMap();
        if ((org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqBO.getAgreementIds()) || org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqBO.getAgreementSkuIds())) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(uccSkuPos = this.uccSkuMapper.selectByAgreementDetailIds(reqBO.getAgreementIds(), reqBO.getAgreementSkuIds())))) {
            groupBySupplier = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqBO.getSkuChangePriceBOs())) {
            List agreementDetailIds = reqBO.getSkuChangePriceBOs().stream().map(SkuChangePriceBO::getAgreementSkuId).collect(Collectors.toList());
            List agreementIds = reqBO.getSkuChangePriceBOs().stream().map(SkuChangePriceBO::getAgreementId).collect(Collectors.toList());
            List uccSkuPos2 = this.uccSkuMapper.selectByAgreementDetailIds(agreementIds, agreementDetailIds);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)uccSkuPos2)) {
                groupBySupplier = uccSkuPos2.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
            }
        }
        for (Map.Entry entry : groupBySupplier.entrySet()) {
            List skuIds = ((List)entry.getValue()).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skuIds));
            syncSceneCommodityToEsReqBO.setSupplierId((Long)entry.getKey());
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            LOGGER.info("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
            try {
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                LOGGER.error("\u540c\u6b65\u5546\u54c1\u72b6\u6001\u548c\u4ef7\u683c\uff0c\u53d1\u9001es MQ\u5931\u8d25\uff1a" + e);
                throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
            }
        }
    }

    private void updateLadderPrice(Long skuId, Long supplierShopId, BigDecimal salePrice) {
        List uccLadderPriceList = this.uccLadderPriceMapper.selectBySkuId(skuId, supplierShopId);
        for (UccLadderPricePO uccLadderPrice : uccLadderPriceList) {
            UccLadderPricePO uccLadderPricePO = new UccLadderPricePO();
            BigDecimal discount = uccLadderPrice.getDiscount();
            if (discount == null) continue;
            BigDecimal price = discount.multiply(salePrice);
            uccLadderPricePO.setPrice(Long.valueOf(price.longValue()));
            uccLadderPricePO.setId(uccLadderPrice.getId());
            this.uccLadderPriceMapper.updateByExampleSelective(uccLadderPricePO);
        }
    }

    private void dealStock(UccUpdateSalesVolumeBO uccUpdateSaleNumBo) {
        if (uccUpdateSaleNumBo == null) {
            return;
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccUpdateSaleNumBo.getSaleNumBos())) {
            return;
        }
        Map<Integer, List<UccUpdateSaleNumBo>> map = uccUpdateSaleNumBo.getSaleNumBos().stream().filter(a -> a.getIncOrDec() != null).collect(Collectors.groupingBy(UccUpdateSaleNumBo::getIncOrDec));
        if (!CollectionUtils.isEmpty(map)) {
            for (Map.Entry<Integer, List<UccUpdateSaleNumBo>> each : map.entrySet()) {
                List<UccUpdateSaleNumBo> uccUpdateSaleNumBos = each.getValue();
                ArrayList<SmcsdkStockNumInfoBO> smcsdkStockNumInfoBOS = new ArrayList<SmcsdkStockNumInfoBO>();
                for (UccUpdateSaleNumBo uccUpdateSaleNumBo1 : uccUpdateSaleNumBos) {
                    SmcsdkStockNumInfoBO smcsdkStockNumInfoBO = new SmcsdkStockNumInfoBO();
                    smcsdkStockNumInfoBO.setSkuId(uccUpdateSaleNumBo1.getSkuId().toString());
                    smcsdkStockNumInfoBO.setOperateNum(Long.valueOf(uccUpdateSaleNumBo1.getSoldNumber().longValue()));
                    smcsdkStockNumInfoBOS.add(smcsdkStockNumInfoBO);
                }
                SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO = new SmcsdkOperateStockNumReqBO();
                smcsdkOperateStockNumReqBO.setSmcsdkStockNumInfoBOs(smcsdkStockNumInfoBOS);
                if (each.getKey() == 1) {
                    smcsdkOperateStockNumReqBO.setOperateType("40");
                } else if (each.getKey() == 0) {
                    smcsdkOperateStockNumReqBO.setOperateType("11");
                }
                try {
                    log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5165\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
                    SmcsdkOperateStockNumRspBO smcsdkOperateStockNumRspBO = this.smcsdkOperateStockNumService.operateStockNum(smcsdkOperateStockNumReqBO);
                    if ("0000".equals(smcsdkOperateStockNumRspBO.getRespCode())) {
                        log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u51fa\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
                        continue;
                    }
                    throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25\uff1a" + smcsdkOperateStockNumRspBO.getRespDesc());
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25:" + e.getMessage());
                }
            }
        }
    }

    private void insertWhiteList(AgrMessageBo reqBO) {
        ArrayList<UccOrgSkuWhiteRestrictionBo> uccOrgSkuWhiteRestrictionBos = new ArrayList<UccOrgSkuWhiteRestrictionBo>();
        ArrayList<UccSkuPo> agrASpu = new ArrayList<UccSkuPo>();
        for (UccAgrScopeSyncBO uccAgrScopeSyncBO : reqBO.getAgrScopeSyncBOs()) {
            UccSkuPo uccCommodityPo = new UccSkuPo();
            uccCommodityPo.setAgreementId(uccAgrScopeSyncBO.getAgreementId());
            List commodityPoList = this.uccSkuMapper.qerySku(uccCommodityPo);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)commodityPoList)) {
                log.info("insertWhiteList commodityPoList isEmpty agrId={}", (Object)uccAgrScopeSyncBO.getAgreementId());
            } else {
                agrASpu.addAll(commodityPoList);
            }
            if (allRange.equals(uccAgrScopeSyncBO.getScopeCodes())) continue;
            String supplierId = this.getSupplier(uccAgrScopeSyncBO.getAgreementId());
            if (INNER_RANGE.equals(uccAgrScopeSyncBO.getScopeCodes()) || INNER_RANGE_V2.equals(uccAgrScopeSyncBO.getScopeCodes())) {
                if (supplierId == null) {
                    uccAgrScopeSyncBO.setScopeCodes("[3,4]");
                } else {
                    uccAgrScopeSyncBO.setScopeCodes("[3,4," + supplierId + "]");
                }
            } else if (OUTER_RANGE.equals(uccAgrScopeSyncBO.getScopeCodes()) || OUTER_RANGE_V2.equals(uccAgrScopeSyncBO.getScopeCodes())) {
                if (supplierId == null) {
                    uccAgrScopeSyncBO.setScopeCodes("[2]");
                } else {
                    uccAgrScopeSyncBO.setScopeCodes("[2," + supplierId + "]");
                }
            } else if (supplierId != null) {
                String scopeCodes = uccAgrScopeSyncBO.getScopeCodes();
                uccAgrScopeSyncBO.setScopeCodes("[" + scopeCodes.substring(1, scopeCodes.length() - 1) + "," + supplierId + "]");
            }
            List list = JSONObject.parseArray((String)uccAgrScopeSyncBO.getScopeCodes(), String.class);
            for (String each : list) {
                UccOrgSkuWhiteRestrictionBo uccOrgSkuWhiteRestrictionPo = new UccOrgSkuWhiteRestrictionBo();
                uccOrgSkuWhiteRestrictionPo.setAgreementId(uccAgrScopeSyncBO.getAgreementId());
                uccOrgSkuWhiteRestrictionPo.setSkuSource(3);
                uccOrgSkuWhiteRestrictionPo.setCreateOperId("message sync");
                uccOrgSkuWhiteRestrictionPo.setId(Long.valueOf(this.uccBatchSequence.nextId()));
                uccOrgSkuWhiteRestrictionPo.setOrgId(Long.valueOf(each));
                uccOrgSkuWhiteRestrictionPo.setOrgTreePath(each);
                uccOrgSkuWhiteRestrictionPo.setStatus(1);
                uccOrgSkuWhiteRestrictionBos.add(uccOrgSkuWhiteRestrictionPo);
            }
        }
        log.info("insertWhiteList uccOrgSkuWhiteRestrictionBos={}", (Object)JSONObject.toJSONString(uccOrgSkuWhiteRestrictionBos));
        if (CollectionUtils.isEmpty(uccOrgSkuWhiteRestrictionBos)) {
            this.sendMQ(agrASpu);
            return;
        }
        UccOrgSkuWhiteRestrictionBusiReqBo uccOrgSkuWhiteRestrictionBusiReqBo = new UccOrgSkuWhiteRestrictionBusiReqBo();
        uccOrgSkuWhiteRestrictionBusiReqBo.setWhites(uccOrgSkuWhiteRestrictionBos);
        uccOrgSkuWhiteRestrictionBusiReqBo.setFromAgr(Boolean.valueOf(true));
        try {
            this.uccOrgAgrWhiteRestrictionBusiService.dealWhite(uccOrgSkuWhiteRestrictionBusiReqBo);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
        this.sendMQ(agrASpu);
    }

    private void sendMQ(List<UccSkuPo> agrASpu) {
        if (!CollectionUtils.isEmpty(agrASpu)) {
            Map<Long, List<UccSkuPo>> agrSpu = agrASpu.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
            for (Long shopId : agrSpu.keySet()) {
                List spuIds = agrSpu.get(shopId).stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList());
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setCommodityIds(spuIds);
                syncSceneCommodityToEsReqBO.setSupplierId(shopId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                if (log.isDebugEnabled()) {
                    LOGGER.debug("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
                }
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    LOGGER.error("\u540c\u6b65\u767d\u540d\u5355\u5931\u8d25\uff0c\u53d1\u9001es MQ\u5931\u8d25\uff1a" + e);
                    throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
                }
            }
        }
    }

    private String getSupplier(Long agreementId) {
        List supplierId = this.uccSkuMapper.getVendorByAgrId(agreementId);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)supplierId)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Long id : supplierId) {
            sb.append(id).append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }
}

