/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.config.consumer;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitAmountQryBo;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitAmountSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitHisSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitMqSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitSubDo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UmcPurchaseLimitMessageConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(UmcPurchaseLimitMessageConsumer.class);
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        log.info("\u91c7\u8d2d\u9650\u989d\u63a5\u6536\u5230\u6d88\u606f\uff1a{}\uff0c\u5185\u5bb9\uff1a{}", (Object)message.getMessageId(), JSON.toJSON((Object)message.getContent()));
        UmcPurchaseLimitMqSubDo umcPurchaseLimitMqSubDo = (UmcPurchaseLimitMqSubDo)JSON.parseObject((String)message.getContent(), UmcPurchaseLimitMqSubDo.class);
        if (umcPurchaseLimitMqSubDo != null) {
            UmcPurchaseLimitQryBo qryBo = new UmcPurchaseLimitQryBo();
            qryBo.setValId(umcPurchaseLimitMqSubDo.getPurchaseValId());
            qryBo.setCurrentTime(new Date());
            StrUtil.noNullStringAttr((Object)((Object)qryBo));
            UmcPurchaseLimitSubDo rspDo = this.iUmcPurchaseLimitModel.getPurchaseLimitDetail(qryBo);
            UmcPurchaseLimitAmountSubDo amountSubDo = new UmcPurchaseLimitAmountSubDo();
            if (rspDo.getPurchaseAmount() != null) {
                amountSubDo.setPurchaseAmount(rspDo.getPurchaseAmount().add(umcPurchaseLimitMqSubDo.getPurchaseAmount()));
            }
            UmcPurchaseLimitAmountQryBo amountQryBo = new UmcPurchaseLimitAmountQryBo();
            amountQryBo.setValId(rspDo.getValId());
            this.iUmcPurchaseLimitModel.updatePurchaseLimitAmount(amountSubDo, amountQryBo);
            UmcPurchaseLimitHisSubDo hisSubDo = this.buildHisDo(amountSubDo, umcPurchaseLimitMqSubDo);
            this.iUmcPurchaseLimitModel.createPurchaseLimitHis(hisSubDo);
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private UmcPurchaseLimitHisSubDo buildHisDo(UmcPurchaseLimitAmountSubDo reqDo, UmcPurchaseLimitMqSubDo umcPurchaseLimitMqSubDo) {
        UmcPurchaseLimitHisSubDo hisSubDo = new UmcPurchaseLimitHisSubDo();
        hisSubDo.setChngType(umcPurchaseLimitMqSubDo.getOperateType());
        hisSubDo.setValId(reqDo.getValId());
        hisSubDo.setLimitConfigId(reqDo.getLimitConfigId());
        hisSubDo.setLimitYear(reqDo.getLimitYear());
        BigDecimal purchaseAmountBefore = reqDo.getLimitAmount().add(reqDo.getAccumulationAmount());
        BigDecimal purchaseAmountAfter = purchaseAmountBefore.subtract(umcPurchaseLimitMqSubDo.getPurchaseAmount());
        hisSubDo.setPurchaseAmountBefore(purchaseAmountBefore);
        hisSubDo.setChngPurchaseAmount(reqDo.getLimitAmount());
        hisSubDo.setPurchaseAmountAfter(purchaseAmountAfter);
        if ("deduct".equals(umcPurchaseLimitMqSubDo.getOperateType())) {
            hisSubDo.setChngRemark("\u91c7\u8d2d\u6263\u51cf");
        } else if ("cancle".equals(umcPurchaseLimitMqSubDo.getOperateType())) {
            hisSubDo.setChngRemark("\u91c7\u8d2d\u9650\u989d\u91ca\u653e");
        } else if ("return".equals(umcPurchaseLimitMqSubDo.getOperateType())) {
            hisSubDo.setChngRemark("\u91c7\u8d2d\u9650\u989d\u91ca\u653e");
        }
        hisSubDo.setCreateOperId(umcPurchaseLimitMqSubDo.getOperateId());
        if (StringUtils.isBlank((CharSequence)umcPurchaseLimitMqSubDo.getOperateName())) {
            umcPurchaseLimitMqSubDo.setOperateName("\u7cfb\u7edf");
        }
        hisSubDo.setCreateOperName(umcPurchaseLimitMqSubDo.getOperateName());
        hisSubDo.setCreateTime(new Date());
        hisSubDo.setHisId(IdUtil.nextId());
        return hisSubDo;
    }
}

