/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.purchaselimit;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitDo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitConfigQryBo;
import com.tydic.dyc.umc.service.purchaselimit.UmcEnablePurchaseLimitConfigService;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcEnablePurchaseLimitConfigReqBo;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcEnablePurchaseLimitConfigRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.purchaselimit.UmcEnablePurchaseLimitConfigService"})
public class UmcEnablePurchaseLimitConfigServiceImpl
implements UmcEnablePurchaseLimitConfigService {
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;

    @PostMapping(value={"enablePurchaseLimitConfig"})
    public UmcEnablePurchaseLimitConfigRspBo enablePurchaseLimitConfig(@RequestBody UmcEnablePurchaseLimitConfigReqBo reqBo) {
        UmcEnablePurchaseLimitConfigRspBo rspBo = (UmcEnablePurchaseLimitConfigRspBo)UmcRu.success(UmcEnablePurchaseLimitConfigRspBo.class);
        this.validateArg(reqBo);
        UmcPurchaseLimitConfigQryBo configQryBo = new UmcPurchaseLimitConfigQryBo();
        configQryBo.setLimitConfigIds(configQryBo.getLimitConfigIds());
        IUmcPurchaseLimitDo reqDo = this.buildDoByBO(reqBo);
        this.iUmcPurchaseLimitModel.updatePurchaseLimitConfig(reqDo, configQryBo);
        return rspBo;
    }

    private IUmcPurchaseLimitDo buildDoByBO(UmcEnablePurchaseLimitConfigReqBo reqBo) {
        IUmcPurchaseLimitDo reqDo = (IUmcPurchaseLimitDo)UmcRu.js((Object)reqBo, IUmcPurchaseLimitDo.class);
        reqDo.setLimitStatus("1");
        return reqDo;
    }

    private void validateArg(UmcEnablePurchaseLimitConfigReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UmcDisablePurchaseLimitConfigReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getLimitConfigIds())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[LimitConfigIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

