/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.purchaselimit;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitAmountQryBo;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitAmountSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitHisSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitSubDo;
import com.tydic.dyc.umc.service.purchaselimit.UmcOperatePurchaseLimitAmountMqService;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcOperatePurchaseLimitAmountMqReqBo;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcOperatePurchaseLimitAmountMqRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.purchaselimit.UmcOperatePurchaseLimitAmountMqService"})
public class UmcOperatePurchaseLimitAmountMqServiceImpl
implements UmcOperatePurchaseLimitAmountMqService {
    private static final Logger log = LoggerFactory.getLogger(UmcOperatePurchaseLimitAmountMqServiceImpl.class);
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;

    @PostMapping(value={"updatePurchaseLimitAmountMq"})
    public UmcOperatePurchaseLimitAmountMqRspBo updatePurchaseLimitAmountMq(@RequestBody UmcOperatePurchaseLimitAmountMqReqBo reqBo) {
        log.info("\u91c7\u8d2d\u9650\u989d\u63a5\u6536\u5230\u6d88\u606f\uff1a{},", (Object)reqBo);
        this.validateArg(reqBo);
        UmcPurchaseLimitQryBo qryBo = new UmcPurchaseLimitQryBo();
        qryBo.setValId(reqBo.getPurchaseValId());
        qryBo.setCurrentTime(new Date());
        qryBo.setDelFlag(null);
        StrUtil.noNullStringAttr((Object)((Object)qryBo));
        UmcPurchaseLimitSubDo rspDo = this.iUmcPurchaseLimitModel.getPurchaseLimitDetail(qryBo);
        UmcPurchaseLimitAmountSubDo amountSubDo = (UmcPurchaseLimitAmountSubDo)UmcRu.js((Object)rspDo, UmcPurchaseLimitAmountSubDo.class);
        String chngRemark = "\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef";
        if ("deduct".equals(reqBo.getOperateType())) {
            chngRemark = "\u91c7\u8d2d\u9650\u989d\u6263\u51cf";
            amountSubDo.setPurchaseAmount(rspDo.getPurchaseAmount().add(reqBo.getPurchaseAmount()));
        } else if ("cancle".equals(reqBo.getOperateType())) {
            amountSubDo.setPurchaseAmount(rspDo.getPurchaseAmount().subtract(reqBo.getPurchaseAmount()));
            chngRemark = "\u91c7\u8d2d\u9650\u989d\u91ca\u653e";
        } else if ("return".equals(reqBo.getOperateType())) {
            amountSubDo.setPurchaseAmount(rspDo.getPurchaseAmount().subtract(reqBo.getPurchaseAmount()));
            chngRemark = "\u91c7\u8d2d\u9650\u989d\u91ca\u653e";
        }
        UmcPurchaseLimitAmountQryBo amountQryBo = new UmcPurchaseLimitAmountQryBo();
        amountQryBo.setValId(rspDo.getValId());
        this.iUmcPurchaseLimitModel.updatePurchaseLimitAmount(amountSubDo, amountQryBo);
        UmcPurchaseLimitHisSubDo hisSubDo = this.buildHisDo(rspDo, reqBo, chngRemark);
        this.iUmcPurchaseLimitModel.createPurchaseLimitHis(hisSubDo);
        UmcOperatePurchaseLimitAmountMqRspBo rspBo = new UmcOperatePurchaseLimitAmountMqRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private UmcPurchaseLimitHisSubDo buildHisDo(UmcPurchaseLimitSubDo umcPurchaseLimitSubDo, UmcOperatePurchaseLimitAmountMqReqBo umcPurchaseLimitMqSubDo, String chngRemark) {
        UmcPurchaseLimitHisSubDo hisSubDo = new UmcPurchaseLimitHisSubDo();
        hisSubDo.setChngType(umcPurchaseLimitMqSubDo.getOperateType());
        hisSubDo.setValId(umcPurchaseLimitSubDo.getValId());
        hisSubDo.setLimitConfigId(umcPurchaseLimitSubDo.getLimitConfigId());
        hisSubDo.setLimitYear(umcPurchaseLimitSubDo.getLimitYear());
        BigDecimal purchaseAmount = "cancle".equals(umcPurchaseLimitMqSubDo.getOperateType()) || "return".equals(umcPurchaseLimitMqSubDo.getOperateType()) ? umcPurchaseLimitMqSubDo.getPurchaseAmount().negate() : umcPurchaseLimitMqSubDo.getPurchaseAmount();
        BigDecimal purchaseAmountBefore = umcPurchaseLimitSubDo.getLimitAmount().add(umcPurchaseLimitSubDo.getAccumulationAmount()).subtract(umcPurchaseLimitSubDo.getPurchaseAmount());
        BigDecimal purchaseAmountAfter = purchaseAmountBefore.subtract(purchaseAmount).abs();
        hisSubDo.setPurchaseAmountBefore(purchaseAmountBefore);
        hisSubDo.setChngPurchaseAmount(purchaseAmount);
        hisSubDo.setPurchaseAmountAfter(purchaseAmountAfter);
        hisSubDo.setChngRemark(!StringUtils.isEmpty((CharSequence)umcPurchaseLimitMqSubDo.getOperNode()) ? umcPurchaseLimitMqSubDo.getOperNode() : chngRemark);
        hisSubDo.setCreateOperId(umcPurchaseLimitMqSubDo.getOperateId());
        if (StringUtils.isBlank((CharSequence)umcPurchaseLimitMqSubDo.getOperateName())) {
            umcPurchaseLimitMqSubDo.setOperateName("\u7cfb\u7edf");
        }
        hisSubDo.setCreateOperName(umcPurchaseLimitMqSubDo.getOperateName());
        hisSubDo.setCreateTime(new Date());
        hisSubDo.setExtField1(umcPurchaseLimitMqSubDo.getOrderCode());
        hisSubDo.setExtField2(String.valueOf(umcPurchaseLimitMqSubDo.getPurchaseAmount()));
        hisSubDo.setHisId(IdUtil.nextId());
        return hisSubDo;
    }

    private void validateArg(UmcOperatePurchaseLimitAmountMqReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOperateType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getPurchaseAmount() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u91c7\u8d2d\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

