/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.purchaselimit;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitDo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitAmountQryBo;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitConfigQryBo;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitAmountSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitHisSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitSubDo;
import com.tydic.dyc.umc.service.purchaselimit.UmcUpdatePurchaseLimitConfigService;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcUpdatePurchaseLimitConfigReqBo;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcUpdatePurchaseLimitConfigRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.purchaselimit.UmcUpdatePurchaseLimitConfigService"})
public class UmcUpdatePurchaseLimitConfigServiceImpl
implements UmcUpdatePurchaseLimitConfigService {
    private static final Logger log = LoggerFactory.getLogger(UmcUpdatePurchaseLimitConfigServiceImpl.class);
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;
    @Autowired
    private CacheClient cacheClient;

    @PostMapping(value={"updatePurchaseLimitConfig"})
    public UmcUpdatePurchaseLimitConfigRspBo updatePurchaseLimitConfig(@RequestBody UmcUpdatePurchaseLimitConfigReqBo reqBo) {
        UmcUpdatePurchaseLimitConfigRspBo rspBo = (UmcUpdatePurchaseLimitConfigRspBo)UmcRu.success(UmcUpdatePurchaseLimitConfigRspBo.class);
        this.validateArg(reqBo);
        UmcPurchaseLimitQryBo qryBo = new UmcPurchaseLimitQryBo();
        qryBo.setLimitConfigId(reqBo.getLimitConfigId());
        qryBo.setCurrentTime(new Date());
        StrUtil.noNullStringAttr((Object)((Object)qryBo));
        UmcPurchaseLimitSubDo rspDo = this.iUmcPurchaseLimitModel.getPurchaseLimitDetail(qryBo);
        Calendar now = Calendar.getInstance();
        int month = now.get(2) + 1;
        log.info("\u521b\u5efa\u91c7\u8d2d\u9650\u989dmonth{}", (Object)month);
        Boolean chngType = false;
        if (rspDo == null) {
            throw new BaseBusinessException("100001", "\u4fee\u6539\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        if (rspDo.getLimitExpTime().compareTo(new Date()) < 0) {
            throw new BaseBusinessException("100001", "\u4fee\u6539\u5bf9\u8c61\u5df2\u8fc7\u671f");
        }
        if (!StringUtils.isEmpty((Object)reqBo.getLimitType()) && !reqBo.getLimitType().equals(rspDo.getLimitType())) {
            chngType = true;
        }
        if (month != 12 && chngType.booleanValue()) {
            throw new BaseBusinessException("100001", "\u9650\u5236\u7c7b\u884c\u53ea\u80fd\u572812\u6708\u4efd\u4fee\u6539");
        }
        IUmcPurchaseLimitDo reqDo = this.buildDoByBO(reqBo);
        if (reqBo.getLimitAmount().compareTo(rspDo.getPurchaseAmount()) < 0) {
            throw new BaseBusinessException("100001", "\u9650\u5236\u989d\u5ea6\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u5df2\u91c7\u8d2d\u989d\u5ea6");
        }
        String redisKey = "UMC_PURCHASE_LIMIT_" + rspDo.getLimitObjType() + "_" + rspDo.getLimitObjCode();
        Long currenNum = this.cacheClient.incrBy(redisKey, 0L);
        BigDecimal currentLimit = BigDecimal.ZERO;
        try {
            currentLimit = MoneyUtils.Long2BigDecimal((Long)currenNum);
        }
        catch (Exception e) {
            throw new BaseBusinessException("100001", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
        if (reqBo.getLimitAmount().compareTo(currentLimit) < 0) {
            throw new BaseBusinessException("100001", "\u9650\u5236\u989d\u5ea6\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u5df2\u91c7\u8d2d\u989d\u5ea6");
        }
        UmcPurchaseLimitConfigQryBo configQryBo = new UmcPurchaseLimitConfigQryBo();
        configQryBo.setLimitConfigId(reqBo.getLimitConfigId());
        this.iUmcPurchaseLimitModel.updatePurchaseLimitConfig(reqDo, configQryBo);
        UmcPurchaseLimitAmountSubDo amountSubDo = this.buildAmountDo(reqDo);
        UmcPurchaseLimitAmountQryBo amountQryBo = new UmcPurchaseLimitAmountQryBo();
        amountQryBo.setValId(rspDo.getValId());
        this.iUmcPurchaseLimitModel.updatePurchaseLimitAmount(amountSubDo, amountQryBo);
        UmcPurchaseLimitHisSubDo hisSubDo = this.buildHisDo(amountSubDo, rspDo, reqBo);
        hisSubDo.setValId(amountQryBo.getValId());
        this.iUmcPurchaseLimitModel.createPurchaseLimitHis(hisSubDo);
        return rspBo;
    }

    private IUmcPurchaseLimitDo buildDoByBO(UmcUpdatePurchaseLimitConfigReqBo reqBo) {
        IUmcPurchaseLimitDo reqDo = new IUmcPurchaseLimitDo();
        reqDo.setIsLimit(reqBo.getIsLimit());
        reqDo.setLimitType(reqBo.getLimitType());
        reqDo.setIsAccumulation(reqBo.getIsAccumulation());
        reqDo.setLimitAmount(reqBo.getLimitAmount());
        reqDo.setUpdateOperId(reqBo.getUpdateOperId());
        reqDo.setUpdateOperName(reqBo.getUpdateOperName());
        reqDo.setCreateOperId(reqBo.getUpdateOperId());
        reqDo.setCreateOperName(reqBo.getCreateOperName());
        reqDo.setUpdateTime(reqBo.getUpdateTime());
        reqDo.setExtField1(reqBo.getExtField1());
        reqDo.setExtField2(reqBo.getExtField2());
        reqDo.setExtField3(reqBo.getExtField3());
        reqDo.setExtField4(reqBo.getExtField4());
        reqDo.setExtField5(reqBo.getExtField5());
        reqDo.setExtField6(reqBo.getExtField6());
        reqDo.setExtField7(reqBo.getExtField7());
        reqDo.setExtField8(reqBo.getExtField8());
        reqDo.setExtField9(reqBo.getExtField9());
        reqDo.setExtField10(reqBo.getExtField10());
        return reqDo;
    }

    private UmcPurchaseLimitAmountSubDo buildAmountDo(IUmcPurchaseLimitDo reqDo) {
        UmcPurchaseLimitAmountSubDo amountSubDo = new UmcPurchaseLimitAmountSubDo();
        amountSubDo.setLimitAmount(reqDo.getLimitAmount());
        amountSubDo.setUpdateOperId(reqDo.getUpdateOperId());
        amountSubDo.setUpdateOperName(reqDo.getUpdateOperName());
        amountSubDo.setUpdateTime(reqDo.getUpdateTime());
        amountSubDo.setCreateOperId(reqDo.getCreateOperId());
        amountSubDo.setCreateOperName(reqDo.getCreateOperName());
        amountSubDo.setIsAccumulation(reqDo.getIsAccumulation());
        return amountSubDo;
    }

    private UmcPurchaseLimitHisSubDo buildHisDo(UmcPurchaseLimitAmountSubDo reqDo, UmcPurchaseLimitSubDo rspDo, UmcUpdatePurchaseLimitConfigReqBo reqBo) {
        UmcPurchaseLimitHisSubDo hisSubDo = new UmcPurchaseLimitHisSubDo();
        hisSubDo.setChngType("modify");
        hisSubDo.setValId(rspDo.getValId());
        hisSubDo.setLimitConfigId(rspDo.getLimitConfigId());
        hisSubDo.setLimitYear(rspDo.getLimitYear());
        BigDecimal beforMoney = rspDo.getLimitAmount().add(rspDo.getAccumulationAmount());
        BigDecimal chngMoney = beforMoney.subtract(reqBo.getLimitAmount());
        hisSubDo.setPurchaseAmountBefore(beforMoney.subtract(rspDo.getPurchaseAmount()));
        hisSubDo.setChngPurchaseAmount(chngMoney);
        hisSubDo.setPurchaseAmountAfter(reqBo.getLimitAmount().subtract(rspDo.getPurchaseAmount()));
        hisSubDo.setChngRemark("\u4fee\u6539\u91c7\u8d2d\u9650\u989d");
        hisSubDo.setCreateOperId(reqDo.getCreateOperId());
        hisSubDo.setCreateOperName(reqDo.getCreateOperName());
        hisSubDo.setCreateTime(reqDo.getCreateTime());
        hisSubDo.setHisId(IdUtil.nextId());
        return hisSubDo;
    }

    private void validateArg(UmcUpdatePurchaseLimitConfigReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UmcUpdatePurchaseLimitConfigReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getLimitConfigId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[LimitConfigId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

