/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.roleJobGroup;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.authority.model.common.sub.SysRoleInfoSubDo;
import com.tydic.dyc.authority.model.menu.ISysMenuModel;
import com.tydic.dyc.authority.model.menu.SysMenuDo;
import com.tydic.dyc.authority.model.menu.qrybo.SysMenuQryBo;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.impl.ISysOrgInfoModelImpl;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.authority.model.subpageRel.ISysSubPageRelModel;
import com.tydic.dyc.authority.model.subpageRel.qrybo.SysAuthMenuBindPageRspBo;
import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.SysUserInfoDo;
import com.tydic.dyc.authority.model.user.qrybo.SysUserInfoQryBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthGetUserAccessMenuReqBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthGetUserAccessMenuRspBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthRoleInfoBo;
import com.tydic.dyc.authority.service.menu.bo.AuthMenuInfoBo;
import com.tydic.dyc.authority.service.subpage.bo.AuthMenuBindPageBo;
import com.tydic.dyc.authority.service.subpage.bo.AuthSubpageInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.roleJobGroup.IUmcRoleJobGroupInfoModel;
import com.tydic.dyc.umc.model.roleJobGroup.qrybo.JobGroupRoleQryBo;
import com.tydic.dyc.umc.service.roleJobGroup.LdAuthGetUserAccessMenuService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.roleJobGroup.LdAuthGetUserAccessMenuService"})
public class LdAuthGetUserAccessMenuServiceImpl
implements LdAuthGetUserAccessMenuService {
    private static final Logger log = LoggerFactory.getLogger(LdAuthGetUserAccessMenuServiceImpl.class);
    @Autowired
    private ISysOrgInfoModelImpl iSysOrgInfoModel;
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;
    @Autowired
    private ISysMenuModel iSysMenuModel;
    @Autowired
    private ISysSubPageRelModel iSysSubPageRelModel;
    @Autowired
    private IUmcRoleJobGroupInfoModel iUmcRoleJobGroupInfoModel;

    @PostMapping(value={"getUserAccessMenu"})
    public AuthGetUserAccessMenuRspBo getUserAccessMenu(@RequestBody AuthGetUserAccessMenuReqBo reqBo) throws Exception {
        AuthGetUserAccessMenuRspBo rspBo = (AuthGetUserAccessMenuRspBo)AuthRu.success(AuthGetUserAccessMenuRspBo.class);
        SysOrgInfoQryBo orgQryBo = new SysOrgInfoQryBo();
        ArrayList<String> tagIdList = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getTagIdList())) {
            for (String tagId : reqBo.getTagIdList()) {
                if (!StringUtils.isNotBlank((CharSequence)tagId)) continue;
                tagIdList.add(tagId);
            }
        }
        tagIdList.add("9");
        orgQryBo.setOrgTreePath(reqBo.getOrgTreePath());
        orgQryBo.setTagIdList(tagIdList);
        orgQryBo.setRoleStatus("1");
        orgQryBo.setIsTimeRange(Integer.valueOf(1));
        SysOrgInfoDo orgInfoDo = this.iSysOrgInfoModel.getRoleInfoListByOrg(orgQryBo);
        Map orgRoleMaps = orgInfoDo.getOrgRoleList().stream().collect(Collectors.toMap(SysRoleInfoSubDo::getRoleId, Function.identity()));
        SysUserInfoQryBo userInfoQryBo = new SysUserInfoQryBo();
        userInfoQryBo.setUserId(reqBo.getUserId());
        userInfoQryBo.setTagIdList(tagIdList);
        userInfoQryBo.setRoleStatus("1");
        userInfoQryBo.setIsTimeRange(Integer.valueOf(1));
        SysUserInfoDo userInfoDo = this.iSysUserInfoModel.getRoleInfoListByUser(userInfoQryBo);
        Map userRolemaps = userInfoDo.getUserRoleList().stream().collect(Collectors.toMap(SysRoleInfoSubDo::getRoleId, Function.identity()));
        orgRoleMaps.putAll(userRolemaps);
        JobGroupRoleQryBo jobGroupRoleQryBo = new JobGroupRoleQryBo();
        jobGroupRoleQryBo.setUserId(reqBo.getUserId());
        jobGroupRoleQryBo.setTagIdList(tagIdList);
        SysUserInfoDo jobGroupInfoDo = this.iUmcRoleJobGroupInfoModel.getRoleInfoListByJobGroup(jobGroupRoleQryBo);
        Map jobGroupRolemaps = jobGroupInfoDo.getUserRoleList().stream().collect(Collectors.toMap(SysRoleInfoSubDo::getRoleId, Function.identity()));
        orgRoleMaps.putAll(jobGroupRolemaps);
        ArrayList RoleInfoSubDoList = new ArrayList(orgRoleMaps.values());
        rspBo.setRoleInfoList(AuthRu.jsl(RoleInfoSubDoList, AuthRoleInfoBo.class));
        ArrayList<Long> roleIdList = new ArrayList<Long>(orgRoleMaps.keySet());
        SysMenuQryBo menuQryBo = new SysMenuQryBo();
        if (CollectionUtils.isEmpty(roleIdList)) {
            throw new BaseBusinessException("101002", "\u65e0\u8bbf\u95ee\u6743\u9650");
        }
        ArrayList roleList = new ArrayList(orgRoleMaps.values());
        menuQryBo.setRoleIdList(roleIdList);
        menuQryBo.setMenuStatus("1");
        List menuDoList = this.iSysMenuModel.getMenuList(menuQryBo).getRows();
        log.info("\u67e5\u8be2\u83dc\u5355\u51fa\u9910\uff1a" + JSONObject.toJSONString((Object)menuDoList));
        List menuIds = menuDoList.stream().map(SysMenuDo::getMenuId).collect(Collectors.toList());
        Map<Object, Object> bindPageMap = new HashMap();
        if (!CollectionUtils.isEmpty(menuIds)) {
            AuthMenuBindPageBo authMenuBindPageBo = new AuthMenuBindPageBo();
            List strList1 = menuIds.stream().collect(Collectors.toList());
            authMenuBindPageBo.setMenuIds(strList1);
            SysAuthMenuBindPageRspBo sysAuthMenuBindPageRspBo = this.iSysSubPageRelModel.queryMenuBoundPage(authMenuBindPageBo);
            List bindPageBos = sysAuthMenuBindPageRspBo.getAuthMenuBindPageBoList();
            bindPageMap = bindPageBos.stream().collect(Collectors.groupingBy(AuthMenuBindPageBo::getMenuId));
        }
        log.info("\u5b50\u9875\u9762\u5206\u7ec4\u524d\uff1a" + JSONObject.toJSONString(bindPageMap));
        for (SysMenuDo sysMenuDo : menuDoList) {
            sysMenuDo.setDomainVal(sysMenuDo.getDomainUrl());
        }
        ArrayList<String> menuCodeList = new ArrayList<String>();
        ArrayList<String> buttonCodeList = new ArrayList<String>();
        HashMap menuMap = new HashMap();
        Map<String, List<AuthMenuInfoBo>> menuListMap = this.buildMenuBoByApplicationCode(menuDoList, menuCodeList, buttonCodeList);
        Map<Object, Object> finalBindPageMap = bindPageMap;
        log.info("\u5b50\u9875\u9762\u5206\u7ec4\uff1a" + JSONObject.toJSONString(finalBindPageMap));
        menuListMap.keySet().forEach(key -> {
            List accessMenus = (List)menuListMap.get(key);
            List menuInfos = AuthRu.jsl((List)accessMenus, AuthMenuInfoBo.class);
            if (menuInfos.size() > 0) {
                List<AuthMenuInfoBo> buildByRecursive = this.buildByRecursive(menuInfos, finalBindPageMap);
                menuMap.put(key, buildByRecursive);
            }
        });
        for (SysRoleInfoSubDo subDo : roleList) {
            buttonCodeList.add(subDo.getAuthIdentity());
        }
        log.info("\u8f6c\u5316\u83dc\u5355\u51fa\u9910\uff1a" + JSONObject.toJSONString(menuMap));
        rspBo.setMenus(menuMap);
        rspBo.setMenuCodeList(menuCodeList);
        rspBo.setPermission(buttonCodeList);
        return rspBo;
    }

    private Map<String, List<AuthMenuInfoBo>> buildMenuBoByApplicationCode(List<SysMenuDo> billingList, List<String> menuCodeList, List<String> buttonCodeList) throws Exception {
        HashMap<String, List<AuthMenuInfoBo>> resultMap = new HashMap<String, List<AuthMenuInfoBo>>();
        try {
            for (SysMenuDo accessMenuDo : billingList) {
                AuthMenuInfoBo accessMenuBo = (AuthMenuInfoBo)AuthRu.js((Object)accessMenuDo, AuthMenuInfoBo.class);
                if ("F".equals(accessMenuBo.getMenuType())) {
                    buttonCodeList.add(accessMenuBo.getMenuCode());
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)accessMenuDo.getDomainUrl())) {
                    accessMenuBo.setDomainVal(accessMenuDo.getDomainUrl());
                    accessMenuBo.setMenuUrl(accessMenuDo.getDomainUrl());
                }
                if (resultMap.containsKey(accessMenuDo.getApplicationCode())) {
                    ((List)resultMap.get(accessMenuBo.getApplicationCode())).add(accessMenuBo);
                } else {
                    ArrayList<AuthMenuInfoBo> tmpList = new ArrayList<AuthMenuInfoBo>();
                    tmpList.add(accessMenuBo);
                    resultMap.put(accessMenuBo.getApplicationCode(), tmpList);
                }
                menuCodeList.add(accessMenuDo.getMenuCode());
            }
        }
        catch (Exception e) {
            throw new Exception("\u6309\u7167\u5b50\u7cfb\u7edf\u7f16\u7801\u5bf9\u83dc\u5355\u6570\u636e\u8fdb\u884c\u5206\u7ec4\u65f6\u51fa\u73b0\u5f02\u5e38", e);
        }
        return resultMap;
    }

    private List<AuthMenuInfoBo> buildByRecursive(List<AuthMenuInfoBo> treeNodes, Map<Long, List<AuthMenuBindPageBo>> bindPageMap) {
        Collections.sort(treeNodes);
        ArrayList<AuthMenuInfoBo> trees = new ArrayList<AuthMenuInfoBo>();
        for (AuthMenuInfoBo treeNode : treeNodes) {
            if (treeNode.getParentId() != null) continue;
            trees.add(this.findChildren(treeNode, treeNodes, bindPageMap));
        }
        Collections.sort(trees);
        return trees;
    }

    private AuthMenuInfoBo findChildren(AuthMenuInfoBo root, List<AuthMenuInfoBo> allMenus, Map<Long, List<AuthMenuBindPageBo>> bindPageMap) {
        for (AuthMenuInfoBo it : allMenus) {
            if (!root.getMenuId().equals(it.getParentId())) continue;
            it.setSubPages(JSONObject.parseArray((String)JSONObject.toJSONString(bindPageMap.get(it.getMenuId())), AuthSubpageInfoBo.class));
            if (root.getChildren() == null) {
                root.setChildren(new ArrayList());
            }
            root.getChildren().add(this.findChildren(it, allMenus, bindPageMap));
        }
        return root;
    }
}

