/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseBankQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseContactQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseExtMapQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseInvoiceQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgTagRelQryBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseBank;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseContact;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseExtMap;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseInvoice;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgTagRel;
import com.tydic.dyc.umc.model.parkInfo.IUmcParkInfoModel;
import com.tydic.dyc.umc.model.parkInfo.sub.UmcParkInfoSubBo;
import com.tydic.dyc.umc.service.enterprise.UmcEnterpriseInfoUpdateService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseInfoUpdateReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseInfoUpdateRspBo;
import com.tydic.dyc.umc.service.parkInfo.bo.UmcParkInfoBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enterprise.UmcEnterpriseInfoUpdateService"})
public class LdUmcEnterpriseInfoUpdateServiceImpl
implements UmcEnterpriseInfoUpdateService {
    private static final Logger log = LoggerFactory.getLogger(LdUmcEnterpriseInfoUpdateServiceImpl.class);
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    private static final String ENTERPRISE_TYPE_ONE = "1";
    private static final String ENTERPRISE_TYPE_TWO = "2";
    @Autowired
    private IUmcParkInfoModel iUmcParkInfoModel;

    @PostMapping(value={"updateEnterpriseInfo"})
    public UmcEnterpriseInfoUpdateRspBo updateEnterpriseInfo(@RequestBody UmcEnterpriseInfoUpdateReqBo reqBo) {
        this.validateParams(reqBo);
        UmcOrgInfoQryBo orgInfoQryBo = new UmcOrgInfoQryBo();
        orgInfoQryBo.setOrgId(reqBo.getOrgId());
        UmcOrgInfo orgInfo = this.iUmcEnterpriseInfoModel.getOrgInfo(orgInfoQryBo);
        if (null == orgInfo) {
            throw new BaseBusinessException("201013", "\u4f01\u4e1a\u4fe1\u606f\u4fee\u6539\u5f02\u5e38\uff1a\u65e0\u6b64\u673a\u6784\u4fe1\u606f");
        }
        UmcEnterpriseInfoUpdateRspBo rspBo = (UmcEnterpriseInfoUpdateRspBo)UmcRu.success(UmcEnterpriseInfoUpdateRspBo.class);
        UmcOrgInfo setOrg = (UmcOrgInfo)UmcRu.js((Object)reqBo.getOrgInfoBo(), UmcOrgInfo.class);
        setOrg.setUpdateTime(new Date());
        setOrg.setExtField1(reqBo.getOrgInfoBo().getSupStatus());
        setOrg.setOrgId(reqBo.getOrgInfoBo().getOrgId());
        this.iUmcEnterpriseInfoModel.updateOrgInfo(setOrg);
        if (reqBo.getIsUpdateTagFlag().booleanValue()) {
            if (CollectionUtils.isEmpty((Collection)reqBo.getOrgInfoBo().getOrgTagRelList())) {
                UmcOrgTagRel orgTagRelSet = new UmcOrgTagRel();
                orgTagRelSet.setDelFlag(ENTERPRISE_TYPE_ONE);
                UmcOrgTagRel orgTagRelWhere = new UmcOrgTagRel();
                orgTagRelSet.setOrgId(reqBo.getOrgId());
                this.iUmcEnterpriseInfoModel.updateOrgTagIdRel(orgTagRelSet);
            } else {
                ArrayList<UmcOrgTagRel> addOrgTagRelList = new ArrayList<UmcOrgTagRel>();
                Iterator delOrgTagRelList = new ArrayList();
                List reqOrgTagRelList = UmcRu.jsl((List)reqBo.getOrgInfoBo().getOrgTagRelList(), UmcOrgTagRel.class);
                UmcOrgTagRelQryBo orgTagRelQryBo = new UmcOrgTagRelQryBo();
                orgTagRelQryBo.setOrgId(reqBo.getOrgId());
                List oldOrgTagRelList = this.iUmcEnterpriseInfoModel.getOrgTagRelList(orgTagRelQryBo).getOrgTagRelList();
                if (CollectionUtils.isEmpty((Collection)oldOrgTagRelList)) {
                    addOrgTagRelList.addAll(reqOrgTagRelList);
                } else {
                    ArrayList<UmcOrgTagRel> sameOldOrgTagIdRelList = new ArrayList<UmcOrgTagRel>();
                    ArrayList<UmcOrgTagRel> sameReqOrgTagIdRelList = new ArrayList<UmcOrgTagRel>();
                    for (UmcOrgTagRel oldOrgTagRel : oldOrgTagRelList) {
                        for (UmcOrgTagRel reqOrgTagRel : reqOrgTagRelList) {
                            if (!oldOrgTagRel.getTagId().equals(reqOrgTagRel.getTagId())) continue;
                            sameOldOrgTagIdRelList.add(oldOrgTagRel);
                            sameReqOrgTagIdRelList.add(reqOrgTagRel);
                        }
                    }
                    delOrgTagRelList.addAll(oldOrgTagRelList);
                    delOrgTagRelList.removeAll(sameOldOrgTagIdRelList);
                    addOrgTagRelList.addAll(reqOrgTagRelList);
                    addOrgTagRelList.removeAll(sameReqOrgTagIdRelList);
                }
                this.updateOrgTagRel((List<UmcOrgTagRel>)addOrgTagRelList, (List<UmcOrgTagRel>)((Object)delOrgTagRelList), orgInfo);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getEnterpriseInvoiceBoList())) {
            List enterpriseInvoiceList = UmcRu.jsl((List)reqBo.getEnterpriseInvoiceBoList(), UmcEnterpriseInvoice.class);
            for (UmcEnterpriseInvoice enterpriseInvoice : enterpriseInvoiceList) {
                if (null != enterpriseInvoice.getInvoiceId()) {
                    UmcEnterpriseInvoiceQryBo enterpriseInvoiceQryBo = new UmcEnterpriseInvoiceQryBo();
                    enterpriseInvoiceQryBo.setInvoiceId(enterpriseInvoice.getInvoiceId());
                    UmcEnterpriseInvoice umcEnterpriseInvoice = this.iUmcEnterpriseInfoModel.getEnterpriseInvoice(enterpriseInvoiceQryBo);
                    if (null == umcEnterpriseInvoice) {
                        throw new BaseBusinessException("201013", "\u4f01\u4e1a\u4fe1\u606f\u4fee\u6539\u5f02\u5e38\uff1a\u53d1\u7968\u4fee\u6539\uff0c\u672a\u67e5\u8be2\u5230\u53d1\u7968\u4fe1\u606f");
                    }
                    UmcEnterpriseInvoice whereInvoice = new UmcEnterpriseInvoice();
                    whereInvoice.setInvoiceId(enterpriseInvoice.getInvoiceId());
                    this.iUmcEnterpriseInfoModel.updateEnterpriseInvoice(enterpriseInvoice);
                    continue;
                }
                enterpriseInvoice.setInvoiceId(Long.valueOf(IdUtil.nextId()));
                this.iUmcEnterpriseInfoModel.createEnterpriseInvoice(enterpriseInvoice);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getEnterpriseBankBoList())) {
            List enterpriseBankList = UmcRu.jsl((List)reqBo.getEnterpriseBankBoList(), UmcEnterpriseBank.class);
            for (UmcEnterpriseBank enterpriseBank : enterpriseBankList) {
                if (null != enterpriseBank.getBankId()) {
                    UmcEnterpriseBankQryBo enterpriseBankQryBo = new UmcEnterpriseBankQryBo();
                    enterpriseBankQryBo.setBankId(enterpriseBank.getBankId());
                    UmcEnterpriseBank umcEnterpriseBank = this.iUmcEnterpriseInfoModel.getEnterpriseBank(enterpriseBankQryBo);
                    if (null == umcEnterpriseBank) {
                        throw new BaseBusinessException("201013", "\u4f01\u4e1a\u4fe1\u606f\u4fee\u6539\u5f02\u5e38\uff1a\u94f6\u884c\u4fee\u6539\uff0c\u672a\u67e5\u8be2\u5230\u94f6\u884c\u4fe1\u606f");
                    }
                    UmcEnterpriseBank whereBank = new UmcEnterpriseBank();
                    whereBank.setBankId(enterpriseBank.getBankId());
                    this.iUmcEnterpriseInfoModel.updateEnterpriseBank(enterpriseBank);
                    continue;
                }
                enterpriseBank.setBankId(Long.valueOf(IdUtil.nextId()));
                this.iUmcEnterpriseInfoModel.createEnterpriseBank(enterpriseBank);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getEnterpriseContactBoList())) {
            List enterpriseContactList = UmcRu.jsl((List)reqBo.getEnterpriseContactBoList(), UmcEnterpriseContact.class);
            for (UmcEnterpriseContact enterpriseContact : enterpriseContactList) {
                if (null != enterpriseContact.getContactId()) {
                    UmcEnterpriseContactQryBo enterpriseContactQryBo = new UmcEnterpriseContactQryBo();
                    enterpriseContactQryBo.setContactId(enterpriseContact.getContactId());
                    UmcEnterpriseContact umcEnterpriseContact = this.iUmcEnterpriseInfoModel.getEnterpriseContact(enterpriseContactQryBo);
                    if (null == umcEnterpriseContact) {
                        throw new BaseBusinessException("201013", "\u4f01\u4e1a\u4fe1\u606f\u4fee\u6539\u5f02\u5e38\uff1a\u53d1\u7968\u4fee\u6539\uff0c\u672a\u67e5\u8be2\u5230\u8054\u7cfb\u4eba\u4fe1\u606f");
                    }
                    UmcEnterpriseContact whereContact = new UmcEnterpriseContact();
                    whereContact.setContactId(enterpriseContact.getContactId());
                    UmcEnterpriseContact setContact = this.buildUpdateContact(enterpriseContact);
                    this.iUmcEnterpriseInfoModel.updateEnterpriseContact(setContact);
                    continue;
                }
                enterpriseContact.setContactId(Long.valueOf(IdUtil.nextId()));
                this.iUmcEnterpriseInfoModel.createEnterpriseContact(enterpriseContact);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getEnterpriseExt())) {
            List enterpriseExtMapList = UmcRu.jsl((List)reqBo.getEnterpriseExt(), UmcEnterpriseExtMap.class);
            for (UmcEnterpriseExtMap enterpriseExtMap : enterpriseExtMapList) {
                UmcEnterpriseExtMapQryBo enterpriseExtMapQryBo = new UmcEnterpriseExtMapQryBo();
                enterpriseExtMapQryBo.setFieldCode(enterpriseExtMap.getFieldCode());
                enterpriseExtMapQryBo.setFieldName(enterpriseExtMap.getFieldName());
                List umcEnterpriseExtMapList = this.iUmcEnterpriseInfoModel.getEnterpriseExtMapList(enterpriseExtMapQryBo).getEnterpriseExt();
                Date now = new Date();
                if (CollectionUtils.isEmpty((Collection)umcEnterpriseExtMapList)) {
                    if (null == enterpriseExtMap.getExtId()) {
                        enterpriseExtMap.setExtId(Long.valueOf(IdUtil.nextId()));
                    }
                    enterpriseExtMap.setCreateTime(now);
                    enterpriseExtMap.setCreateOperId(reqBo.getUpdateOperId());
                    enterpriseExtMap.setCreateOperName(reqBo.getUpdateOperName());
                    StrUtil.noNullStringAttr((Object)enterpriseExtMap);
                    this.iUmcEnterpriseInfoModel.createEnterpriseExtMap(enterpriseExtMap);
                    continue;
                }
                UmcEnterpriseExtMap whereExtMap = (UmcEnterpriseExtMap)UmcRu.js((Object)enterpriseExtMapQryBo, UmcEnterpriseExtMap.class);
                enterpriseExtMap.setUpdateOperName(reqBo.getUpdateOperName());
                enterpriseExtMap.setUpdateOperId(reqBo.getUpdateOperId());
                enterpriseExtMap.setUpdateTime(now);
                StrUtil.noNullStringAttr((Object)enterpriseExtMap);
                this.iUmcEnterpriseInfoModel.updateEnterpriseExtMap(enterpriseExtMap);
            }
        }
        String parkId = "";
        if (ENTERPRISE_TYPE_ONE.equals(reqBo.getExtField2())) {
            parkId = reqBo.getExtField4();
        } else if (ENTERPRISE_TYPE_TWO.equals(reqBo.getExtField2())) {
            UmcParkInfoSubBo umcParkInfoSubBo;
            UmcParkInfoBo umcParkInfoBo = (UmcParkInfoBo)JSONObject.parseObject((String)reqBo.getExtField4(), UmcParkInfoBo.class);
            log.debug("\u5ba2\u5546\u57fa\u672c\u4fe1\u606f\u4fee\u6539\u56ed\u533a\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)umcParkInfoBo));
            if (umcParkInfoBo.getParkId() != null) {
                parkId = umcParkInfoBo.getParkId().toString();
                umcParkInfoSubBo = new UmcParkInfoSubBo();
                umcParkInfoSubBo.setParkId(umcParkInfoBo.getParkId());
                umcParkInfoSubBo.setCityId(umcParkInfoBo.getCityId());
                umcParkInfoSubBo.setCityName(umcParkInfoBo.getCityName());
                umcParkInfoSubBo.setProvinceId(umcParkInfoBo.getProvinceId());
                umcParkInfoSubBo.setProvinceName(umcParkInfoBo.getProvinceName());
                umcParkInfoSubBo.setParkManager(umcParkInfoBo.getParkManager());
                umcParkInfoSubBo.setAreaManager(umcParkInfoBo.getAreaManager());
                umcParkInfoSubBo.setBelongRegion(umcParkInfoBo.getBelongRegion());
                umcParkInfoSubBo.setParkType(ENTERPRISE_TYPE_TWO);
                this.iUmcParkInfoModel.updateParkInfo(umcParkInfoSubBo);
            } else {
                umcParkInfoSubBo = new UmcParkInfoSubBo();
                umcParkInfoSubBo.setParkId(IdUtil.nextId());
                umcParkInfoSubBo.setCityId(umcParkInfoBo.getCityId());
                umcParkInfoSubBo.setCityName(umcParkInfoBo.getCityName());
                umcParkInfoSubBo.setProvinceId(umcParkInfoBo.getProvinceId());
                umcParkInfoSubBo.setProvinceName(umcParkInfoBo.getProvinceName());
                umcParkInfoSubBo.setParkManager(umcParkInfoBo.getParkManager());
                umcParkInfoSubBo.setAreaManager(umcParkInfoBo.getAreaManager());
                umcParkInfoSubBo.setBelongRegion(umcParkInfoBo.getBelongRegion());
                umcParkInfoSubBo.setParkType(ENTERPRISE_TYPE_TWO);
                this.iUmcParkInfoModel.createParkInfo(umcParkInfoSubBo);
                parkId = umcParkInfoSubBo.getParkId().toString();
            }
        }
        UmcEnterpriseInfoDo setInfo = (UmcEnterpriseInfoDo)UmcRu.js((Object)reqBo, UmcEnterpriseInfoDo.class);
        StrUtil.noNullStringAttr((Object)setInfo);
        this.buildUpdateEnterprise(setInfo, reqBo);
        setInfo.setOrgId(reqBo.getOrgId());
        setInfo.setExtField4(parkId);
        this.iUmcEnterpriseInfoModel.updateEnterpriseInfo(setInfo);
        return rspBo;
    }

    private UmcEnterpriseContact buildUpdateContact(UmcEnterpriseContact enterpriseContact) {
        UmcEnterpriseContact contact = (UmcEnterpriseContact)UmcRu.js((Object)enterpriseContact, UmcEnterpriseContact.class);
        StrUtil.noNullStringAttr((Object)contact);
        if (StringUtils.isEmpty((Object)enterpriseContact.getContactName())) {
            contact.setContactName("");
        }
        if (StringUtils.isEmpty((Object)enterpriseContact.getPhoneNumber())) {
            contact.setPhoneNumber("");
        }
        if (StringUtils.isEmpty((Object)enterpriseContact.getTel())) {
            contact.setTel("");
        }
        if (StringUtils.isEmpty((Object)enterpriseContact.getEmail())) {
            contact.setEmail("");
        }
        return contact;
    }

    private void buildUpdateEnterprise(UmcEnterpriseInfoDo setInfo, UmcEnterpriseInfoUpdateReqBo reqBo) {
        if (StringUtils.isEmpty((Object)reqBo.getOrgShortName())) {
            setInfo.setOrgShortName("");
        }
        if (StringUtils.isEmpty((Object)reqBo.getIsAbroad())) {
            setInfo.setIsAbroad("");
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusinessLicense())) {
            setInfo.setBusinessLicense("");
        }
        if (StringUtils.isEmpty((Object)reqBo.getFax())) {
            setInfo.setFax("");
        }
        if (StringUtils.isEmpty((Object)reqBo.getMailBox())) {
            setInfo.setMailBox("");
        }
    }

    private void updateOrgTagRel(List<UmcOrgTagRel> add, List<UmcOrgTagRel> del, UmcOrgInfo orgInfo) {
        for (UmcOrgTagRel addOrgTagRel : add) {
            addOrgTagRel.setOrgId(orgInfo.getOrgId());
            addOrgTagRel.setRelId(Long.valueOf(IdUtil.nextId()));
            addOrgTagRel.setTenantId(orgInfo.getTenantId());
            addOrgTagRel.setTagStatus(ENTERPRISE_TYPE_ONE);
            addOrgTagRel.setUpdateTime(new Date());
            StrUtil.noNullStringAttr((Object)addOrgTagRel);
            this.iUmcEnterpriseInfoModel.createOrgTagIdRel(addOrgTagRel);
        }
        for (UmcOrgTagRel delOrgTagRel : del) {
            delOrgTagRel.setDelFlag(ENTERPRISE_TYPE_ONE);
            delOrgTagRel.setUpdateTime(new Date());
            UmcOrgTagRel orgTagRelWhere = new UmcOrgTagRel();
            orgTagRelWhere.setRelId(delOrgTagRel.getRelId());
            StrUtil.noNullStringAttr((Object)delOrgTagRel);
            this.iUmcEnterpriseInfoModel.updateOrgTagIdRel(delOrgTagRel);
        }
    }

    private void validateParams(UmcEnterpriseInfoUpdateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u4fee\u6539 \u5165\u53c2\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrgInfoBo())) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u4fee\u6539 \u5165\u53c2[UmcOrgInfoBo]\u4e3a\u7a7a\uff01");
        }
        if (null == reqBo.getOrgId()) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u4fee\u6539 \u5165\u53c2[orgId]\u4e3a\u7a7a\uff01");
        }
    }
}

