/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.parkInfo;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.parkInfo.IUmcParkInfoModel;
import com.tydic.dyc.umc.model.parkInfo.qrybo.UmcParkInfoQryBo;
import com.tydic.dyc.umc.model.parkInfo.sub.UmcParkInfoSubBo;
import com.tydic.dyc.umc.service.parkInfo.UmcCreateParkInfoService;
import com.tydic.dyc.umc.service.parkInfo.bo.UmcCreateParkInfoReqBo;
import com.tydic.dyc.umc.service.parkInfo.bo.UmcCreateParkInfoRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.parkInfo.UmcCreateParkInfoService"})
public class UmcCreateParkInfoServiceImpl
implements UmcCreateParkInfoService {
    private static final Logger log = LoggerFactory.getLogger(UmcCreateParkInfoServiceImpl.class);
    @Autowired
    private IUmcParkInfoModel iUmcParkInfoModel;

    @PostMapping(value={"createParkInfo"})
    public UmcCreateParkInfoRspBo createParkInfo(@RequestBody UmcCreateParkInfoReqBo reqBo) {
        UmcCreateParkInfoRspBo rspBo = (UmcCreateParkInfoRspBo)UmcRu.success(UmcCreateParkInfoRspBo.class);
        this.validateArg(reqBo);
        this.validateUmcParkInfo(reqBo);
        UmcParkInfoSubBo umcParkInfoSubBo = (UmcParkInfoSubBo)UmcRu.js((Object)reqBo, UmcParkInfoSubBo.class);
        umcParkInfoSubBo.setParkId(IdUtil.nextId());
        umcParkInfoSubBo.setCreatedTime(new Date());
        umcParkInfoSubBo.setCreatedId(reqBo.getUserId());
        umcParkInfoSubBo.setCreatedName(reqBo.getUserName());
        umcParkInfoSubBo.setUpdatedId(reqBo.getUserId());
        umcParkInfoSubBo.setUpdatedName(reqBo.getUserName());
        umcParkInfoSubBo.setUpdatedTime(new Date());
        umcParkInfoSubBo.setParkType("1");
        try {
            this.iUmcParkInfoModel.createParkInfo(umcParkInfoSubBo);
        }
        catch (Exception e) {
            log.debug("\u56ed\u533a\u4fe1\u606f\u65b0\u589e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new BaseBusinessException("100001", "\u56ed\u533a\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
        }
        return rspBo;
    }

    private void validateUmcParkInfo(UmcCreateParkInfoReqBo reqBo) {
        UmcParkInfoQryBo umcParkInfoQryBo = new UmcParkInfoQryBo();
        umcParkInfoQryBo.setParkName(reqBo.getParkName());
        umcParkInfoQryBo.setParkType("1");
        long count = this.iUmcParkInfoModel.qryParkInfoCount(umcParkInfoQryBo);
        if (count > 0L) {
            throw new BaseBusinessException("100001", "\u8be5\u56ed\u533a\u540d\u79f0\u91cd\u590d\u5df2\u5b58\u5728");
        }
    }

    private void validateArg(UmcCreateParkInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getParkName())) {
            throw new BaseBusinessException("100001", "\u56ed\u533a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getUValleyDirector())) {
            throw new BaseBusinessException("100001", "U\u8c37\u603b\u76d1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getUValleySales())) {
            throw new BaseBusinessException("100001", "U\u8c37\u9500\u552e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getBelongRegion())) {
            throw new BaseBusinessException("100001", "\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getAreaManager())) {
            throw new BaseBusinessException("100001", "\u7247\u533a\u7ecf\u7406\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getParkManager())) {
            throw new BaseBusinessException("100001", "\u56ed\u533a\u7ecf\u7406\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

