/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.parkInfo;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.umc.model.parkInfo.IUmcParkInfoModel;
import com.tydic.dyc.umc.model.parkInfo.qrybo.UmcParkInfoQryBo;
import com.tydic.dyc.umc.model.parkInfo.sub.UmcParkInfoSubBo;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.service.parkInfo.UmcGetParkInfoListService;
import com.tydic.dyc.umc.service.parkInfo.bo.UmcGetParkInfoListReqBo;
import com.tydic.dyc.umc.service.parkInfo.bo.UmcGetParkInfoListRspBo;
import com.tydic.dyc.umc.service.parkInfo.bo.UmcParkInfoBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.parkInfo.UmcGetParkInfoListService"})
public class UmcGetParkInfoListServiceImpl
implements UmcGetParkInfoListService {
    private static final Logger log = LoggerFactory.getLogger(UmcGetParkInfoListServiceImpl.class);
    @Autowired
    private IUmcParkInfoModel iUmcParkInfoModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;

    @PostMapping(value={"getParkInfoList"})
    public UmcGetParkInfoListRspBo getParkInfoList(@RequestBody UmcGetParkInfoListReqBo reqBo) {
        UmcGetParkInfoListRspBo rspBo = (UmcGetParkInfoListRspBo)UmcRu.success(UmcGetParkInfoListRspBo.class);
        UmcParkInfoQryBo umcParkInfoQryBo = (UmcParkInfoQryBo)((Object)UmcRu.js((Object)reqBo, UmcParkInfoQryBo.class));
        BasePageRspBo<UmcParkInfoSubBo> umcParkInfoSubBos = this.iUmcParkInfoModel.getParkInfoList(umcParkInfoQryBo);
        if (umcParkInfoSubBos.getRows() == null || umcParkInfoSubBos.getRows().size() < 1) {
            rspBo.setPageNo(0);
            rspBo.setRecordsTotal(0);
            rspBo.setTotal(0);
            return rspBo;
        }
        List jsl = UmcRu.jsl((List)umcParkInfoSubBos.getRows(), UmcParkInfoBo.class);
        for (UmcParkInfoBo each : jsl) {
            if (StringUtils.isNotBlank((String)each.getProvinceName())) {
                String belongCityStr = each.getProvinceName();
                if (StringUtils.isNotBlank((String)each.getCityName())) {
                    belongCityStr = belongCityStr + "/" + each.getCityName();
                }
                each.setBelongCityStr(belongCityStr);
            }
            if (!StringUtils.isNotBlank((String)each.getBelongRegion())) continue;
            Map belongRegionMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "umc_region")).getMap();
            each.setBelongRegionStr((String)belongRegionMap.get(each.getBelongRegion()));
        }
        rspBo.setRows(jsl);
        rspBo.setPageNo(umcParkInfoSubBos.getPageNo());
        rspBo.setTotal(umcParkInfoSubBos.getTotal());
        rspBo.setRecordsTotal(umcParkInfoSubBos.getRecordsTotal());
        rspBo.setRespCode(umcParkInfoSubBos.getRespCode());
        rspBo.setRespDesc(umcParkInfoSubBos.getRespDesc());
        return rspBo;
    }
}

