/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.purchaselimit;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.ldOrganization.IUmcLdOrganizationInfoModel;
import com.tydic.dyc.umc.model.ldOrganization.UmcLdOrganizationInfoQryDo;
import com.tydic.dyc.umc.model.ldOrganization.qrybo.UmcLdOrganizationInfoQryBo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcDepPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitSubDo;
import com.tydic.dyc.umc.service.purchaselimit.UmcOperatePurchaseLimitAmountService;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcOperatePurchaseLimitAmountMqReqBo;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcOperatePurchaseLimitAmountReqBO;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcOperatePurchaseLimitAmountRspBO;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.MoneyUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Arrays;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.purchaselimit.UmcOperatePurchaseLimitAmountService"})
public class UmcOperatePurchasePurchaseLimitAmountServiceImpl
implements UmcOperatePurchaseLimitAmountService {
    private static final Logger log = LoggerFactory.getLogger(UmcOperatePurchasePurchaseLimitAmountServiceImpl.class);
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;
    @Autowired
    private IUmcLdOrganizationInfoModel iUmcLdOrganizationInfoModel;
    @Value(value="${UMC_PURCHASE_LIMIT_MESSAGE_TOPIC:UMC_PURCHASE_LIMIT_MESSAGE_TOPIC}")
    private String umcCreateTopic;
    @Value(value="${UMC_ERP_MESSAGE_TAG:*}")
    private String umcCreateTag;
    @Resource(name="umcPurchaseLimitMessageProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Autowired
    private CacheClient cacheClient;

    @PostMapping(value={"operateLimitAmount"})
    public UmcOperatePurchaseLimitAmountRspBO operateLimitAmount(@RequestBody UmcOperatePurchaseLimitAmountReqBO reqBO) {
        log.debug("\u91c7\u8d2d\u9650\u989d\u64cd\u4f5c\u5165\u53c2{}", (Object)reqBO);
        UmcOperatePurchaseLimitAmountRspBO rspBO = new UmcOperatePurchaseLimitAmountRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.validateArg(reqBO);
        UmcPurchaseLimitSubDo rspDo = new UmcPurchaseLimitSubDo();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getProjectCode())) {
            UmcPurchaseLimitQryBo qryBo = new UmcPurchaseLimitQryBo();
            qryBo.setLimitObjCode(reqBO.getProjectCode());
            qryBo.setLimitObjType("P1");
            qryBo.setCurrentTime(new Date());
            qryBo.setLimitStatus("1");
            StrUtil.noNullStringAttr((Object)((Object)qryBo));
            rspDo = this.iUmcPurchaseLimitModel.getPurchaseLimitDetail(qryBo);
        } else {
            if (reqBO.getOrgId() == null) {
                throw new BaseBusinessException("100001", "\u673a\u6784Id\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            UmcLdOrganizationInfoQryBo umcLdOrganizationInfoQryBo = new UmcLdOrganizationInfoQryBo();
            umcLdOrganizationInfoQryBo.setOrgId(reqBO.getOrgId());
            UmcLdOrganizationInfoQryDo umcLdOrganizationInfoQryDo = this.iUmcLdOrganizationInfoModel.qryLdOrgInfoDetail(umcLdOrganizationInfoQryBo);
            if (umcLdOrganizationInfoQryDo != null) {
                String orgNoFullPath = umcLdOrganizationInfoQryDo.getOrgNoFullPath();
                String[] split = orgNoFullPath.split("-");
                UmcDepPurchaseLimitQryBo umcDepPurchaseLimitQryBo = new UmcDepPurchaseLimitQryBo();
                umcDepPurchaseLimitQryBo.setLimitObjType("E1");
                umcDepPurchaseLimitQryBo.setLimitObjCodes(Arrays.asList(split));
                umcDepPurchaseLimitQryBo.setCurrentTime(new Date());
                umcDepPurchaseLimitQryBo.setLimitStatus("1");
                StrUtil.noNullStringAttr((Object)((Object)umcDepPurchaseLimitQryBo));
                rspDo = this.iUmcPurchaseLimitModel.getDepPurchaseLimitDetail(umcDepPurchaseLimitQryBo);
            }
        }
        if (rspDo == null) {
            throw new BaseBusinessException("100001", "\u6ca1\u6709\u91c7\u8d2d\u9650\u989d\u7981\u6b62\u4e0b\u5355!");
        }
        if ("0".equals(rspDo.getLimitStatus())) {
            throw new BaseBusinessException("100001", "\u91c7\u8d2d\u9650\u989d\u5df2\u7ecf\u88ab\u505c\u7528,\u7981\u6b62\u4e0b\u5355!");
        }
        Long purchaseAmount = MoneyUtil.bigDecimal2Long(reqBO.getPurchaseAmount());
        if ("deduct".equals(reqBO.getOperateType())) {
            this.placeLimitAmount(rspDo, reqBO, purchaseAmount);
        } else if ("cancle".equals(reqBO.getOperateType())) {
            this.blackLimitAmount(rspDo, reqBO, purchaseAmount);
        } else if ("return".equals(reqBO.getOperateType())) {
            this.blackLimitAmount(rspDo, reqBO, purchaseAmount);
        }
        this.sendMassage(reqBO, rspDo);
        return rspBO;
    }

    private void blackLimitAmount(UmcPurchaseLimitSubDo umcPurchaseLimitSubDo, UmcOperatePurchaseLimitAmountReqBO reqBO, Long purchaseAmount) {
        String redisKey = "UMC_PURCHASE_LIMIT_" + umcPurchaseLimitSubDo.getLimitObjType() + "_" + umcPurchaseLimitSubDo.getLimitObjCode();
        Long currenNum = this.cacheClient.incrBy(redisKey, 0L);
        if (currenNum == 0L) {
            this.cacheClient.incrBy(redisKey, MoneyUtil.bigDecimal2Long(umcPurchaseLimitSubDo.getPurchaseAmount()).longValue());
        }
        Long count = this.cacheClient.incrBy(redisKey, -purchaseAmount.longValue());
        log.info("\u56de\u9000\u540e\u7684\u91c7\u8d2d\u91d1\u989d\u4e3a" + count);
    }

    private void sendMassage(UmcOperatePurchaseLimitAmountReqBO reqBO, UmcPurchaseLimitSubDo rspDo) {
        UmcOperatePurchaseLimitAmountMqReqBo umcPurchaseLimitMqSubDo = (UmcOperatePurchaseLimitAmountMqReqBo)UmcRu.js((Object)reqBO, UmcOperatePurchaseLimitAmountMqReqBo.class);
        umcPurchaseLimitMqSubDo.setUniKey(Long.valueOf(IdUtil.nextId()));
        umcPurchaseLimitMqSubDo.setPurchaseValId(rspDo.getValId());
        log.info("\u53d1\u6d88\u606f\u66f4\u65b0\u5e93\u5b58\u4fe1\u606f\u53c2\u6570\u4e3a:" + JSON.toJSONString((Object)umcPurchaseLimitMqSubDo));
        ProxyMessage proxyMessage = new ProxyMessage(this.umcCreateTopic, this.umcCreateTag, JSON.toJSONString((Object)umcPurchaseLimitMqSubDo));
        ProxySendResult result = this.proxyMessageProducer.send(proxyMessage);
        log.info("\u53d1\u6d88\u606f\u66f4\u65b0\u5e93\u5b58\u4fe1\u606f\u5b8c\u6210\u7ed3\u679c\u4e3a\uff1a" + JSON.toJSONString((Object)result));
    }

    private void placeLimitAmount(UmcPurchaseLimitSubDo umcPurchaseLimitSubDo, UmcOperatePurchaseLimitAmountReqBO reqBO, Long purchaseAmount) {
        String redisKey = "UMC_PURCHASE_LIMIT_" + umcPurchaseLimitSubDo.getLimitObjType() + "_" + umcPurchaseLimitSubDo.getLimitObjCode();
        Long currenNum = this.cacheClient.incrBy(redisKey, 0L);
        if (currenNum == 0L) {
            this.cacheClient.incrBy(redisKey, MoneyUtil.bigDecimal2Long(umcPurchaseLimitSubDo.getPurchaseAmount()).longValue());
        }
        if ("0".equals(umcPurchaseLimitSubDo.getIsLimit())) {
            Long count = this.cacheClient.incrBy(redisKey, purchaseAmount.longValue());
            log.info("\u66f4\u65b0\u540e\u7684\u91c7\u8d2d\u91d1\u989d\u4e3a:" + count);
        } else {
            Long count = this.cacheClient.incrBy(redisKey, purchaseAmount.longValue());
            log.info("\u66f4\u65b0\u540e\u7684\u91c7\u8d2d\u91d1\u989d\u4e3a" + count);
            Long aLong = MoneyUtil.bigDecimal2Long(umcPurchaseLimitSubDo.getLimitAmount()) + MoneyUtil.bigDecimal2Long(umcPurchaseLimitSubDo.getAccumulationAmount());
            if (count > aLong) {
                this.cacheClient.incrBy(redisKey, -purchaseAmount.longValue());
                throw new BaseBusinessException("100001", "\u5df2\u7ecf\u8d85\u51fa\u9650\u989d\u4e86!");
            }
        }
    }

    private void validateArg(UmcOperatePurchaseLimitAmountReqBO reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOperateType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getPurchaseAmount() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u91c7\u8d2d\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

