/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.purchaselimit;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitDo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitAmountQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitAmountSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitHisSubDo;
import com.tydic.dyc.umc.service.purchaselimit.UmcTimedTaskPurchaseLimitService;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcTimedTaskPurchaseLimitReqBO;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcTimedTaskPurchaseLimitRspBO;
import com.tydic.dyc.umc.utils.DateUtil;
import com.tydic.dyc.umc.utils.IdUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.purchaselimit.UmcTimedTaskPurchaseLimitService"})
public class UmcTimedTaskPurchaseLimitServiceImpl
implements UmcTimedTaskPurchaseLimitService {
    private static final Logger log = LoggerFactory.getLogger(UmcTimedTaskPurchaseLimitServiceImpl.class);
    private static final String DELETED = "1";
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;
    @Autowired
    private CacheClient cacheClient;

    @PostMapping(value={"timedTaskPurchaseLimit"})
    public UmcTimedTaskPurchaseLimitRspBO timedTaskPurchaseLimit(@RequestBody UmcTimedTaskPurchaseLimitReqBO reqBO) {
        UmcTimedTaskPurchaseLimitRspBO rspBO = new UmcTimedTaskPurchaseLimitRspBO();
        int pageNo = 1;
        int pageSize = 500;
        while (true) {
            UmcPurchaseLimitAmountQryBo umcPurchaseLimitQryBo = new UmcPurchaseLimitAmountQryBo();
            umcPurchaseLimitQryBo.setPageNo(pageNo);
            umcPurchaseLimitQryBo.setPageSize(pageSize);
            umcPurchaseLimitQryBo.setLimitExpTimeEnd(new Date());
            umcPurchaseLimitQryBo.setLimitEffTimeStart(new Date());
            BasePageRspBo<IUmcPurchaseLimitDo> purchaseLimitConfigList = this.iUmcPurchaseLimitModel.getNotActivePurchaseLimitConfigList(umcPurchaseLimitQryBo);
            List umcPurchaseLimitDos = purchaseLimitConfigList.getRows();
            if (CollectionUtils.isEmpty((Collection)umcPurchaseLimitDos)) break;
            for (IUmcPurchaseLimitDo each : umcPurchaseLimitDos) {
                UmcPurchaseLimitAmountSubDo amountSubDo = null;
                UmcPurchaseLimitAmountQryBo qryBo = new UmcPurchaseLimitAmountQryBo();
                qryBo.setLimitConfigId(each.getLimitConfigId());
                qryBo.setOrderBy("a.create_time desc");
                BasePageRspBo<UmcPurchaseLimitAmountSubDo> purchaseLimitAmountSubDoBasePageRspBo = this.iUmcPurchaseLimitModel.getPurchaseLimitAmountPageList(qryBo);
                List umcPurchaseLimitAmountSubDoList = purchaseLimitAmountSubDoBasePageRspBo.getRows();
                if (!CollectionUtils.isEmpty((Collection)umcPurchaseLimitAmountSubDoList)) {
                    amountSubDo = (UmcPurchaseLimitAmountSubDo)umcPurchaseLimitAmountSubDoList.get(0);
                }
                if (null == amountSubDo) continue;
                BigDecimal accumulationAmount = new BigDecimal(0);
                amountSubDo.setLimitAmount(each.getLimitAmount());
                if (DELETED.equals(each.getIsAccumulation())) {
                    accumulationAmount = amountSubDo.getAccumulationAmount().add(amountSubDo.getLimitAmount()).subtract(amountSubDo.getPurchaseAmount());
                }
                amountSubDo.setAccumulationAmount(accumulationAmount);
                String redisKey = "UMC_PURCHASE_LIMIT_" + each.getLimitObjType() + "_" + each.getLimitObjCode();
                if ("month".equals(each.getLimitType())) {
                    this.cacheClient.delete(redisKey);
                    this.cacheClient.incrBy(redisKey, 0L);
                    amountSubDo.setLimitEffTime(DateUtil.getCurrentMonthStartTime());
                    amountSubDo.setLimitExpTime(DateUtil.getCurrentMonthEndTime());
                } else if ("season".equals(each.getLimitType())) {
                    this.cacheClient.delete(redisKey);
                    this.cacheClient.incrBy(redisKey, 0L);
                    amountSubDo.setLimitEffTime(DateUtil.getCurrentQuarterStartTime());
                    amountSubDo.setLimitExpTime(DateUtil.getCurrentQuarterEndTime());
                } else if ("year".equals(each.getLimitType())) {
                    this.cacheClient.delete(redisKey);
                    this.cacheClient.incrBy(redisKey, 0L);
                    amountSubDo.setLimitEffTime(DateUtil.getCurrentYearStartTime());
                    amountSubDo.setLimitExpTime(DateUtil.getCurrentYearEndTime());
                }
                amountSubDo.setPurchaseAmount(new BigDecimal(0));
                amountSubDo.setValId(IdUtil.nextId());
                amountSubDo.setCreateTime(new Date());
                amountSubDo.setCreateOperId(0L);
                amountSubDo.setCreateOperName("\u7cfb\u7edf");
                amountSubDo.setUpdateTime(new Date());
                amountSubDo.setUpdateOperId(0L);
                amountSubDo.setUpdateOperName("\u7cfb\u7edf");
                this.iUmcPurchaseLimitModel.createPurchaseLimitAmount(amountSubDo);
                UmcPurchaseLimitHisSubDo hisSubDo = this.buildHisDo(accumulationAmount, (UmcPurchaseLimitAmountSubDo)umcPurchaseLimitAmountSubDoList.get(0), amountSubDo);
                this.iUmcPurchaseLimitModel.createPurchaseLimitHis(hisSubDo);
            }
            ++pageNo;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private UmcPurchaseLimitHisSubDo buildHisDo(BigDecimal accumulationAmount, UmcPurchaseLimitAmountSubDo beforeReqBo, UmcPurchaseLimitAmountSubDo afterReqBo) {
        UmcPurchaseLimitHisSubDo hisSubDo = new UmcPurchaseLimitHisSubDo();
        hisSubDo.setChngType("timedTask ");
        hisSubDo.setValId(beforeReqBo.getValId());
        hisSubDo.setLimitConfigId(beforeReqBo.getLimitConfigId());
        hisSubDo.setLimitYear(beforeReqBo.getLimitYear());
        BigDecimal purchaseAmountAfter = afterReqBo.getLimitAmount().add(afterReqBo.getAccumulationAmount());
        BigDecimal chngPurchaseAmount = purchaseAmountAfter.subtract(accumulationAmount).abs();
        hisSubDo.setPurchaseAmountBefore(accumulationAmount);
        hisSubDo.setChngPurchaseAmount(chngPurchaseAmount);
        hisSubDo.setPurchaseAmountAfter(purchaseAmountAfter);
        hisSubDo.setChngRemark("\u91c7\u8d2d\u9650\u989d\u7d2f\u8ba1\u4e0b\u671f");
        hisSubDo.setCreateOperName("\u7cfb\u7edf");
        hisSubDo.setCreateTime(new Date());
        hisSubDo.setHisId(IdUtil.nextId());
        return hisSubDo;
    }
}

