/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.model.parkInfo.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.umc.model.parkInfo.bo.UmcPushParkInfoWmsBO;
import com.tydic.dyc.umc.model.parkInfo.bo.UmcPushParkInfoWmsBodyBO;
import com.tydic.dyc.umc.model.parkInfo.bo.UmcPushParkInfoWmsHeadBO;
import com.tydic.dyc.umc.model.parkInfo.bo.UmcPushParkInfoWmsPostReqBO;
import com.tydic.dyc.umc.utils.HttpClientUtil;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WmsParkInfoPushUtil {
    private static final Logger log = LoggerFactory.getLogger(WmsParkInfoPushUtil.class);
    @Value(value="${PUSH_WMS_PARK_URL}")
    private String PUSH_WMS_PARK_URL;
    @Value(value="${WMS_SIGNATURE}")
    private String WMS_SIGNATURE;
    @Value(value="${WMS_APP_KEY}")
    private String WMS_APP_KEY;
    @Value(value="${WMS_APP_TOKEN}")
    private String WMS_APP_TOKEN;
    @Value(value="${WMS_CHANNEL}")
    private String WMS_CHANNEL;
    @Value(value="${WMS_VERSION}")
    private String WMS_VERSION;
    @Value(value="${WMS_LANG}")
    private String WMS_LANG;
    @Value(value="${WMS_ZONE}")
    private String WMS_ZONE;

    public void pushParkInfo(List<UmcPushParkInfoWmsBO> infos) {
        CompletableFuture.runAsync(() -> {
            try {
                UmcPushParkInfoWmsBodyBO body = new UmcPushParkInfoWmsBodyBO();
                body.setParkList(infos);
                UmcPushParkInfoWmsHeadBO head = new UmcPushParkInfoWmsHeadBO();
                head.setAppkey(this.WMS_APP_KEY);
                head.setService("UG_PARK");
                head.setApptoken(this.WMS_APP_TOKEN);
                head.setChannel(this.WMS_CHANNEL);
                head.setVersion(this.WMS_VERSION);
                head.setLang(this.WMS_LANG);
                head.setZone(this.WMS_ZONE);
                UmcPushParkInfoWmsPostReqBO umcPushParkInfoWmsPostReqBO = new UmcPushParkInfoWmsPostReqBO();
                umcPushParkInfoWmsPostReqBO.setBody(body);
                umcPushParkInfoWmsPostReqBO.setHead(head);
                umcPushParkInfoWmsPostReqBO.setSignature(this.WMS_SIGNATURE);
                log.debug("\u56ed\u533a\u4fe1\u606f\u63a8\u9001\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)umcPushParkInfoWmsPostReqBO));
                try {
                    JSONObject jsonObject = HttpClientUtil.httpPost(this.PUSH_WMS_PARK_URL, (JSONObject)JSONObject.toJSON((Object)umcPushParkInfoWmsPostReqBO));
                    log.debug("\u56ed\u533a\u4fe1\u606f\u63a8\u9001\u8fd4\u56de:" + jsonObject.toJSONString());
                }
                catch (Exception e) {
                    log.error("\u56ed\u533a\u4fe1\u606f\u7cfb\u7edf\u5f02\u5e38\uff1a", (Throwable)e);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        });
    }
}

