/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.costControl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.costControl.IUmcCostControlModel;
import com.tydic.dyc.umc.model.costControl.qrybo.UmcCostControlHisQryBo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitAmountQryBo;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitHisQryBo;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitAmountSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitHisSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitSubDo;
import com.tydic.dyc.umc.service.costControl.UmcAfterSaleReturnCostPurchaseLimitService;
import com.tydic.dyc.umc.service.costControl.bo.UmcAfterSaleReturnCostPurchaseLimitReqBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcAfterSaleReturnCostPurchaseLimitRspBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcAfterSaleReturnCostPurchaseLimitSkuInfoBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcCostControlHisBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcOperateCostPurchaseLimitMqReqBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcOperateCostPurchaseLimitMqSkuInfoBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.MoneyUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.costControl.UmcAfterSaleReturnCostPurchaseLimitService"})
public class UmcAfterSaleReturnCostPurchaseLimitServiceImpl
implements UmcAfterSaleReturnCostPurchaseLimitService {
    private static final Logger log = LoggerFactory.getLogger(UmcAfterSaleReturnCostPurchaseLimitServiceImpl.class);
    @Autowired
    private IUmcCostControlModel iUmcCostControlModel;
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${UMC_PURCHASE_LIMIT_MESSAGE_TOPIC:UMC_PURCHASE_LIMIT_MESSAGE_TOPIC}")
    private String umcCreateTopic;
    @Value(value="${UMC_ERP_MESSAGE_TAG:*}")
    private String umcCreateTag;
    @Resource(name="umcPurchaseLimitMessageProvider")
    private ProxyMessageProducer proxyMessageProducer;

    @PostMapping(value={"operateAfterSaleReturn"})
    public UmcAfterSaleReturnCostPurchaseLimitRspBo operateAfterSaleReturn(@RequestBody UmcAfterSaleReturnCostPurchaseLimitReqBo reqBo) {
        this.validateArg(reqBo);
        List<Long> skuIds = reqBo.getBackSkuInfoBos().stream().map(UmcAfterSaleReturnCostPurchaseLimitSkuInfoBo::getSkuId).collect(Collectors.toList());
        HashMap<Long, UmcAfterSaleReturnCostPurchaseLimitSkuInfoBo> backSkuInfoMap = new HashMap<Long, UmcAfterSaleReturnCostPurchaseLimitSkuInfoBo>(reqBo.getBackSkuInfoBos().size());
        BigDecimal backTotal = this.getBackTotal(reqBo);
        HashMap<String, Long> deductionQueueMap = new HashMap<String, Long>(reqBo.getBackSkuInfoBos().size());
        for (UmcAfterSaleReturnCostPurchaseLimitSkuInfoBo backSkuInfoBo : reqBo.getBackSkuInfoBos()) {
            backSkuInfoMap.put(backSkuInfoBo.getSkuId(), backSkuInfoBo);
        }
        String extField1 = String.valueOf(reqBo.getOrderId());
        UmcCostControlHisQryBo costControlHisQryBo = new UmcCostControlHisQryBo();
        costControlHisQryBo.setExtField1(extField1);
        costControlHisQryBo.setDelFlag(null);
        costControlHisQryBo.setSkuIds(skuIds);
        costControlHisQryBo.setPageNo(-1);
        costControlHisQryBo.setPageNo(-1);
        BasePageRspBo<UmcCostControlHisBo> costControlHisPageList = this.iUmcCostControlModel.getCostControlHisPageList(costControlHisQryBo);
        UmcOperateCostPurchaseLimitMqReqBo limitMqReqBo = new UmcOperateCostPurchaseLimitMqReqBo();
        limitMqReqBo.setUniKey(Long.valueOf(IdUtil.nextId()));
        limitMqReqBo.setOrderCode(String.valueOf(reqBo.getOrderId()));
        limitMqReqBo.setOperateType("return");
        limitMqReqBo.setOperNode(reqBo.getOperNode());
        limitMqReqBo.setOperateId(reqBo.getOperateId());
        limitMqReqBo.setOperateName(reqBo.getOperateName());
        boolean isSendMassage = false;
        if (!CollectionUtils.isEmpty((Collection)costControlHisPageList.getRows())) {
            ArrayList<UmcOperateCostPurchaseLimitMqSkuInfoBo> controlList = new ArrayList<UmcOperateCostPurchaseLimitMqSkuInfoBo>(costControlHisPageList.getRows().size());
            ArrayList<Long> controlAmountIds = new ArrayList<Long>(costControlHisPageList.getRows().size());
            for (UmcCostControlHisBo row : costControlHisPageList.getRows()) {
                UmcAfterSaleReturnCostPurchaseLimitSkuInfoBo afterSaleReturnCostPurchaseLimitSkuInfoBo = (UmcAfterSaleReturnCostPurchaseLimitSkuInfoBo)backSkuInfoMap.get(row.getSkuId());
                if (null == afterSaleReturnCostPurchaseLimitSkuInfoBo) continue;
                if (row.getPurchaseAmountAfter().subtract(row.getPurchaseAmountBefore()).abs().compareTo(afterSaleReturnCostPurchaseLimitSkuInfoBo.getPurchaseQuantity()) < 0) {
                    this.returnDeductionQueue(deductionQueueMap);
                    throw new BaseBusinessException("100001", "\u9000\u56de\u6210\u672c\u63a7\u5236\u91cf\u8d85\u8fc7\u8be5\u6b21\u8ba2\u5355\u8be5\u5355\u54c1\u91c7\u8d2d\u6570\u91cf\uff01skuId:" + afterSaleReturnCostPurchaseLimitSkuInfoBo.getSkuId());
                }
                backTotal = backTotal.subtract(afterSaleReturnCostPurchaseLimitSkuInfoBo.getBackPrices());
                if ("0".equals(row.getDelFlag())) {
                    String redisKey = "UMC_COST_CONTROL_" + row.getProjectTreePath() + "_" + row.getSkuId();
                    long value = afterSaleReturnCostPurchaseLimitSkuInfoBo.getPurchaseQuantity().longValue();
                    this.cacheClient.incrBy(redisKey, -Math.abs(value));
                    deductionQueueMap.put(redisKey, value);
                }
                UmcOperateCostPurchaseLimitMqSkuInfoBo mqSkuInfoBo = new UmcOperateCostPurchaseLimitMqSkuInfoBo();
                mqSkuInfoBo.setControlAmountId(row.getControlAmountId());
                log.info("\u56de\u9000\u6210\u672c\u63a7\u5236\u7684\u91cf:{}", (Object)afterSaleReturnCostPurchaseLimitSkuInfoBo.getPurchaseQuantity());
                mqSkuInfoBo.setPurchaseQuantity(new BigDecimal(afterSaleReturnCostPurchaseLimitSkuInfoBo.getPurchaseQuantity().longValue()).negate());
                log.info("\u56de\u9000\u6210\u672c\u63a7\u5236\u7684\u91cf\u76f8\u53cd\u6570:{}", (Object)mqSkuInfoBo.getPurchaseQuantity());
                controlList.add(mqSkuInfoBo);
                controlAmountIds.add(row.getControlAmountId());
            }
            limitMqReqBo.setControlAmountIds(controlAmountIds);
            limitMqReqBo.setControlList(controlList);
            isSendMassage = true;
        }
        UmcPurchaseLimitHisQryBo purchaseLimitHisQryBo = new UmcPurchaseLimitHisQryBo();
        purchaseLimitHisQryBo.setExtField1(extField1);
        purchaseLimitHisQryBo.setChngType("deduct");
        purchaseLimitHisQryBo.setDelFlag(null);
        BasePageRspBo<UmcPurchaseLimitHisSubDo> purchaseLimitHisPageList = this.iUmcPurchaseLimitModel.getPurchaseLimitHisList(purchaseLimitHisQryBo);
        BigDecimal deductTotal = BigDecimal.ZERO;
        for (UmcPurchaseLimitHisSubDo row : purchaseLimitHisPageList.getRows()) {
            deductTotal = deductTotal.add(row.getChngPurchaseAmount().abs());
        }
        UmcPurchaseLimitHisQryBo purchaseLimitAdjustHisQryBo = new UmcPurchaseLimitHisQryBo();
        purchaseLimitAdjustHisQryBo.setExtField1(extField1);
        purchaseLimitAdjustHisQryBo.setChngType("orderPriceAdjust");
        purchaseLimitAdjustHisQryBo.setDelFlag(null);
        BasePageRspBo<UmcPurchaseLimitHisSubDo> purchaseLimitAdjustHisPageList = this.iUmcPurchaseLimitModel.getPurchaseLimitHisList(purchaseLimitAdjustHisQryBo);
        if (!CollectionUtils.isEmpty((Collection)purchaseLimitAdjustHisPageList.getRows())) {
            deductTotal = deductTotal.add(((UmcPurchaseLimitHisSubDo)purchaseLimitAdjustHisPageList.getRows().get(0)).getChngPurchaseAmount().abs());
        }
        log.debug("\u8ba2\u5355\u6263\u51cf\u603b\u91d1\u989d:{}", (Object)deductTotal);
        if (!CollectionUtils.isEmpty((Collection)purchaseLimitHisPageList.getRows())) {
            UmcPurchaseLimitHisSubDo deductDo = (UmcPurchaseLimitHisSubDo)purchaseLimitHisPageList.getRows().get(0);
            if (deductTotal.abs().compareTo(backTotal) < 0) {
                this.returnDeductionQueue(deductionQueueMap);
                throw new BaseBusinessException("100001", "\u9000\u56de\u91d1\u989d\u8d85\u8fc7\u8be5\u6b21\u8ba2\u5355\u91c7\u8d2d\u603b\u91d1\u989d\uff01");
            }
            UmcPurchaseLimitHisQryBo returnHisQryBo = new UmcPurchaseLimitHisQryBo();
            returnHisQryBo.setExtField1(extField1);
            returnHisQryBo.setChngType("return");
            returnHisQryBo.setDelFlag(null);
            BasePageRspBo<UmcPurchaseLimitHisSubDo> returnHisList = this.iUmcPurchaseLimitModel.getPurchaseLimitHisPageList(returnHisQryBo);
            BigDecimal returnTotal = backTotal;
            for (UmcPurchaseLimitHisSubDo row : returnHisList.getRows()) {
                returnTotal = returnTotal.add(new BigDecimal(row.getExtField2()).abs());
            }
            if (deductTotal.compareTo(returnTotal) < 0) {
                this.returnDeductionQueue(deductionQueueMap);
                throw new BaseBusinessException("100001", "\u5df2\u9000\u56de\u603b\u91d1\u989d\u8d85\u8fc7\u8be5\u6b21\u8ba2\u5355\u91c7\u8d2d\u603b\u91d1\u989d\uff01");
            }
            if ("1".equals(deductDo.getExtField3())) {
                UmcPurchaseLimitAmountSubDo limitAmountSubDo = new UmcPurchaseLimitAmountSubDo();
                UmcPurchaseLimitAmountQryBo purchaseLimitAmountQryBo = new UmcPurchaseLimitAmountQryBo();
                purchaseLimitAmountQryBo.setLimitConfigId(deductDo.getLimitConfigId());
                purchaseLimitAmountQryBo.setDelFlag(null);
                purchaseLimitAmountQryBo.setOrderBy("a.create_time desc");
                purchaseLimitAmountQryBo.setLimitEffTimeEnd(new Date());
                purchaseLimitAmountQryBo.setLimitExpTimeStart(new Date());
                purchaseLimitAmountQryBo.setCurrentTime(new Date());
                BasePageRspBo<UmcPurchaseLimitAmountSubDo> purchaseLimitAmountPageList = this.iUmcPurchaseLimitModel.getPurchaseLimitAmountPageList(purchaseLimitAmountQryBo);
                if (!CollectionUtils.isEmpty((Collection)purchaseLimitAmountPageList.getRows())) {
                    limitAmountSubDo = (UmcPurchaseLimitAmountSubDo)purchaseLimitAmountPageList.getRows().get(0);
                    if (deductDo.getValId().equals(limitAmountSubDo.getValId())) {
                        limitMqReqBo.setIsNowAmountConfig("1");
                    } else {
                        limitMqReqBo.setIsNowAmountConfig("0");
                    }
                }
                if ("0".equals(deductDo.getIsAccumulation())) {
                    UmcPurchaseLimitQryBo purchaseLimitQryBo = new UmcPurchaseLimitQryBo();
                    purchaseLimitQryBo.setValId(deductDo.getValId());
                    purchaseLimitQryBo.setDelFlag(null);
                    UmcPurchaseLimitSubDo purchaseLimitModelLimitAmount = this.iUmcPurchaseLimitModel.getLimitAmount(purchaseLimitQryBo);
                    this.dealPurchaseLimitRedis(limitMqReqBo, deductDo, purchaseLimitModelLimitAmount.getDelFlag(), deductDo.getValId(), backTotal);
                } else {
                    this.dealPurchaseLimitRedis(limitMqReqBo, deductDo, limitAmountSubDo.getDelFlag(), limitAmountSubDo.getValId(), backTotal);
                }
                isSendMassage = true;
            }
        }
        if (isSendMassage) {
            this.sendMassage(limitMqReqBo);
        }
        UmcAfterSaleReturnCostPurchaseLimitRspBo rspBO = new UmcAfterSaleReturnCostPurchaseLimitRspBo();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateArg(UmcAfterSaleReturnCostPurchaseLimitReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UmcAfterSaleReturnCostPurchaseLimitReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId() || 0L == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getBackSkuInfoBos())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u552e\u540e\u9000\u8d27\u9000\u56de\u6210\u672c\u548c\u91c7\u8d2d\u670d\u52a1\u5355\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashSet<Long> skuIdSet = new HashSet<Long>(reqBo.getBackSkuInfoBos().size());
        for (UmcAfterSaleReturnCostPurchaseLimitSkuInfoBo backSkuInfoBo : reqBo.getBackSkuInfoBos()) {
            if (null == backSkuInfoBo) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5355\u4e2a\u5355\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == backSkuInfoBo.getSkuId() || 0L == backSkuInfoBo.getSkuId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5355\u54c1ID[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == backSkuInfoBo.getPurchaseQuantity() || new BigDecimal(0).compareTo(backSkuInfoBo.getPurchaseQuantity()) >= 0) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5355\u4e2a\u5355\u54c1\u4fe1\u606f\u91c7\u8d2d\u6570\u91cf\u4e0d\u5408\u6cd5");
            }
            if (null == backSkuInfoBo.getBackPrices() || backSkuInfoBo.getBackPrices().compareTo(BigDecimal.ZERO) <= 0) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5355\u4e2a\u5355\u54c1\u4fe1\u606f\u5355\u54c1\u9000\u56de\u603b\u4ef7\u4e0d\u5408\u6cd5");
            }
            skuIdSet.add(backSkuInfoBo.getSkuId());
        }
        if (reqBo.getBackSkuInfoBos().size() != skuIdSet.size()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5355\u54c1\u4fe1\u606f\u5355\u54c1ID\u6709\u91cd\u590d");
        }
        if (null == reqBo.getOperateId() || 0L == reqBo.getOperateId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getOperateName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private BigDecimal getBackTotal(UmcAfterSaleReturnCostPurchaseLimitReqBo reqBo) {
        BigDecimal backTotal = new BigDecimal(0);
        for (UmcAfterSaleReturnCostPurchaseLimitSkuInfoBo backSkuInfoBo : reqBo.getBackSkuInfoBos()) {
            backTotal = backTotal.add(backSkuInfoBo.getBackPrices());
        }
        return backTotal;
    }

    private void returnDeductionQueue(Map<String, Long> deductionQueueMap) {
        if (MapUtils.isNotEmpty(deductionQueueMap)) {
            for (Map.Entry<String, Long> deductionQueueEntry : deductionQueueMap.entrySet()) {
                this.cacheClient.incrBy(deductionQueueEntry.getKey(), deductionQueueEntry.getValue().longValue());
            }
        }
    }

    private void dealPurchaseLimitRedis(UmcOperateCostPurchaseLimitMqReqBo limitMqReqBo, UmcPurchaseLimitHisSubDo purchaseLimitHisSubDo, String delFlag2, Long valId, BigDecimal backTotal) {
        if ("0".equals(delFlag2) && "1".equals(limitMqReqBo.getIsNowAmountConfig())) {
            String redisKey = "UMC_PURCHASE_LIMIT_" + purchaseLimitHisSubDo.getLimitObjType() + "_" + purchaseLimitHisSubDo.getLimitObjCode();
            this.cacheClient.incrBy(redisKey, -MoneyUtil.bigDecimal2Long(backTotal).longValue());
        }
        limitMqReqBo.setPurchaseValId(valId);
        limitMqReqBo.setPurchaseAmount(backTotal);
    }

    private void sendMassage(UmcOperateCostPurchaseLimitMqReqBo limitMqReqBo) {
        log.info("\u53d1\u6d88\u606f\u66f4\u65b0\u6210\u672c\u548c\u91c7\u8d2d\u4fe1\u606f\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)limitMqReqBo));
        ProxyMessage proxyMessage = new ProxyMessage(this.umcCreateTopic, this.umcCreateTag, JSON.toJSONString((Object)limitMqReqBo));
        ProxySendResult result = this.proxyMessageProducer.send(proxyMessage);
        log.info("\u53d1\u6d88\u606f\u66f4\u65b0\u6210\u672c\u548c\u91c7\u8d2d\u4fe1\u606f\u5b8c\u6210\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)result));
    }
}

