/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.costControl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.costControl.IUmcCostControlModel;
import com.tydic.dyc.umc.model.costControl.qrybo.UmcCostControlHisQryBo;
import com.tydic.dyc.umc.model.costControl.qrybo.UmcCostControlQryBo;
import com.tydic.dyc.umc.model.costControl.sub.UmcCostControlSubDo;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseInfoQryBo;
import com.tydic.dyc.umc.model.ldOrganization.IUmcLdOrganizationInfoModel;
import com.tydic.dyc.umc.model.ldOrganization.UmcLdOrganizationInfoQryDo;
import com.tydic.dyc.umc.model.ldOrganization.qrybo.UmcLdOrganizationInfoQryBo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcDepPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitHisQryBo;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitHisSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitSubDo;
import com.tydic.dyc.umc.service.costControl.UmcDeductionCostPurchaseLimitService;
import com.tydic.dyc.umc.service.costControl.bo.UmcCostControlHisBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcDeductionCostPurchaseLimitReqBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcDeductionCostPurchaseLimitRspBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcDeductionCostPurchaseLimitSkuInfoBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcOperateCostPurchaseLimitMqReqBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.MoneyUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.costControl.UmcDeductionCostPurchaseLimitService"})
public class UmcDeductionCostPurchaseLimitServiceImpl
implements UmcDeductionCostPurchaseLimitService {
    private static final Logger log = LoggerFactory.getLogger(UmcDeductionCostPurchaseLimitServiceImpl.class);
    @Autowired
    private IUmcCostControlModel iUmcCostControlModel;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;
    @Autowired
    private IUmcLdOrganizationInfoModel iUmcLdOrganizationInfoModel;
    @Value(value="${UMC_PURCHASE_LIMIT_MESSAGE_TOPIC:UMC_PURCHASE_LIMIT_MESSAGE_TOPIC}")
    private String umcCreateTopic;
    @Value(value="${UMC_ERP_MESSAGE_TAG:*}")
    private String umcCreateTag;
    @Resource(name="umcPurchaseLimitMessageProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    @PostMapping(value={"operateDeductionCostPurchaseLimit"})
    public UmcDeductionCostPurchaseLimitRspBo operateDeductionCostPurchaseLimit(@RequestBody UmcDeductionCostPurchaseLimitReqBo reqBo) {
        boolean airProjectCode = this.validateArg(reqBo);
        String extField1 = String.valueOf(reqBo.getOrderId());
        UmcCostControlHisQryBo costControlHisQryBo = new UmcCostControlHisQryBo();
        costControlHisQryBo.setExtField1(extField1);
        costControlHisQryBo.setDelFlag(null);
        costControlHisQryBo.setPageNo(-1);
        costControlHisQryBo.setPageSize(-1);
        BasePageRspBo<UmcCostControlHisBo> costControlHisPageList = this.iUmcCostControlModel.getCostControlHisPageList(costControlHisQryBo);
        if (!CollectionUtils.isEmpty((Collection)costControlHisPageList.getRows())) {
            throw new BaseBusinessException("100001", "\u8be5\u8ba2\u5355\u5df2\u5b58\u5728\u6263\u51cf");
        }
        UmcPurchaseLimitHisQryBo purchaseLimitHisQryBo = new UmcPurchaseLimitHisQryBo();
        purchaseLimitHisQryBo.setExtField1(extField1);
        purchaseLimitHisQryBo.setDelFlag(null);
        BasePageRspBo<UmcPurchaseLimitHisSubDo> purchaseLimitHisPageList = this.iUmcPurchaseLimitModel.getPurchaseLimitHisPageList(purchaseLimitHisQryBo);
        if (!CollectionUtils.isEmpty((Collection)purchaseLimitHisPageList.getRows())) {
            throw new BaseBusinessException("100001", "\u8be5\u8ba2\u5355\u5df2\u5b58\u5728\u6263\u51cf");
        }
        UmcDeductionCostPurchaseLimitRspBo rspBO = new UmcDeductionCostPurchaseLimitRspBo();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Map<String, Long> deductionQueueMap = new HashMap<String, Long>(1);
        UmcOperateCostPurchaseLimitMqReqBo limitMqReqBo = new UmcOperateCostPurchaseLimitMqReqBo();
        limitMqReqBo.setUniKey(Long.valueOf(IdUtil.nextId()));
        limitMqReqBo.setOrderCode(String.valueOf(reqBo.getOrderId()));
        limitMqReqBo.setOperateType("deduct");
        limitMqReqBo.setOperateId(reqBo.getOperateId());
        limitMqReqBo.setOperateName(reqBo.getOperateName());
        if (!airProjectCode && !CollectionUtils.isEmpty((Collection)reqBo.getLimitSkuInfoBos()) && (deductionQueueMap = this.operateDeductionCostControl(reqBo, limitMqReqBo)).size() == reqBo.getLimitSkuInfoBos().size()) {
            this.sendMassage(limitMqReqBo);
            return rspBO;
        }
        this.operateDeductionPurchaseLimit(reqBo, airProjectCode, deductionQueueMap, limitMqReqBo);
        this.sendMassage(limitMqReqBo);
        return rspBO;
    }

    private void sendMassage(UmcOperateCostPurchaseLimitMqReqBo limitMqReqBo) {
        log.info("\u53d1\u6d88\u606f\u66f4\u65b0\u6210\u672c\u548c\u91c7\u8d2d\u4fe1\u606f\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)limitMqReqBo));
        ProxyMessage proxyMessage = new ProxyMessage(this.umcCreateTopic, this.umcCreateTag, JSON.toJSONString((Object)limitMqReqBo));
        ProxySendResult result = this.proxyMessageProducer.send(proxyMessage);
        log.info("\u53d1\u6d88\u606f\u66f4\u65b0\u6210\u672c\u548c\u91c7\u8d2d\u4fe1\u606f\u5b8c\u6210\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)result));
    }

    private Map<String, Long> operateDeductionCostControl(UmcDeductionCostPurchaseLimitReqBo reqBo, UmcOperateCostPurchaseLimitMqReqBo limitMqReqBo) {
        UmcCostControlQryBo qryBo = new UmcCostControlQryBo();
        qryBo.setProjectCode(reqBo.getProjectCode());
        qryBo.setCurrentTime(new Date());
        qryBo.setControlStatus("1");
        StrUtil.noNullStringAttr((Object)((Object)qryBo));
        BasePageRspBo<UmcCostControlSubDo> rspDos = this.iUmcCostControlModel.getCostControlPageList(qryBo);
        HashMap<Long, UmcCostControlSubDo> costControlInfoMap = new HashMap<Long, UmcCostControlSubDo>(rspDos.getRows().size());
        for (UmcCostControlSubDo row : rspDos.getRows()) {
            costControlInfoMap.put(row.getSkuId(), row);
        }
        HashMap<String, Long> deductionQueueMap = new HashMap<String, Long>(reqBo.getLimitSkuInfoBos().size());
        ArrayList limitMqSkuInfoBos = new ArrayList(reqBo.getLimitSkuInfoBos().size());
        ArrayList controlAmountIds = new ArrayList(reqBo.getLimitSkuInfoBos().size());
        if (deductionQueueMap.size() < reqBo.getLimitSkuInfoBos().size() && reqBo.getTotalPurchaseAmount().compareTo(BigDecimal.ZERO) <= 0) {
            this.returnDeductionQueue(deductionQueueMap);
            throw new BaseBusinessException("100001", "\u5165\u53c2\u91c7\u8d2d\u603b\u91d1\u989d\u6216\u8005\u5355\u54c1\u4fe1\u606f\u91c7\u8d2d\u5355\u4ef7\u6709\u8bef");
        }
        if (deductionQueueMap.size() > 0) {
            limitMqReqBo.setControlList(limitMqSkuInfoBos);
            limitMqReqBo.setControlAmountIds(controlAmountIds);
        }
        return deductionQueueMap;
    }

    private void returnDeductionQueue(Map<String, Long> deductionQueueMap) {
        if (MapUtils.isNotEmpty(deductionQueueMap)) {
            for (Map.Entry<String, Long> deductionQueueEntry : deductionQueueMap.entrySet()) {
                this.cacheClient.incrBy(deductionQueueEntry.getKey(), deductionQueueEntry.getValue().longValue());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void operateDeductionPurchaseLimit(UmcDeductionCostPurchaseLimitReqBo reqBo, Boolean airProjectCode, Map<String, Long> deductionQueueMap, UmcOperateCostPurchaseLimitMqReqBo limitMqReqBo) {
        UmcPurchaseLimitSubDo rspDo = null;
        if (!airProjectCode.booleanValue()) {
            UmcPurchaseLimitQryBo qryBo = new UmcPurchaseLimitQryBo();
            qryBo.setLimitObjCode(reqBo.getProjectCode());
            qryBo.setLimitObjType("P1");
            qryBo.setCurrentTime(new Date());
            qryBo.setLimitStatus("1");
            StrUtil.noNullStringAttr((Object)((Object)qryBo));
            rspDo = this.iUmcPurchaseLimitModel.getPurchaseLimitDetail(qryBo);
        } else {
            UmcEnterpriseInfoQryBo umcEnterpriseInfoQryBo = new UmcEnterpriseInfoQryBo();
            umcEnterpriseInfoQryBo.setOrgId(reqBo.getOrgId());
            UmcEnterpriseInfoDo enterpriseInfo = this.iUmcEnterpriseInfoModel.getEnterpriseInfo(umcEnterpriseInfoQryBo);
            if (enterpriseInfo == null) {
                throw new BaseBusinessException("100001", "\u8be5\u673a\u6784\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u5df2\u7ecf\u88ab\u5220\u9664!");
            }
            if ("4".equals(enterpriseInfo.getOrgClass()) || "3".equals(enterpriseInfo.getOrgClass())) {
                UmcLdOrganizationInfoQryBo umcLdOrganizationInfoQryBo = new UmcLdOrganizationInfoQryBo();
                umcLdOrganizationInfoQryBo.setOrgId(reqBo.getOrgId());
                UmcLdOrganizationInfoQryDo umcLdOrganizationInfoQryDo = this.iUmcLdOrganizationInfoModel.qryLdOrgInfoDetail(umcLdOrganizationInfoQryBo);
                if (umcLdOrganizationInfoQryDo != null) {
                    String orgNoFullPath = umcLdOrganizationInfoQryDo.getOrgNoFullPath();
                    String[] split = orgNoFullPath.split("-");
                    UmcDepPurchaseLimitQryBo umcDepPurchaseLimitQryBo = new UmcDepPurchaseLimitQryBo();
                    umcDepPurchaseLimitQryBo.setLimitObjType("E1");
                    umcDepPurchaseLimitQryBo.setLimitObjCodes(Arrays.asList(split));
                    umcDepPurchaseLimitQryBo.setCurrentTime(new Date());
                    umcDepPurchaseLimitQryBo.setLimitStatus("1");
                    StrUtil.noNullStringAttr((Object)((Object)umcDepPurchaseLimitQryBo));
                    rspDo = this.iUmcPurchaseLimitModel.getDepPurchaseLimitDetail(umcDepPurchaseLimitQryBo);
                }
            } else {
                UmcPurchaseLimitQryBo qryBo = new UmcPurchaseLimitQryBo();
                qryBo.setLimitObjId(reqBo.getOrgId().toString());
                qryBo.setLimitObjType("EXT");
                qryBo.setCurrentTime(new Date());
                qryBo.setLimitStatus("1");
                StrUtil.noNullStringAttr((Object)((Object)qryBo));
                rspDo = this.iUmcPurchaseLimitModel.getPurchaseLimitDetail(qryBo);
            }
        }
        if (rspDo == null) {
            this.returnDeductionQueue(deductionQueueMap);
            throw new BaseBusinessException("100001", "\u6ca1\u6709\u91c7\u8d2d\u9650\u989d\u7981\u6b62\u4e0b\u5355");
        }
        if ("0".equals(rspDo.getLimitStatus())) {
            this.returnDeductionQueue(deductionQueueMap);
            throw new BaseBusinessException("100001", "\u91c7\u8d2d\u9650\u989d\u5df2\u7ecf\u88ab\u505c\u7528,\u7981\u6b62\u4e0b\u5355");
        }
        if (!rspDo.getIsLimit().equals("1")) {
            UmcPurchaseLimitHisSubDo hisSubDo = this.buildHisDo(rspDo, reqBo);
            this.iUmcPurchaseLimitModel.createPurchaseLimitHis(hisSubDo);
            return;
        }
        String redisKey = "UMC_PURCHASE_LIMIT_" + rspDo.getLimitObjType() + "_" + rspDo.getLimitObjCode();
        log.debug("\u91c7\u8d2d\u9650\u989d\u7684redisKey{}", (Object)redisKey);
        long totalPurchaseAmount = MoneyUtil.bigDecimal2Long(reqBo.getTotalPurchaseAmount());
        long purchaseAmount = MoneyUtil.bigDecimal2Long(rspDo.getSumLimitAmount());
        Long currenNum = this.cacheClient.incrBy(redisKey, 0L);
        log.debug("\u83b7\u53d6\u5230\u91c7\u8d2d\u9650\u989d\u7684\u503c{}", (Object)currenNum);
        if (currenNum == 0L) {
            if (purchaseAmount < totalPurchaseAmount) {
                this.returnDeductionQueue(deductionQueueMap);
                throw new BaseBusinessException("100001", "\u5df2\u7ecf\u8d85\u51fa\u91c7\u8d2d\u9650\u989d");
            }
            if (null != rspDo.getPurchaseAmount() && rspDo.getPurchaseAmount().compareTo(BigDecimal.ZERO) > 0) {
                totalPurchaseAmount += MoneyUtil.bigDecimal2Long(rspDo.getPurchaseAmount()).longValue();
            }
            deductionQueueMap.put(redisKey, -totalPurchaseAmount);
            this.cacheClient.incrBy(redisKey, totalPurchaseAmount);
        } else {
            Long quantityAfterDeduction = this.cacheClient.incrBy(redisKey, totalPurchaseAmount);
            log.debug("\u5904\u7406\u540e\u91c7\u8d2d\u9650\u989d\u7684\u503c{}", (Object)quantityAfterDeduction);
            deductionQueueMap.put(redisKey, -totalPurchaseAmount);
            Long aLong = MoneyUtil.bigDecimal2Long(rspDo.getLimitAmount()) + MoneyUtil.bigDecimal2Long(rspDo.getAccumulationAmount());
            log.debug("\u91c7\u8d2d\u9650\u989d\u4e3a\uff1a{}", (Object)aLong);
            if (quantityAfterDeduction > aLong) {
                this.returnDeductionQueue(deductionQueueMap);
                throw new BaseBusinessException("100001", "\u5df2\u7ecf\u8d85\u51fa\u91c7\u8d2d\u9650\u989d");
            }
        }
        limitMqReqBo.setPurchaseValId(rspDo.getValId());
        limitMqReqBo.setPurchaseAmount(reqBo.getTotalPurchaseAmount());
    }

    private Boolean validateArg(UmcDeductionCostPurchaseLimitReqBo reqBo) {
        boolean airProjectCode;
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UmcDeductionCostPurchaseLimitReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean bl = airProjectCode = !StringUtils.hasText((String)reqBo.getProjectCode());
        if (airProjectCode) {
            if (null == reqBo.getOrgId() || 0L == reqBo.getOrgId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u673a\u6784ID\u548c\u9879\u76ee\u7f16\u7801\u4e8c\u9009\u4e00\u4f20\uff0c\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
            if (null == reqBo.getTotalPurchaseAmount() || reqBo.getTotalPurchaseAmount().compareTo(BigDecimal.ZERO) <= 0) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u91c7\u8d2d\u603b\u91d1\u989d\u4e0d\u5408\u6cd5");
            }
        } else {
            if (null != reqBo.getOrgId() && 0L != reqBo.getOrgId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u673a\u6784ID\u548c\u9879\u76ee\u7f16\u7801\u4e8c\u9009\u4e00\u4f20\uff0c\u53c8\u4e0d\u80fd\u540c\u65f6\u6709\u503c");
            }
            if (CollectionUtils.isEmpty((Collection)reqBo.getLimitSkuInfoBos())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5355\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            HashSet<Long> skuIdSet = new HashSet<Long>(reqBo.getLimitSkuInfoBos().size());
            for (UmcDeductionCostPurchaseLimitSkuInfoBo limitSkuInfoBo : reqBo.getLimitSkuInfoBos()) {
                if (null == limitSkuInfoBo) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u5355\u4e2a\u5355\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null == limitSkuInfoBo.getSkuId() || 0L == limitSkuInfoBo.getSkuId()) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u5355\u4e2a\u5355\u54c1\u4fe1\u606f\u5355\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null == limitSkuInfoBo.getPurchaseQuantity() || new BigDecimal(0).compareTo(limitSkuInfoBo.getPurchaseQuantity()) >= 0) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u5355\u4e2a\u5355\u54c1\u4fe1\u606f\u91c7\u8d2d\u6570\u91cf\u4e0d\u5408\u6cd5");
                }
                if (null == limitSkuInfoBo.getPurchasePrices() || limitSkuInfoBo.getPurchasePrices().compareTo(BigDecimal.ZERO) <= 0) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u5355\u4e2a\u5355\u54c1\u4fe1\u606f\u91c7\u8d2d\u5355\u4ef7\u4e0d\u5408\u6cd5");
                }
                skuIdSet.add(limitSkuInfoBo.getSkuId());
            }
            if (reqBo.getLimitSkuInfoBos().size() != skuIdSet.size()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5355\u54c1\u4fe1\u606f\u5355\u54c1ID\u6709\u91cd\u590d");
            }
        }
        if (null == reqBo.getOrderId() || 0L == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOperateId() || 0L == reqBo.getOperateId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getOperateName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return airProjectCode;
    }

    private UmcPurchaseLimitHisSubDo buildHisDo(UmcPurchaseLimitSubDo umcPurchaseLimitSubDo, UmcDeductionCostPurchaseLimitReqBo umcDeductionCostPurchaseLimitReqBo) {
        UmcPurchaseLimitHisSubDo hisSubDo = new UmcPurchaseLimitHisSubDo();
        hisSubDo.setChngType("notLimitDeduct");
        hisSubDo.setValId(umcPurchaseLimitSubDo.getValId());
        hisSubDo.setLimitConfigId(umcPurchaseLimitSubDo.getLimitConfigId());
        hisSubDo.setLimitYear(umcPurchaseLimitSubDo.getLimitYear());
        BigDecimal purchaseAmount = umcDeductionCostPurchaseLimitReqBo.getTotalPurchaseAmount();
        BigDecimal purchaseAmountBefore = umcPurchaseLimitSubDo.getLimitAmount().add(umcPurchaseLimitSubDo.getAccumulationAmount()).subtract(umcPurchaseLimitSubDo.getPurchaseAmount());
        hisSubDo.setPurchaseAmountBefore(purchaseAmountBefore);
        hisSubDo.setChngPurchaseAmount(purchaseAmount);
        hisSubDo.setPurchaseAmountAfter(purchaseAmountBefore);
        hisSubDo.setChngRemark("\u4e0d\u53d7\u91c7\u8d2d\u9650\u989d\u7ba1\u63a7\u7684\u91c7\u8d2d\u8bb0\u5f55");
        hisSubDo.setCreateOperId(umcDeductionCostPurchaseLimitReqBo.getOperateId());
        hisSubDo.setCreateOperName(umcDeductionCostPurchaseLimitReqBo.getOperateName());
        hisSubDo.setCreateTime(new Date());
        hisSubDo.setExtField1(umcDeductionCostPurchaseLimitReqBo.getOrderId().toString());
        hisSubDo.setExtField2(String.valueOf(purchaseAmount));
        hisSubDo.setHisId(IdUtil.nextId());
        hisSubDo.setExtField3(umcPurchaseLimitSubDo.getIsLimit());
        hisSubDo.setExtField4(umcPurchaseLimitSubDo.getIsAccumulation());
        return hisSubDo;
    }
}

