/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.costControl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.costControl.IUmcCostControlModel;
import com.tydic.dyc.umc.model.costControl.qrybo.UmcCostControlQryBo;
import com.tydic.dyc.umc.model.costControl.sub.UmcCostControlSubDo;
import com.tydic.dyc.umc.model.ldOrganization.IUmcLdOrganizationInfoModel;
import com.tydic.dyc.umc.service.costControl.UmcOperateCostControlAmountService;
import com.tydic.dyc.umc.service.costControl.bo.UmcCostControlExtBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcCostPurSkuInfoBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcOperateCostControlAmountMqReqBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcOperateCostControlAmountServiceReqBO;
import com.tydic.dyc.umc.service.costControl.bo.UmcOperateCostControlAmountServiceRspBO;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.costControl.UmcOperateCostControlAmountService"})
public class UmcOperateCostControlAmountServiceImpl
implements UmcOperateCostControlAmountService {
    private static final Logger log = LoggerFactory.getLogger(UmcOperateCostControlAmountServiceImpl.class);
    @Autowired
    private IUmcCostControlModel iUmcCostControlModel;
    @Autowired
    private IUmcLdOrganizationInfoModel iUmcLdOrganizationInfoModel;
    @Value(value="${UMC_PURCHASE_LIMIT_MESSAGE_TOPIC:UMC_PURCHASE_LIMIT_MESSAGE_TOPIC}")
    private String umcCreateTopic;
    @Value(value="${UMC_ERP_MESSAGE_TAG:*}")
    private String umcCreateTag;
    @Resource(name="umcPurchaseLimitMessageProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Autowired
    private CacheClient cacheClient;

    @PostMapping(value={"operateCostControlAmount"})
    public UmcOperateCostControlAmountServiceRspBO operateCostControlAmount(@RequestBody UmcOperateCostControlAmountServiceReqBO reqBO) {
        log.debug("\u6210\u672c\u63a7\u5236\u64cd\u4f5c\u5165\u53c2{}", (Object)reqBO);
        UmcOperateCostControlAmountServiceRspBO rspBO = new UmcOperateCostControlAmountServiceRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.validateArg(reqBO);
        UmcCostControlQryBo qryBo = new UmcCostControlQryBo();
        qryBo.setProjectCode(reqBO.getProjectCode());
        qryBo.setCurrentTime(new Date());
        qryBo.setControlStatus("1");
        StrUtil.noNullStringAttr((Object)((Object)qryBo));
        BasePageRspBo<UmcCostControlSubDo> rspDos = this.iUmcCostControlModel.getCostControlPageList(qryBo);
        if (!CollectionUtils.isEmpty((Collection)rspDos.getRows())) {
            ArrayList<UmcCostControlSubDo> downSkus = new ArrayList<UmcCostControlSubDo>();
            for (UmcCostControlSubDo row : rspDos.getRows()) {
                if (CollectionUtils.isEmpty((Collection)reqBO.getPurSkuInfoBos())) continue;
                for (UmcCostPurSkuInfoBo purSkuInfoBo : reqBO.getPurSkuInfoBos()) {
                    if (!row.getSkuId().equals(purSkuInfoBo.getSkuId())) continue;
                    log.info("sku\u8d2d\u4e70\u91cf\u8f6c\u5316\u524d===" + purSkuInfoBo.getPurchaseQuantity());
                    Long purchaseQuantity = purSkuInfoBo.getPurchaseQuantity().longValue();
                    log.info("sku\u8d2d\u4e70\u91cf\u8f6c\u5316\u540e===" + purchaseQuantity);
                    if ("deduct".equals(reqBO.getOperateType())) {
                        this.placeCostControlAmount(row, purchaseQuantity);
                    } else if ("cancle".equals(reqBO.getOperateType())) {
                        this.blackCostControlAmount(row, purchaseQuantity);
                    } else if ("return".equals(reqBO.getOperateType())) {
                        this.blackCostControlAmount(row, purchaseQuantity);
                    }
                    row.setPurchaseQuantity(purSkuInfoBo.getPurchaseQuantity().toString());
                    downSkus.add(row);
                }
            }
            if (!CollectionUtils.isEmpty(downSkus)) {
                log.info("\u53d1\u9001\u6d88\u606f\u7ec4\u5408\u524d\u5165\u53c2\u4e0b\u5355\u7684sku\u4fe1\u606f===" + downSkus);
                this.sendMassage(reqBO, downSkus);
            }
        }
        return rspBO;
    }

    private void validateArg(UmcOperateCostControlAmountServiceReqBO reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOperateType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getPurchaseQuantity() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void placeCostControlAmount(UmcCostControlSubDo umcCostControlSubDo, Long purchaseQuantity) {
        String redisKey = "UMC_COST_CONTROL_" + umcCostControlSubDo.getProjectTreePath() + "_" + umcCostControlSubDo.getSkuId();
        Long currenNum = this.cacheClient.incrBy(redisKey, 0L);
        if (currenNum == 0L) {
            this.cacheClient.incrBy(redisKey, new Double(Double.parseDouble(umcCostControlSubDo.getPurchasedQuantity())).longValue());
        }
        log.info("\u66f4\u65b0\u524d\u7684\u63a7\u5236\u91cf\u4e3a" + currenNum);
        Long count = this.cacheClient.incrBy(redisKey, purchaseQuantity.longValue());
        log.info("\u66f4\u65b0\u540e\u7684\u63a7\u5236\u91cf\u4e3a" + count);
        Long aLong = new Double(Double.parseDouble(umcCostControlSubDo.getCostControlQuantity())).longValue();
        if (count > aLong) {
            this.cacheClient.incrBy(redisKey, -purchaseQuantity.longValue());
            throw new BaseBusinessException("100001", "\u5355\u54c1\u540d\u79f0\uff1a" + umcCostControlSubDo.getSkuName() + "\u5df2\u7ecf\u8d85\u51fa\u9650\u989d\u4e86!");
        }
    }

    private void blackCostControlAmount(UmcCostControlSubDo umcCostControlSubDo, Long purchaseQuantity) {
        String redisKey = "UMC_COST_CONTROL_" + umcCostControlSubDo.getProjectTreePath() + "_" + umcCostControlSubDo.getSkuId();
        Long currenNum = this.cacheClient.incrBy(redisKey, 0L);
        if (currenNum == 0L) {
            this.cacheClient.incrBy(redisKey, new Double(Double.parseDouble(umcCostControlSubDo.getPurchasedQuantity())).longValue());
        }
        Long count = this.cacheClient.incrBy(redisKey, -purchaseQuantity.longValue());
        log.info("\u56de\u9000\u540e\u7684\u63a7\u5236\u91cf\u4e3a" + count);
    }

    private void sendMassage(UmcOperateCostControlAmountServiceReqBO reqBO, List<UmcCostControlSubDo> rspDo) {
        UmcOperateCostControlAmountMqReqBo umcPurchaseLimitMqSubDo = (UmcOperateCostControlAmountMqReqBo)UmcRu.js((Object)reqBO, UmcOperateCostControlAmountMqReqBo.class);
        umcPurchaseLimitMqSubDo.setUniKey(Long.valueOf(IdUtil.nextId()));
        List controlAmountIds = rspDo.stream().map(UmcCostControlSubDo::getControlAmountId).collect(Collectors.toList());
        umcPurchaseLimitMqSubDo.setControlAmountIds(controlAmountIds);
        ArrayList<UmcCostControlExtBo> controlList = new ArrayList<UmcCostControlExtBo>();
        for (UmcCostControlSubDo umcCostControlSubDo : rspDo) {
            UmcCostControlExtBo costControlExtBo = new UmcCostControlExtBo();
            costControlExtBo.setControlAmountId(umcCostControlSubDo.getControlAmountId());
            costControlExtBo.setPurchaseQuantity(new BigDecimal(umcCostControlSubDo.getPurchaseQuantity()));
            controlList.add(costControlExtBo);
        }
        umcPurchaseLimitMqSubDo.setControlList(controlList);
        log.info("\u53d1\u6d88\u606f\u66f4\u65b0\u6210\u672c\u63a7\u5236\u4fe1\u606f\u53c2\u6570\u4e3a:" + JSON.toJSONString((Object)umcPurchaseLimitMqSubDo));
        ProxyMessage proxyMessage = new ProxyMessage(this.umcCreateTopic, this.umcCreateTag, JSON.toJSONString((Object)umcPurchaseLimitMqSubDo));
        ProxySendResult result = this.proxyMessageProducer.send(proxyMessage);
        log.info("\u53d1\u6d88\u606f\u66f4\u65b0\u6210\u672c\u63a7\u5236\u4fe1\u606f\u5b8c\u6210\u7ed3\u679c\u4e3a\uff1a" + JSON.toJSONString((Object)result));
    }
}

