/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.costControl;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.costControl.IUmcCostControlModel;
import com.tydic.dyc.umc.model.costControl.qrybo.UmcCostControlQryBo;
import com.tydic.dyc.umc.model.costControl.sub.UmcCostControlHisSubDo;
import com.tydic.dyc.umc.service.costControl.UmcGetCostControlDetailService;
import com.tydic.dyc.umc.service.costControl.UmcUpdateCostControlConfigService;
import com.tydic.dyc.umc.service.costControl.bo.UmcCostControlBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcGetCostControlDetailReqBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcGetCostControlDetailRspBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcUpdateCostControlConfigReqBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcUpdateCostControlConfigRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.math.BigDecimal;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.costControl.UmcUpdateCostControlConfigService"})
public class UmcUpdateCostControlConfigServiceImpl
implements UmcUpdateCostControlConfigService {
    @Autowired
    private IUmcCostControlModel iUmcCostControlModel;
    @Autowired
    private UmcGetCostControlDetailService getCostControlDetailService;
    @Autowired
    private CacheClient cacheClient;

    @PostMapping(value={"updateCostControlConfig"})
    public UmcUpdateCostControlConfigRspBo updateCostControlConfig(@RequestBody UmcUpdateCostControlConfigReqBo reqBo) {
        UmcUpdateCostControlConfigRspBo rspBo = (UmcUpdateCostControlConfigRspBo)UmcRu.success(UmcUpdateCostControlConfigRspBo.class);
        this.validateArg(reqBo);
        UmcGetCostControlDetailReqBo detailReqBo = new UmcGetCostControlDetailReqBo();
        detailReqBo.setControlConfigId(reqBo.getControlConfigId());
        UmcGetCostControlDetailRspBo costControlDetail = this.getCostControlDetailService.getCostControlDetail(detailReqBo);
        UmcCostControlBo costControlBo = costControlDetail.getCostControlBo();
        if (costControlBo == null) {
            throw new BaseBusinessException("100001", "\u4fee\u6539\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        if (reqBo.getCostControlQuantity() != null && reqBo.getCostControlQuantity().compareTo(costControlBo.getPurchasedQuantity()) < 0) {
            throw new BaseBusinessException("100001", "\u586b\u5199\u7684\u6210\u672c\u63a7\u5236\u91cf\u4e0d\u53ef\u5c0f\u4e8e\u5df2\u91c7\u8d2d\u6570\u91cf");
        }
        if (reqBo.getCostControlQuantity() != null) {
            String redisKey = "UMC_COST_CONTROL_" + costControlBo.getProjectTreePath() + "_" + costControlBo.getSkuId();
            Long purchasedNum = this.cacheClient.incrBy(redisKey, 0L);
            BigDecimal purchasedQuantity = BigDecimal.ZERO;
            try {
                purchasedQuantity = MoneyUtils.Long2BigDecimal((Long)purchasedNum);
            }
            catch (Exception e) {
                throw new BaseBusinessException("100001", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
            }
            if (reqBo.getCostControlQuantity().compareTo(purchasedQuantity) < 0) {
                throw new BaseBusinessException("100001", "\u586b\u5199\u7684\u6210\u672c\u63a7\u5236\u91cf\u4e0d\u53ef\u5c0f\u4e8e\u5df2\u91c7\u8d2d\u6570\u91cf");
            }
        }
        UmcCostControlQryBo configQryBo = this.buildConfigQreBo(reqBo, costControlBo);
        this.iUmcCostControlModel.updateCostControl(configQryBo);
        UmcCostControlHisSubDo hisSubDo = this.buildHisDo(reqBo, costControlBo);
        this.iUmcCostControlModel.createCostControlHis(hisSubDo);
        return rspBo;
    }

    private UmcCostControlQryBo buildConfigQreBo(UmcUpdateCostControlConfigReqBo reqBo, UmcCostControlBo costControlBo) {
        UmcCostControlQryBo qryBo = new UmcCostControlQryBo();
        qryBo.setControlConfigId(reqBo.getControlConfigId());
        qryBo.setCostControlQuantity(reqBo.getCostControlQuantity());
        qryBo.setUpdateOperId(reqBo.getUpdateOperId());
        qryBo.setUpdateOperName(reqBo.getUpdateOperName());
        qryBo.setControlAmountId(costControlBo.getControlAmountId());
        qryBo.setAvailableControlQuantity(reqBo.getCostControlQuantity().subtract(costControlBo.getPurchasedQuantity()));
        return qryBo;
    }

    private UmcCostControlHisSubDo buildHisDo(UmcUpdateCostControlConfigReqBo reqBo, UmcCostControlBo costControlBo) {
        UmcCostControlHisSubDo hisSubDo = new UmcCostControlHisSubDo();
        hisSubDo.setHisId(IdUtil.nextId());
        hisSubDo.setControlConfigId(reqBo.getControlConfigId());
        hisSubDo.setControlAmountId(costControlBo.getControlAmountId());
        hisSubDo.setHisFrom("\u4fee\u6539\u6210\u672c\u63a7\u5236");
        hisSubDo.setPurchaseAmountBefore(costControlBo.getCostControlQuantity());
        hisSubDo.setChngPurchaseAmount(reqBo.getCostControlQuantity().subtract(costControlBo.getCostControlQuantity()));
        hisSubDo.setPurchaseAmountAfter(reqBo.getCostControlQuantity());
        hisSubDo.setChngRemark("\u9879\u76ee\u63a7\u5236\u6570\u91cf");
        hisSubDo.setDelFlag("0");
        hisSubDo.setCreateOperId(reqBo.getUpdateOperId());
        hisSubDo.setCreateOperName(reqBo.getUpdateOperName());
        hisSubDo.setCreateTime(new Date());
        return hisSubDo;
    }

    private void validateArg(UmcUpdateCostControlConfigReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UmcUpdateCostControlConfigReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getControlConfigId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[ControlConfigId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getCostControlQuantity() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[CostControlQuantity]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

