/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.creditApply;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.creditApply.IUmcCreditApplyInfoModel;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditAccountPeriodQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditApplyAllInfoQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditApplyInfoQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditContractApplyQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditCustomerApplyQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditGuarantorApplyQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditRelatedCustomerApplyQryBo;
import com.tydic.dyc.umc.service.creditApply.UmcAddCreditApplyInfoService;
import com.tydic.dyc.umc.service.creditApply.UmcQryVerifyCreditInfoExistsService;
import com.tydic.dyc.umc.service.creditApply.bo.UmcAddCreditApplyInfoReqBo;
import com.tydic.dyc.umc.service.creditApply.bo.UmcAddCreditApplyInfoRspBo;
import com.tydic.dyc.umc.service.creditApply.bo.UmcQryVerifyCreditInfoExistsReqBo;
import com.tydic.dyc.umc.service.creditApply.bo.UmcQryVerifyCreditInfoExistsRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.creditApply.UmcAddCreditApplyInfoService"})
public class UmcAddCreditApplyInfoServiceImpl
implements UmcAddCreditApplyInfoService {
    private static final Logger log = LoggerFactory.getLogger(UmcAddCreditApplyInfoServiceImpl.class);
    @Autowired
    private IUmcCreditApplyInfoModel iUmcCreditApplyInfoModel;
    @Autowired
    private UmcQryVerifyCreditInfoExistsService umcQryVerifyCreditInfoExistsService;

    @PostMapping(value={"addCreditApplyInfo"})
    public UmcAddCreditApplyInfoRspBo addCreditApplyInfo(@RequestBody UmcAddCreditApplyInfoReqBo reqBo) {
        UmcAddCreditApplyInfoRspBo rspBo = (UmcAddCreditApplyInfoRspBo)UmcRu.success(UmcAddCreditApplyInfoRspBo.class);
        this.validate(reqBo);
        UmcQryVerifyCreditInfoExistsReqBo umcQryVerifyCreditInfoExistsReqBo = new UmcQryVerifyCreditInfoExistsReqBo();
        umcQryVerifyCreditInfoExistsReqBo.setOrgIdWeb(reqBo.getOrgIdWeb());
        UmcQryVerifyCreditInfoExistsRspBo umcQryVerifyCreditInfoExistsRspBo = this.umcQryVerifyCreditInfoExistsService.qryVerifyCreditInfoExists(umcQryVerifyCreditInfoExistsReqBo);
        if (!"0000".equals(umcQryVerifyCreditInfoExistsRspBo.getRespCode())) {
            throw new BaseBusinessException("100001", "\u6821\u9a8c\u5ba2\u6237\u662f\u5426\u5df2\u7ecf\u6dfb\u52a0\u4e86\u6388\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        if ("2".equals(umcQryVerifyCreditInfoExistsRspBo.getVerifyStatus())) {
            throw new BaseBusinessException("100001", "\u8be5\u5ba2\u6237\u5df2\u7ecf\u6dfb\u52a0\u4e86\u6388\u4fe1");
        }
        UmcCreditApplyAllInfoQryBo umcCreditApplyAllInfoQryBo = new UmcCreditApplyAllInfoQryBo();
        UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo = UmcAddCreditApplyInfoServiceImpl.buildUmcCreditApplyInfoQryBo(reqBo);
        UmcCreditCustomerApplyQryBo umcCreditCustomerApplyPo = UmcAddCreditApplyInfoServiceImpl.buildUmcCreditCustomerApplyQryBo(reqBo, umcCreditApplyInfoQryBo);
        UmcCreditAccountPeriodQryBo umcCreditAccountPeriodQryBo = UmcAddCreditApplyInfoServiceImpl.buildUmcCreditAccountPeriodQryBo(reqBo, umcCreditApplyInfoQryBo);
        UmcCreditGuarantorApplyQryBo umcCreditGuarantorApplyQryBo = UmcAddCreditApplyInfoServiceImpl.buildUmcCreditGuarantorApplyQryBo(reqBo, umcCreditApplyInfoQryBo);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUmcCreditRelatedCustomerApplyBos())) {
            List umcCreditRelatedCustomerApplyQryBos = UmcRu.jsl((List)reqBo.getUmcCreditRelatedCustomerApplyBos(), UmcCreditRelatedCustomerApplyQryBo.class);
            for (UmcCreditRelatedCustomerApplyQryBo each : umcCreditRelatedCustomerApplyQryBos) {
                each.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
                each.setCreateOperId(umcCreditApplyInfoQryBo.getCreateOperId());
                each.setCreateTime(umcCreditApplyInfoQryBo.getCreateTime());
                each.setCreateOperName(umcCreditApplyInfoQryBo.getCreateOperName());
                each.setRelatedCustomerId(IdUtil.nextId());
            }
            umcCreditApplyAllInfoQryBo.setUmcCreditRelatedCustomerApplyQryBos(umcCreditRelatedCustomerApplyQryBos);
        }
        UmcCreditContractApplyQryBo umcCreditContractApplyQryBo = UmcAddCreditApplyInfoServiceImpl.buildUmcCreditContractApplyQryBo(reqBo, umcCreditApplyInfoQryBo);
        umcCreditApplyAllInfoQryBo.setUmcCreditApplyInfoQryBo(umcCreditApplyInfoQryBo);
        umcCreditApplyAllInfoQryBo.setUmcCreditCustomerApplyQryBo(umcCreditCustomerApplyPo);
        umcCreditApplyAllInfoQryBo.setUmcCreditAccountPeriodQryBo(umcCreditAccountPeriodQryBo);
        umcCreditApplyAllInfoQryBo.setUmcCreditGuarantorApplyQryBo(umcCreditGuarantorApplyQryBo);
        umcCreditApplyAllInfoQryBo.setUmcCreditContractApplyQryBo(umcCreditContractApplyQryBo);
        try {
            this.iUmcCreditApplyInfoModel.addCreditApplyAllInfo(umcCreditApplyAllInfoQryBo);
        }
        catch (Exception e) {
            log.debug("\u65b0\u589e\u6388\u4fe1\u5931\u8d25\uff0c{}", (Object)e.getMessage());
            throw new BaseBusinessException("100001", "\u65b0\u589e\u6388\u4fe1\u5931\u8d25");
        }
        return rspBo;
    }

    private static UmcCreditContractApplyQryBo buildUmcCreditContractApplyQryBo(UmcAddCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        UmcCreditContractApplyQryBo umcCreditContractApplyQryBo = (UmcCreditContractApplyQryBo)UmcRu.js((Object)reqBo.getUmcCreditContractApplyBo(), UmcCreditContractApplyQryBo.class);
        umcCreditContractApplyQryBo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        umcCreditContractApplyQryBo.setCreateOperId(umcCreditApplyInfoQryBo.getCreateOperId());
        umcCreditContractApplyQryBo.setCreateTime(umcCreditApplyInfoQryBo.getCreateTime());
        umcCreditContractApplyQryBo.setCreateOperName(umcCreditApplyInfoQryBo.getCreateOperName());
        umcCreditContractApplyQryBo.setContractId(IdUtil.nextId());
        return umcCreditContractApplyQryBo;
    }

    private static UmcCreditGuarantorApplyQryBo buildUmcCreditGuarantorApplyQryBo(UmcAddCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        UmcCreditGuarantorApplyQryBo umcCreditGuarantorApplyQryBo = new UmcCreditGuarantorApplyQryBo();
        if (reqBo.getUmcCreditGuarantorApplyBo() != null) {
            umcCreditGuarantorApplyQryBo = (UmcCreditGuarantorApplyQryBo)UmcRu.js((Object)reqBo.getUmcCreditGuarantorApplyBo(), UmcCreditGuarantorApplyQryBo.class);
        }
        umcCreditGuarantorApplyQryBo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        umcCreditGuarantorApplyQryBo.setCreateOperId(umcCreditApplyInfoQryBo.getCreateOperId());
        umcCreditGuarantorApplyQryBo.setCreateTime(umcCreditApplyInfoQryBo.getCreateTime());
        umcCreditGuarantorApplyQryBo.setCreateOperName(umcCreditApplyInfoQryBo.getCreateOperName());
        umcCreditGuarantorApplyQryBo.setGuarantorId(IdUtil.nextId());
        return umcCreditGuarantorApplyQryBo;
    }

    private static UmcCreditAccountPeriodQryBo buildUmcCreditAccountPeriodQryBo(UmcAddCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        UmcCreditAccountPeriodQryBo umcCreditAccountPeriodQryBo = (UmcCreditAccountPeriodQryBo)UmcRu.js((Object)reqBo.getUmcCreditAccountPeriodApplyBo(), UmcCreditAccountPeriodQryBo.class);
        umcCreditAccountPeriodQryBo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        umcCreditAccountPeriodQryBo.setCreateOperId(umcCreditApplyInfoQryBo.getCreateOperId());
        umcCreditAccountPeriodQryBo.setCreateTime(umcCreditApplyInfoQryBo.getCreateTime());
        umcCreditAccountPeriodQryBo.setCreateOperName(umcCreditApplyInfoQryBo.getCreateOperName());
        umcCreditAccountPeriodQryBo.setAccountPeriodId(IdUtil.nextId());
        umcCreditAccountPeriodQryBo.setCreditLimit(reqBo.getCreditLimit());
        return umcCreditAccountPeriodQryBo;
    }

    private static UmcCreditCustomerApplyQryBo buildUmcCreditCustomerApplyQryBo(UmcAddCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        UmcCreditCustomerApplyQryBo umcCreditCustomerApplyPo = (UmcCreditCustomerApplyQryBo)UmcRu.js((Object)reqBo.getUmcCreditCustomerApplyBo(), UmcCreditCustomerApplyQryBo.class);
        umcCreditCustomerApplyPo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        umcCreditCustomerApplyPo.setCreateOperId(umcCreditApplyInfoQryBo.getCreateOperId());
        umcCreditCustomerApplyPo.setCreateTime(umcCreditApplyInfoQryBo.getCreateTime());
        umcCreditCustomerApplyPo.setCreateOperName(umcCreditApplyInfoQryBo.getCreateOperName());
        umcCreditCustomerApplyPo.setCustomerId(IdUtil.nextId());
        umcCreditCustomerApplyPo.setOrgId(reqBo.getOrgIdWeb());
        umcCreditCustomerApplyPo.setOrgName(reqBo.getOrgNameWeb());
        return umcCreditCustomerApplyPo;
    }

    private static UmcCreditApplyInfoQryBo buildUmcCreditApplyInfoQryBo(UmcAddCreditApplyInfoReqBo reqBo) {
        UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo = new UmcCreditApplyInfoQryBo();
        Date date = new Date();
        umcCreditApplyInfoQryBo.setApplyId(IdUtil.nextId());
        umcCreditApplyInfoQryBo.setApplyType(reqBo.getApplyType());
        umcCreditApplyInfoQryBo.setOrgId(reqBo.getOrgIdWeb());
        umcCreditApplyInfoQryBo.setOrgName(reqBo.getOrgNameWeb());
        umcCreditApplyInfoQryBo.setIsAffiliate(reqBo.getIsAffiliate());
        umcCreditApplyInfoQryBo.setIsGuarantor(reqBo.getIsGuarantor());
        umcCreditApplyInfoQryBo.setCommitmentLetter(reqBo.getCommitmentLetter());
        umcCreditApplyInfoQryBo.setContractAppendices(reqBo.getContractAppendices());
        umcCreditApplyInfoQryBo.setCreditLimit(reqBo.getCreditLimit());
        if (reqBo.getCreditLimitOld() == null) {
            umcCreditApplyInfoQryBo.setCreditLimitOld(reqBo.getCreditLimit());
        } else {
            umcCreditApplyInfoQryBo.setCreditLimitOld(reqBo.getCreditLimitOld());
        }
        umcCreditApplyInfoQryBo.setCreateOperId(reqBo.getUserId());
        umcCreditApplyInfoQryBo.setCreateOperName(reqBo.getName());
        umcCreditApplyInfoQryBo.setCreateTime(date);
        umcCreditApplyInfoQryBo.setDelFlag("0");
        if ("1".equals(reqBo.getOperType())) {
            umcCreditApplyInfoQryBo.setApplyStatus("2");
        } else if ("2".equals(reqBo.getOperType())) {
            umcCreditApplyInfoQryBo.setApplyStatus("3");
        } else {
            throw new BaseBusinessException("100001", "\u4f20\u5165\u7684\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5bf9");
        }
        return umcCreditApplyInfoQryBo;
    }

    private void validate(UmcAddCreditApplyInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getApplyType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u7533\u8bf7\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOperType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u64cd\u4f5c\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOrgNameWeb())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u5ba2\u6237\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgIdWeb() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u5ba2\u6237ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getCreditLimit() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u6388\u4fe1\u989d\u5ea6]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUmcCreditCustomerApplyBo() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u6388\u4fe1\u989d\u5ea6\u5ba2\u6237\u57fa\u672c\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUmcCreditAccountPeriodApplyBo() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u8d26\u671f\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getIsGuarantor())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u662f\u5426\u6709\u62c5\u4fdd\u65b9]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("1".equals(reqBo.getIsGuarantor()) && reqBo.getUmcCreditGuarantorApplyBo() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u62c5\u4fdd\u65b9\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getIsAffiliate())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u662f\u5426\u6709\u5173\u8054\u516c\u53f8]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("1".equals(reqBo.getIsAffiliate()) && CollectionUtils.isEmpty((Collection)reqBo.getUmcCreditRelatedCustomerApplyBos())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u5173\u8054\u5ba2\u6237]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUmcCreditContractApplyBo() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u5408\u540c\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

