/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.creditApply;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.creditApply.UmcQryCreditApplyInfoModel;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditApprovalCallBackQryBo;
import com.tydic.dyc.umc.model.creditApply.sub.UmcCreditApprovalCallBackSubDo;
import com.tydic.dyc.umc.model.creditApply.sub.UmcCreditInfoApplySubDo;
import com.tydic.dyc.umc.service.creditApply.UmcCreditApprovalCallBackService;
import com.tydic.dyc.umc.service.creditApply.bo.UmcCreditApprovalCallBackReqBO;
import com.tydic.dyc.umc.service.creditApply.bo.UmcCreditApprovalCallBackRspBO;
import com.tydic.dyc.umc.service.purchaselimit.UmcUpdatePurchaseLimitConfigService;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcUpdatePurchaseLimitConfigReqBo;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcUpdatePurchaseLimitConfigRspBo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.creditApply.UmcCreditApprovalCallBackService"})
public class UmcCreditApprovalCallBackServiceImpl
implements UmcCreditApprovalCallBackService {
    @Autowired
    private UmcQryCreditApplyInfoModel umcQryCreditApplyInfoModel;
    @Autowired
    private UmcUpdatePurchaseLimitConfigService umcUpdatePurchaseLimitConfigService;

    @PostMapping(value={"approvalCallBack"})
    public UmcCreditApprovalCallBackRspBO approvalCallBack(@RequestBody UmcCreditApprovalCallBackReqBO reqBO) {
        UmcCreditApprovalCallBackSubDo subDo;
        this.validate(reqBO);
        UmcCreditApprovalCallBackQryBo qryBo = (UmcCreditApprovalCallBackQryBo)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), UmcCreditApprovalCallBackQryBo.class));
        switch (reqBO.getApproval()) {
            case 1: {
                subDo = this.umcQryCreditApplyInfoModel.approvalCallBack(qryBo);
                this.migratePurchaseLimitsToConfiguration(reqBO);
                break;
            }
            case 2: {
                subDo = this.umcQryCreditApplyInfoModel.approvalCallBackReject(qryBo);
                break;
            }
            default: {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[approval]\u4e0d\u5408\u6cd5");
            }
        }
        return (UmcCreditApprovalCallBackRspBO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)subDo)), UmcCreditApprovalCallBackRspBO.class);
    }

    private void migratePurchaseLimitsToConfiguration(UmcCreditApprovalCallBackReqBO reqBO) {
        UmcCreditInfoApplySubDo subDo = this.umcQryCreditApplyInfoModel.qryCreditApply(reqBO.getApplyId());
        if (ObjectUtils.isEmpty((Object)subDo)) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u7533\u8bf7\u4fe1\u606f");
        }
        UmcUpdatePurchaseLimitConfigReqBo configReqBo = new UmcUpdatePurchaseLimitConfigReqBo();
        BeanUtils.copyProperties((Object)subDo, (Object)configReqBo);
        configReqBo.setIsAccumulation("0");
        configReqBo.setLimitType("once");
        configReqBo.setLimitObjType("EXT");
        configReqBo.setIsLimit("1");
        configReqBo.setLimitStatus("1");
        configReqBo.setExtField1("1");
        configReqBo.setLimitObjCode(subDo.getOrgId().toString());
        configReqBo.setLimitObjId(subDo.getOrgId().toString());
        configReqBo.setLimitAmount(subDo.getCreditLimit());
        configReqBo.setExtField2(subDo.getContractAppendices());
        configReqBo.setExtField3(subDo.getCommitmentLetter());
        configReqBo.setExtField4(subDo.getIsGuarantor());
        configReqBo.setExtField5(subDo.getIsAffiliate());
        UmcUpdatePurchaseLimitConfigRspBo umcUpdatePurchaseLimitConfigRspBo = this.umcUpdatePurchaseLimitConfigService.updatePurchaseLimitConfig(configReqBo);
        if (!"0000".equals(umcUpdatePurchaseLimitConfigRspBo.getRespCode())) {
            throw new BaseBusinessException("100001", "\u66f4\u65b0\u914d\u7f6e\u670d\u52a1\u8fd4\u56de\u5931\u8d25\uff1a" + umcUpdatePurchaseLimitConfigRspBo.getRespDesc());
        }
    }

    private void validate(UmcCreditApprovalCallBackReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getApplyId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[applyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getApproval())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[approval]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

