/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.creditApply;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.creditApply.IUmcCreditApplyInfoModel;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditAccountPeriodQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditApplyAllInfoQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditApplyInfoQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditContractApplyQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditCustomerApplyQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditGuarantorApplyQryBo;
import com.tydic.dyc.umc.service.creditApply.UmcUpdateCreditApplyInfoService;
import com.tydic.dyc.umc.service.creditApply.bo.UmcUpdateCreditApplyInfoReqBo;
import com.tydic.dyc.umc.service.creditApply.bo.UmcUpdateCreditApplyInfoRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.creditApply.UmcUpdateCreditApplyInfoService"})
public class UmcUpdateCreditApplyInfoServiceImpl
implements UmcUpdateCreditApplyInfoService {
    private static final Logger log = LoggerFactory.getLogger(UmcUpdateCreditApplyInfoServiceImpl.class);
    @Autowired
    private IUmcCreditApplyInfoModel iUmcCreditApplyInfoModel;

    @PostMapping(value={"updateCreditApplyInfo"})
    public UmcUpdateCreditApplyInfoRspBo updateCreditApplyInfo(@RequestBody UmcUpdateCreditApplyInfoReqBo reqBo) {
        UmcUpdateCreditApplyInfoRspBo rspBo = (UmcUpdateCreditApplyInfoRspBo)UmcRu.success(UmcUpdateCreditApplyInfoRspBo.class);
        this.validate(reqBo);
        this.checkInfo(reqBo);
        UmcCreditApplyAllInfoQryBo umcCreditApplyAllInfoQryBo = new UmcCreditApplyAllInfoQryBo();
        UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo = UmcUpdateCreditApplyInfoServiceImpl.buildUmcCreditApplyInfoQryBo(reqBo);
        UmcCreditCustomerApplyQryBo umcCreditCustomerApplyPo = UmcUpdateCreditApplyInfoServiceImpl.buildUmcCreditCustomerApplyQryBo(reqBo, umcCreditApplyInfoQryBo);
        UmcCreditAccountPeriodQryBo umcCreditAccountPeriodQryBo = UmcUpdateCreditApplyInfoServiceImpl.buildUmcCreditAccountPeriodQryBo(reqBo, umcCreditApplyInfoQryBo);
        UmcCreditContractApplyQryBo umcCreditContractApplyQryBo = UmcUpdateCreditApplyInfoServiceImpl.buildUmcCreditContractApplyQryBo(reqBo, umcCreditApplyInfoQryBo);
        umcCreditApplyAllInfoQryBo.setUmcCreditApplyInfoQryBo(umcCreditApplyInfoQryBo);
        umcCreditApplyAllInfoQryBo.setUmcCreditCustomerApplyQryBo(umcCreditCustomerApplyPo);
        umcCreditApplyAllInfoQryBo.setUmcCreditAccountPeriodQryBo(umcCreditAccountPeriodQryBo);
        umcCreditApplyAllInfoQryBo.setUmcCreditContractApplyQryBo(umcCreditContractApplyQryBo);
        try {
            this.iUmcCreditApplyInfoModel.updateCreditApplyAllInfo(umcCreditApplyAllInfoQryBo);
        }
        catch (Exception e) {
            log.debug("\u4fee\u6539\u6388\u4fe1\u5931\u8d25{}", (Object)e.getMessage());
            throw new BaseBusinessException("100001", "\u4fee\u6539\u6388\u4fe1\u5931\u8d25");
        }
        return rspBo;
    }

    private void checkInfo(UmcUpdateCreditApplyInfoReqBo reqBo) {
        UmcCreditApplyInfoQryBo qryBo = new UmcCreditApplyInfoQryBo();
        qryBo.setApplyId(reqBo.getApplyId());
        UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo = this.iUmcCreditApplyInfoModel.qryCreditApplyDetailInfo(qryBo);
        if (umcCreditApplyInfoQryBo == null) {
            throw new BaseBusinessException("100001", "\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u6388\u4fe1\u4fe1\u606f");
        }
        if (!"2".equals(umcCreditApplyInfoQryBo.getApplyStatus())) {
            throw new BaseBusinessException("100001", "\u8be5\u6761\u6388\u4fe1\u5df2\u7ecf\u4e0d\u662f\u8349\u7a3f\u72b6\u6001\u4e86\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
    }

    private static UmcCreditContractApplyQryBo buildUmcCreditContractApplyQryBo(UmcUpdateCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        UmcCreditContractApplyQryBo umcCreditContractApplyQryBo = (UmcCreditContractApplyQryBo)UmcRu.js((Object)reqBo.getUmcCreditContractApplyBo(), UmcCreditContractApplyQryBo.class);
        umcCreditContractApplyQryBo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        umcCreditContractApplyQryBo.setUpdateOperId(umcCreditApplyInfoQryBo.getUpdateOperId());
        umcCreditContractApplyQryBo.setUpdateTime(umcCreditApplyInfoQryBo.getUpdateTime());
        umcCreditContractApplyQryBo.setUpdateOperName(umcCreditApplyInfoQryBo.getUpdateOperName());
        return umcCreditContractApplyQryBo;
    }

    private static UmcCreditGuarantorApplyQryBo buildUmcCreditGuarantorApplyQryBo(UmcUpdateCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        UmcCreditGuarantorApplyQryBo umcCreditGuarantorApplyQryBo = new UmcCreditGuarantorApplyQryBo();
        if (reqBo.getUmcCreditGuarantorApplyBo() != null) {
            umcCreditGuarantorApplyQryBo = (UmcCreditGuarantorApplyQryBo)UmcRu.js((Object)reqBo.getUmcCreditGuarantorApplyBo(), UmcCreditGuarantorApplyQryBo.class);
        }
        umcCreditGuarantorApplyQryBo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        umcCreditGuarantorApplyQryBo.setUpdateOperId(umcCreditApplyInfoQryBo.getUpdateOperId());
        umcCreditGuarantorApplyQryBo.setUpdateTime(umcCreditApplyInfoQryBo.getUpdateTime());
        umcCreditGuarantorApplyQryBo.setUpdateOperName(umcCreditApplyInfoQryBo.getUpdateOperName());
        return umcCreditGuarantorApplyQryBo;
    }

    private static UmcCreditAccountPeriodQryBo buildUmcCreditAccountPeriodQryBo(UmcUpdateCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        UmcCreditAccountPeriodQryBo umcCreditAccountPeriodQryBo = (UmcCreditAccountPeriodQryBo)UmcRu.js((Object)reqBo.getUmcCreditAccountPeriodApplyBo(), UmcCreditAccountPeriodQryBo.class);
        umcCreditAccountPeriodQryBo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        umcCreditAccountPeriodQryBo.setUpdateOperId(umcCreditApplyInfoQryBo.getUpdateOperId());
        umcCreditAccountPeriodQryBo.setUpdateTime(umcCreditApplyInfoQryBo.getUpdateTime());
        umcCreditAccountPeriodQryBo.setUpdateOperName(umcCreditApplyInfoQryBo.getUpdateOperName());
        umcCreditAccountPeriodQryBo.setCreditLimit(reqBo.getCreditLimit());
        return umcCreditAccountPeriodQryBo;
    }

    private static UmcCreditCustomerApplyQryBo buildUmcCreditCustomerApplyQryBo(UmcUpdateCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        UmcCreditCustomerApplyQryBo umcCreditCustomerApplyPo = (UmcCreditCustomerApplyQryBo)UmcRu.js((Object)reqBo.getUmcCreditCustomerApplyBo(), UmcCreditCustomerApplyQryBo.class);
        umcCreditCustomerApplyPo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        umcCreditCustomerApplyPo.setUpdateOperId(umcCreditApplyInfoQryBo.getUpdateOperId());
        umcCreditCustomerApplyPo.setUpdateOperName(umcCreditApplyInfoQryBo.getUpdateOperName());
        umcCreditCustomerApplyPo.setUpdateTime(umcCreditApplyInfoQryBo.getUpdateTime());
        return umcCreditCustomerApplyPo;
    }

    private static UmcCreditApplyInfoQryBo buildUmcCreditApplyInfoQryBo(UmcUpdateCreditApplyInfoReqBo reqBo) {
        UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo = new UmcCreditApplyInfoQryBo();
        Date date = new Date();
        umcCreditApplyInfoQryBo.setApplyId(reqBo.getApplyId());
        umcCreditApplyInfoQryBo.setIsAffiliate(reqBo.getIsAffiliate());
        umcCreditApplyInfoQryBo.setIsGuarantor(reqBo.getIsGuarantor());
        umcCreditApplyInfoQryBo.setCommitmentLetter(reqBo.getCommitmentLetter());
        umcCreditApplyInfoQryBo.setContractAppendices(reqBo.getContractAppendices());
        umcCreditApplyInfoQryBo.setCreditLimit(reqBo.getCreditLimit());
        if (reqBo.getCreditLimitOld() == null) {
            umcCreditApplyInfoQryBo.setCreditLimitOld(reqBo.getCreditLimit());
        } else {
            umcCreditApplyInfoQryBo.setCreditLimitOld(reqBo.getCreditLimitOld());
        }
        umcCreditApplyInfoQryBo.setUpdateOperId(reqBo.getUserId());
        umcCreditApplyInfoQryBo.setUpdateOperName(reqBo.getName());
        umcCreditApplyInfoQryBo.setUpdateTime(date);
        if ("1".equals(reqBo.getOperType())) {
            umcCreditApplyInfoQryBo.setApplyStatus("2");
        } else if ("2".equals(reqBo.getOperType())) {
            umcCreditApplyInfoQryBo.setApplyStatus("3");
        } else {
            throw new BaseBusinessException("100001", "\u4f20\u5165\u7684\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5bf9");
        }
        return umcCreditApplyInfoQryBo;
    }

    private void validate(UmcUpdateCreditApplyInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getApplyId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u7533\u8bf7\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getApplyType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u7533\u8bf7\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOperType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u64cd\u4f5c\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getCreditLimit() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u6388\u4fe1\u989d\u5ea6]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUmcCreditCustomerApplyBo() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u6388\u4fe1\u989d\u5ea6\u5ba2\u6237\u57fa\u672c\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUmcCreditAccountPeriodApplyBo() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u8d26\u671f\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUmcCreditContractApplyBo() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u5408\u540c\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

