/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.freight;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.freight.IUmcFreightConfigModel;
import com.tydic.dyc.umc.model.freight.UmcFreightConfigDo;
import com.tydic.dyc.umc.model.freight.qrybo.UmcFreightConfigQryBo;
import com.tydic.dyc.umc.service.freight.bo.UmcCreateBatchFreightConfigReqBo;
import com.tydic.dyc.umc.service.freight.bo.UmcCreateBatchFreightConfigRspBo;
import com.tydic.dyc.umc.service.freight.bo.UmcFreightConfigBo;
import com.tydic.dyc.umc.service.freight.service.UmcCreateBatchFreightConfigService;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.freight.service.UmcCreateBatchFreightConfigService"})
public class UmcCreateBatchFreightConfigServiceImpl
implements UmcCreateBatchFreightConfigService {
    private static final Logger log = LoggerFactory.getLogger(UmcCreateBatchFreightConfigServiceImpl.class);
    public static final String DEL_FLAG = "0";
    @Autowired
    private IUmcFreightConfigModel iUmcFreightConfigModel;

    @PostMapping(value={"createBatchFreight"})
    public UmcCreateBatchFreightConfigRspBo createBatchFreight(@RequestBody UmcCreateBatchFreightConfigReqBo reqBo) {
        UmcCreateBatchFreightConfigRspBo rspBo = (UmcCreateBatchFreightConfigRspBo)UmcRu.success(UmcCreateBatchFreightConfigRspBo.class);
        this.checkParam(reqBo);
        List umcFreightConfigBos = reqBo.getUmcFreightConfigBos();
        Map<Long, List<UmcFreightConfigDo>> umcFreightConfigMap = this.getLongListMap(umcFreightConfigBos);
        ArrayList<UmcFreightConfigDo> addUmcFreightConfigDos = new ArrayList<UmcFreightConfigDo>();
        for (UmcFreightConfigBo each : umcFreightConfigBos) {
            UmcFreightConfigDo umcFreightConfigDo = (UmcFreightConfigDo)UmcRu.js((Object)each, UmcFreightConfigDo.class);
            if (umcFreightConfigMap != null) {
                Set<Long> orgIds = umcFreightConfigMap.keySet();
                if (!CollectionUtils.isEmpty(orgIds) && orgIds.contains(each.getEnterpriseId())) {
                    List<UmcFreightConfigDo> umcFreightConfigDos = umcFreightConfigMap.get(each.getEnterpriseId());
                    UmcFreightConfigDo umcFreightConfigDoOld = umcFreightConfigDos.get(0);
                    umcFreightConfigDo.setFreightConfigId(umcFreightConfigDoOld.getFreightConfigId());
                    umcFreightConfigDo.setUpdatedTime(new Date());
                    umcFreightConfigDo.setUpdatedName(reqBo.getUserName());
                    umcFreightConfigDo.setUpdatedId(reqBo.getUserId());
                    try {
                        this.iUmcFreightConfigModel.updateFreightConfig(umcFreightConfigDo);
                        continue;
                    }
                    catch (Exception e) {
                        log.debug("\u4fee\u6539\u95e8\u69db\u8fd0\u8d39\u8bbe\u7f6e\u5931\u8d25{}", (Object)e.getMessage());
                        throw new BaseBusinessException("100001", "\u4fee\u6539\u95e8\u69db\u8fd0\u8d39\u8bbe\u7f6e\u5931\u8d25!");
                    }
                }
                this.addUmcFreightConfigDo(reqBo, addUmcFreightConfigDos, umcFreightConfigDo);
                continue;
            }
            this.addUmcFreightConfigDo(reqBo, addUmcFreightConfigDos, umcFreightConfigDo);
        }
        if (!CollectionUtils.isEmpty(addUmcFreightConfigDos)) {
            try {
                this.iUmcFreightConfigModel.insertBatch(addUmcFreightConfigDos);
            }
            catch (Exception e) {
                log.debug("\u6279\u91cf\u65b0\u589e\u95e8\u69db\u8fd0\u8d39\u8bbe\u7f6e\u5931\u8d25{}", (Object)e.getMessage());
                throw new BaseBusinessException("100001", "\u6279\u91cf\u65b0\u589e\u95e8\u69db\u8fd0\u8d39\u8bbe\u7f6e\u5931\u8d25!");
            }
        }
        return rspBo;
    }

    private void addUmcFreightConfigDo(UmcCreateBatchFreightConfigReqBo reqBo, List<UmcFreightConfigDo> addUmcFreightConfigDos, UmcFreightConfigDo umcFreightConfigDo) {
        umcFreightConfigDo.setFreightConfigId(IdUtil.nextId());
        umcFreightConfigDo.setIsDefault(DEL_FLAG);
        umcFreightConfigDo.setCreatedId(reqBo.getUserId());
        umcFreightConfigDo.setCreatedName(reqBo.getUserName());
        umcFreightConfigDo.setCreatedTime(new Date());
        umcFreightConfigDo.setUpdatedId(reqBo.getUserId());
        umcFreightConfigDo.setUpdatedName(reqBo.getUserName());
        umcFreightConfigDo.setUpdatedTime(new Date());
        umcFreightConfigDo.setDelFlag(DEL_FLAG);
        addUmcFreightConfigDos.add(umcFreightConfigDo);
    }

    private Map<Long, List<UmcFreightConfigDo>> getLongListMap(List<UmcFreightConfigBo> umcFreightConfigBos) {
        List<Long> orgIds = umcFreightConfigBos.stream().map(UmcFreightConfigBo::getEnterpriseId).collect(Collectors.toList());
        UmcFreightConfigQryBo qryBo = new UmcFreightConfigQryBo();
        qryBo.setFreightType("2");
        qryBo.setEnterpriseIds(orgIds);
        List<UmcFreightConfigDo> umcFreightConfigDos = this.iUmcFreightConfigModel.qryFreightConfigList(qryBo);
        Map<Long, List<UmcFreightConfigDo>> umcFreightConfigMap = new HashMap<Long, List<UmcFreightConfigDo>>();
        if (!CollectionUtils.isEmpty(umcFreightConfigDos)) {
            umcFreightConfigMap = umcFreightConfigDos.stream().collect(Collectors.groupingBy(UmcFreightConfigDo::getEnterpriseId));
        }
        return umcFreightConfigMap;
    }

    private void checkParam(UmcCreateBatchFreightConfigReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getUmcFreightConfigBos())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[umcFreightConfigBos]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

