/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.purchaselimit;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitDo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitConfigQryBo;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitAmountConfigHisSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitSubDo;
import com.tydic.dyc.umc.service.purchaselimit.UmcEnablePurchaseLimitConfigService;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcEnablePurchaseLimitConfigReqBo;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcEnablePurchaseLimitConfigRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.purchaselimit.UmcEnablePurchaseLimitConfigService"})
public class UmcEnablePurchaseLimitConfigServiceImpl
implements UmcEnablePurchaseLimitConfigService {
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;

    @PostMapping(value={"enablePurchaseLimitConfig"})
    public UmcEnablePurchaseLimitConfigRspBo enablePurchaseLimitConfig(@RequestBody UmcEnablePurchaseLimitConfigReqBo reqBo) {
        UmcEnablePurchaseLimitConfigRspBo rspBo = (UmcEnablePurchaseLimitConfigRspBo)UmcRu.success(UmcEnablePurchaseLimitConfigRspBo.class);
        this.validateArg(reqBo);
        UmcPurchaseLimitConfigQryBo configQryBo = new UmcPurchaseLimitConfigQryBo();
        configQryBo.setLimitConfigIds(reqBo.getLimitConfigIds());
        IUmcPurchaseLimitDo reqDo = this.buildDoByBO(reqBo);
        this.iUmcPurchaseLimitModel.updatePurchaseLimitConfig(reqDo, configQryBo);
        for (Long limitConfigId : reqBo.getLimitConfigIds()) {
            UmcPurchaseLimitQryBo qryBo = new UmcPurchaseLimitQryBo();
            qryBo.setLimitConfigId(limitConfigId);
            qryBo.setCurrentTime(new Date());
            StrUtil.noNullStringAttr((Object)((Object)qryBo));
            UmcPurchaseLimitSubDo rspDo = this.iUmcPurchaseLimitModel.getPurchaseLimitDetail(qryBo);
            UmcPurchaseLimitAmountConfigHisSubDo configHisSubDo = this.buildConfigHisDo(rspDo, reqDo);
            this.iUmcPurchaseLimitModel.createPurchaseLimitConfigHis(configHisSubDo);
        }
        return rspBo;
    }

    private IUmcPurchaseLimitDo buildDoByBO(UmcEnablePurchaseLimitConfigReqBo reqBo) {
        IUmcPurchaseLimitDo reqDo = (IUmcPurchaseLimitDo)UmcRu.js((Object)reqBo, IUmcPurchaseLimitDo.class);
        reqDo.setLimitStatus("1");
        return reqDo;
    }

    private void validateArg(UmcEnablePurchaseLimitConfigReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UmcEnablePurchaseLimitConfigReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getLimitConfigIds())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[LimitConfigIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private UmcPurchaseLimitAmountConfigHisSubDo buildConfigHisDo(UmcPurchaseLimitSubDo rspDo, IUmcPurchaseLimitDo reqDo) {
        UmcPurchaseLimitAmountConfigHisSubDo configHisDo = (UmcPurchaseLimitAmountConfigHisSubDo)UmcRu.js((Object)reqDo, UmcPurchaseLimitAmountConfigHisSubDo.class);
        configHisDo.setLimitConfigHisId(IdUtil.nextId());
        configHisDo.setExtField1("\u542f\u7528\u91c7\u8d2d\u9650\u989d");
        configHisDo.setLimitConfigId(rspDo.getLimitConfigId());
        configHisDo.setLimitObjType(rspDo.getLimitObjType());
        configHisDo.setLimitObjId(rspDo.getLimitObjId());
        configHisDo.setLimitObjCode(rspDo.getLimitObjCode());
        configHisDo.setLimitStatus(reqDo.getLimitStatus());
        configHisDo.setDelFlag(rspDo.getDelFlag());
        configHisDo.setLimitObjTreePath(rspDo.getLimitObjTreePath());
        configHisDo.setLimitObjName(rspDo.getLimitObjName());
        configHisDo.setIsLimit(rspDo.getIsLimit());
        configHisDo.setLimitType(rspDo.getLimitType());
        configHisDo.setIsAccumulation(rspDo.getIsAccumulation());
        configHisDo.setLimitAmount(rspDo.getLimitAmount());
        configHisDo.setCreateOperId(configHisDo.getUpdateOperId());
        configHisDo.setCreateOperName(configHisDo.getUpdateOperName());
        configHisDo.setCreateTime(configHisDo.getUpdateTime());
        return configHisDo;
    }
}

