/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.supplierSignAccess;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.constants.UmcStatusConstant;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseBankQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseBank;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.enterpriseapply.IUmcEnterpriseInfoApplyModel;
import com.tydic.dyc.umc.model.enterpriseapply.LdIUmcEnterpriseInfoApplyModel;
import com.tydic.dyc.umc.model.enterpriseapply.UmcEnterpriseInfoApplyDo;
import com.tydic.dyc.umc.model.enterpriseapply.qrybo.UmcEnterpriseBankApplyQryBo;
import com.tydic.dyc.umc.model.enterpriseapply.qrybo.UmcEnterpriseInfoApplyQryBo;
import com.tydic.dyc.umc.model.enterpriseapply.qrybo.UmcOrgInfoApplyQryBo;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcEnterpriseBankApply;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcEnterpriseContactApply;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcEnterpriseInfoApplyListRspBo;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcOrgInfoApply;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcOrgTagRelApply;
import com.tydic.dyc.umc.model.orgProductCategoryRel.IUmcOrgProductCategoryRelModel;
import com.tydic.dyc.umc.model.orgProductCategoryRel.qrybo.UmcOrgProductCategoryRelQryBo;
import com.tydic.dyc.umc.model.signcontractapply.IUmcSignContractApplyModel;
import com.tydic.dyc.umc.model.signcontractapply.UmcSignContractApplyDo;
import com.tydic.dyc.umc.model.signcontractapply.sup.SignContractYearRuleApply;
import com.tydic.dyc.umc.model.signcontractapply.sup.SignSalesCategoryApply;
import com.tydic.dyc.umc.model.supplierSignAccess.IUmcSupplierSignAccessModel;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcEnterpriseContactApplyBo;
import com.tydic.dyc.umc.service.supplierSignAccess.bo.UmcChangeSupplierInfoSignReqBO;
import com.tydic.dyc.umc.service.supplierSignAccess.bo.UmcChangeSupplierInfoSignRspBO;
import com.tydic.dyc.umc.service.supplierSignAccess.bo.UmcOrgProductCategoryRelBo;
import com.tydic.dyc.umc.service.supplierSignAccess.bo.UmcSignContractApplyBo;
import com.tydic.dyc.umc.service.supplierSignAccess.service.UmcChangeSupplierInfoSignService;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.supplierSignAccess.service.UmcChangeSupplierInfoSignService"})
public class UmcChangeSupplierInfoSignServiceImpl
implements UmcChangeSupplierInfoSignService {
    private static final Logger log = LoggerFactory.getLogger(UmcChangeSupplierInfoSignServiceImpl.class);
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    @Autowired
    private IUmcEnterpriseInfoApplyModel iUmcEnterpriseInfoApplyModel;
    @Autowired
    private IUmcSignContractApplyModel iUmcSignContractApplyModel;
    @Autowired
    private IUmcSupplierSignAccessModel iUmcSupplierSignAccessModel;
    @Autowired
    private IUmcOrgProductCategoryRelModel iUmcOrgProductCategoryRelModel;
    @Autowired
    private LdIUmcEnterpriseInfoApplyModel ldIUmcEnterpriseInfoApplyModel;
    private static final String SUBMIT = "2";
    private static final String SAVE = "1";
    private static final String YEAR_FEE_NOT_CONFIRM = "4";

    @PostMapping(value={"changeSupplierInfoSign"})
    public UmcChangeSupplierInfoSignRspBO changeSupplierInfoSign(@RequestBody UmcChangeSupplierInfoSignReqBO reqBO) {
        this.checkReqBo(reqBO);
        long applyId = 0L;
        StrUtil.noNullStringAttr((Object)reqBO);
        try {
            applyId = this.insertEnterprise(reqBO);
        }
        catch (Exception e) {
            log.error("\u5f02\u5e38", (Throwable)e);
            throw new BaseBusinessException("200100", e.getMessage());
        }
        reqBO.setApplyId(Long.valueOf(applyId));
        if (!CollectionUtils.isEmpty((Collection)reqBO.getUmcSignContractApplyBo().getSignSalesCategoryApplyBos()) && reqBO.getUmcSignContractApplyBo().getSignSalesCategoryApplyBos().size() > 1000) {
            ThreadPoolExecutor threadService = new ThreadPoolExecutor(1, 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Executors.defaultThreadFactory(), new ThreadPoolExecutor.DiscardOldestPolicy());
            threadService.execute(() -> {
                block2: {
                    try {
                        this.dealSignContract(reqBO);
                        this.dealProductCategory(reqBO);
                    }
                    catch (Exception e) {
                        log.error("\u5408\u4f5c\u54c1\u7c7b,\u4ea7\u54c1\u7c7b\u578b\u5904\u7406\u5931\u8d25{}", (Object)e.getMessage());
                        if (!SUBMIT.equals(reqBO.getOperType())) break block2;
                        UmcEnterpriseInfoApplyDo umcEnterpriseInfoApplyDo = new UmcEnterpriseInfoApplyDo();
                        umcEnterpriseInfoApplyDo.setApplyId(reqBO.getApplyId());
                        umcEnterpriseInfoApplyDo.setApplyStatus("3");
                        this.iUmcEnterpriseInfoApplyModel.updateEnterpriseInfoApply(umcEnterpriseInfoApplyDo);
                    }
                }
            });
            threadService.shutdown();
        } else {
            this.dealSignContract(reqBO);
            this.dealProductCategory(reqBO);
        }
        this.insertContact(reqBO);
        this.updateOrg(reqBO);
        this.insertBank(reqBO);
        UmcChangeSupplierInfoSignRspBO rspBo = new UmcChangeSupplierInfoSignRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setApplyId(reqBO.getApplyId());
        return rspBo;
    }

    private void checkReqBo(UmcChangeSupplierInfoSignReqBO reqBO) {
        if (reqBO.getOrgIdWeb() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSupplierName())) {
            throw new BaseBusinessException("200100", "\u4f9b\u5e94\u5546\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getUmcSignContractApplyBo() == null) {
            throw new BaseBusinessException("200100", "\u7b7e\u7ea6\u76f8\u5173\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        UmcOrgInfoQryBo umcOrgInfoQryBo = new UmcOrgInfoQryBo();
        umcOrgInfoQryBo.setNotOrgId(reqBO.getOrgIdWeb());
        umcOrgInfoQryBo.setOrgName(reqBO.getSupplierName());
        Integer number1 = this.iUmcEnterpriseInfoModel.getCheckOrgInfo((UmcOrgInfoQryBo)StrUtil.noNullStringAttr((Object)umcOrgInfoQryBo)).getNumber();
        if (number1 != null && number1 > 0) {
            throw new BaseBusinessException("200100", "\u4f9b\u5e94\u5546\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u4f9b\u5e94\u5546\u540d\u79f0");
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrgCertificateCode())) {
            UmcEnterpriseInfoQryBo umcEnterpriseInfoQryBo = new UmcEnterpriseInfoQryBo();
            umcEnterpriseInfoQryBo.setNotOrgId(reqBO.getOrgIdWeb());
            umcEnterpriseInfoQryBo.setCreditNo(reqBO.getOrgCertificateCode());
            Integer number = this.iUmcEnterpriseInfoModel.getCheckByEnterpriseInfo((UmcEnterpriseInfoQryBo)StrUtil.noNullStringAttr((Object)umcEnterpriseInfoQryBo)).getNumber();
            if (number != null && number > 0) {
                throw new BaseBusinessException("200100", "\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801");
            }
        }
    }

    private void dealProductCategory(UmcChangeSupplierInfoSignReqBO reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getUmcOrgProductCategoryRelBos())) {
            ArrayList<UmcOrgProductCategoryRelQryBo> addUmcOrgProductCategoryRelQryBos = new ArrayList<UmcOrgProductCategoryRelQryBo>();
            try {
                UmcOrgProductCategoryRelQryBo umcOrgProductCategoryRelQryBo = new UmcOrgProductCategoryRelQryBo();
                umcOrgProductCategoryRelQryBo.setApplyId(reqBO.getApplyId());
                this.iUmcOrgProductCategoryRelModel.delOrgProductCategoryRelApplyBatch(umcOrgProductCategoryRelQryBo);
            }
            catch (Exception e) {
                log.debug("\u5220\u9664\u4ea7\u54c1\u7c7b\u578b\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                throw new BaseBusinessException("200100", "\u5220\u9664\u4ea7\u54c1\u7c7b\u578b\u5931\u8d25");
            }
            for (UmcOrgProductCategoryRelBo each : reqBO.getUmcOrgProductCategoryRelBos()) {
                UmcOrgProductCategoryRelQryBo js;
                if (SAVE.equals(each.getChngType()) && each.getRelId() == null) {
                    js = (UmcOrgProductCategoryRelQryBo)((Object)UmcRu.js((Object)each, UmcOrgProductCategoryRelQryBo.class));
                    js.setRelId(IdUtil.nextId());
                    js.setApplyId(reqBO.getApplyId());
                    js.setOrgId(reqBO.getOrgIdWeb());
                    js.setExtField1(SUBMIT);
                    js.setCreateOperId(reqBO.getUserId());
                    js.setCategoryName(reqBO.getRegAccountIn());
                    js.setCreateTime(new Date());
                    addUmcOrgProductCategoryRelQryBos.add(js);
                    continue;
                }
                if (!YEAR_FEE_NOT_CONFIRM.equals(each.getChngType()) && !(each.getChngType() == null & each.getRelId() != null)) continue;
                js = (UmcOrgProductCategoryRelQryBo)((Object)UmcRu.js((Object)each, UmcOrgProductCategoryRelQryBo.class));
                js.setRelId(IdUtil.nextId());
                js.setExtField1(SUBMIT);
                js.setApplyId(reqBO.getApplyId());
                js.setOrgId(reqBO.getOrgIdWeb());
                js.setCreateOperId(reqBO.getUserId());
                js.setCategoryName(reqBO.getRegAccountIn());
                js.setCreateTime(new Date());
                js.setUpdateOperId(reqBO.getUserId());
                js.setUpdateOperName(reqBO.getRegAccountIn());
                js.setUpdateTime(new Date());
                addUmcOrgProductCategoryRelQryBos.add(js);
            }
            if (!CollectionUtils.isEmpty(addUmcOrgProductCategoryRelQryBos)) {
                try {
                    this.iUmcOrgProductCategoryRelModel.createOrgProductCategoryRelApplyBatch(addUmcOrgProductCategoryRelQryBos);
                }
                catch (Exception e) {
                    log.debug("\u65b0\u589e\u4ea7\u54c1\u7c7b\u578b\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                    throw new BaseBusinessException("200100", "\u65b0\u589e\u4ea7\u54c1\u7c7b\u578b\u5931\u8d25");
                }
            }
        }
    }

    private void updateOrg(UmcChangeSupplierInfoSignReqBO reqBO) {
        UmcOrgInfoQryBo orgInfoQryBo = new UmcOrgInfoQryBo();
        UmcOrgInfoApply insertOrgInfo = new UmcOrgInfoApply();
        orgInfoQryBo.setOrgId(reqBO.getOrgIdWeb());
        UmcOrgInfo orgInfo = this.iUmcEnterpriseInfoModel.getOrgInfo(orgInfoQryBo);
        if (orgInfo == null) {
            throw new BaseBusinessException("200100", "\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a");
        }
        UmcOrgInfoApplyQryBo orgInfoApplyQryBo = new UmcOrgInfoApplyQryBo();
        orgInfoApplyQryBo.setOrgId(reqBO.getOrgIdWeb());
        orgInfoApplyQryBo.setApplyId(reqBO.getApplyId());
        UmcOrgInfoApply orgInfoApply = this.iUmcEnterpriseInfoApplyModel.getOrgInfoApply(orgInfoApplyQryBo);
        if (orgInfoApply == null) {
            insertOrgInfo = (UmcOrgInfoApply)UmcRu.js((Object)orgInfo, UmcOrgInfoApply.class);
            insertOrgInfo.setApplyId(reqBO.getApplyId());
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getSupplierName())) {
            insertOrgInfo.setOrgName(reqBO.getSupplierName());
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getSupplierShortName())) {
            insertOrgInfo.setOrgAlias(reqBO.getSupplierShortName());
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getOrgCode())) {
            insertOrgInfo.setOrgCode(reqBO.getOrgCode());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrgTagRelList())) {
            ArrayList<UmcOrgTagRelApply> tags = new ArrayList<UmcOrgTagRelApply>();
            for (String tag : reqBO.getOrgTagRelList()) {
                UmcOrgTagRelApply tagRelApply = new UmcOrgTagRelApply();
                tagRelApply.setApplyId(reqBO.getApplyId());
                tagRelApply.setOrgId(reqBO.getOrgIdWeb());
                tagRelApply.setTenantId(reqBO.getTenantIdIn());
                tagRelApply.setTagId(tag);
                tagRelApply.setTagStatus(SAVE);
                tagRelApply.setEffTime(new Date());
                tagRelApply.setCreateOperId(reqBO.getUserId());
                tagRelApply.setCreateOperName(reqBO.getRegAccountIn());
                tagRelApply.setCreateTime(new Date());
                tagRelApply.setDelFlag("0");
                tags.add(tagRelApply);
            }
            insertOrgInfo.setOrgTagRelApplyList(tags);
        }
        if (orgInfoApply != null) {
            insertOrgInfo.setUpdateOperId(reqBO.getUserId());
            insertOrgInfo.setUpdateTime(new Date());
            insertOrgInfo.setUpdateOperName(reqBO.getRegAccountIn());
            insertOrgInfo.setApplyId(reqBO.getApplyId());
            this.iUmcEnterpriseInfoApplyModel.updateOrgInfoApply(insertOrgInfo);
        } else {
            insertOrgInfo.setCreateOperId(reqBO.getUserId());
            insertOrgInfo.setCreateTime(new Date());
            insertOrgInfo.setCreateOperName(reqBO.getRegAccountIn());
            this.iUmcEnterpriseInfoApplyModel.createOrgInfoApply(insertOrgInfo);
        }
    }

    private void insertContact(UmcChangeSupplierInfoSignReqBO reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getUmcEnterpriseContactApplyBos())) {
            ArrayList<UmcEnterpriseContactApply> umcEnterpriseContactApplies = new ArrayList<UmcEnterpriseContactApply>();
            for (UmcEnterpriseContactApplyBo each : reqBO.getUmcEnterpriseContactApplyBos()) {
                UmcEnterpriseContactApply js = (UmcEnterpriseContactApply)UmcRu.js((Object)each, UmcEnterpriseContactApply.class);
                js.setOrgId(reqBO.getOrgIdWeb());
                js.setDelFlag("0");
                js.setApplyId(reqBO.getApplyId());
                if (SAVE.equals(each.getExtField4()) && each.getApplyId() == null) {
                    js.setExtField4(SAVE);
                    js.setContactId(Long.valueOf(IdUtil.nextId()));
                    js.setCreateOperId(reqBO.getUserId());
                    js.setCreateOperName(reqBO.getRegAccountIn());
                    js.setCreateTime(new Date());
                    umcEnterpriseContactApplies.add(js);
                    continue;
                }
                if (YEAR_FEE_NOT_CONFIRM.equals(each.getExtField4()) || each.getExtField4() == null) {
                    if (each.getApplyId() == null || !each.getApplyId().equals(reqBO.getApplyId())) {
                        js.setExtField4("3");
                        js.setContactId(Long.valueOf(IdUtil.nextId()));
                        js.setCreateOperId(reqBO.getUserId());
                        js.setCreateOperName(reqBO.getRegAccountIn());
                        if (js.getCreateTime() == null) {
                            js.setCreateTime(new Date());
                        }
                        umcEnterpriseContactApplies.add(js);
                        continue;
                    }
                    js.setExtField4("3");
                    js.setUpdateOperId(reqBO.getUserId());
                    js.setUpdateOperName(reqBO.getRegAccountIn());
                    js.setUpdateTime(new Date());
                    js.setContactId(each.getContactId());
                    this.iUmcEnterpriseInfoApplyModel.updateEnterpriseContactApply(js);
                    continue;
                }
                if (!SUBMIT.equals(each.getExtField4())) continue;
                js.setExtField4(SUBMIT);
                js.setDelFlag(SAVE);
                js.setUpdateOperId(reqBO.getUserId());
                js.setUpdateOperName(reqBO.getRegAccountIn());
                js.setUpdateTime(new Date());
                js.setContactId(each.getContactId());
                this.iUmcEnterpriseInfoApplyModel.updateEnterpriseContactApply(js);
            }
            if (!CollectionUtils.isEmpty(umcEnterpriseContactApplies)) {
                try {
                    this.ldIUmcEnterpriseInfoApplyModel.createEnterpriseContactApplyList(umcEnterpriseContactApplies);
                }
                catch (Exception e) {
                    log.debug("\u6279\u91cf\u65b0\u589e\u8054\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                    throw new BaseBusinessException("200100", "\u6279\u91cf\u65b0\u589e\u8054\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25");
                }
            }
        }
    }

    public Long insertEnterprise(UmcChangeSupplierInfoSignReqBO reqBO) throws ParseException {
        Long applyId;
        log.debug("\u4f01\u4e1a\u4fe1\u606f\u53d8\u66f4\u5165\u53c2\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        UmcEnterpriseInfoApplyQryBo enterpriseInfoBo = new UmcEnterpriseInfoApplyQryBo();
        enterpriseInfoBo.setOrgId(reqBO.getOrgIdWeb());
        enterpriseInfoBo.setApplyType(String.valueOf(UmcCommConstant.OBJ_BUSI_TYPE.ENTERPRISE_UPDATE));
        enterpriseInfoBo.setApplyStatus("3");
        enterpriseInfoBo.setOrderBy("create_time desc");
        UmcEnterpriseInfoApplyListRspBo umcEnterpriseInfoApplyListRspBo = this.iUmcEnterpriseInfoApplyModel.getEnterpriseInfoApplyList(enterpriseInfoBo);
        List enterpriseInfoList = umcEnterpriseInfoApplyListRspBo.getRows();
        UmcEnterpriseInfoApplyDo eninfoChngPo = null;
        if (!CollectionUtils.isEmpty((Collection)enterpriseInfoList)) {
            eninfoChngPo = (UmcEnterpriseInfoApplyDo)enterpriseInfoList.get(0);
        }
        UmcEnterpriseInfoQryBo enterpriseInfoMainPo = new UmcEnterpriseInfoQryBo();
        enterpriseInfoMainPo.setOrgId(reqBO.getOrgIdWeb());
        UmcEnterpriseInfoDo eninfoMainPo = this.iUmcEnterpriseInfoModel.getEnterpriseInfo(enterpriseInfoMainPo);
        UmcEnterpriseInfoApplyDo infoChngPo = (UmcEnterpriseInfoApplyDo)UmcRu.js((Object)reqBO, UmcEnterpriseInfoApplyDo.class);
        log.debug("\u4f01\u4e1a\u4fe1\u606f\u5165\u53c2\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)infoChngPo));
        infoChngPo.setOrgId(reqBO.getOrgIdWeb());
        infoChngPo.setApplyType(String.valueOf(UmcCommConstant.OBJ_BUSI_TYPE.ENTERPRISE_UPDATE));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (SAVE.equals(reqBO.getOperType())) {
            infoChngPo.setApplyStatus("3");
        } else if (SUBMIT.equals(reqBO.getOperType())) {
            infoChngPo.setApplyStatus("0");
        }
        infoChngPo.setTenantId(reqBO.getTenantIdIn());
        infoChngPo.setIsMerchant("0");
        infoChngPo.setOrgName(reqBO.getSupplierName());
        infoChngPo.setSupplierType(reqBO.getSupplierType());
        infoChngPo.setOrgNature(reqBO.getEnterpriseNature());
        infoChngPo.setCreditNo(reqBO.getOrgCertificateCode());
        if (reqBO.getEffDate() != null) {
            infoChngPo.setEffDate(simpleDateFormat.format(reqBO.getEffDate()));
        }
        if (reqBO.getExpDate() != null) {
            infoChngPo.setExpDate(simpleDateFormat.format(reqBO.getExpDate()));
        }
        infoChngPo.setProvince(reqBO.getProvinceName());
        infoChngPo.setBusinessLicense(JSONObject.toJSONString((Object)reqBO.getBusinessLicense()));
        infoChngPo.setLegalCertificateType(reqBO.getLegalPersonIdcardType());
        infoChngPo.setLegalCertificateNum(reqBO.getLegalPersonIdcardNum());
        infoChngPo.setLegalCertificateFront(JSONObject.toJSONString((Object)reqBO.getLegalPersonCardPro()));
        infoChngPo.setLegalCertificateBack(JSONObject.toJSONString((Object)reqBO.getLegalPersonCardCan()));
        infoChngPo.setOrgEnName(reqBO.getSupplierEnName());
        infoChngPo.setOrgShortName(reqBO.getSupplierShortName());
        infoChngPo.setCapaPicture(JSONObject.toJSONString((Object)reqBO.getCapaPicture()));
        if (null == eninfoChngPo) {
            infoChngPo.setCreateOperId(reqBO.getUserId());
            infoChngPo.setCreateOperName(reqBO.getRegAccountIn());
            infoChngPo.setCreateTime(new Date());
            infoChngPo.setApplyId(Long.valueOf(IdUtil.nextId()));
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getOrgEnName())) {
                infoChngPo.setOrgEnName(eninfoMainPo.getOrgEnName());
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getOrgShortName())) {
                infoChngPo.setOrgShortName(eninfoMainPo.getOrgShortName());
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getOrgNature())) {
                infoChngPo.setOrgNature(eninfoMainPo.getOrgNature());
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getIsMerchant())) {
                infoChngPo.setIsMerchant(eninfoMainPo.getIsMerchant());
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getProvince())) {
                infoChngPo.setProvince(eninfoMainPo.getProvince());
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getAddress())) {
                infoChngPo.setAddress(eninfoMainPo.getAddress());
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getIndustry())) {
                infoChngPo.setIndustry(eninfoMainPo.getIndustry());
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getLegalPerson())) {
                infoChngPo.setLegalPerson(eninfoMainPo.getLegalPerson());
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getLegalCertificateType())) {
                infoChngPo.setLegalCertificateType(eninfoMainPo.getLegalCertificateType());
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getLegalCertificateFront())) {
                infoChngPo.setLegalCertificateFront(eninfoMainPo.getLegalCertificateFront());
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getLegalCertificateBack())) {
                infoChngPo.setLegalCertificateBack(eninfoMainPo.getLegalCertificateBack());
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getCapital())) {
                infoChngPo.setCapital(eninfoMainPo.getCapital());
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getCreditNo())) {
                infoChngPo.setCreditNo(eninfoMainPo.getCreditNo());
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getBusinessLicense())) {
                infoChngPo.setBusinessLicense(eninfoMainPo.getBusinessLicense());
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getBusinessScope())) {
                infoChngPo.setBusinessScope(eninfoMainPo.getBusinessScope());
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getCapaPicture())) {
                infoChngPo.setCapaPicture(eninfoMainPo.getCapaPicture());
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getEffDate())) {
                infoChngPo.setEffDate(eninfoMainPo.getEffDate());
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getExpDate())) {
                infoChngPo.setExpDate(eninfoMainPo.getExpDate());
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getLegalCertificateNum())) {
                infoChngPo.setLegalCertificateNum(eninfoMainPo.getLegalCertificateNum());
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getSupplierType())) {
                infoChngPo.setSupplierType(eninfoMainPo.getSupplierType());
            }
            this.iUmcEnterpriseInfoApplyModel.createEnterpriseInfoApply(infoChngPo);
            applyId = infoChngPo.getApplyId();
        } else {
            infoChngPo.setUpdateOperId(reqBO.getUserId());
            infoChngPo.setUpdateOperName(reqBO.getRegAccountIn());
            infoChngPo.setApplyId(eninfoChngPo.getApplyId());
            infoChngPo.setCreateTime(new Date());
            infoChngPo.setUpdateTime(new Date());
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getEffDate())) {
                infoChngPo.setEffDate("");
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getExpDate())) {
                infoChngPo.setExpDate("");
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getProvince())) {
                infoChngPo.setProvince("");
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getAddress())) {
                infoChngPo.setAddress("");
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getLegalCertificateFront())) {
                infoChngPo.setLegalCertificateFront("");
            }
            if (StringUtils.isEmpty((CharSequence)infoChngPo.getLegalCertificateBack())) {
                infoChngPo.setLegalCertificateBack("");
            }
            log.debug("\u4fee\u6539\u7684\u5165\u53c2\u4e3a\uff1a{}", (Object)infoChngPo);
            this.iUmcEnterpriseInfoApplyModel.updateEnterpriseInfoApply(infoChngPo);
            applyId = eninfoChngPo.getApplyId();
        }
        return applyId;
    }

    public void insertBank(UmcChangeSupplierInfoSignReqBO reqBo) {
        UmcEnterpriseBankApplyQryBo bankInfoChngPo = new UmcEnterpriseBankApplyQryBo();
        bankInfoChngPo.setOrgId(reqBo.getOrgIdWeb());
        bankInfoChngPo.setApplyId(reqBo.getApplyId());
        UmcEnterpriseBankApply enterpriseBankInfoChngPo = this.iUmcEnterpriseInfoApplyModel.getEnterpriseBankApply(bankInfoChngPo);
        UmcEnterpriseBankQryBo bankInfoPo = new UmcEnterpriseBankQryBo();
        bankInfoPo.setOrgId(reqBo.getOrgIdWeb());
        UmcEnterpriseBank enterpriseBankInfoPo = this.iUmcEnterpriseInfoModel.getEnterpriseBank(bankInfoPo);
        UmcEnterpriseBankApply infoPo = new UmcEnterpriseBankApply();
        infoPo.setBankAccount(reqBo.getBankAccount());
        infoPo.setBankName(reqBo.getBankName());
        infoPo.setBankAccountName(reqBo.getBankAccountName());
        infoPo.setBankLinkNo(reqBo.getBankLinkNo());
        infoPo.setBankAddr(reqBo.getBankAddr());
        infoPo.setApplyId(reqBo.getApplyId());
        infoPo.setOrgId(reqBo.getOrgIdWeb());
        infoPo.setTenantId(reqBo.getTenantIdIn());
        if (enterpriseBankInfoPo != null) {
            infoPo.setBankId(enterpriseBankInfoPo.getBankId());
        } else {
            infoPo.setBankId(Long.valueOf(IdUtil.nextId()));
        }
        if (null != enterpriseBankInfoChngPo) {
            infoPo.setUpdateOperId(reqBo.getUserId());
            infoPo.setUpdateTime(new Date());
            infoPo.setUpdateOperName(reqBo.getRegAccountIn());
            infoPo.setApplyId(reqBo.getApplyId());
            this.iUmcEnterpriseInfoApplyModel.updateEnterpriseBankApply(infoPo);
        } else {
            infoPo.setCreateOperId(reqBo.getUserId());
            infoPo.setCreateOperName(reqBo.getRegAccountIn());
            infoPo.setCreateTime(new Date());
            this.iUmcEnterpriseInfoApplyModel.createEnterpriseBankApply(infoPo);
        }
    }

    private void dealSignContract(UmcChangeSupplierInfoSignReqBO reqBO) {
        UmcSignContractApplyDo qryUmcSignContractApplyDo = new UmcSignContractApplyDo();
        qryUmcSignContractApplyDo.setApplyId(reqBO.getApplyId());
        qryUmcSignContractApplyDo.setOrgId(reqBO.getOrgIdWeb());
        qryUmcSignContractApplyDo.setApplyType(SUBMIT);
        UmcSignContractApplyDo umcSignContractApplyResult = this.iUmcSupplierSignAccessModel.querySignContractApplyInfo(qryUmcSignContractApplyDo);
        UmcSignContractApplyBo umcSignContractApplyBo = reqBO.getUmcSignContractApplyBo();
        Integer signStatus = UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.Draft;
        if (SUBMIT.equals(reqBO.getOperType())) {
            signStatus = UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.APPLYING;
        }
        if (umcSignContractApplyResult == null) {
            this.insertSignContract(reqBO, umcSignContractApplyBo, signStatus);
        } else {
            this.updateSignContract(reqBO, umcSignContractApplyResult, umcSignContractApplyBo, signStatus);
        }
    }

    private void updateSignContract(UmcChangeSupplierInfoSignReqBO reqBo, UmcSignContractApplyDo umcSignContractApplyResult, UmcSignContractApplyBo umcSignContractApplyBo, Integer signStatus) {
        UmcSignContractApplyDo updateSignApplyDo = (UmcSignContractApplyDo)StrUtil.noNullStringAttr((Object)UmcRu.js((Object)umcSignContractApplyBo, UmcSignContractApplyDo.class));
        updateSignApplyDo.setApplyId(umcSignContractApplyResult.getApplyId());
        updateSignApplyDo.setSignContractId(umcSignContractApplyResult.getSignContractId());
        updateSignApplyDo.setUpdateTime(new Date());
        updateSignApplyDo.setUpdateOperId(reqBo.getUserId());
        this.iUmcSignContractApplyModel.updateSignContractApply(updateSignApplyDo);
        SignSalesCategoryApply signSalesCategoryApply = new SignSalesCategoryApply();
        signSalesCategoryApply.setApplyId(umcSignContractApplyResult.getApplyId());
        signSalesCategoryApply.setDelFlag(SAVE);
        signSalesCategoryApply.setUpdateTime(new Date());
        signSalesCategoryApply.setUpdateOperName(reqBo.getRegAccountIn());
        signSalesCategoryApply.setUpdateOperId(reqBo.getUserId());
        this.iUmcSupplierSignAccessModel.updateSignSalesCategory(signSalesCategoryApply);
        if (!CollectionUtils.isEmpty((Collection)umcSignContractApplyBo.getSignSalesCategoryApplyBos())) {
            ArrayList<SignSalesCategoryApply> addSalesCategories = new ArrayList<SignSalesCategoryApply>();
            for (Object umcSupSalesCategoryBO : umcSignContractApplyBo.getSignSalesCategoryApplyBos()) {
                if (SUBMIT.equals(umcSupSalesCategoryBO.getChngType())) continue;
                SignSalesCategoryApply supSalesCategoryPo = new SignSalesCategoryApply();
                BeanUtils.copyProperties((Object)umcSupSalesCategoryBO, (Object)supSalesCategoryPo);
                supSalesCategoryPo.setDelFlag("0");
                supSalesCategoryPo.setApplyId(umcSignContractApplyResult.getApplyId());
                supSalesCategoryPo.setSignContractId(umcSignContractApplyResult.getSignContractId());
                supSalesCategoryPo.setSalesCategoryId(Long.valueOf(IdUtil.nextId()));
                if (umcSupSalesCategoryBO.getServiceFeeRate() == null) {
                    supSalesCategoryPo.setServiceFeeRate(Double.valueOf(0.0));
                }
                supSalesCategoryPo.setChngType(YEAR_FEE_NOT_CONFIRM);
                supSalesCategoryPo.setCreateOperId(reqBo.getUserId());
                supSalesCategoryPo.setCreateOperName(reqBo.getRegAccountIn());
                supSalesCategoryPo.setCreateTime(new Date());
                supSalesCategoryPo.setUpdateTime(new Date());
                supSalesCategoryPo.setUpdateOperId(reqBo.getUserId());
                supSalesCategoryPo.setUpdateOperName(reqBo.getRegAccountIn());
                addSalesCategories.add(supSalesCategoryPo);
            }
            if (!CollectionUtils.isEmpty(addSalesCategories)) {
                UmcSignContractApplyDo addCategoryDo = new UmcSignContractApplyDo();
                addCategoryDo.setSignSalesCategoryApplies(addSalesCategories);
                this.iUmcSupplierSignAccessModel.insertBatchSignSalesCategory(addCategoryDo);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)umcSignContractApplyResult.getSignContractYearRuleApplies())) {
            SignContractYearRuleApply where = new SignContractYearRuleApply();
            where.setApplyId(umcSignContractApplyResult.getApplyId());
            where.setDelFlag(SAVE);
            where.setUpdateOperId(reqBo.getUserId());
            where.setUpdateOperName(reqBo.getRegAccountIn());
            where.setUpdateTime(new Date());
            this.iUmcSignContractApplyModel.updateSignContractYearRuleApplies(where);
            ArrayList<SignContractYearRuleApply> addYearRule = new ArrayList<SignContractYearRuleApply>();
            for (SignContractYearRuleApply umcSupSignContractYearRuleBO : umcSignContractApplyResult.getSignContractYearRuleApplies()) {
                SignContractYearRuleApply signContractYearRulePo = new SignContractYearRuleApply();
                BeanUtils.copyProperties((Object)umcSupSignContractYearRuleBO, (Object)signContractYearRulePo);
                signContractYearRulePo.setCreateOperId(reqBo.getUserId());
                signContractYearRulePo.setCreateOperName(reqBo.getRegAccountIn());
                signContractYearRulePo.setCreateTime(new Date());
                signContractYearRulePo.setSignContractId(umcSignContractApplyResult.getSignContractId());
                signContractYearRulePo.setApplyId(umcSignContractApplyResult.getApplyId());
                signContractYearRulePo.setChngType(YEAR_FEE_NOT_CONFIRM);
                signContractYearRulePo.setDelFlag("0");
                signContractYearRulePo.setRuleId(Long.valueOf(IdUtil.nextId()));
                addYearRule.add(signContractYearRulePo);
            }
            if (!CollectionUtils.isEmpty(addYearRule)) {
                UmcSignContractApplyDo addYearDo = new UmcSignContractApplyDo();
                addYearDo.setSignContractYearRuleApplies(addYearRule);
                this.iUmcSignContractApplyModel.addSignContractYearRuleApplies(addYearDo);
            }
        }
    }

    private void insertSignContract(UmcChangeSupplierInfoSignReqBO reqBO, UmcSignContractApplyBo umcSignContractApplyBo, Integer signStatus) {
        UmcSignContractApplyDo insertUmcSignContractApply = (UmcSignContractApplyDo)UmcRu.js((Object)umcSignContractApplyBo, UmcSignContractApplyDo.class);
        insertUmcSignContractApply.setSignContractId(Long.valueOf(IdUtil.nextId()));
        insertUmcSignContractApply.setApplyId(reqBO.getApplyId());
        insertUmcSignContractApply.setTenantId(reqBO.getTenantIdIn());
        insertUmcSignContractApply.setOrgId(reqBO.getOrgIdWeb());
        insertUmcSignContractApply.setCreateTime(new Date());
        insertUmcSignContractApply.setDelFlag("0");
        insertUmcSignContractApply.setStatus(signStatus);
        insertUmcSignContractApply.setApplyType(SUBMIT);
        if (!CollectionUtils.isEmpty((Collection)umcSignContractApplyBo.getSignSalesCategoryApplyBos())) {
            List salesCategoryApplies = UmcRu.jsl((List)umcSignContractApplyBo.getSignSalesCategoryApplyBos(), SignSalesCategoryApply.class);
            for (SignSalesCategoryApply bo2 : salesCategoryApplies) {
                bo2.setSalesCategoryId(Long.valueOf(IdUtil.nextId()));
                bo2.setTenantId(reqBO.getTenantIdIn());
                bo2.setApplyId(reqBO.getApplyId());
                bo2.setSignContractId(insertUmcSignContractApply.getSignContractId());
                if (SUBMIT.equals(bo2.getChngType())) {
                    bo2.setDelFlag(SAVE);
                    continue;
                }
                bo2.setDelFlag("0");
            }
            insertUmcSignContractApply.setSignSalesCategoryApplies(salesCategoryApplies);
        }
        UmcSignContractApplyDo signContractApply = this.iUmcSignContractApplyModel.createSignContractApply(insertUmcSignContractApply);
        if (!CollectionUtils.isEmpty((Collection)umcSignContractApplyBo.getSignContractYearRuleApplyBos())) {
            List ruleApplies = UmcRu.jsl((List)umcSignContractApplyBo.getSignContractYearRuleApplyBos(), SignContractYearRuleApply.class);
            UmcSignContractApplyDo ruleApplyDo = new UmcSignContractApplyDo();
            ruleApplyDo.setSignContractYearRuleApplies(ruleApplies);
            ruleApplyDo.setApplyId(reqBO.getApplyId());
            ruleApplyDo.setSignContractId(insertUmcSignContractApply.getSignContractId());
            ruleApplyDo.setDelFlag("0");
            this.iUmcSignContractApplyModel.addSignContractYearRuleApplies(ruleApplyDo);
        }
    }
}

