/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.costControl;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.costControl.IUmcCostControlModel;
import com.tydic.dyc.umc.model.costControl.qrybo.UmcCostControlQryBo;
import com.tydic.dyc.umc.model.costControl.sub.UmcCostControlSubDo;
import com.tydic.dyc.umc.service.costControl.UmcGetCostControlDetailService;
import com.tydic.dyc.umc.service.costControl.bo.UmcCostControlBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcGetCostControlDetailReqBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcGetCostControlDetailRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.costControl.UmcGetCostControlDetailService"})
public class UmcGetCostControlDetailServiceImpl
implements UmcGetCostControlDetailService {
    private static final Logger log = LoggerFactory.getLogger(UmcGetCostControlDetailServiceImpl.class);
    @Autowired
    private IUmcCostControlModel iUmcCostControlModel;

    @PostMapping(value={"getCostControlDetail"})
    public UmcGetCostControlDetailRspBo getCostControlDetail(@RequestBody UmcGetCostControlDetailReqBo reqBo) {
        UmcGetCostControlDetailRspBo rspBo = (UmcGetCostControlDetailRspBo)UmcRu.success(UmcGetCostControlDetailRspBo.class);
        this.validateArg(reqBo);
        UmcCostControlQryBo qryBo = new UmcCostControlQryBo();
        qryBo.setControlConfigId(reqBo.getControlConfigId());
        qryBo.setCurrentTime(reqBo.getCurrentTime());
        UmcCostControlSubDo subDo = this.iUmcCostControlModel.getCostControlDetail(qryBo);
        UmcCostControlBo costControlBo = (UmcCostControlBo)UmcRu.js((Object)subDo, UmcCostControlBo.class);
        costControlBo.setAvailableControlQuantity(costControlBo.getAvailableControlQuantity().setScale(0, 4));
        costControlBo.setCostControlQuantity(costControlBo.getCostControlQuantity().setScale(0, 4));
        costControlBo.setPurchasedQuantity(costControlBo.getPurchasedQuantity().setScale(0, 4));
        rspBo.setCostControlBo(costControlBo);
        return rspBo;
    }

    private void validateArg(UmcGetCostControlDetailReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UmcGetCostControlDetailReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getControlConfigId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[ControlConfigId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

