/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.costControl;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.costControl.IUmcCostControlModel;
import com.tydic.dyc.umc.model.costControl.qrybo.UmcCostControlQryBo;
import com.tydic.dyc.umc.model.costControl.sub.UmcCostControlAmountSubDo;
import com.tydic.dyc.umc.model.costControl.sub.UmcCostControlHisSubDo;
import com.tydic.dyc.umc.model.costControl.sub.UmcCostControlSubDo;
import com.tydic.dyc.umc.service.costControl.UmcOperateCostControlAmountMqService;
import com.tydic.dyc.umc.service.costControl.bo.UmcCostControlExtBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcOperateCostControlAmountMqReqBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcOperateCostControlAmountMqRspBo;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcOperatePurchaseLimitAmountMqRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.costControl.UmcOperateCostControlAmountMqService"})
public class UmcOperateCostControlAmountMqServiceImpl
implements UmcOperateCostControlAmountMqService {
    private static final Logger log = LoggerFactory.getLogger(UmcOperateCostControlAmountMqServiceImpl.class);
    @Autowired
    private IUmcCostControlModel iUmcCostControlModel;

    @PostMapping(value={"operateCostControlAmountMq"})
    public UmcOperateCostControlAmountMqRspBo operateCostControlAmountMq(@RequestBody UmcOperateCostControlAmountMqReqBo reqBo) {
        log.info("\u6210\u672c\u63a7\u5236\u63a5\u6536\u5230\u6d88\u606f\uff1a{},", (Object)reqBo);
        this.validateArg(reqBo);
        UmcCostControlQryBo qryBo = new UmcCostControlQryBo();
        qryBo.setControlAmountIds(reqBo.getControlAmountIds());
        qryBo.setDelFlag(null);
        StrUtil.noNullStringAttr((Object)((Object)qryBo));
        BasePageRspBo<UmcCostControlSubDo> rspDos = this.iUmcCostControlModel.getCostControlPageList(qryBo);
        if (!CollectionUtils.isEmpty((Collection)rspDos.getRows())) {
            HashMap<Long, UmcCostControlExtBo> costControlExtBoMap = new HashMap<Long, UmcCostControlExtBo>(reqBo.getControlList().size());
            for (UmcCostControlExtBo costControlExtBo : reqBo.getControlList()) {
                costControlExtBoMap.put(costControlExtBo.getControlAmountId(), costControlExtBo);
            }
            for (UmcCostControlSubDo row : rspDos.getRows()) {
                String hisFrom = "\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef";
                String chngRemark = "\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef";
                UmcCostControlAmountSubDo amountSubDo = (UmcCostControlAmountSubDo)UmcRu.js((Object)row, UmcCostControlAmountSubDo.class);
                UmcCostControlExtBo bo2 = (UmcCostControlExtBo)costControlExtBoMap.get(row.getControlAmountId());
                if ("deduct".equals(reqBo.getOperateType())) {
                    hisFrom = "\u91c7\u8d2d\u6263\u51cf";
                    chngRemark = "\u6210\u672c\u63a7\u5236\u91cf\u6263\u51cf";
                    amountSubDo.setPurchasedQuantity(new BigDecimal(row.getPurchasedQuantity()).add(bo2.getPurchaseQuantity()));
                    amountSubDo.setAvailableControlQuantity(new BigDecimal(row.getCostControlQuantity()).subtract(amountSubDo.getPurchasedQuantity()));
                } else if ("cancle".equals(reqBo.getOperateType())) {
                    hisFrom = "\u8ba2\u5355\u53d6\u6d88";
                    chngRemark = "\u6210\u672c\u63a7\u5236\u91cf\u91ca\u653e";
                    amountSubDo.setPurchasedQuantity(new BigDecimal(row.getPurchasedQuantity()).add(bo2.getPurchaseQuantity()));
                    amountSubDo.setAvailableControlQuantity(new BigDecimal(row.getCostControlQuantity()).subtract(amountSubDo.getPurchasedQuantity()));
                } else if ("return".equals(reqBo.getOperateType())) {
                    hisFrom = "\u552e\u540e\u9000\u8d27";
                    chngRemark = "\u6210\u672c\u63a7\u5236\u91cf\u91ca\u653e";
                    log.debug("bo\u91cc\u7684\u9000\u56de\u91cf======{}:", (Object)bo2.getPurchaseQuantity());
                    amountSubDo.setPurchasedQuantity(new BigDecimal(row.getPurchasedQuantity()).add(bo2.getPurchaseQuantity()));
                    amountSubDo.setAvailableControlQuantity(new BigDecimal(row.getCostControlQuantity()).subtract(amountSubDo.getPurchasedQuantity()));
                }
                UmcCostControlQryBo amountQryBo = new UmcCostControlQryBo();
                amountQryBo.setControlAmountId(amountSubDo.getControlAmountId());
                amountQryBo.setPurchasedQuantity(amountSubDo.getPurchasedQuantity());
                amountQryBo.setAvailableControlQuantity(amountSubDo.getAvailableControlQuantity());
                this.iUmcCostControlModel.updateCostControl(amountQryBo);
                UmcCostControlHisSubDo hisSubDo = this.buildHisDo(row, reqBo, bo2, hisFrom, chngRemark);
                this.iUmcCostControlModel.createCostControlHis(hisSubDo);
                UmcOperatePurchaseLimitAmountMqRspBo rspBo = new UmcOperatePurchaseLimitAmountMqRspBo();
                rspBo.setRespCode("0000");
                rspBo.setRespDesc("\u6210\u529f");
            }
        }
        return null;
    }

    private void validateArg(UmcOperateCostControlAmountMqReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOperateType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private UmcCostControlHisSubDo buildHisDo(UmcCostControlSubDo umcCostControlSubDo, UmcOperateCostControlAmountMqReqBo controlAmountMqReqBo, UmcCostControlExtBo umcCostControlExtBo, String hisFrom, String chngRemark) {
        UmcCostControlHisSubDo hisSubDo = new UmcCostControlHisSubDo();
        hisSubDo.setHisId(IdUtil.nextId());
        hisSubDo.setHisFrom(!StringUtils.isEmpty((CharSequence)controlAmountMqReqBo.getOperNode()) ? controlAmountMqReqBo.getOperNode() : hisFrom);
        hisSubDo.setControlAmountId(umcCostControlSubDo.getControlAmountId());
        hisSubDo.setControlConfigId(umcCostControlSubDo.getControlConfigId());
        BigDecimal purchaseAmountBefore = new BigDecimal(umcCostControlSubDo.getCostControlQuantity()).subtract(new BigDecimal(umcCostControlSubDo.getPurchasedQuantity()));
        BigDecimal purchaseAmountAfter = purchaseAmountBefore.subtract(umcCostControlExtBo.getPurchaseQuantity()).abs();
        hisSubDo.setPurchaseAmountBefore(purchaseAmountBefore);
        hisSubDo.setChngPurchaseAmount(umcCostControlExtBo.getPurchaseQuantity());
        hisSubDo.setPurchaseAmountAfter(purchaseAmountAfter);
        hisSubDo.setChngRemark(chngRemark);
        hisSubDo.setCreateOperId(controlAmountMqReqBo.getOperateId());
        hisSubDo.setCreateOperName(controlAmountMqReqBo.getOperateName());
        if (StringUtils.isBlank((CharSequence)controlAmountMqReqBo.getOperateName())) {
            controlAmountMqReqBo.setOperateName("\u7cfb\u7edf");
        }
        hisSubDo.setCreateTime(new Date());
        hisSubDo.setExtField1(controlAmountMqReqBo.getOrderCode());
        hisSubDo.setExtField2(String.valueOf(umcCostControlExtBo.getPurchaseQuantity()));
        return hisSubDo;
    }
}

