/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.credit;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.credit.IUmcCreditInfoModel;
import com.tydic.dyc.umc.model.credit.qrybo.UmcQyrCreditInfoDetailQryBO;
import com.tydic.dyc.umc.model.credit.sub.UmcQyrCreditInfoDetailSubDo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitSubDo;
import com.tydic.dyc.umc.service.credit.UmcQyrCreditInfoDetailService;
import com.tydic.dyc.umc.service.credit.bo.UmcQyrCreditInfoDetailReqBO;
import com.tydic.dyc.umc.service.credit.bo.UmcQyrCreditInfoDetailRspBO;
import com.tydic.dyc.umc.service.enterprise.DictionaryBusiService;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcPurchaseLimitBo;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;

public class UmcQyrCreditInfoDetailServiceImpl
implements UmcQyrCreditInfoDetailService {
    @Autowired
    private IUmcCreditInfoModel iUmcCreditInfoModel;
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;
    @Autowired
    private DictionaryBusiService dictionaryBusiService;

    public UmcQyrCreditInfoDetailRspBO qryCreditInfoDetail(UmcQyrCreditInfoDetailReqBO reqBO) {
        UmcQyrCreditInfoDetailRspBO rspBO = new UmcQyrCreditInfoDetailRspBO();
        rspBO.setRespCode("0000");
        if (ObjectUtils.isEmpty((Object)reqBO.getLimitConfigId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[limitConfigId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UmcQyrCreditInfoDetailQryBO detailQryBO = (UmcQyrCreditInfoDetailQryBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), UmcQyrCreditInfoDetailQryBO.class));
        UmcQyrCreditInfoDetailSubDo detailSubDo = this.iUmcCreditInfoModel.qryCreditInfoDetail(detailQryBO);
        if (!ObjectUtils.isEmpty((Object)((Object)detailSubDo))) {
            rspBO = (UmcQyrCreditInfoDetailRspBO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)detailSubDo)), UmcQyrCreditInfoDetailRspBO.class);
        }
        UmcPurchaseLimitQryBo configQryBo = new UmcPurchaseLimitQryBo();
        configQryBo.setLimitConfigId(reqBO.getLimitConfigId());
        configQryBo.setExtField1(reqBO.getExtField1());
        UmcPurchaseLimitSubDo purchaseLimitDetail = this.iUmcPurchaseLimitModel.getPurchaseLimitDetail(configQryBo);
        if (!ObjectUtils.isEmpty((Object)purchaseLimitDetail)) {
            UmcPurchaseLimitBo limitBo = (UmcPurchaseLimitBo)JSONObject.parseObject((String)JSON.toJSONString((Object)purchaseLimitDetail), UmcPurchaseLimitBo.class);
            rspBO.setPurchaseLimitBo(limitBo);
        }
        this.translate(rspBO);
        return rspBO;
    }

    private void translate(UmcQyrCreditInfoDetailRspBO rspBO) {
        Map enterpriseTypeMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_CREDIT_ENTERPRISE_TYPE");
        Map typeMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_CREDIT_PARK_CLASSIFICATION");
        Map usageMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_CREDIT_WATER_ELECTRICITY_USAGE");
        Map paymentTimeMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_CREDIT_PAYMENT_TIME");
        Map accountPeriodMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_CREDIT_ACCOUNT_PERIOD");
        Map paymentMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_CREDIT_PAYMENT_METHOD");
        Map guarantorMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_CREDIT_IS_GUARANTOR");
        Map affiliateMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_CREDIT_IS_AFFILIATE");
        Map orderMethodMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_CREDIT_ORDER_METHOD");
        Map priceMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_CREDIT_PRODUCT_PRICE");
        if (!ObjectUtils.isEmpty((Object)rspBO)) {
            if (!ObjectUtils.isEmpty((Object)rspBO.getUmcCreditCustomerBo())) {
                if (!MapUtils.isEmpty((Map)enterpriseTypeMap)) {
                    rspBO.getUmcCreditCustomerBo().setEnterpriseTypeStr((String)enterpriseTypeMap.get(rspBO.getUmcCreditCustomerBo().getEnterpriseType()));
                }
                if (!MapUtils.isEmpty((Map)typeMap)) {
                    rspBO.getUmcCreditCustomerBo().setParkClassificationStr((String)typeMap.get(rspBO.getUmcCreditCustomerBo().getParkClassification()));
                }
                if (!MapUtils.isEmpty((Map)usageMap)) {
                    rspBO.getUmcCreditCustomerBo().setWaterElectricityUsageStr((String)typeMap.get(rspBO.getUmcCreditCustomerBo().getWaterElectricityUsage()));
                }
            }
            if (!ObjectUtils.isEmpty((Object)rspBO.getUmcCreditAccountPeriodBo()) && !MapUtils.isEmpty((Map)paymentTimeMap)) {
                rspBO.getUmcCreditAccountPeriodBo().setPaymentMethodStr((String)paymentMap.get(rspBO.getUmcCreditAccountPeriodBo().getPaymentMethod()));
            }
            if (!ObjectUtils.isEmpty((Object)rspBO.getUmcCreditContractBo())) {
                if (!MapUtils.isEmpty((Map)paymentTimeMap)) {
                    rspBO.getUmcCreditContractBo().setOrderMethodStr((String)orderMethodMap.get(rspBO.getUmcCreditContractBo().getOrderMethod()));
                }
                if (!MapUtils.isEmpty((Map)accountPeriodMap)) {
                    rspBO.getUmcCreditContractBo().setProductPriceStr((String)priceMap.get(rspBO.getUmcCreditContractBo().getProductPrice()));
                }
            }
            if (!ObjectUtils.isEmpty((Object)rspBO.getPurchaseLimitBo())) {
                if (!MapUtils.isEmpty((Map)paymentTimeMap)) {
                    rspBO.getPurchaseLimitBo().setExtField4Str((String)guarantorMap.get(rspBO.getPurchaseLimitBo().getExtField4()));
                }
                if (!MapUtils.isEmpty((Map)accountPeriodMap)) {
                    rspBO.getPurchaseLimitBo().setExtField5Str((String)affiliateMap.get(rspBO.getPurchaseLimitBo().getExtField5()));
                }
            }
        }
    }
}

