/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.creditApply;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.creditApply.UmcQryCreditApplyInfoModel;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditApprovalCallBackQryBo;
import com.tydic.dyc.umc.model.creditApply.sub.UmcCreditApprovalCallBackSubDo;
import com.tydic.dyc.umc.model.creditApply.sub.UmcCreditInfoApplySubDo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitDo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitAmountQryBo;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitConfigQryBo;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitAmountSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitHisSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitSubDo;
import com.tydic.dyc.umc.service.creditApply.UmcCreditApprovalCallBackService;
import com.tydic.dyc.umc.service.creditApply.bo.UmcCreditApprovalCallBackReqBO;
import com.tydic.dyc.umc.service.creditApply.bo.UmcCreditApprovalCallBackRspBO;
import com.tydic.dyc.umc.utils.IdUtil;
import java.math.BigDecimal;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.creditApply.UmcCreditApprovalCallBackService"})
public class UmcCreditApprovalCallBackServiceImpl
implements UmcCreditApprovalCallBackService {
    @Autowired
    private UmcQryCreditApplyInfoModel umcQryCreditApplyInfoModel;
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;

    @PostMapping(value={"saveApprovalCallBack"})
    public UmcCreditApprovalCallBackRspBO saveApprovalCallBack(@RequestBody UmcCreditApprovalCallBackReqBO reqBO) {
        UmcCreditApprovalCallBackSubDo subDo;
        this.validate(reqBO);
        UmcCreditApprovalCallBackQryBo qryBo = (UmcCreditApprovalCallBackQryBo)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), UmcCreditApprovalCallBackQryBo.class));
        switch (reqBO.getApproval()) {
            case 1: {
                subDo = this.umcQryCreditApplyInfoModel.approvalCallBack(qryBo);
                this.migratePurchaseLimitsToConfiguration(reqBO);
                break;
            }
            case 2: {
                subDo = this.umcQryCreditApplyInfoModel.approvalCallBackReject(qryBo);
                break;
            }
            default: {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[approval]\u4e0d\u5408\u6cd5");
            }
        }
        return (UmcCreditApprovalCallBackRspBO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)subDo)), UmcCreditApprovalCallBackRspBO.class);
    }

    private void migratePurchaseLimitsToConfiguration(UmcCreditApprovalCallBackReqBO reqBO) {
        UmcCreditInfoApplySubDo subDo = this.umcQryCreditApplyInfoModel.qryCreditApply(reqBO.getApplyId());
        if (ObjectUtils.isEmpty((Object)subDo)) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u7533\u8bf7\u4fe1\u606f");
        }
        UmcPurchaseLimitQryBo configQryBo = new UmcPurchaseLimitQryBo();
        configQryBo.setLimitObjId(subDo.getOrgId().toString());
        configQryBo.setExtField1("1");
        UmcPurchaseLimitSubDo rspDo = this.iUmcPurchaseLimitModel.getPurchaseLimitDetail(configQryBo);
        if (rspDo == null) {
            throw new BaseBusinessException("100001", "\u9650\u989d\u6570\u636e\u4e0d\u5b58\u5728");
        }
        IUmcPurchaseLimitDo reqDo = new IUmcPurchaseLimitDo();
        reqDo.setLimitConfigId(rspDo.getLimitConfigId());
        reqDo.setExtField3(subDo.getCommitmentLetter());
        reqDo.setLimitAmount(subDo.getCreditLimit());
        reqDo.setContractCreditLimit(subDo.getCreditLimit());
        reqDo.setUpdateOperName(reqBO.getName());
        reqDo.setUpdateOperId(reqBO.getUserId());
        reqDo.setUpdateTime(new Date());
        reqDo.setLimitStatus("1");
        UmcPurchaseLimitConfigQryBo configQryBoWhere = new UmcPurchaseLimitConfigQryBo();
        configQryBoWhere.setLimitConfigId(rspDo.getLimitConfigId());
        this.iUmcPurchaseLimitModel.updatePurchaseLimitConfig(reqDo, configQryBoWhere);
        UmcPurchaseLimitAmountSubDo amountSubDo = this.buildAmountDo(reqDo);
        UmcPurchaseLimitAmountQryBo amountQryBo = new UmcPurchaseLimitAmountQryBo();
        amountQryBo.setValId(rspDo.getValId());
        this.iUmcPurchaseLimitModel.updatePurchaseLimitAmount(amountSubDo, amountQryBo);
        UmcPurchaseLimitHisSubDo hisSubDo = this.buildHisDo(amountSubDo, rspDo);
        hisSubDo.setValId(amountQryBo.getValId());
    }

    private UmcPurchaseLimitHisSubDo buildHisDo(UmcPurchaseLimitAmountSubDo reqDo, UmcPurchaseLimitSubDo rspDo) {
        UmcPurchaseLimitHisSubDo hisSubDo = new UmcPurchaseLimitHisSubDo();
        hisSubDo.setChngType("create");
        hisSubDo.setValId(rspDo.getValId());
        hisSubDo.setLimitConfigId(rspDo.getLimitConfigId());
        hisSubDo.setLimitYear(rspDo.getLimitYear());
        hisSubDo.setChngRemark("\u521b\u5efa\u6388\u4fe1\u989d\u5ea6");
        BigDecimal beforMoney = rspDo.getLimitAmount().subtract(rspDo.getPurchaseAmount());
        BigDecimal afterMoney = reqDo.getLimitAmount().subtract(rspDo.getPurchaseAmount());
        hisSubDo.setPurchaseAmountBefore(beforMoney);
        hisSubDo.setChngPurchaseAmount(afterMoney.subtract(beforMoney));
        hisSubDo.setPurchaseAmountAfter(afterMoney);
        hisSubDo.setCreateOperId(reqDo.getCreateOperId());
        hisSubDo.setCreateOperName(reqDo.getCreateOperName());
        hisSubDo.setCreateTime(reqDo.getCreateTime());
        hisSubDo.setHisId(IdUtil.nextId());
        return hisSubDo;
    }

    private UmcPurchaseLimitAmountSubDo buildAmountDo(IUmcPurchaseLimitDo reqDo) {
        UmcPurchaseLimitAmountSubDo amountSubDo = new UmcPurchaseLimitAmountSubDo();
        amountSubDo.setLimitAmount(reqDo.getLimitAmount());
        amountSubDo.setUpdateOperId(reqDo.getUpdateOperId());
        amountSubDo.setUpdateOperName(reqDo.getUpdateOperName());
        amountSubDo.setUpdateTime(reqDo.getUpdateTime());
        amountSubDo.setCreateOperId(reqDo.getCreateOperId());
        amountSubDo.setCreateOperName(reqDo.getCreateOperName());
        return amountSubDo;
    }

    private void validate(UmcCreditApprovalCallBackReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getApplyId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[applyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getApproval())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[approval]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

