/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseBank;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseContact;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseExtMap;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseInvoice;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgTagRel;
import com.tydic.dyc.umc.model.ldOrganization.IUmcLdOrganizationInfoModel;
import com.tydic.dyc.umc.model.ldOrganization.sub.UmcEnterpriseOrgInfo;
import com.tydic.dyc.umc.service.enterprise.UmcEnterpriseIAccountInfoAddService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseInfoAddReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseInfoAddRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcBusinessException;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enterprise.UmcEnterpriseIAccountInfoAddService"})
public class UmcEnterpriseIAccountInfoAddServiceImpl
implements UmcEnterpriseIAccountInfoAddService {
    private static final Logger log = LoggerFactory.getLogger(UmcEnterpriseIAccountInfoAddServiceImpl.class);
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    @Autowired
    private IUmcLdOrganizationInfoModel iUmcLdOrganizationInfoModel;

    @PostMapping(value={"createEnterpriseAccountInfo"})
    public UmcEnterpriseInfoAddRspBo createEnterpriseAccountInfo(@RequestBody UmcEnterpriseInfoAddReqBo reqBo) {
        this.validateParams(reqBo);
        UmcEnterpriseInfoAddRspBo rspBo = (UmcEnterpriseInfoAddRspBo)UmcRu.success(UmcEnterpriseInfoAddRspBo.class);
        UmcOrgInfo orgInfo = this.buileOrgInfo(reqBo);
        orgInfo = this.iUmcEnterpriseInfoModel.createOrgInfo(orgInfo);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getEnterpriseInvoiceBoList())) {
            List enterpriseInvoiceList = UmcRu.jsl((List)reqBo.getEnterpriseInvoiceBoList(), UmcEnterpriseInvoice.class);
            for (UmcEnterpriseInvoice enterpriseInvoice : enterpriseInvoiceList) {
                enterpriseInvoice.setOrgId(orgInfo.getOrgId());
                enterpriseInvoice.setDelFlag("0");
                enterpriseInvoice.setCreateTime(new Date());
                enterpriseInvoice.setUpdateTime(enterpriseInvoice.getCreateTime());
                if (null != enterpriseInvoice.getInvoiceId()) continue;
                enterpriseInvoice.setInvoiceId(Long.valueOf(IdUtil.nextId()));
            }
            UmcEnterpriseInfoDo batchInvoice = new UmcEnterpriseInfoDo();
            batchInvoice.setEnterpriseInvoiceList(enterpriseInvoiceList);
            this.iUmcEnterpriseInfoModel.createEnterpriseInvoice((UmcEnterpriseInfoDo)StrUtil.noNullStringAttr((Object)batchInvoice));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getEnterpriseBankBoList())) {
            List enterpriseBankList = UmcRu.jsl((List)reqBo.getEnterpriseBankBoList(), UmcEnterpriseBank.class);
            for (UmcEnterpriseBank enterpriseBank : enterpriseBankList) {
                enterpriseBank.setOrgId(orgInfo.getOrgId());
                enterpriseBank.setDelFlag("0");
                enterpriseBank.setCreateTime(new Date());
                enterpriseBank.setUpdateTime(enterpriseBank.getCreateTime());
                if (null == enterpriseBank.getBankId()) {
                    enterpriseBank.setBankId(Long.valueOf(IdUtil.nextId()));
                }
                StrUtil.noNullStringAttr((Object)enterpriseBank);
            }
            UmcEnterpriseInfoDo batchBankInfo = new UmcEnterpriseInfoDo();
            batchBankInfo.setEnterpriseBankList(enterpriseBankList);
            this.iUmcEnterpriseInfoModel.createEnterpriseBank(batchBankInfo);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getEnterpriseContactBoList())) {
            List enterpriseContactList = UmcRu.jsl((List)reqBo.getEnterpriseContactBoList(), UmcEnterpriseContact.class);
            for (UmcEnterpriseContact enterpriseContact : enterpriseContactList) {
                enterpriseContact.setOrgId(orgInfo.getOrgId());
                enterpriseContact.setDelFlag("0");
                enterpriseContact.setCreateTime(new Date());
                enterpriseContact.setUpdateTime(enterpriseContact.getCreateTime());
                if (null == enterpriseContact.getContactId()) {
                    enterpriseContact.setContactId(Long.valueOf(IdUtil.nextId()));
                }
                StrUtil.noNullStringAttr((Object)enterpriseContact);
            }
            UmcEnterpriseInfoDo batchContact = new UmcEnterpriseInfoDo();
            batchContact.setEnterpriseContactList(enterpriseContactList);
            this.iUmcEnterpriseInfoModel.createEnterpriseContact(batchContact);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getEnterpriseExt())) {
            List enterpriseExtMapList = UmcRu.jsl((List)reqBo.getEnterpriseExt(), UmcEnterpriseExtMap.class);
            for (UmcEnterpriseExtMap enterpriseExtMap : enterpriseExtMapList) {
                if (null == enterpriseExtMap.getExtId()) {
                    enterpriseExtMap.setExtId(Long.valueOf(IdUtil.nextId()));
                }
                enterpriseExtMap.setTenantId(orgInfo.getTenantId());
                enterpriseExtMap.setOrgId(orgInfo.getOrgId());
                Date date = new Date();
                enterpriseExtMap.setCreateTime(date);
                enterpriseExtMap.setUpdateTime(date);
                enterpriseExtMap.setDelFlag("0");
                StrUtil.noNullStringAttr((Object)enterpriseExtMap);
            }
            UmcEnterpriseInfoDo extMapList = new UmcEnterpriseInfoDo();
            extMapList.setEnterpriseExt(enterpriseExtMapList);
            this.iUmcEnterpriseInfoModel.createEnterpriseExtMap(extMapList);
        }
        UmcEnterpriseInfoDo umcEnterpriseInfoDo = (UmcEnterpriseInfoDo)UmcRu.js((Object)reqBo, UmcEnterpriseInfoDo.class);
        umcEnterpriseInfoDo.setOrgId(orgInfo.getOrgId());
        umcEnterpriseInfoDo.setCreateTime(new Date());
        umcEnterpriseInfoDo.setUpdateTime(umcEnterpriseInfoDo.getCreateTime());
        StrUtil.noNullStringAttr((Object)umcEnterpriseInfoDo);
        this.iUmcEnterpriseInfoModel.createEnterpriseInfo((UmcEnterpriseInfoDo)StrUtil.noNullStringAttr((Object)umcEnterpriseInfoDo));
        UmcEnterpriseOrgInfo umcEnterpriseOrgInfo = new UmcEnterpriseOrgInfo();
        umcEnterpriseOrgInfo.setOrgId(orgInfo.getOrgId());
        umcEnterpriseOrgInfo.setOrgName(orgInfo.getOrgName());
        try {
            this.iUmcLdOrganizationInfoModel.insertEnterpriseAccount(umcEnterpriseOrgInfo);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u9ed8\u8ba4\u8d26\u5957\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new UmcBusinessException("8888", "\u65b0\u589e\u9ed8\u8ba4\u8d26\u5957\u5931\u8d25!");
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private UmcOrgInfo buileOrgInfo(UmcEnterpriseInfoAddReqBo reqBo) {
        UmcOrgInfo umcEnterpriseOrg = (UmcOrgInfo)UmcRu.js((Object)reqBo.getOrgInfoBo(), UmcOrgInfo.class);
        if (null == umcEnterpriseOrg.getOrgId()) {
            umcEnterpriseOrg.setOrgId(Long.valueOf(IdUtil.nextId()));
        }
        umcEnterpriseOrg.setOrgStatus("1");
        umcEnterpriseOrg.setCreateTime(new Date());
        umcEnterpriseOrg.setUpdateTime(umcEnterpriseOrg.getCreateTime());
        umcEnterpriseOrg.setDelFlag("0");
        if (!CollectionUtils.isEmpty((Collection)umcEnterpriseOrg.getOrgTagRelList())) {
            for (UmcOrgTagRel orgTagRel : umcEnterpriseOrg.getOrgTagRelList()) {
                if (null == orgTagRel.getRelId()) {
                    orgTagRel.setRelId(Long.valueOf(IdUtil.nextId()));
                }
                orgTagRel.setDelFlag("0");
            }
        }
        return umcEnterpriseOrg;
    }

    private void validateParams(UmcEnterpriseInfoAddReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u521b\u5efa \u5165\u53c2\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrgInfoBo())) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u521b\u5efa \u5165\u53c2[enterpriseOrgBo]\u4e3a\u7a7a\uff01");
        }
    }
}

