/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.umc.model.enterprise.LdUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcSupplierInfoQryBo;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.service.enterprise.UmcQryShopSupplierInfoListService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcParkProvinceInfoBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryShopSupplierInfoListReqBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryShopSupplierInfoListRspBO;
import com.tydic.dyc.umc.service.supplierSignAccess.bo.UmcOrgProductCategoryRelBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enterprise.UmcQryShopSupplierInfoListService"})
public class UmcQryShopSupplierInfoListServiceImpl
implements UmcQryShopSupplierInfoListService {
    private static final Logger log = LoggerFactory.getLogger(UmcQryShopSupplierInfoListServiceImpl.class);
    @Autowired
    private LdUmcEnterpriseInfoModel ldUmcEnterpriseInfoModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;

    @PostMapping(value={"qryShopSupplierInfoList"})
    public UmcQryShopSupplierInfoListRspBO qryShopSupplierInfoList(@RequestBody UmcQryShopSupplierInfoListReqBO reqBO) {
        UmcQryShopSupplierInfoListRspBO rspBo = (UmcQryShopSupplierInfoListRspBO)UmcRu.success(UmcQryShopSupplierInfoListRspBO.class);
        UmcSupplierInfoQryBo umcSupplierInfoQryBo = (UmcSupplierInfoQryBo)((Object)UmcRu.js((Object)reqBO, UmcSupplierInfoQryBo.class));
        umcSupplierInfoQryBo.setPageNo(-1);
        umcSupplierInfoQryBo.setPageSize(-1);
        BasePageRspBo<UmcSupplierInfoQryBo> shopSupplierInfoList = this.ldUmcEnterpriseInfoModel.qryShopSupplierInfoList(umcSupplierInfoQryBo);
        if (!CollectionUtils.isEmpty((Collection)shopSupplierInfoList.getRows())) {
            ArrayList<UmcParkProvinceInfoBo> umcParkProvinceInfoBos = new ArrayList<UmcParkProvinceInfoBo>();
            Map<String, List<UmcSupplierInfoQryBo>> provinceIdMap = shopSupplierInfoList.getRows().stream().filter(x -> StringUtils.isNotBlank((String)x.getProvinceId())).collect(Collectors.groupingBy(UmcSupplierInfoQryBo::getProvinceId));
            for (String province : provinceIdMap.keySet()) {
                List<UmcSupplierInfoQryBo> umcSupplierInfoQryBos = provinceIdMap.get(province);
                if (CollectionUtils.isEmpty(umcSupplierInfoQryBos)) continue;
                UmcParkProvinceInfoBo umcParkProvinceInfoBo = new UmcParkProvinceInfoBo();
                umcParkProvinceInfoBo.setProvinceId(umcSupplierInfoQryBos.get(0).getProvinceId());
                umcParkProvinceInfoBo.setProvinceName(((UmcSupplierInfoQryBo)((Object)umcSupplierInfoQryBos.get(0))).getProvinceName());
                umcParkProvinceInfoBos.add(umcParkProvinceInfoBo);
            }
            ArrayList<UmcOrgProductCategoryRelBo> umcOrgProductCategoryRelBos = new ArrayList<UmcOrgProductCategoryRelBo>();
            Map<Long, List<UmcSupplierInfoQryBo>> categoryIdMap = shopSupplierInfoList.getRows().stream().filter(x -> x.getCategoryId() != null).collect(Collectors.groupingBy(UmcSupplierInfoQryBo::getCategoryId));
            for (Long categoryId : categoryIdMap.keySet()) {
                List<UmcSupplierInfoQryBo> umcSupplierInfoQryBos = categoryIdMap.get(categoryId);
                if (CollectionUtils.isEmpty(umcSupplierInfoQryBos)) continue;
                UmcOrgProductCategoryRelBo umcOrgProductCategoryRelBo = new UmcOrgProductCategoryRelBo();
                umcOrgProductCategoryRelBo.setCategoryId(umcSupplierInfoQryBos.get(0).getCategoryId());
                umcOrgProductCategoryRelBo.setCategoryName(umcSupplierInfoQryBos.get(0).getCategoryName());
                umcOrgProductCategoryRelBos.add(umcOrgProductCategoryRelBo);
            }
            Set orgIds = shopSupplierInfoList.getRows().stream().map(UmcSupplierInfoQryBo::getOrgId).filter(Objects::nonNull).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(orgIds)) {
                rspBo.setOrgIds(new ArrayList(orgIds));
            }
            rspBo.setUmcParkProvinceInfoBos(umcParkProvinceInfoBos);
            rspBo.setUmcOrgProductCategoryRelBos(umcOrgProductCategoryRelBos);
        }
        return rspBo;
    }
}

