/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.umc.model.enterprise.LdUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcSupplierInfoQryBo;
import com.tydic.dyc.umc.model.orgProductCategoryRel.IUmcOrgProductCategoryRelModel;
import com.tydic.dyc.umc.model.orgProductCategoryRel.qrybo.UmcOrgProductCategoryRelQryBo;
import com.tydic.dyc.umc.model.orgProductCategoryRel.sub.UmcOrgProductCategoryRelSubDo;
import com.tydic.dyc.umc.model.supplierSignAccess.IUmcSupplierSignAccessModel;
import com.tydic.dyc.umc.model.supplierSignAccess.qrybo.UmcSignSalesCategoryInfoQrybo;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.service.enterprise.UmcSupplierQueryBusinessService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgProductCategoryBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcSupplierInfoBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcSupplierQueryBusinessReqBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcSupplierQueryBusinessRspBO;
import com.tydic.dyc.umc.service.signcontract.bo.SignSalesCategoryBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enterprise.UmcSupplierQueryBusinessService"})
public class UmcSupplierQueryBusinessServiceImpl
implements UmcSupplierQueryBusinessService {
    private static final Logger log = LoggerFactory.getLogger(UmcSupplierQueryBusinessServiceImpl.class);
    @Autowired
    private LdUmcEnterpriseInfoModel ldUmcEnterpriseInfoModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;
    @Autowired
    private IUmcSupplierSignAccessModel iUmcSupplierSignAccessModel;
    @Autowired
    private IUmcOrgProductCategoryRelModel iUmcOrgProductCategoryRelModel;

    @PostMapping(value={"queryBusinessScoreList"})
    public UmcSupplierQueryBusinessRspBO queryBusinessScoreList(@RequestBody UmcSupplierQueryBusinessReqBO reqBO) {
        UmcSupplierQueryBusinessRspBO rspBo = (UmcSupplierQueryBusinessRspBO)UmcRu.success(UmcSupplierQueryBusinessRspBO.class);
        BasePageRspBo<UmcSupplierInfoQryBo> queryBusinessScoreList = this.getUmcSupplierInfoQryBoBasePageRspBo(reqBO);
        if (queryBusinessScoreList.getRows() == null || queryBusinessScoreList.getRows().size() < 1) {
            rspBo.setPageNo(0);
            rspBo.setRecordsTotal(0);
            rspBo.setTotal(0);
            return rspBo;
        }
        ArrayList<UmcSupplierInfoBo> rows = new ArrayList<UmcSupplierInfoBo>();
        Map<Long, List<UmcSignSalesCategoryInfoQrybo>> umcSignSalesCategoryInfoMap = this.getSignSalesCategoryInfoMap(reqBO);
        Set<Long> signSalesCategoryOrgIds = umcSignSalesCategoryInfoMap.keySet();
        Map<Long, List<UmcOrgProductCategoryRelSubDo>> umcOrgProductCategoryMap = this.getUmcOrgProductCategoryMap(reqBO);
        Set<Long> productCategoryOrgIds = umcOrgProductCategoryMap.keySet();
        Map belongRegionMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "umc_region")).getMap();
        for (UmcSupplierInfoQryBo each : queryBusinessScoreList.getRows()) {
            List<UmcOrgProductCategoryRelSubDo> umcOrgProductCategoryRelSubDos;
            List<UmcSignSalesCategoryInfoQrybo> umcSignSalesCategoryInfoQrybos;
            UmcSupplierInfoBo js = (UmcSupplierInfoBo)UmcRu.js((Object)((Object)each), UmcSupplierInfoBo.class);
            if (StringUtils.isNotBlank((String)each.getBelongRegion())) {
                js.setBelongRegionStr((String)belongRegionMap.get(each.getBelongRegion()));
            }
            if (StringUtils.isNotBlank((String)each.getProvinceName())) {
                String belongCityStr = each.getProvinceName();
                if (StringUtils.isNotBlank((String)each.getCityName())) {
                    belongCityStr = belongCityStr + "/" + each.getCityName();
                }
                js.setBelongCityStr(belongCityStr);
            }
            if (!CollectionUtils.isEmpty(signSalesCategoryOrgIds) && signSalesCategoryOrgIds.contains(each.getOrgId()) && !CollectionUtils.isEmpty(umcSignSalesCategoryInfoQrybos = umcSignSalesCategoryInfoMap.get(each.getOrgId()))) {
                List signSalesCategoryBos = UmcRu.jsl(umcSignSalesCategoryInfoQrybos, SignSalesCategoryBo.class);
                js.setSignSalesCategoryBos(signSalesCategoryBos);
            }
            if (!CollectionUtils.isEmpty(productCategoryOrgIds) && productCategoryOrgIds.contains(each.getOrgId()) && !CollectionUtils.isEmpty(umcOrgProductCategoryRelSubDos = umcOrgProductCategoryMap.get(each.getOrgId()))) {
                List umcOrgProductCategoryBos = UmcRu.jsl(umcOrgProductCategoryRelSubDos, UmcOrgProductCategoryBo.class);
                js.setUmcOrgProductCategoryBos(umcOrgProductCategoryBos);
            }
            rows.add(js);
        }
        rspBo.setRows(rows);
        rspBo.setPageNo(queryBusinessScoreList.getPageNo());
        rspBo.setTotal(queryBusinessScoreList.getTotal());
        rspBo.setRecordsTotal(queryBusinessScoreList.getRecordsTotal());
        return rspBo;
    }

    private Map<Long, List<UmcOrgProductCategoryRelSubDo>> getUmcOrgProductCategoryMap(UmcSupplierQueryBusinessReqBO reqBO) {
        Map<Long, List<UmcOrgProductCategoryRelSubDo>> umcOrgProductCategoryMap = new HashMap<Long, List<UmcOrgProductCategoryRelSubDo>>();
        UmcOrgProductCategoryRelQryBo qryBo = new UmcOrgProductCategoryRelQryBo();
        qryBo.setOrgIds(reqBO.getOrgIds());
        qryBo.setPageNo(-1);
        qryBo.setPageSize(-1);
        BasePageRspBo<UmcOrgProductCategoryRelSubDo> umcOrgProductCategoryRelSubDoBasePageRspBo = this.iUmcOrgProductCategoryRelModel.qryOrgProductCategoryRelList(qryBo);
        if (!CollectionUtils.isEmpty((Collection)umcOrgProductCategoryRelSubDoBasePageRspBo.getRows())) {
            umcOrgProductCategoryMap = umcOrgProductCategoryRelSubDoBasePageRspBo.getRows().stream().collect(Collectors.groupingBy(UmcOrgProductCategoryRelSubDo::getOrgId));
        }
        return umcOrgProductCategoryMap;
    }

    private BasePageRspBo<UmcSupplierInfoQryBo> getUmcSupplierInfoQryBoBasePageRspBo(UmcSupplierQueryBusinessReqBO reqBO) {
        UmcSupplierInfoQryBo umcSupplierInfoQryBo = (UmcSupplierInfoQryBo)((Object)UmcRu.js((Object)reqBO, UmcSupplierInfoQryBo.class));
        umcSupplierInfoQryBo.setPageNo(-1);
        umcSupplierInfoQryBo.setPageSize(-1);
        return this.ldUmcEnterpriseInfoModel.queryBusinessScoreList(umcSupplierInfoQryBo);
    }

    private Map<Long, List<UmcSignSalesCategoryInfoQrybo>> getSignSalesCategoryInfoMap(UmcSupplierQueryBusinessReqBO reqBO) {
        Map<Long, List<UmcSignSalesCategoryInfoQrybo>> umcSignSalesCategoryInfoMap = new HashMap<Long, List<UmcSignSalesCategoryInfoQrybo>>();
        UmcSignSalesCategoryInfoQrybo qryBo = new UmcSignSalesCategoryInfoQrybo();
        qryBo.setOrgIds(reqBO.getOrgIds());
        qryBo.setPageNo(-1);
        qryBo.setPageSize(-1);
        BasePageRspBo<UmcSignSalesCategoryInfoQrybo> signSalesCategoryListPage = this.iUmcSupplierSignAccessModel.getSignItemByOrgListPage(qryBo);
        if (!CollectionUtils.isEmpty((Collection)signSalesCategoryListPage.getRows())) {
            umcSignSalesCategoryInfoMap = signSalesCategoryListPage.getRows().stream().collect(Collectors.groupingBy(UmcSignSalesCategoryInfoQrybo::getOrgId));
        }
        return umcSignSalesCategoryInfoMap;
    }
}

