/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.service.enterprise.UmcUpdateEnterpriseBaseInfoService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseInfoUpdateReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseInfoUpdateRspBo;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enterprise.UmcUpdateEnterpriseBaseInfoService"})
public class UmcUpdateEnterpriseBaseInfoServiceImpl
implements UmcUpdateEnterpriseBaseInfoService {
    private static final Logger log = LoggerFactory.getLogger(UmcUpdateEnterpriseBaseInfoServiceImpl.class);
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    @PostMapping(value={"updateEnterpriseInfo"})
    public UmcEnterpriseInfoUpdateRspBo updateEnterpriseInfo(@RequestBody UmcEnterpriseInfoUpdateReqBo reqBo) {
        UmcEnterpriseInfoUpdateRspBo rspBo = (UmcEnterpriseInfoUpdateRspBo)UmcRu.success(UmcEnterpriseInfoUpdateRspBo.class);
        this.validateParams(reqBo);
        UmcEnterpriseInfoDo setInfo = (UmcEnterpriseInfoDo)UmcRu.js((Object)reqBo, UmcEnterpriseInfoDo.class);
        StrUtil.noNullStringAttr((Object)setInfo);
        setInfo.setUpdateTime(new Date());
        setInfo.setOrgId(reqBo.getOrgId());
        try {
            this.iUmcEnterpriseInfoModel.updateEnterpriseInfo(setInfo);
        }
        catch (Exception e) {
            log.debug("\u4fee\u6539\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new BaseBusinessException("100001", "\u4fee\u6539\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
        }
        return rspBo;
    }

    private void validateParams(UmcEnterpriseInfoUpdateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u4fee\u6539 \u5165\u53c2\u4e3a\u7a7a\uff01");
        }
        if (null == reqBo.getOrgId()) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u4fee\u6539 \u5165\u53c2[orgId]\u4e3a\u7a7a\uff01");
        }
    }
}

