/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.ldOrganization;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.ldOrganization.IUmcLdOrganizationInfoModel;
import com.tydic.dyc.umc.model.ldOrganization.UmcLdOrganizationInfoQryDo;
import com.tydic.dyc.umc.model.ldOrganization.qrybo.UmcLdOrganizationInfoQryBo;
import com.tydic.dyc.umc.service.ldOrganization.UmcQryLdOrgInfoDetailService;
import com.tydic.dyc.umc.service.ldOrganization.bo.UmcLdOrgInfoDetailBO;
import com.tydic.dyc.umc.service.ldOrganization.bo.UmcQryLdOrgInfoDetailReqBO;
import com.tydic.dyc.umc.service.ldOrganization.bo.UmcQryLdOrgInfoDetailRspBO;
import com.tydic.dyc.umc.utils.UmcRu;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.ldOrganization.UmcQryLdOrgInfoDetailService"})
public class UmcQryLdOrgInfoDetailServiceImpl
implements UmcQryLdOrgInfoDetailService {
    private static final Logger log = LogManager.getLogger(UmcQryLdOrgInfoDetailServiceImpl.class);
    @Autowired
    private IUmcLdOrganizationInfoModel iUmcLdOrganizationInfoModel;

    @PostMapping(value={"qryLdOrgInfoDetail"})
    public UmcQryLdOrgInfoDetailRspBO qryLdOrgInfoDetail(@RequestBody UmcQryLdOrgInfoDetailReqBO reqBO) {
        UmcQryLdOrgInfoDetailRspBO rspBo = (UmcQryLdOrgInfoDetailRspBO)UmcRu.success(UmcQryLdOrgInfoDetailRspBO.class);
        this.validate(reqBO);
        UmcLdOrganizationInfoQryBo umcLdOrganizationInfoQryBo = new UmcLdOrganizationInfoQryBo();
        umcLdOrganizationInfoQryBo.setOrgDepId(reqBO.getOrgCodeWeb());
        umcLdOrganizationInfoQryBo.setOrgId(reqBO.getOrgIdWeb());
        umcLdOrganizationInfoQryBo.setPbNum(reqBO.getPbNum());
        UmcLdOrganizationInfoQryDo rspDo = this.iUmcLdOrganizationInfoModel.qryLdOrgInfoDetail(umcLdOrganizationInfoQryBo);
        UmcLdOrgInfoDetailBO limitBo = (UmcLdOrgInfoDetailBO)UmcRu.js((Object)rspDo, UmcLdOrgInfoDetailBO.class);
        rspBo.setUmcLdOrgInfoDetailBO(limitBo);
        return rspBo;
    }

    @PostMapping(value={"qryLdOrgInfoDetailByFullName"})
    public UmcQryLdOrgInfoDetailRspBO qryLdOrgInfoDetailByFullName(@RequestBody UmcQryLdOrgInfoDetailReqBO reqBO) {
        UmcQryLdOrgInfoDetailRspBO rspBo = (UmcQryLdOrgInfoDetailRspBO)UmcRu.success(UmcQryLdOrgInfoDetailRspBO.class);
        this.validateFullName(reqBO);
        UmcLdOrganizationInfoQryBo umcLdOrganizationInfoQryBo = new UmcLdOrganizationInfoQryBo();
        umcLdOrganizationInfoQryBo.setOrgNameFullPath(reqBO.getOrgNameFullPath());
        UmcLdOrganizationInfoQryDo rspDo = this.iUmcLdOrganizationInfoModel.qryLdOrgInfoDetail(umcLdOrganizationInfoQryBo);
        UmcLdOrgInfoDetailBO limitBo = (UmcLdOrgInfoDetailBO)UmcRu.js((Object)rspDo, UmcLdOrgInfoDetailBO.class);
        rspBo.setUmcLdOrgInfoDetailBO(limitBo);
        return rspBo;
    }

    private void validate(UmcQryLdOrgInfoDetailReqBO reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgCodeWeb() == null && reqBo.getOrgIdWeb() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u673a\u6784id\u6216\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateFullName(UmcQryLdOrgInfoDetailReqBO reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getOrgNameFullPath())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u7ec4\u7ec7\u540d\u79f0\u5168\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

