/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.purchaselimit;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitDo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitConfigQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitAmountConfigHisSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitAmountSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitHisSubDo;
import com.tydic.dyc.umc.service.purchaselimit.UmcCreatePurchaseLimitConfigService;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcCreatePurchaseLimitConfigReqBo;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcCreatePurchaseLimitConfigRspBo;
import com.tydic.dyc.umc.utils.DateUtil;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.purchaselimit.UmcCreatePurchaseLimitConfigService"})
public class UmcCreatePurchaseLimitConfigServiceImpl
implements UmcCreatePurchaseLimitConfigService {
    private static final Logger log = LoggerFactory.getLogger(UmcCreatePurchaseLimitConfigServiceImpl.class);
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;
    @Autowired
    private CacheClient cacheClient;

    @PostMapping(value={"createPurchaseLimitConfig"})
    public UmcCreatePurchaseLimitConfigRspBo createPurchaseLimitConfig(@RequestBody UmcCreatePurchaseLimitConfigReqBo reqBo) {
        UmcCreatePurchaseLimitConfigRspBo rspBo = (UmcCreatePurchaseLimitConfigRspBo)UmcRu.success(UmcCreatePurchaseLimitConfigRspBo.class);
        this.validateArg(reqBo);
        this.checkData(reqBo);
        IUmcPurchaseLimitDo reqDo = this.buildDoByBO(reqBo);
        this.iUmcPurchaseLimitModel.createPurchaseLimitConfig(reqDo);
        UmcPurchaseLimitAmountSubDo amountSubDo = this.buildAmountDo(reqDo);
        this.iUmcPurchaseLimitModel.createPurchaseLimitAmount(amountSubDo);
        UmcPurchaseLimitHisSubDo hisSubDo = this.buildHisDo(amountSubDo);
        this.iUmcPurchaseLimitModel.createPurchaseLimitHis(hisSubDo);
        UmcPurchaseLimitAmountConfigHisSubDo configHisSubDo = this.buildConfigHisDo(reqDo);
        this.iUmcPurchaseLimitModel.createPurchaseLimitConfigHis(configHisSubDo);
        String redisKey = "UMC_PURCHASE_LIMIT_" + reqBo.getLimitObjType() + "_" + reqBo.getLimitObjCode();
        this.cacheClient.delete(redisKey);
        Long currenNum = this.cacheClient.incrBy(redisKey, 0L);
        log.info("\u521b\u5efa\u91c7\u8d2d\u9650\u989dkey{},\u521d\u59cb\u5316\u9650\u989d{}", (Object)redisKey, (Object)currenNum);
        return rspBo;
    }

    private void checkData(UmcCreatePurchaseLimitConfigReqBo reqBo) {
        UmcPurchaseLimitConfigQryBo configQryBo = new UmcPurchaseLimitConfigQryBo();
        configQryBo.setLimitObjCode(reqBo.getLimitObjCode());
        configQryBo.setLimitObjType(reqBo.getLimitObjType());
        StrUtil.noNullStringAttr((Object)((Object)configQryBo));
        BasePageRspBo<IUmcPurchaseLimitDo> rspDo = this.iUmcPurchaseLimitModel.getPurchaseLimitConfigPageList(configQryBo);
        if (!CollectionUtils.isEmpty((Collection)rspDo.getRows())) {
            throw new BaseBusinessException("100001", "\u9650\u989d\u5df2\u7ecf\u5b58\u5728\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        }
    }

    private IUmcPurchaseLimitDo buildDoByBO(UmcCreatePurchaseLimitConfigReqBo reqBo) {
        IUmcPurchaseLimitDo reqDo = (IUmcPurchaseLimitDo)UmcRu.js((Object)reqBo, IUmcPurchaseLimitDo.class);
        reqDo.setLimitConfigId(IdUtil.nextId());
        return reqDo;
    }

    private UmcPurchaseLimitAmountSubDo buildAmountDo(IUmcPurchaseLimitDo reqDo) {
        UmcPurchaseLimitAmountSubDo amountSubDo = new UmcPurchaseLimitAmountSubDo();
        amountSubDo.setLimitConfigId(reqDo.getLimitConfigId());
        SimpleDateFormat year = new SimpleDateFormat("yyyy");
        Date date = new Date();
        amountSubDo.setLimitYear(year.format(date));
        amountSubDo.setLimitType(reqDo.getLimitType());
        amountSubDo.setIsAccumulation(reqDo.getIsAccumulation());
        amountSubDo.setAccumulationAmount(BigDecimal.ZERO);
        amountSubDo.setLimitAmount(reqDo.getLimitAmount());
        amountSubDo.setPurchaseAmount(BigDecimal.ZERO);
        if ("month".equals(reqDo.getLimitType())) {
            amountSubDo.setLimitEffTime(DateUtil.getCurrentMonthStartTime());
            amountSubDo.setLimitExpTime(DateUtil.getCurrentMonthEndTime());
        } else if ("season".equals(reqDo.getLimitType())) {
            amountSubDo.setLimitEffTime(DateUtil.getCurrentQuarterStartTime());
            amountSubDo.setLimitExpTime(DateUtil.getCurrentQuarterEndTime());
        } else if ("year".equals(reqDo.getLimitType())) {
            amountSubDo.setLimitEffTime(DateUtil.getCurrentYearStartTime());
            amountSubDo.setLimitExpTime(DateUtil.getCurrentYearEndTime());
        } else if ("once".equals(reqDo.getLimitType())) {
            amountSubDo.setLimitYear("0");
            amountSubDo.setLimitEffTime(DateUtil.getCurrentYearStartTime());
            Calendar cal = Calendar.getInstance();
            cal.setTime(DateUtil.getCurrentYearStartTime());
            cal.add(1, 50);
            amountSubDo.setLimitExpTime(cal.getTime());
        } else {
            throw new BaseBusinessException("100001", "\u65e0\u6548\u7684\u5165\u53c2\u91c7\u8d2d\u9650\u989d\u7c7b\u578b");
        }
        amountSubDo.setCreateOperId(reqDo.getCreateOperId());
        amountSubDo.setCreateOperName(reqDo.getCreateOperName());
        amountSubDo.setCreateTime(reqDo.getCreateTime());
        amountSubDo.setUpdateOperId(reqDo.getUpdateOperId());
        amountSubDo.setUpdateOperName(reqDo.getUpdateOperName());
        amountSubDo.setUpdateTime(reqDo.getUpdateTime());
        amountSubDo.setValId(IdUtil.nextId());
        amountSubDo.setLimitTemporary(reqDo.getLimitTemporary());
        return amountSubDo;
    }

    private UmcPurchaseLimitHisSubDo buildHisDo(UmcPurchaseLimitAmountSubDo reqDo) {
        UmcPurchaseLimitHisSubDo hisSubDo = new UmcPurchaseLimitHisSubDo();
        hisSubDo.setChngType("create");
        hisSubDo.setValId(reqDo.getValId());
        hisSubDo.setLimitConfigId(reqDo.getLimitConfigId());
        hisSubDo.setLimitYear(reqDo.getLimitYear());
        hisSubDo.setPurchaseAmountBefore(BigDecimal.ZERO);
        BigDecimal addLimitAmount = reqDo.getLimitAmount().add(reqDo.getLimitTemporary());
        hisSubDo.setChngPurchaseAmount(addLimitAmount);
        hisSubDo.setPurchaseAmountAfter(addLimitAmount);
        hisSubDo.setChngRemark("\u521b\u5efa\u91c7\u8d2d\u9650\u989d");
        hisSubDo.setCreateOperId(reqDo.getCreateOperId());
        hisSubDo.setCreateOperName(reqDo.getCreateOperName());
        hisSubDo.setCreateTime(reqDo.getCreateTime());
        hisSubDo.setHisId(IdUtil.nextId());
        return hisSubDo;
    }

    private UmcPurchaseLimitAmountConfigHisSubDo buildConfigHisDo(IUmcPurchaseLimitDo reqDo) {
        UmcPurchaseLimitAmountConfigHisSubDo configHisDo = (UmcPurchaseLimitAmountConfigHisSubDo)UmcRu.js((Object)reqDo, UmcPurchaseLimitAmountConfigHisSubDo.class);
        configHisDo.setLimitConfigHisId(IdUtil.nextId());
        configHisDo.setExtField1("\u521b\u5efa\u91c7\u8d2d\u9650\u989d");
        configHisDo.setLimitStatus("1");
        return configHisDo;
    }

    private void validateArg(UmcCreatePurchaseLimitConfigReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UmcCreatePurchaseLimitConfigReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

