/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.purchaselimit;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseInfoQryBo;
import com.tydic.dyc.umc.model.ldOrganization.IUmcLdOrganizationInfoModel;
import com.tydic.dyc.umc.model.ldOrganization.UmcLdOrganizationInfoQryDo;
import com.tydic.dyc.umc.model.ldOrganization.qrybo.UmcLdOrganizationInfoQryBo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcDepPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitSubDo;
import com.tydic.dyc.umc.service.purchaselimit.UmcGetPurchaseLimitCartDetailService;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcGetPurchaseLimitCartDetailReqBo;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcGetPurchaseLimitCartDetailRspBo;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcPurchaseLimitBo;
import com.tydic.dyc.umc.utils.MoneyUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.purchaselimit.UmcGetPurchaseLimitCartDetailService"})
public class UmcGetPurchaseLimitCartDetailServiceImpl
implements UmcGetPurchaseLimitCartDetailService {
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;
    @Autowired
    private IUmcLdOrganizationInfoModel iUmcLdOrganizationInfoModel;
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    @Autowired
    private CacheClient cacheClient;

    @PostMapping(value={"getPurchaseLimitDetail"})
    public UmcGetPurchaseLimitCartDetailRspBo getPurchaseLimitDetail(@RequestBody UmcGetPurchaseLimitCartDetailReqBo reqBo) {
        String redisKey;
        Long currenNum;
        UmcGetPurchaseLimitCartDetailRspBo rspBo = (UmcGetPurchaseLimitCartDetailRspBo)UmcRu.success(UmcGetPurchaseLimitCartDetailRspBo.class);
        this.validateArg(reqBo);
        UmcPurchaseLimitSubDo rspDo = new UmcPurchaseLimitSubDo();
        if (StringUtils.isNotBlank((CharSequence)reqBo.getProjectCode())) {
            UmcPurchaseLimitQryBo qryBo = new UmcPurchaseLimitQryBo();
            qryBo.setLimitObjCode(reqBo.getProjectCode());
            qryBo.setLimitObjType("P1");
            qryBo.setCurrentTime(new Date());
            StrUtil.noNullStringAttr((Object)((Object)qryBo));
            rspDo = this.iUmcPurchaseLimitModel.getPurchaseLimitDetail(qryBo);
        } else {
            if (reqBo.getOrgId() == null) {
                throw new BaseBusinessException("100001", "\u673a\u6784Id\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            UmcEnterpriseInfoQryBo umcEnterpriseInfoQryBo = new UmcEnterpriseInfoQryBo();
            umcEnterpriseInfoQryBo.setOrgId(reqBo.getOrgId());
            UmcEnterpriseInfoDo enterpriseInfo = this.iUmcEnterpriseInfoModel.getEnterpriseInfo(umcEnterpriseInfoQryBo);
            if (enterpriseInfo == null) {
                throw new BaseBusinessException("100001", "\u8be5\u673a\u6784\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u5df2\u7ecf\u88ab\u5220\u9664!");
            }
            if ("4".equals(enterpriseInfo.getOrgClass()) || "3".equals(enterpriseInfo.getOrgClass())) {
                UmcLdOrganizationInfoQryBo umcLdOrganizationInfoQryBo = new UmcLdOrganizationInfoQryBo();
                umcLdOrganizationInfoQryBo.setOrgId(reqBo.getOrgId());
                UmcLdOrganizationInfoQryDo umcLdOrganizationInfoQryDo = this.iUmcLdOrganizationInfoModel.qryLdOrgInfoDetail(umcLdOrganizationInfoQryBo);
                if (umcLdOrganizationInfoQryDo != null) {
                    String orgNoFullPath = umcLdOrganizationInfoQryDo.getOrgNoFullPath();
                    String[] split = orgNoFullPath.split("-");
                    UmcDepPurchaseLimitQryBo umcDepPurchaseLimitQryBo = new UmcDepPurchaseLimitQryBo();
                    umcDepPurchaseLimitQryBo.setLimitObjType("E1");
                    umcDepPurchaseLimitQryBo.setLimitObjCodes(Arrays.asList(split));
                    umcDepPurchaseLimitQryBo.setCurrentTime(new Date());
                    StrUtil.noNullStringAttr((Object)((Object)umcDepPurchaseLimitQryBo));
                    rspDo = this.iUmcPurchaseLimitModel.getDepPurchaseLimitDetail(umcDepPurchaseLimitQryBo);
                }
            } else {
                if (reqBo.getCompanyId() == null) {
                    throw new BaseBusinessException("100001", "\u516c\u53f8Id\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                UmcPurchaseLimitQryBo qryBo = new UmcPurchaseLimitQryBo();
                qryBo.setLimitObjId(reqBo.getCompanyId().toString());
                qryBo.setLimitObjType("EXT");
                qryBo.setCurrentTime(new Date());
                qryBo.setLimitStatus("1");
                StrUtil.noNullStringAttr((Object)((Object)qryBo));
                rspDo = this.iUmcPurchaseLimitModel.getPurchaseLimitDetail(qryBo);
            }
        }
        if (rspDo != null && (currenNum = this.cacheClient.incrBy(redisKey = "UMC_PURCHASE_LIMIT_" + rspDo.getLimitObjType() + "_" + rspDo.getLimitObjCode(), 0L)) == 0L) {
            this.cacheClient.incrBy(redisKey, MoneyUtil.bigDecimal2Long(rspDo.getPurchaseAmount()).longValue());
        }
        UmcPurchaseLimitBo limitBo = (UmcPurchaseLimitBo)UmcRu.js((Object)rspDo, UmcPurchaseLimitBo.class);
        rspBo.setPurchaseLimitBo(limitBo);
        return rspBo;
    }

    private void validateArg(UmcGetPurchaseLimitCartDetailReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UmcGetPurchaseLimitCartDetailReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

