/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.purchaselimit;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitSubDo;
import com.tydic.dyc.umc.service.costControl.bo.UmcOperateCostPurchaseLimitMqReqBo;
import com.tydic.dyc.umc.service.purchaselimit.UmcReleaseExtPurchaseLimitService;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcReleaseExtPurchaseLimitReqBO;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcReleaseExtPurchaseLimitRspBO;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.MoneyUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.purchaselimit.UmcReleaseExtPurchaseLimitService"})
public class UmcReleaseExtPurchaseLimitServiceImpl
implements UmcReleaseExtPurchaseLimitService {
    private static final Logger log = LoggerFactory.getLogger(UmcReleaseExtPurchaseLimitServiceImpl.class);
    private static final String TAKE_EFFECT = "0";
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${UMC_PURCHASE_LIMIT_MESSAGE_TOPIC:UMC_PURCHASE_LIMIT_MESSAGE_TOPIC}")
    private String umcCreateTopic;
    @Value(value="${UMC_ERP_MESSAGE_TAG:*}")
    private String umcCreateTag;
    @Resource(name="umcPurchaseLimitMessageProvider")
    private ProxyMessageProducer proxyMessageProducer;

    @PostMapping(value={"releaseExtPurchaseLimit"})
    public UmcReleaseExtPurchaseLimitRspBO releaseExtPurchaseLimit(@RequestBody UmcReleaseExtPurchaseLimitReqBO reqBO) {
        this.validateArg(reqBO);
        UmcReleaseExtPurchaseLimitRspBO rspBo = (UmcReleaseExtPurchaseLimitRspBO)UmcRu.success(UmcReleaseExtPurchaseLimitRspBO.class);
        UmcPurchaseLimitQryBo configQryBo = new UmcPurchaseLimitQryBo();
        configQryBo.setLimitConfigId(reqBO.getLimitConfigId());
        configQryBo.setDelFlag(TAKE_EFFECT);
        UmcPurchaseLimitSubDo rspDo = this.iUmcPurchaseLimitModel.getPurchaseLimitDetail(configQryBo);
        if (rspDo == null) {
            throw new BaseBusinessException("100001", "\u6ca1\u6709\u67e5\u8be2\u5230\u9650\u989d");
        }
        if (!"EXT".equals(rspDo.getLimitObjType())) {
            throw new BaseBusinessException("100001", "\u4e0d\u662f\u5916\u90e8\u7684\u9650\u989d\u8bbe\u7f6e\uff0c\u4e0d\u5141\u8bb8\u91ca\u653e\u989d\u5ea6");
        }
        if (rspDo.getPurchaseAmount() == null || reqBO.getReleaseLimitAmount().compareTo(rspDo.getPurchaseAmount()) > 0) {
            throw new BaseBusinessException("100001", "\u672c\u6b21\u91ca\u653e\u91d1\u989d\u4e0d\u53ef\u8d85\u8fc7\u5df2\u91c7\u8d2d\u91d1\u989d\u6570\u91cf");
        }
        String redisKey = "UMC_PURCHASE_LIMIT_" + rspDo.getLimitObjType() + "_" + rspDo.getLimitObjCode();
        Long currenNum = this.cacheClient.incrBy(redisKey, 0L);
        if (currenNum == 0L) {
            this.cacheClient.incrBy(redisKey, MoneyUtil.bigDecimal2Long(rspDo.getPurchaseAmount()).longValue());
        }
        this.cacheClient.incrBy(redisKey, -MoneyUtil.bigDecimal2Long(reqBO.getReleaseLimitAmount()).longValue());
        UmcOperateCostPurchaseLimitMqReqBo limitMqReqBo = new UmcOperateCostPurchaseLimitMqReqBo();
        limitMqReqBo.setOperateType("releaseExtLimit");
        limitMqReqBo.setPurchaseValId(rspDo.getValId());
        limitMqReqBo.setPurchaseAmount(reqBO.getReleaseLimitAmount().negate());
        limitMqReqBo.setOperateName(reqBO.getName());
        limitMqReqBo.setOperateId(reqBO.getUserId());
        limitMqReqBo.setUniKey(Long.valueOf(IdUtil.nextId()));
        log.info("\u53d1\u6d88\u606f\u66f4\u65b0\u6210\u672c\u548c\u91c7\u8d2d\u4fe1\u606f\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)limitMqReqBo));
        ProxyMessage proxyMessage = new ProxyMessage(this.umcCreateTopic, this.umcCreateTag, JSON.toJSONString((Object)limitMqReqBo));
        ProxySendResult result = this.proxyMessageProducer.send(proxyMessage);
        log.info("\u53d1\u6d88\u606f\u66f4\u65b0\u6210\u672c\u548c\u91c7\u8d2d\u4fe1\u606f\u5b8c\u6210\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)result));
        return rspBo;
    }

    public void validateArg(UmcReleaseExtPurchaseLimitReqBO reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getLimitConfigId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9650\u989d\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getReleaseLimitAmount() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u672c\u6b21\u91ca\u653e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getReleaseLimitAmount().compareTo(BigDecimal.ZERO) <= 0) {
            throw new BaseBusinessException("100001", "\u9700\u8981\u91ca\u653e\u7684\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u6216\u7b49\u4e8e0");
        }
    }
}

