/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.register;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseOrgQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseOrgQryRspBo;
import com.tydic.dyc.umc.model.enterpriseapply.IUmcEnterpriseInfoApplyModel;
import com.tydic.dyc.umc.model.enterpriseapply.LdIUmcEnterpriseInfoApplyModel;
import com.tydic.dyc.umc.model.enterpriseapply.UmcEnterpriseInfoApplyDo;
import com.tydic.dyc.umc.model.enterpriseapply.qrybo.LdUmcEnterpriseInfoApplyQryBo;
import com.tydic.dyc.umc.model.enterpriseapply.qrybo.UmcEnterpriseInfoApplyQryBo;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcEnterpriseInfoApplyListRspBo;
import com.tydic.dyc.umc.service.register.bo.UmcCheckUserOrEnterpriseRegisterReqBo;
import com.tydic.dyc.umc.service.register.bo.UmcCheckUserOrEnterpriseRegisterRspBo;
import com.tydic.dyc.umc.service.register.service.UmcCheckUserOrEnterpriseRegisterService;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.register.service.UmcCheckUserOrEnterpriseRegisterService"})
public class UmcCheckUserOrEnterpriseRegisterServiceImpl
implements UmcCheckUserOrEnterpriseRegisterService {
    public static final String OPER_TYPE_REGISTER = "1";
    public static final String OPER_TYPE_REGISTER_FILL = "2";
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    @Autowired
    private IUmcEnterpriseInfoApplyModel iUmcEnterpriseInfoApplyModel;
    @Autowired
    private LdIUmcEnterpriseInfoApplyModel ldIUmcEnterpriseInfoApplyModel;

    @PostMapping(value={"checkUserOrEnterpriseRegister"})
    public UmcCheckUserOrEnterpriseRegisterRspBo checkUserOrEnterpriseRegister(@RequestBody UmcCheckUserOrEnterpriseRegisterReqBo reqBo) {
        UmcCheckUserOrEnterpriseRegisterRspBo rspBo = (UmcCheckUserOrEnterpriseRegisterRspBo)UmcRu.success(UmcCheckUserOrEnterpriseRegisterRspBo.class);
        String checkRegister = "";
        this.validate(reqBo);
        UmcEnterpriseOrgQryBo existReqBo = new UmcEnterpriseOrgQryBo();
        existReqBo.setCreditNo(reqBo.getOrgCertificateCode());
        existReqBo.setOrderBy("uoi.create_time desc limit 1");
        UmcEnterpriseOrgQryRspBo umcEnterpriseOrgQryRspBo = this.iUmcEnterpriseInfoModel.getEnterpriseOrgList(existReqBo);
        if (umcEnterpriseOrgQryRspBo != null && !CollectionUtils.isEmpty((Collection)umcEnterpriseOrgQryRspBo.getRows())) {
            UmcEnterpriseInfoApplyQryBo enterpriseInfoBo = new UmcEnterpriseInfoApplyQryBo();
            enterpriseInfoBo.setOrgId(((UmcEnterpriseInfoDo)umcEnterpriseOrgQryRspBo.getRows().get(0)).getOrgId());
            enterpriseInfoBo.setApplyType(String.valueOf(UmcCommConstant.OBJ_BUSI_TYPE.ENTERPRISE_BASIC_INFO));
            enterpriseInfoBo.setExtField5(OPER_TYPE_REGISTER);
            enterpriseInfoBo.setOrderBy("create_time desc limit 1");
            enterpriseInfoBo.setApplyStatus(OPER_TYPE_REGISTER);
            UmcEnterpriseInfoApplyListRspBo umcEnterpriseInfoApplyListRspBo = this.iUmcEnterpriseInfoApplyModel.getEnterpriseInfoApplyList(enterpriseInfoBo);
            if (CollectionUtils.isEmpty((Collection)umcEnterpriseInfoApplyListRspBo.getRows())) {
                checkRegister = OPER_TYPE_REGISTER_FILL.equals(reqBo.getOperType()) ? "3" : OPER_TYPE_REGISTER;
            } else {
                checkRegister = OPER_TYPE_REGISTER_FILL;
                rspBo.setOrgId(((UmcEnterpriseInfoApplyDo)umcEnterpriseInfoApplyListRspBo.getRows().get(0)).getOrgId());
            }
        } else {
            LdUmcEnterpriseInfoApplyQryBo enterpriseInfoBo = new LdUmcEnterpriseInfoApplyQryBo();
            enterpriseInfoBo.setCreditNo(reqBo.getOrgCertificateCode());
            enterpriseInfoBo.setApplyType(String.valueOf(UmcCommConstant.OBJ_BUSI_TYPE.ENTERPRISE_BASIC_INFO));
            enterpriseInfoBo.setExtField5(OPER_TYPE_REGISTER);
            if (OPER_TYPE_REGISTER_FILL.equals(reqBo.getOperType())) {
                enterpriseInfoBo.setNoApplyId(reqBo.getNoApplyId());
            }
            enterpriseInfoBo.setNoApplyStatus(OPER_TYPE_REGISTER);
            int enterpriseApplyCheckBy = this.ldIUmcEnterpriseInfoApplyModel.getEnterpriseApplyCheckBy(enterpriseInfoBo);
            checkRegister = enterpriseApplyCheckBy > 0 ? OPER_TYPE_REGISTER : "3";
        }
        rspBo.setCheckRegister(checkRegister);
        return rspBo;
    }

    private void validate(UmcCheckUserOrEnterpriseRegisterReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOrgCertificateCode())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2[\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOperType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2[\u64cd\u4f5c\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

