/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.register;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseInfoQryBo;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.qrybo.UmcCustInfoQryBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import com.tydic.dyc.umc.model.user.sub.UmcCustInfo;
import com.tydic.dyc.umc.service.enterpriseapply.UmcEnterpriseInfoApplyAddService;
import com.tydic.dyc.umc.service.enterpriseapply.UmcEnterpriseInfoApplyUpdateService;
import com.tydic.dyc.umc.service.enterpriseapply.UmcQryEnterpriseInfoApplyDetailService;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcEnterpriseContactApplyBo;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcEnterpriseInfoApplyAddReqBo;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcEnterpriseInfoApplyAddRspBo;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcEnterpriseInfoApplyUpdateReqBo;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcEnterpriseInfoApplyUpdateRspBo;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcOrgInfoApplyBo;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcOrgTagRelApplyBo;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcQryEnterpriseInfoApplyDetailReqBo;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcQryEnterpriseInfoApplyDetailRspBo;
import com.tydic.dyc.umc.service.register.bo.UmcApprovalOfCustomerReqBo;
import com.tydic.dyc.umc.service.register.bo.UmcApprovalOfCustomerRspBo;
import com.tydic.dyc.umc.service.register.bo.UmcUserPersonalAuthenticationReqBo;
import com.tydic.dyc.umc.service.register.bo.UmcUserPersonalAuthenticationRspBo;
import com.tydic.dyc.umc.service.register.service.UmcApprovalOfCustomerService;
import com.tydic.dyc.umc.service.register.service.UmcUserPersonalAuthenticationService;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.register.service.UmcUserPersonalAuthenticationService"})
public class UmcUserPersonalAuthenticationServiceImpl
implements UmcUserPersonalAuthenticationService {
    private static final Logger log = LoggerFactory.getLogger(UmcUserPersonalAuthenticationServiceImpl.class);
    public static final String OPER_TYPE = "1";
    public static final String UPDATE_OPER_NAME = "\u7cfb\u7edf";
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    public static final String CHECK_REGISTER = "2";
    public static final String USER_SOURCE = "1";
    private static final Long DEFAULT_TANENT_ID = 10000L;
    @Autowired
    private UmcEnterpriseInfoApplyAddService umcEnterpriseInfoApplyAddService;
    @Autowired
    private UmcApprovalOfCustomerService umcApprovalOfCustomerService;
    @Autowired
    private UmcEnterpriseInfoApplyUpdateService umcEnterpriseInfoApplyUpdateService;
    @Autowired
    private IUmcUserInfoModel iUmcUserInfoModel;
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;
    public static final String IS_MAIN = "1";
    @Value(value="${register_default_parent_org:305775845729763332}")
    private Long REGISTER_DEFAULT_PARENT_ORG;
    public static final String REGEX = ",";
    @Autowired
    private UmcQryEnterpriseInfoApplyDetailService umcQryEnterpriseInfoApplyDetailService;

    @PostMapping(value={"savePersonalAuth"})
    public UmcUserPersonalAuthenticationRspBo savePersonalAuth(@RequestBody UmcUserPersonalAuthenticationReqBo reqBo) {
        UmcUserPersonalAuthenticationRspBo rspBo = (UmcUserPersonalAuthenticationRspBo)UmcRu.success(UmcUserPersonalAuthenticationRspBo.class);
        this.checkInitReq(reqBo);
        this.checkUserInfoReq(reqBo);
        Long applyId = reqBo.getApplyId();
        Long orgId = reqBo.getOrgIdIn();
        UmcOrgInfoApplyBo umcOrgInfoApplyBo = new UmcOrgInfoApplyBo();
        umcOrgInfoApplyBo = "1".equals(reqBo.getOperType()) ? this.createEnterpriseInfoApply(reqBo, applyId, orgId) : this.updateEnterpriseInfoApplyInfo(reqBo, applyId, orgId);
        if (!reqBo.getRegisterAuditFlag().booleanValue()) {
            UmcQryEnterpriseInfoApplyDetailReqBo detailReqBo = new UmcQryEnterpriseInfoApplyDetailReqBo();
            detailReqBo.setApplyId(applyId);
            log.debug("\u4f01\u4e1a\u7533\u8bf7\u4fe1\u606f\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)detailReqBo));
            UmcQryEnterpriseInfoApplyDetailRspBo umcQryEnterpriseInfoApplyDetailRspBo = this.umcQryEnterpriseInfoApplyDetailService.qryEnterpriseInfoApplyDetail(detailReqBo);
            log.debug("\u4f01\u4e1a\u7533\u8bf7\u4fe1\u606f\u67e5\u8be2\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)umcQryEnterpriseInfoApplyDetailRspBo));
            UmcApprovalOfCustomerReqBo umcApprovalOfCustomerReqBo = new UmcApprovalOfCustomerReqBo();
            umcApprovalOfCustomerReqBo.setUmcQryEnterpriseInfoApplyDetailRspBo(umcQryEnterpriseInfoApplyDetailRspBo);
            UmcApprovalOfCustomerRspBo umcApprovalOfCustomerRspBo = this.umcApprovalOfCustomerService.saveApprovalOfCustomer(umcApprovalOfCustomerReqBo);
            if (!"0000".equals(umcApprovalOfCustomerRspBo.getRespCode())) {
                throw new ZTBusinessException("\u89d2\u8272\u6743\u9650\u5904\u7406\u5931\u8d25");
            }
        }
        rspBo.setUmcOrgInfoApplyBo(umcOrgInfoApplyBo);
        return rspBo;
    }

    private UmcOrgInfoApplyBo updateEnterpriseInfoApplyInfo(UmcUserPersonalAuthenticationReqBo reqBo, Long applyId, Long orgId) {
        UmcEnterpriseInfoApplyUpdateRspBo enterpriseInfoApply;
        UmcEnterpriseInfoApplyUpdateReqBo updateReqBo = new UmcEnterpriseInfoApplyUpdateReqBo();
        UmcOrgInfoApplyBo umcOrgInfoBo = this.makeUmcOrgInfoApplyBo(reqBo, orgId, applyId);
        updateReqBo.setOrgId(orgId);
        updateReqBo.setTenantId(umcOrgInfoBo.getTenantId());
        updateReqBo.setTelephone(reqBo.getRegMobileIn());
        updateReqBo.setLegalPerson(reqBo.getName());
        updateReqBo.setOrgCertificateCode(reqBo.getOrgCertificateCode());
        updateReqBo.setCreditNo(reqBo.getOrgCertificateCode());
        if (!CollectionUtils.isEmpty((Collection)reqBo.getBusinessLicense())) {
            updateReqBo.setBusinessLicense(JSON.toJSONString((Object)reqBo.getBusinessLicense()));
        }
        updateReqBo.setOrgInfoApplyBo(umcOrgInfoBo);
        updateReqBo.setCreateOperId(reqBo.getUserId());
        updateReqBo.setCreateOperName(reqBo.getName());
        updateReqBo.setCreateTime(new Date());
        updateReqBo.setExtField1("1");
        List<UmcEnterpriseContactApplyBo> umcEnterpriseContactBos = UmcUserPersonalAuthenticationServiceImpl.markUmcEnterpriseContactApplyBos(reqBo, orgId, umcOrgInfoBo);
        updateReqBo.setEnterpriseContactApplyBoList(umcEnterpriseContactBos);
        if (!reqBo.getRegisterAuditFlag().booleanValue()) {
            updateReqBo.setApplyStatus("1");
        } else {
            updateReqBo.setApplyStatus("0");
        }
        updateReqBo.setApplyId(applyId);
        updateReqBo.setApplyType(UmcCommConstant.OBJ_BUSI_TYPE.ENTERPRISE_BASIC_INFO.toString());
        updateReqBo.setSupplierManageId(reqBo.getUserIdIn().toString());
        updateReqBo.setExtField5(reqBo.getCheckRegister());
        updateReqBo.setExtField7(CHECK_REGISTER);
        if (CHECK_REGISTER.equals(reqBo.getCheckRegister()) && reqBo.getOrgIdWeb() != null) {
            UmcEnterpriseInfoDo umcEnterpriseInfoDo = this.getUmcEnterpriseInfoDo(reqBo);
            updateReqBo.setExtField2(umcEnterpriseInfoDo.getExtField2());
            updateReqBo.setExtField3(umcEnterpriseInfoDo.getExtField3());
            updateReqBo.setExtField4(umcEnterpriseInfoDo.getExtField4());
            updateReqBo.setIndustry(umcEnterpriseInfoDo.getIndustry());
        }
        if (!reqBo.getRegisterAuditFlag().booleanValue()) {
            updateReqBo.setUpdateOperId(Long.valueOf(0L));
            updateReqBo.setUpdateOperName(UPDATE_OPER_NAME);
            updateReqBo.setUpdateTime(new Date());
        }
        if (!"0000".equals((enterpriseInfoApply = this.umcEnterpriseInfoApplyUpdateService.updateEnterpriseInfoApply(updateReqBo)).getRespCode())) {
            throw new ZTBusinessException("\u91cd\u65b0\u8ba4\u8bc1\u5931\u8d25");
        }
        return umcOrgInfoBo;
    }

    private void checkUserInfoReq(UmcUserPersonalAuthenticationReqBo reqBo) {
        UmcUserInfoQryBo userInfoQryBo = new UmcUserInfoQryBo();
        userInfoQryBo.setUserId(reqBo.getUserId());
        UmcUserInfoDo userInfoDo = this.iUmcUserInfoModel.getUserInfo(userInfoQryBo);
        if (null == userInfoDo) {
            throw new BaseBusinessException("201014", "\u7528\u6237\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a");
        }
        UmcCustInfoQryBo custInfoQryBo = new UmcCustInfoQryBo();
        custInfoQryBo.setCustId(userInfoDo.getCustId());
        UmcCustInfo custInfo = this.iUmcUserInfoModel.getCustInfo(custInfoQryBo);
        if (null == custInfo) {
            throw new BaseBusinessException("201014", "\u5ba2\u6237\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a");
        }
    }

    public UmcOrgInfoApplyBo createEnterpriseInfoApply(UmcUserPersonalAuthenticationReqBo reqBo, Long applyId, Long orgId) {
        UmcEnterpriseInfoApplyAddRspBo enterpriseInfoApply;
        UmcEnterpriseInfoApplyAddReqBo addReqBo = new UmcEnterpriseInfoApplyAddReqBo();
        UmcOrgInfoApplyBo umcOrgInfoBo = this.makeUmcOrgInfoApplyBo(reqBo, orgId, applyId);
        addReqBo.setOrgId(orgId);
        addReqBo.setTenantId(umcOrgInfoBo.getTenantId());
        addReqBo.setTelephone(reqBo.getRegMobileIn());
        addReqBo.setLegalPerson(reqBo.getName());
        addReqBo.setOrgCertificateCode(reqBo.getOrgCertificateCode());
        addReqBo.setCreditNo(reqBo.getOrgCertificateCode());
        if (!CollectionUtils.isEmpty((Collection)reqBo.getBusinessLicense())) {
            addReqBo.setBusinessLicense(JSON.toJSONString((Object)reqBo.getBusinessLicense()));
        }
        addReqBo.setOrgInfoApplyBo(umcOrgInfoBo);
        addReqBo.setCreateOperId(reqBo.getUserId());
        addReqBo.setCreateOperName(reqBo.getName());
        addReqBo.setCreateTime(new Date());
        addReqBo.setOrgClass(CHECK_REGISTER);
        addReqBo.setExtField1("1");
        List<UmcEnterpriseContactApplyBo> umcEnterpriseContactBos = UmcUserPersonalAuthenticationServiceImpl.markUmcEnterpriseContactApplyBos(reqBo, orgId, umcOrgInfoBo);
        addReqBo.setEnterpriseContactApplyBoList(umcEnterpriseContactBos);
        if (!reqBo.getRegisterAuditFlag().booleanValue()) {
            addReqBo.setApplyStatus("1");
        } else {
            addReqBo.setApplyStatus("0");
        }
        addReqBo.setApplyId(applyId);
        addReqBo.setApplyType(UmcCommConstant.OBJ_BUSI_TYPE.ENTERPRISE_BASIC_INFO.toString());
        addReqBo.setSupplierManageId(reqBo.getUserIdIn().toString());
        addReqBo.setIsMerchant("1");
        addReqBo.setExtField5(reqBo.getCheckRegister());
        addReqBo.setExtField7(CHECK_REGISTER);
        if (!reqBo.getRegisterAuditFlag().booleanValue()) {
            addReqBo.setUpdateOperId(Long.valueOf(0L));
            addReqBo.setUpdateOperName(UPDATE_OPER_NAME);
            addReqBo.setUpdateTime(new Date());
        }
        if (CHECK_REGISTER.equals(reqBo.getCheckRegister()) && reqBo.getOrgIdWeb() != null) {
            UmcEnterpriseInfoDo umcEnterpriseInfoDo = this.getUmcEnterpriseInfoDo(reqBo);
            addReqBo.setExtField2(umcEnterpriseInfoDo.getExtField2());
            addReqBo.setExtField3(umcEnterpriseInfoDo.getExtField3());
            addReqBo.setExtField4(umcEnterpriseInfoDo.getExtField4());
            addReqBo.setIndustry(umcEnterpriseInfoDo.getIndustry());
        }
        if (!"0000".equals((enterpriseInfoApply = this.umcEnterpriseInfoApplyAddService.createEnterpriseInfoApply(addReqBo)).getRespCode())) {
            throw new ZTBusinessException("\u8ba4\u8bc1\u5931\u8d25");
        }
        return umcOrgInfoBo;
    }

    private static List<UmcEnterpriseContactApplyBo> markUmcEnterpriseContactApplyBos(UmcUserPersonalAuthenticationReqBo reqBo, Long orgId, UmcOrgInfoApplyBo umcOrgInfoBo) {
        ArrayList<UmcEnterpriseContactApplyBo> umcEnterpriseContactBos = new ArrayList<UmcEnterpriseContactApplyBo>();
        UmcEnterpriseContactApplyBo umcEnterpriseContactBo = new UmcEnterpriseContactApplyBo();
        umcEnterpriseContactBo.setContactName(reqBo.getMemName2());
        if ("1".equals(reqBo.getOperType())) {
            umcEnterpriseContactBo.setContactId(Long.valueOf(IdUtil.nextId()));
        } else {
            if (reqBo.getEnterpriseContactId() == null) {
                throw new BaseBusinessException("201014", "\u4f01\u4e1a\u8054\u7cfb\u4ebaid\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
            }
            umcEnterpriseContactBo.setContactId(reqBo.getEnterpriseContactId());
        }
        umcEnterpriseContactBo.setPhoneNumber(reqBo.getRegMobileIn());
        umcEnterpriseContactBo.setOrgId(orgId);
        umcEnterpriseContactBo.setTenantId(umcOrgInfoBo.getTenantId());
        umcEnterpriseContactBo.setCreateOperId(reqBo.getUserId());
        umcEnterpriseContactBo.setCreateOperName(reqBo.getUsername());
        umcEnterpriseContactBo.setCreateTime(new Date());
        umcEnterpriseContactBo.setExtField1("1");
        umcEnterpriseContactBo.setApplyId(umcOrgInfoBo.getApplyId());
        umcEnterpriseContactBo.setDelFlag("0");
        umcEnterpriseContactBos.add(umcEnterpriseContactBo);
        return umcEnterpriseContactBos;
    }

    private UmcOrgInfoApplyBo makeUmcOrgInfoApplyBo(UmcUserPersonalAuthenticationReqBo reqBo, Long orgId, Long applyId) {
        SysOrgInfoDo parentOrgDo = this.getSysOrgInfoDo();
        UmcOrgInfoApplyBo umcOrgInfoBo = new UmcOrgInfoApplyBo();
        umcOrgInfoBo.setOrgId(orgId);
        umcOrgInfoBo.setTenantId(DEFAULT_TANENT_ID);
        umcOrgInfoBo.setParentId(parentOrgDo.getOrgId());
        umcOrgInfoBo.setExtField1("1");
        umcOrgInfoBo.setOrgTreePath(parentOrgDo.getOrgTreePath() + orgId + "-");
        umcOrgInfoBo.setOrgType(Long.valueOf(2L));
        umcOrgInfoBo.setCompanyId(orgId);
        umcOrgInfoBo.setDeep(Integer.valueOf(parentOrgDo.getDeep() + 1));
        umcOrgInfoBo.setOrgName(reqBo.getOrgNameWeb());
        umcOrgInfoBo.setIsVirtual("1");
        umcOrgInfoBo.setOrgStatus("1");
        umcOrgInfoBo.setCreateOperId(reqBo.getUserId());
        umcOrgInfoBo.setCreateOperName(reqBo.getName());
        umcOrgInfoBo.setCreateTime(new Date());
        umcOrgInfoBo.setEffTime(new Date());
        umcOrgInfoBo.setApplyId(applyId);
        ArrayList<UmcOrgTagRelApplyBo> orgTagRelApplyBos = new ArrayList<UmcOrgTagRelApplyBo>();
        for (String tag : reqBo.getTradeCapacity().split(REGEX)) {
            UmcOrgTagRelApplyBo umcOrgTagRelBo = new UmcOrgTagRelApplyBo();
            umcOrgTagRelBo.setTagStatus("1");
            umcOrgTagRelBo.setOrgId(orgId);
            umcOrgTagRelBo.setTenantId(DEFAULT_TANENT_ID);
            umcOrgTagRelBo.setTagId(tag);
            umcOrgTagRelBo.setCreateOperId(reqBo.getUserId());
            umcOrgTagRelBo.setCreateOperName(reqBo.getName());
            umcOrgTagRelBo.setCreateTime(new Date());
            umcOrgTagRelBo.setEffTime(new Date());
            umcOrgTagRelBo.setApplyId(applyId);
            umcOrgTagRelBo.setDelFlag("0");
            orgTagRelApplyBos.add(umcOrgTagRelBo);
        }
        umcOrgInfoBo.setOrgTagRelApplyBoList(orgTagRelApplyBos);
        return umcOrgInfoBo;
    }

    private SysOrgInfoDo getSysOrgInfoDo() {
        SysOrgInfoQryBo parentQryBo = new SysOrgInfoQryBo();
        parentQryBo.setOrgId(this.REGISTER_DEFAULT_PARENT_ORG);
        SysOrgInfoDo parentOrgDo = this.iSysOrgInfoModel.getOrgInfoDetails(parentQryBo);
        if (parentOrgDo == null) {
            throw new BaseBusinessException("200001", "\u9ed8\u8ba4\u7236\u673a\u6784\u67e5\u8be2\u5931\u8d25");
        }
        return parentOrgDo;
    }

    private UmcEnterpriseInfoDo getUmcEnterpriseInfoDo(UmcUserPersonalAuthenticationReqBo reqBo) {
        UmcEnterpriseInfoQryBo umcEnterpriseOrgQryBo = new UmcEnterpriseInfoQryBo();
        umcEnterpriseOrgQryBo.setOrgId(reqBo.getOrgIdWeb());
        UmcEnterpriseInfoDo enterpriseInfo = this.iUmcEnterpriseInfoModel.getEnterpriseInfo(umcEnterpriseOrgQryBo);
        if (enterpriseInfo == null) {
            throw new BaseBusinessException("100001", "\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
        return enterpriseInfo;
    }

    public void checkInitReq(UmcUserPersonalAuthenticationReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException("200001", "\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getApplyId()) {
            throw new BaseBusinessException("200001", "\u5ba1\u6279\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOperType())) {
            throw new BaseBusinessException("200001", "\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getCheckRegister())) {
            throw new BaseBusinessException("200001", "\u5224\u65ad\u662f\u5426\u9996\u6b21\u6ce8\u518c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOrgNameWeb())) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOrgCertificateCode())) {
            throw new BaseBusinessException("200001", "\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getTradeCapacity())) {
            throw new BaseBusinessException("200001", "\u8d38\u6613\u8eab\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

