/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.supplierSignAccess;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterpriseapply.UmcEnterpriseInfoApplyDo;
import com.tydic.dyc.umc.model.enterpriseapply.qrybo.UmcEnterpriseInfoApplyQryBo;
import com.tydic.dyc.umc.model.supplierSignAccess.IUmcSupplierSignAccessModel;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.service.supplierSignAccess.bo.UmcQrySupplierAccessSignListReqBo;
import com.tydic.dyc.umc.service.supplierSignAccess.bo.UmcQrySupplierAccessSignListRspBo;
import com.tydic.dyc.umc.service.supplierSignAccess.bo.UmcQrySupplierAccessSignPageBo;
import com.tydic.dyc.umc.service.supplierSignAccess.service.UmcQrySupplierAccessSignListService;
import com.tydic.dyc.umc.utils.UmcRu;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.supplierSignAccess.service.UmcQrySupplierAccessSignListService"})
public class UmcQrySupplierAccessSignListServiceImpl
implements UmcQrySupplierAccessSignListService {
    private static final Logger log = LoggerFactory.getLogger(UmcQrySupplierAccessSignListServiceImpl.class);
    @Autowired
    private IUmcSupplierSignAccessModel iUmcSupplierSignAccessModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;

    @PostMapping(value={"qrySupplierAccessList"})
    public UmcQrySupplierAccessSignListRspBo qrySupplierAccessList(@RequestBody UmcQrySupplierAccessSignListReqBo reqBo) {
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException("200100", "\u5165\u53c2\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        UmcQrySupplierAccessSignListRspBo rspBo = new UmcQrySupplierAccessSignListRspBo();
        ArrayList<UmcQrySupplierAccessSignPageBo> list = new ArrayList<UmcQrySupplierAccessSignPageBo>();
        UmcEnterpriseInfoApplyQryBo qryBo = new UmcEnterpriseInfoApplyQryBo();
        qryBo.setOrgName(reqBo.getSupplierName());
        qryBo.setAddress(reqBo.getAddress());
        qryBo.setCreateTimeStart(reqBo.getAccessSubmitStartTime());
        qryBo.setCreateTimeEnd(reqBo.getAccessSubmitEndTime());
        qryBo.setContactName(reqBo.getConsignerName());
        qryBo.setUserId(reqBo.getUserId());
        qryBo.setPageNo(reqBo.getPageNo());
        qryBo.setPageSize(reqBo.getPageSize());
        qryBo.setTabId(reqBo.getTabId());
        BasePageRspBo<UmcEnterpriseInfoApplyDo> accessList = this.iUmcSupplierSignAccessModel.qrySupplierAccessList(qryBo);
        if (CollectionUtils.isEmpty((Collection)accessList.getRows())) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBo;
        }
        rspBo = (UmcQrySupplierAccessSignListRspBo)UmcRu.js(accessList, UmcQrySupplierAccessSignListRspBo.class);
        Map supplierTypeMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "UMC_SUPPLIER_TYPE")).getMap();
        Map applyStatusMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "UMC_APPLY_STATUS")).getMap();
        for (UmcEnterpriseInfoApplyDo bo2 : accessList.getRows()) {
            UmcQrySupplierAccessSignPageBo accessPageBo = new UmcQrySupplierAccessSignPageBo();
            BeanUtils.copyProperties((Object)bo2, (Object)accessPageBo);
            accessPageBo.setSupplierId(bo2.getOrgId());
            accessPageBo.setSupplierName(bo2.getOrgName());
            accessPageBo.setConsignerName(bo2.getContactName());
            accessPageBo.setSupplierType(bo2.getSupplierType());
            if (supplierTypeMap != null && supplierTypeMap.containsKey(accessPageBo.getSupplierType())) {
                accessPageBo.setSupplierTypeStr((String)supplierTypeMap.get(accessPageBo.getSupplierType()));
            }
            try {
                accessPageBo.setAccessSubmitTime(sdf.parse(bo2.getSupplierAccessTime()));
            }
            catch (ParseException e) {
                log.error("\u5f02\u5e38", (Throwable)e);
                throw new BaseBusinessException("200100", e.getMessage());
            }
            accessPageBo.setAccessStatus(bo2.getApplyStatus());
            if (applyStatusMap != null && applyStatusMap.containsKey(bo2.getApplyStatus())) {
                accessPageBo.setAccessStatusStr((String)applyStatusMap.get(bo2.getApplyStatus()));
            }
            if ("1".equals(bo2.getAuditStatus())) {
                accessPageBo.setAuditStatusStr("\u901a\u8fc7");
            } else if ("0".equals(bo2.getAuditStatus())) {
                accessPageBo.setAuditStatusStr("\u9a73\u56de");
            } else {
                accessPageBo.setAuditStatus("2");
                accessPageBo.setAuditStatusStr("\u5ba1\u6279\u4e2d");
            }
            list.add(accessPageBo);
        }
        rspBo.setRows(list);
        return rspBo;
    }
}

