/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.model.parkInfo.impl;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.umc.model.parkInfo.IUmcParkInfoModel;
import com.tydic.dyc.umc.model.parkInfo.UmcEnterpriseLabelInfoDo;
import com.tydic.dyc.umc.model.parkInfo.bo.UmcPushParkInfoWmsBO;
import com.tydic.dyc.umc.model.parkInfo.impl.WmsParkInfoPushUtil;
import com.tydic.dyc.umc.model.parkInfo.qrybo.UmcEnterpriseLabelInfoQryBo;
import com.tydic.dyc.umc.model.parkInfo.qrybo.UmcParkInfoQryBo;
import com.tydic.dyc.umc.model.parkInfo.qrybo.UmcParkInfoVByOrgQryBo;
import com.tydic.dyc.umc.model.parkInfo.sub.UmcParkInfoByOrgSubBo;
import com.tydic.dyc.umc.model.parkInfo.sub.UmcParkInfoSubBo;
import com.tydic.dyc.umc.repository.UmcParkInfoRepository;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IUmcParkInfoModelImpl
implements IUmcParkInfoModel {
    @Autowired
    private UmcParkInfoRepository umcParkInfoRepository;
    @Autowired
    private WmsParkInfoPushUtil wmsParkInfoPushUtil;

    @Override
    public void createParkInfo(UmcParkInfoSubBo umcParkInfoSubBo) {
        this.umcParkInfoRepository.createParkInfo(umcParkInfoSubBo);
        UmcPushParkInfoWmsBO umcPushParkInfoWmsBO = new UmcPushParkInfoWmsBO();
        umcPushParkInfoWmsBO.setParkCode(umcParkInfoSubBo.getParkId().toString());
        umcPushParkInfoWmsBO.setParkName(umcParkInfoSubBo.getParkName());
        umcPushParkInfoWmsBO.setStatus(1);
        umcPushParkInfoWmsBO.setProvince(umcParkInfoSubBo.getProvinceName());
        umcPushParkInfoWmsBO.setCity(umcParkInfoSubBo.getCityName());
        umcPushParkInfoWmsBO.setContactName(umcParkInfoSubBo.getParkManager());
        this.wmsParkInfoPushUtil.pushParkInfo(Collections.singletonList(umcPushParkInfoWmsBO));
    }

    @Override
    public BasePageRspBo<UmcParkInfoSubBo> getParkInfoList(UmcParkInfoQryBo umcParkInfoQryBo) {
        return this.umcParkInfoRepository.getParkInfoList(umcParkInfoQryBo);
    }

    @Override
    public List<UmcParkInfoByOrgSubBo> getParkInfoListByOrgList(UmcParkInfoVByOrgQryBo umcParkInfoQryBo) {
        return this.umcParkInfoRepository.getParkInfoListByOrgList(umcParkInfoQryBo);
    }

    @Override
    public long qryParkInfoCount(UmcParkInfoQryBo umcParkInfoQryBo) {
        return this.umcParkInfoRepository.qryParkInfoCount(umcParkInfoQryBo);
    }

    @Override
    public void updateParkInfo(UmcParkInfoSubBo umcParkInfoSubBo) {
        this.umcParkInfoRepository.updateParkInfo(umcParkInfoSubBo);
        UmcPushParkInfoWmsBO umcPushParkInfoWmsBO = new UmcPushParkInfoWmsBO();
        umcPushParkInfoWmsBO.setParkCode(umcParkInfoSubBo.getParkId().toString());
        umcPushParkInfoWmsBO.setParkName(umcParkInfoSubBo.getParkName());
        umcPushParkInfoWmsBO.setStatus(1);
        umcPushParkInfoWmsBO.setProvince(umcParkInfoSubBo.getProvinceName());
        umcPushParkInfoWmsBO.setCity(umcParkInfoSubBo.getCityName());
        umcPushParkInfoWmsBO.setContactName(umcParkInfoSubBo.getParkManager());
        this.wmsParkInfoPushUtil.pushParkInfo(Collections.singletonList(umcPushParkInfoWmsBO));
    }

    @Override
    public List<UmcParkInfoSubBo> qryParkAndOrgCountInfo(UmcParkInfoQryBo umcParkInfoQryBo) {
        return this.umcParkInfoRepository.qryParkAndOrgCountInfo(umcParkInfoQryBo);
    }

    @Override
    public int deleteParkInfo(UmcParkInfoQryBo umcParkInfoQryBo) {
        int i = this.umcParkInfoRepository.deleteParkInfo(umcParkInfoQryBo);
        if (umcParkInfoQryBo.getParkIds() != null && umcParkInfoQryBo.getParkIds().size() > 0) {
            for (Long each : umcParkInfoQryBo.getParkIds()) {
                if (i <= 0) continue;
                UmcPushParkInfoWmsBO umcPushParkInfoWmsBO = new UmcPushParkInfoWmsBO();
                umcPushParkInfoWmsBO.setParkCode(each.toString());
                umcPushParkInfoWmsBO.setStatus(0);
                this.wmsParkInfoPushUtil.pushParkInfo(Collections.singletonList(umcPushParkInfoWmsBO));
            }
        }
        return i;
    }

    @Override
    public UmcParkInfoSubBo getParkInfoDetail(UmcParkInfoQryBo umcParkInfoQryBo) {
        return this.umcParkInfoRepository.getParkInfoDetail(umcParkInfoQryBo);
    }

    @Override
    public void createParkInfoBatch(List<UmcParkInfoSubBo> umcParkInfoSubBos) {
        this.umcParkInfoRepository.createParkInfoBatch(umcParkInfoSubBos);
        List<UmcPushParkInfoWmsBO> list = umcParkInfoSubBos.stream().map(info -> {
            UmcPushParkInfoWmsBO umcPushParkInfoWmsBO = new UmcPushParkInfoWmsBO();
            umcPushParkInfoWmsBO.setParkCode(info.getParkId().toString());
            umcPushParkInfoWmsBO.setParkName(info.getParkName());
            umcPushParkInfoWmsBO.setStatus(1);
            umcPushParkInfoWmsBO.setProvince(info.getProvinceName());
            umcPushParkInfoWmsBO.setCity(info.getCityName());
            umcPushParkInfoWmsBO.setContactName(info.getParkManager());
            return umcPushParkInfoWmsBO;
        }).collect(Collectors.toList());
        this.wmsParkInfoPushUtil.pushParkInfo(list);
    }

    @Override
    public BasePageRspBo<UmcEnterpriseLabelInfoDo> qryEnterpriseLabelInfoListPage(UmcEnterpriseLabelInfoQryBo umcEnterpriseLabelInfoQryBo) {
        return this.umcParkInfoRepository.qryEnterpriseLabelInfoListPage(umcEnterpriseLabelInfoQryBo);
    }
}

