/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.address;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.address.IUmcAddressInfoModel;
import com.tydic.dyc.umc.model.address.qrybo.UmcAddressAreaInfoQryBo;
import com.tydic.dyc.umc.model.address.qrybo.UmcAddressCityInfoQryBo;
import com.tydic.dyc.umc.model.address.qrybo.UmcAddressProvinceInfoQryBo;
import com.tydic.dyc.umc.model.address.qrybo.UmcAddressTownsInfoQryBo;
import com.tydic.dyc.umc.service.address.bo.ConvertAddressBo;
import com.tydic.dyc.umc.service.address.bo.ConvertAreaAddressBo;
import com.tydic.dyc.umc.service.address.bo.ConvertCityAddressBo;
import com.tydic.dyc.umc.service.address.bo.ConvertProvinceAddressBo;
import com.tydic.dyc.umc.service.address.bo.ConvertTownAddressBo;
import com.tydic.dyc.umc.service.address.bo.UmcConvertAddressInfoReqBo;
import com.tydic.dyc.umc.service.address.bo.UmcConvertAddressInfoRspBo;
import com.tydic.dyc.umc.service.address.service.UmcConvertAddressInfoService;
import com.tydic.dyc.umc.utils.JsonFormatTool;
import com.tydic.dyc.umc.utils.UmcRu;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.address.service.UmcConvertAddressInfoService"})
public class UmcConvertAddressInfoServiceImpl
implements UmcConvertAddressInfoService {
    private static final Logger log = LoggerFactory.getLogger(UmcConvertAddressInfoServiceImpl.class);
    private static final String PATH = "dyc-common/";
    @Autowired
    private IUmcAddressInfoModel iUmcAddressInfoModel;
    @Autowired
    private FileClient fileClient;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    @PostMapping(value={"convertAddressInfo"})
    public UmcConvertAddressInfoRspBo convertAddressInfo(@RequestBody UmcConvertAddressInfoReqBo reqBo) {
        UmcConvertAddressInfoRspBo rspBo = (UmcConvertAddressInfoRspBo)UmcRu.success(UmcConvertAddressInfoRspBo.class);
        UmcAddressProvinceInfoQryBo qryAddressProvinceInfoQryBo = new UmcAddressProvinceInfoQryBo();
        List<UmcAddressProvinceInfoQryBo> umcAddressProvinceInfoQryBos = this.iUmcAddressInfoModel.getProvinceInfoList(qryAddressProvinceInfoQryBo);
        UmcAddressCityInfoQryBo qryUmcAddressCityInfoQryBo = new UmcAddressCityInfoQryBo();
        List<UmcAddressCityInfoQryBo> umcAddressCityInfoQryBos = this.iUmcAddressInfoModel.getCityInfoList(qryUmcAddressCityInfoQryBo);
        Map<String, List<UmcAddressCityInfoQryBo>> umcAddressCityInfoMap = umcAddressCityInfoQryBos.stream().collect(Collectors.groupingBy(UmcAddressCityInfoQryBo::getProvinceCode));
        UmcAddressAreaInfoQryBo qryUmcAddressAreaInfoQryBo = new UmcAddressAreaInfoQryBo();
        List<UmcAddressAreaInfoQryBo> umcAddressAreaInfoQryBos = this.iUmcAddressInfoModel.getAreaInfoList(qryUmcAddressAreaInfoQryBo);
        Map<String, List<UmcAddressAreaInfoQryBo>> umcAddressAreaInfoMap = umcAddressAreaInfoQryBos.stream().collect(Collectors.groupingBy(UmcAddressAreaInfoQryBo::getCityCode));
        UmcAddressTownsInfoQryBo qryUmcAddressTownsInfoQryBo = new UmcAddressTownsInfoQryBo();
        List<UmcAddressTownsInfoQryBo> umcAddressTownsInfoQryBos = this.iUmcAddressInfoModel.getTownInfoList(qryUmcAddressTownsInfoQryBo);
        Map<String, List<UmcAddressTownsInfoQryBo>> umcAddressTownsInfoMap = umcAddressTownsInfoQryBos.stream().collect(Collectors.groupingBy(UmcAddressTownsInfoQryBo::getAreaCode));
        ConvertAddressBo convertAddressBo = new ConvertAddressBo();
        convertAddressBo.setCode(Integer.valueOf(0));
        ArrayList<ConvertProvinceAddressBo> convertProvinceAddressBos = new ArrayList<ConvertProvinceAddressBo>();
        for (UmcAddressProvinceInfoQryBo provinceInfoQryBo : umcAddressProvinceInfoQryBos) {
            ConvertProvinceAddressBo convertProvinceAddressBo = new ConvertProvinceAddressBo();
            convertProvinceAddressBo.setProvinceName(provinceInfoQryBo.getName());
            convertProvinceAddressBo.setProvinceCode(provinceInfoQryBo.getCode());
            ArrayList<ConvertCityAddressBo> convertCityAddressBos = new ArrayList<ConvertCityAddressBo>();
            if (umcAddressCityInfoMap != null && umcAddressCityInfoMap.containsKey(provinceInfoQryBo.getCode())) {
                List<UmcAddressCityInfoQryBo> umcAddressCityInfoList = umcAddressCityInfoMap.get(provinceInfoQryBo.getCode());
                for (UmcAddressCityInfoQryBo cityInfoQryBo : umcAddressCityInfoList) {
                    ConvertCityAddressBo convertCityAddressBo = new ConvertCityAddressBo();
                    convertCityAddressBo.setCityCode(cityInfoQryBo.getCode());
                    convertCityAddressBo.setCityName(cityInfoQryBo.getName());
                    if (umcAddressAreaInfoMap != null && umcAddressAreaInfoMap.containsKey(cityInfoQryBo.getCode())) {
                        ArrayList<ConvertAreaAddressBo> convertAreaAddressBos = new ArrayList<ConvertAreaAddressBo>();
                        List<UmcAddressAreaInfoQryBo> umcAddressAreaInfoList = umcAddressAreaInfoMap.get(cityInfoQryBo.getCode());
                        for (UmcAddressAreaInfoQryBo addressAreaInfoQryBo : umcAddressAreaInfoList) {
                            ConvertAreaAddressBo convertAreaAddressBo = new ConvertAreaAddressBo();
                            convertAreaAddressBo.setAreaCode(addressAreaInfoQryBo.getCode());
                            convertAreaAddressBo.setAreaName(addressAreaInfoQryBo.getName());
                            if (umcAddressTownsInfoMap != null && umcAddressTownsInfoMap.containsKey(addressAreaInfoQryBo.getCode())) {
                                List<UmcAddressTownsInfoQryBo> umcAddressTownsInfoList = umcAddressTownsInfoMap.get(addressAreaInfoQryBo.getCode());
                                ArrayList<ConvertTownAddressBo> convertTownAddressBos = new ArrayList<ConvertTownAddressBo>();
                                for (UmcAddressTownsInfoQryBo townsInfoQryBo : umcAddressTownsInfoList) {
                                    ConvertTownAddressBo convertTownAddressBo = new ConvertTownAddressBo();
                                    convertTownAddressBo.setTownCode(townsInfoQryBo.getCode());
                                    convertTownAddressBo.setTownName(townsInfoQryBo.getName());
                                    convertTownAddressBos.add(convertTownAddressBo);
                                }
                                convertAreaAddressBo.setTowns(convertTownAddressBos);
                            }
                            convertAreaAddressBos.add(convertAreaAddressBo);
                        }
                        convertCityAddressBo.setAreas(convertAreaAddressBos);
                    }
                    convertCityAddressBos.add(convertCityAddressBo);
                }
                convertProvinceAddressBo.setCitys(convertCityAddressBos);
            }
            convertProvinceAddressBos.add(convertProvinceAddressBo);
        }
        convertAddressBo.setData(convertProvinceAddressBos);
        String string = JSON.toJSONString((Object)convertAddressBo);
        log.debug("\u751f\u6210\u7684json\u4e3a\uff1a{}", (Object)string);
        String path = this.createJsonFile(string, "address.json");
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new BaseBusinessException("100001", "\u751f\u6210\u5730\u5740json\u6587\u4ef6\u5931\u8d25");
        }
        String fileUrl = null;
        String innerFileUrl = null;
        if ("OSS".equals(this.fileType)) {
            innerFileUrl = this.accessUrl + path;
            fileUrl = this.ossFileUrl + path;
        } else if ("FASTDFS".equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "address.json");
        map.put("url", fileUrl);
        map.put("innerUrl", innerFileUrl);
        rspBo.setMap(map);
        return rspBo;
    }

    public String createJsonFile(String jsonString, String fileName) {
        InputStream inputStream = null;
        String path = "";
        try {
            jsonString = JsonFormatTool.formatJson(jsonString);
            byte[] bytes = jsonString.getBytes();
            inputStream = new ByteArrayInputStream(bytes);
            path = this.fileClient.uploadFileByInputStream(PATH, fileName, inputStream);
        }
        catch (Exception e) {
            log.debug("\u751f\u6210\u5730\u5740json\u6587\u4ef6\u5931\u8d25{}", (Object)e.getMessage());
            throw new BaseBusinessException("100001", "\u751f\u6210\u5730\u5740json\u6587\u4ef6\u5931\u8d25");
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.debug("\u6587\u4ef6\u4e0a\u4f20\u5173\u95ed\u6d41\u5931\u8d25");
            }
        }
        return path;
    }
}

