/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.costControl;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.service.costControl.UmcCheckCostPurchaseLimitService;
import com.tydic.dyc.umc.service.costControl.bo.UmcCheckCostPurchaseLimitReqBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcCheckCostPurchaseLimitRspBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcCheckCostPurchaseLimitSkuInfoBo;
import java.math.BigDecimal;
import java.util.Collection;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.costControl.UmcCheckCostPurchaseLimitService"})
public class UmcCheckCostPurchaseLimitServiceImpl
implements UmcCheckCostPurchaseLimitService {
    @PostMapping(value={"getCheckCostPurchaseLimit"})
    public UmcCheckCostPurchaseLimitRspBo getCheckCostPurchaseLimit(@RequestBody UmcCheckCostPurchaseLimitReqBo reqBo) {
        Boolean checkCostControl;
        boolean airProjectCode = this.validateArg(reqBo);
        UmcCheckCostPurchaseLimitRspBo rspBO = new UmcCheckCostPurchaseLimitRspBo();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (!airProjectCode && !(checkCostControl = this.checkCostControl(reqBo, rspBO)).booleanValue()) {
            return rspBO;
        }
        this.checkPurchaseLimit(reqBo, rspBO);
        return rspBO;
    }

    private Boolean checkCostControl(UmcCheckCostPurchaseLimitReqBo reqBo, UmcCheckCostPurchaseLimitRspBo rspBO) {
        return true;
    }

    private void checkPurchaseLimit(UmcCheckCostPurchaseLimitReqBo reqBo, UmcCheckCostPurchaseLimitRspBo rspBO) {
    }

    private Boolean validateArg(UmcCheckCostPurchaseLimitReqBo reqBo) {
        boolean airProjectCode;
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UmcCheckCostPurchaseLimitReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean bl = airProjectCode = !StringUtils.hasText((String)reqBo.getProjectCode());
        if (airProjectCode) {
            if (null == reqBo.getOrgId() || 0L == reqBo.getOrgId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u673a\u6784ID\u548c\u9879\u76ee\u7f16\u7801\u4e8c\u9009\u4e00\u4f20\uff0c\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
            if (null == reqBo.getTotalPurchaseAmount() || reqBo.getTotalPurchaseAmount().compareTo(BigDecimal.ZERO) <= 0) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u91c7\u8d2d\u603b\u91d1\u989d\u4e0d\u5408\u6cd5");
            }
        } else {
            if (null != reqBo.getOrgId() && 0L != reqBo.getOrgId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u673a\u6784ID\u548c\u9879\u76ee\u7f16\u7801\u4e8c\u9009\u4e00\u4f20\uff0c\u53c8\u4e0d\u80fd\u540c\u65f6\u6709\u503c");
            }
            if (CollectionUtils.isEmpty((Collection)reqBo.getLimitSkuInfoBos())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5355\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (UmcCheckCostPurchaseLimitSkuInfoBo limitSkuInfoBo : reqBo.getLimitSkuInfoBos()) {
                if (null == limitSkuInfoBo) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u5355\u4e2a\u5355\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null == limitSkuInfoBo.getSkuId() || 0L == limitSkuInfoBo.getSkuId()) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u5355\u4e2a\u5355\u54c1\u4fe1\u606f\u5355\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null == limitSkuInfoBo.getPurchaseQuantity() || 0 >= limitSkuInfoBo.getPurchaseQuantity()) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u5355\u4e2a\u5355\u54c1\u4fe1\u606f\u91c7\u8d2d\u6570\u91cf\u4e0d\u5408\u6cd5");
                }
                if (null != limitSkuInfoBo.getPurchasePrices() && limitSkuInfoBo.getPurchasePrices().compareTo(BigDecimal.ZERO) > 0) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5355\u4e2a\u5355\u54c1\u4fe1\u606f\u91c7\u8d2d\u5355\u4ef7\u4e0d\u5408\u6cd5");
            }
        }
        if (null == reqBo.getOperateId() || 0L == reqBo.getOperateId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getOperateName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return airProjectCode;
    }
}

