/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.costControl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.costControl.IUmcCostControlModel;
import com.tydic.dyc.umc.model.costControl.qrybo.UmcCostControlQryBo;
import com.tydic.dyc.umc.model.costControl.sub.UmcCostControlAmountSubDo;
import com.tydic.dyc.umc.model.costControl.sub.UmcCostControlHisSubDo;
import com.tydic.dyc.umc.model.costControl.sub.UmcCostControlSubDo;
import com.tydic.dyc.umc.service.costControl.UmcCreateCostControlConfigService;
import com.tydic.dyc.umc.service.costControl.bo.UmcCreateCostControlConfigReqBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcCreateCostControlConfigRspBo;
import com.tydic.dyc.umc.utils.DateUtil;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.costControl.UmcCreateCostControlConfigService"})
public class UmcCreateCostControlConfigServiceImpl
implements UmcCreateCostControlConfigService {
    private static final Logger log = LoggerFactory.getLogger(UmcCreateCostControlConfigServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private IUmcCostControlModel iUmcCostControlModel;

    @PostMapping(value={"createCostControlConfig"})
    public UmcCreateCostControlConfigRspBo createCostControlConfig(@RequestBody UmcCreateCostControlConfigReqBo reqBo) {
        UmcCreateCostControlConfigRspBo rspBo = (UmcCreateCostControlConfigRspBo)UmcRu.success(UmcCreateCostControlConfigRspBo.class);
        this.validateArg(reqBo);
        UmcCostControlQryBo configQryBo = new UmcCostControlQryBo();
        configQryBo.setProjectCode(reqBo.getProjectCode());
        configQryBo.setProjectId(reqBo.getProjectId());
        configQryBo.setSkuId(reqBo.getSkuId());
        UmcCostControlSubDo costControlDetail = this.iUmcCostControlModel.getCostControlDetail(configQryBo);
        if (costControlDetail != null) {
            throw new BaseBusinessException("100001", "\u6210\u672c\u63a7\u5236\u5df2\u7ecf\u5b58\u5728\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        }
        UmcCostControlSubDo configSubDo = this.buildDoByBO(reqBo);
        UmcCostControlSubDo umcCostControlSubDo = this.iUmcCostControlModel.createCostControlConfig(configSubDo);
        UmcCostControlAmountSubDo subDo = this.buildAmountDo(reqBo);
        subDo.setControlConfigId(configSubDo.getControlConfigId());
        this.iUmcCostControlModel.createCostControlAmount(subDo);
        UmcCostControlHisSubDo hisSubDo = this.buildHisDo(reqBo);
        hisSubDo.setControlAmountId(subDo.getControlAmountId());
        hisSubDo.setControlConfigId(configSubDo.getControlConfigId());
        this.iUmcCostControlModel.createCostControlHis(hisSubDo);
        return rspBo;
    }

    private UmcCostControlHisSubDo buildHisDo(UmcCreateCostControlConfigReqBo reqBo) {
        UmcCostControlHisSubDo subDo = new UmcCostControlHisSubDo();
        subDo.setHisId(IdUtil.nextId());
        subDo.setPurchaseAmountBefore(new BigDecimal(0));
        subDo.setChngPurchaseAmount(reqBo.getCostControlQuantity());
        subDo.setPurchaseAmountAfter(new BigDecimal(reqBo.getCostControlQuantity().stripTrailingZeros().toPlainString()));
        subDo.setChngRemark("\u9879\u76ee\u63a7\u5236\u6570\u91cf");
        subDo.setDelFlag("0");
        subDo.setCreateOperId(reqBo.getCreateOperId());
        subDo.setCreateOperName(reqBo.getCreateOperName());
        subDo.setCreateTime(new Date());
        subDo.setHisFrom("\u521b\u5efa\u6210\u672c\u63a7\u5236");
        return subDo;
    }

    private UmcCostControlAmountSubDo buildAmountDo(UmcCreateCostControlConfigReqBo reqBo) {
        UmcCostControlAmountSubDo subDo = new UmcCostControlAmountSubDo();
        subDo.setControlAmountId(IdUtil.nextId());
        subDo.setProjectCode(reqBo.getProjectCode());
        subDo.setProjectName(reqBo.getProjectName());
        subDo.setSkuName(reqBo.getSkuName());
        subDo.setSkuId(reqBo.getSkuId());
        subDo.setSkuCode(reqBo.getSkuCode());
        subDo.setUnitMeasurement(reqBo.getUnitMeasurement());
        subDo.setCostControlQuantity(reqBo.getCostControlQuantity());
        subDo.setPurchasedQuantity(new BigDecimal(0));
        subDo.setAvailableControlQuantity(reqBo.getCostControlQuantity());
        subDo.setControlEffTime(DateUtil.getCurrentMonthStartTime());
        subDo.setControlExpTime(DateUtil.getCurrentQuarterEndTime());
        subDo.setControlStatus("1");
        subDo.setDelFlag("0");
        subDo.setCreateOperId(reqBo.getCreateOperId());
        subDo.setCreateOperName(reqBo.getCreateOperName());
        subDo.setCreateTime(new Date());
        subDo.setUpdateOperId(reqBo.getUpdateOperId());
        subDo.setUpdateOperName(reqBo.getUpdateOperName());
        if (null == reqBo.getUpdateOperId()) {
            subDo.setUpdateTime(null);
        } else {
            subDo.setUpdateTime(new Date());
        }
        return subDo;
    }

    private UmcCostControlSubDo buildDoByBO(UmcCreateCostControlConfigReqBo reqBo) {
        UmcCostControlSubDo reqDo = (UmcCostControlSubDo)UmcRu.js((Object)reqBo, UmcCostControlSubDo.class);
        reqDo.setControlConfigId(IdUtil.nextId());
        reqDo.setDelFlag("0");
        return reqDo;
    }

    private void validateArg(UmcCreateCostControlConfigReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UmcCreateCostControlConfigReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public BigDecimal getPrettyNumber(String dec) {
        BigDecimal decimal = new BigDecimal(BigDecimal.valueOf(Double.parseDouble(dec)).stripTrailingZeros().toPlainString());
        return decimal;
    }
}

