/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.costControl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.costControl.IUmcCostControlModel;
import com.tydic.dyc.umc.model.costControl.qrybo.UmcCostControlQryBo;
import com.tydic.dyc.umc.service.costControl.UmcEnableCostControlService;
import com.tydic.dyc.umc.service.costControl.UmcGetCostControlDetailService;
import com.tydic.dyc.umc.service.costControl.bo.UmcCostControlBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcEnableCostControlReqBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcEnableCostControlRspBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcGetCostControlDetailReqBo;
import com.tydic.dyc.umc.service.costControl.bo.UmcGetCostControlDetailRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.costControl.UmcEnableCostControlService"})
public class UmcEnableCostControlServiceImpl
implements UmcEnableCostControlService {
    @Autowired
    private IUmcCostControlModel iUmcCostControlModel;
    @Autowired
    private UmcGetCostControlDetailService getCostControlDetailService;
    @Autowired
    private CacheClient cacheClient;

    @PostMapping(value={"enableCostControlConfig"})
    public UmcEnableCostControlRspBo enableCostControlConfig(@RequestBody UmcEnableCostControlReqBo reqBo) {
        UmcEnableCostControlRspBo rspBo = (UmcEnableCostControlRspBo)UmcRu.success(UmcEnableCostControlRspBo.class);
        this.validateArg(reqBo);
        UmcGetCostControlDetailReqBo detailReqBo = new UmcGetCostControlDetailReqBo();
        for (Long controlConfigId : reqBo.getControlConfigIds()) {
            detailReqBo.setControlConfigId(controlConfigId);
            UmcGetCostControlDetailRspBo costControlDetail = this.getCostControlDetailService.getCostControlDetail(detailReqBo);
            UmcCostControlBo costControlBo = costControlDetail.getCostControlBo();
            if (costControlBo == null || "1".equals(costControlBo.getControlStatus())) continue;
            UmcCostControlQryBo configReqBo = (UmcCostControlQryBo)((Object)UmcRu.js((Object)reqBo, UmcCostControlQryBo.class));
            configReqBo.setControlStatus("1");
            this.iUmcCostControlModel.updateCostControl(configReqBo);
        }
        return rspBo;
    }

    private void validateArg(UmcEnableCostControlReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UmcEnableCostControlReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getControlConfigIds() == null || reqBo.getControlConfigIds().size() <= 0) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[ControlConfigIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

