/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.credit;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.credit.IUmcCreditInfoModel;
import com.tydic.dyc.umc.model.credit.qrybo.UmcCreditAccountPeriodQryBo;
import com.tydic.dyc.umc.model.credit.sub.UmcCreditAccountPeriodSubDo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitSubDo;
import com.tydic.dyc.umc.service.credit.UmcQryCreditAccountPeriodInfoService;
import com.tydic.dyc.umc.service.credit.bo.UmcCreditAccountPeriodBo;
import com.tydic.dyc.umc.service.credit.bo.UmcQryCreditAccountPeriodInfoReqBo;
import com.tydic.dyc.umc.service.credit.bo.UmcQryCreditAccountPeriodInfoRspBo;
import com.tydic.dyc.umc.service.enterprise.DictionaryBusiService;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Date;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.credit.UmcQryCreditAccountPeriodInfoService"})
public class UmcQryCreditAccountPeriodInfoServiceImpl
implements UmcQryCreditAccountPeriodInfoService {
    @Autowired
    private IUmcCreditInfoModel iUmcCreditInfoModel;
    @Autowired
    private DictionaryBusiService dictionaryBusiService;
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;

    @PostMapping(value={"qryCreditAccountPeriodInfo"})
    public UmcQryCreditAccountPeriodInfoRspBo qryCreditAccountPeriodInfo(@RequestBody UmcQryCreditAccountPeriodInfoReqBo reqBo) {
        UmcQryCreditAccountPeriodInfoRspBo rspBo = (UmcQryCreditAccountPeriodInfoRspBo)UmcRu.success(UmcQryCreditAccountPeriodInfoRspBo.class);
        this.validate(reqBo);
        UmcPurchaseLimitQryBo umcPurchaseLimitQryBo = new UmcPurchaseLimitQryBo();
        umcPurchaseLimitQryBo.setLimitObjId(reqBo.getCompanyIdWeb().toString());
        umcPurchaseLimitQryBo.setLimitObjType("EXT");
        umcPurchaseLimitQryBo.setCurrentTime(new Date());
        umcPurchaseLimitQryBo.setExtField1("1");
        umcPurchaseLimitQryBo.setLimitStatus("1");
        StrUtil.noNullStringAttr((Object)((Object)umcPurchaseLimitQryBo));
        UmcPurchaseLimitSubDo umcPurchaseLimitSubDo = this.iUmcPurchaseLimitModel.getPurchaseLimitDetail(umcPurchaseLimitQryBo);
        if (umcPurchaseLimitSubDo == null) {
            throw new BaseBusinessException("100100", "\u672a\u67e5\u8be2\u5230\u6388\u4fe1\u4fe1\u606f\u6216\u8005\u5df2\u7ecf\u88ab\u505c\u7528\uff0c\u4e0d\u80fd\u4f7f\u7528\u56fa\u5b9a\u989d\u5ea6\u652f\u4ed8");
        }
        UmcCreditAccountPeriodQryBo qryBo = new UmcCreditAccountPeriodQryBo();
        qryBo.setLimitConfigId(umcPurchaseLimitSubDo.getLimitConfigId());
        UmcCreditAccountPeriodSubDo subDo = this.iUmcCreditInfoModel.qryCreditAccountPeriodInfo(qryBo);
        if (subDo == null) {
            throw new BaseBusinessException("100100", "\u6388\u4fe1\u7ba1\u7406\u4e2d\u6ca1\u6709\u7ef4\u62a4\u76f8\u5173\u5ba2\u6237\u7684\u8d26\u671f\u4fe1\u606f\uff0c\u4e0d\u80fd\u4f7f\u7528\u56fa\u5b9a\u989d\u5ea6\u652f\u4ed8");
        }
        subDo.setCreditLimit(umcPurchaseLimitSubDo.getLimitAmount());
        subDo.setContractCreditLimit(subDo.getContractCreditLimit());
        UmcCreditAccountPeriodBo umcCreditAccountPeriodBo = (UmcCreditAccountPeriodBo)UmcRu.js((Object)subDo, UmcCreditAccountPeriodBo.class);
        if (StringUtils.isBlank((CharSequence)umcCreditAccountPeriodBo.getAccountPeriod()) || StringUtils.isBlank((CharSequence)umcCreditAccountPeriodBo.getExtField2())) {
            throw new BaseBusinessException("100100", "\u8d26\u671f\u76f8\u5173\u4fe1\u606f\u4e0d\u5b8c\u5584\uff0c\u4e0d\u80fd\u4f7f\u7528\u56fa\u5b9a\u989d\u5ea6\u652f\u4ed8");
        }
        this.translate(umcCreditAccountPeriodBo);
        rspBo.setUmcCreditAccountPeriodBo(umcCreditAccountPeriodBo);
        return rspBo;
    }

    private void translate(UmcCreditAccountPeriodBo rspBO) {
        Map paymentTimeMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_CREDIT_PAYMENT_TIME");
        Map accountPeriodMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_CREDIT_ACCOUNT_PERIOD");
        Map accountPeriodMoonMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_CREDIT_ACCOUNT_PERIOD_MOON");
        Map paymentMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_CREDIT_PAYMENT_METHOD");
        if (!MapUtils.isEmpty((Map)paymentTimeMap)) {
            rspBO.setPaymentTimeStr((String)paymentTimeMap.get(rspBO.getPaymentTime()));
        }
        if (!MapUtils.isEmpty((Map)paymentMap)) {
            rspBO.setPaymentMethodStr((String)paymentMap.get(rspBO.getPaymentMethod()));
        }
        if (!MapUtils.isEmpty((Map)accountPeriodMap)) {
            rspBO.setAccountPeriodStr((String)accountPeriodMap.get(rspBO.getAccountPeriod()));
        }
        rspBO.setAccountPeriodComStr(rspBO.getAccountPeriodStr());
        if (StringUtils.isNotBlank((CharSequence)rspBO.getExtField2()) && StringUtils.isNotBlank((CharSequence)rspBO.getAccountPeriod())) {
            if ("1".equals(rspBO.getAccountPeriod())) {
                rspBO.setAccountPeriodComStr("\u89c1\u7968\u540e" + rspBO.getExtField2() + "\u5929\u4ed8\u6b3e");
            } else if ("2".equals(rspBO.getAccountPeriod()) && !MapUtils.isEmpty((Map)accountPeriodMoonMap)) {
                rspBO.setExtField2Str((String)accountPeriodMoonMap.get(rspBO.getExtField2()));
                rspBO.setAccountPeriodComStr(rspBO.getExtField2Str() + "\u6700\u540e\u4e00\u4e2a\u5de5\u4f5c\u65e5\u4ed8\u6b3e");
            }
        }
    }

    private void validate(UmcQryCreditAccountPeriodInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getCompanyIdWeb() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u516c\u53f8id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

