/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.credit;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.credit.IUmcCreditInfoModel;
import com.tydic.dyc.umc.model.credit.qrybo.UmcCreditCustomerQryBo;
import com.tydic.dyc.umc.model.credit.sub.UmcCreditCustomerSubDo;
import com.tydic.dyc.umc.service.credit.UmcQryCreditCustomerInfoService;
import com.tydic.dyc.umc.service.credit.bo.UmcQryCreditCustomerInfoReqBo;
import com.tydic.dyc.umc.service.credit.bo.UmcQryCreditCustomerInfoRspBo;
import com.tydic.dyc.umc.service.enterprise.DictionaryBusiService;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.credit.UmcQryCreditCustomerInfoService"})
public class UmcQryCreditCustomerInfoServiceImpl
implements UmcQryCreditCustomerInfoService {
    private static final Logger log = LoggerFactory.getLogger(UmcQryCreditCustomerInfoServiceImpl.class);
    @Autowired
    private IUmcCreditInfoModel iUmcCreditInfoModel;
    @Autowired
    private DictionaryBusiService dictionaryBusiService;

    @PostMapping(value={"qryCreditCustomerInfo"})
    public UmcQryCreditCustomerInfoRspBo qryCreditCustomerInfo(@RequestBody UmcQryCreditCustomerInfoReqBo reqBo) {
        UmcQryCreditCustomerInfoRspBo rspBo = (UmcQryCreditCustomerInfoRspBo)UmcRu.success(UmcQryCreditCustomerInfoRspBo.class);
        this.validate(reqBo);
        UmcCreditCustomerQryBo umcCreditCustomerQryBo = new UmcCreditCustomerQryBo();
        umcCreditCustomerQryBo.setOrgId(reqBo.getOrgId());
        UmcCreditCustomerSubDo umcCreditCustomerSubDo = this.iUmcCreditInfoModel.qryCreditCustomerInfo(umcCreditCustomerQryBo);
        if (umcCreditCustomerSubDo != null) {
            rspBo = (UmcQryCreditCustomerInfoRspBo)UmcRu.js((Object)umcCreditCustomerSubDo, UmcQryCreditCustomerInfoRspBo.class);
            Map enterpriseTypeMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_CREDIT_ENTERPRISE_TYPE");
            if (!MapUtils.isEmpty((Map)enterpriseTypeMap)) {
                rspBo.setEnterpriseTypeStr((String)enterpriseTypeMap.get(rspBo.getEnterpriseType()));
            }
            if ("1".equals(rspBo.getEnterpriseType())) {
                rspBo.setIsValleyCustomer("1");
                rspBo.setIsValleyCustomerStr("\u662f");
            } else {
                rspBo.setIsValleyCustomer("0");
                rspBo.setIsValleyCustomerStr("\u5426");
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void validate(UmcQryCreditCustomerInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[orgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

