/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.creditApply;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCreditConstants;
import com.tydic.dyc.umc.model.creditApply.IUmcCreditApplyInfoModel;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditAccountPeriodApplyQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditApplyAllInfoQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditApplyInfoQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditAttachmentQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditContractApplyQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditCustomerApplyQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditGuarantorApplyQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditInvoiceInfoApplyQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditRelatedCustomerApplyQryBo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitDo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitConfigQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitAmountSubDo;
import com.tydic.dyc.umc.service.creditApply.UmcAddCreditApplyInfoService;
import com.tydic.dyc.umc.service.creditApply.UmcQryVerifyCreditInfoExistsService;
import com.tydic.dyc.umc.service.creditApply.bo.UmcAddCreditApplyInfoReqBo;
import com.tydic.dyc.umc.service.creditApply.bo.UmcAddCreditApplyInfoRspBo;
import com.tydic.dyc.umc.service.creditApply.bo.UmcQryVerifyCreditInfoExistsReqBo;
import com.tydic.dyc.umc.service.creditApply.bo.UmcQryVerifyCreditInfoExistsRspBo;
import com.tydic.dyc.umc.utils.DateUtil;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.creditApply.UmcAddCreditApplyInfoService"})
public class UmcAddCreditApplyInfoServiceImpl
implements UmcAddCreditApplyInfoService {
    private static final Logger log = LoggerFactory.getLogger(UmcAddCreditApplyInfoServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;
    @Autowired
    private IUmcCreditApplyInfoModel iUmcCreditApplyInfoModel;
    @Autowired
    private UmcQryVerifyCreditInfoExistsService umcQryVerifyCreditInfoExistsService;

    @PostMapping(value={"addCreditApplyInfo"})
    public UmcAddCreditApplyInfoRspBo addCreditApplyInfo(@RequestBody UmcAddCreditApplyInfoReqBo reqBo) {
        UmcAddCreditApplyInfoRspBo rspBo = (UmcAddCreditApplyInfoRspBo)UmcRu.success(UmcAddCreditApplyInfoRspBo.class);
        reqBo.setApplyType("1");
        this.validate(reqBo);
        UmcQryVerifyCreditInfoExistsRspBo umcQryVerifyCreditInfoExistsRspBo = this.checkInfo(reqBo);
        UmcCreditApplyAllInfoQryBo umcCreditApplyAllInfoQryBo = new UmcCreditApplyAllInfoQryBo();
        UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo = UmcAddCreditApplyInfoServiceImpl.buildUmcCreditApplyInfoQryBo(reqBo);
        UmcCreditCustomerApplyQryBo umcCreditCustomerApplyPo = UmcAddCreditApplyInfoServiceImpl.buildUmcCreditCustomerApplyQryBo(reqBo, umcCreditApplyInfoQryBo);
        UmcCreditAccountPeriodApplyQryBo umcCreditAccountPeriodApplyQryBo = UmcAddCreditApplyInfoServiceImpl.buildUmcCreditAccountPeriodQryBo(reqBo, umcCreditApplyInfoQryBo);
        UmcCreditGuarantorApplyQryBo umcCreditGuarantorApplyQryBo = UmcAddCreditApplyInfoServiceImpl.buildUmcCreditGuarantorApplyQryBo(reqBo, umcCreditApplyInfoQryBo);
        List<UmcCreditRelatedCustomerApplyQryBo> umcCreditRelatedCustomerApplyQryBos = UmcAddCreditApplyInfoServiceImpl.buildCreditRelatedCustomerApply(reqBo, umcCreditApplyInfoQryBo);
        UmcCreditInvoiceInfoApplyQryBo umcCreditInvoiceInfoApplyQryBo = UmcAddCreditApplyInfoServiceImpl.buildUmcCreditInvoiceInfoApplyQryBo(reqBo, umcCreditApplyInfoQryBo);
        UmcCreditContractApplyQryBo umcCreditContractApplyQryBo = UmcAddCreditApplyInfoServiceImpl.buildUmcCreditContractApplyQryBo(reqBo, umcCreditApplyInfoQryBo);
        List<UmcCreditAttachmentQryBo> umcCreditAttachmentQryBos = UmcAddCreditApplyInfoServiceImpl.buildUmcCreditAttachmentQryBos(reqBo, umcCreditApplyInfoQryBo);
        umcCreditApplyAllInfoQryBo.setUmcCreditApplyInfoQryBo(umcCreditApplyInfoQryBo);
        umcCreditApplyAllInfoQryBo.setUmcCreditCustomerApplyQryBo(umcCreditCustomerApplyPo);
        umcCreditApplyAllInfoQryBo.setUmcCreditAccountPeriodApplyQryBo(umcCreditAccountPeriodApplyQryBo);
        umcCreditApplyAllInfoQryBo.setUmcCreditGuarantorApplyQryBo(umcCreditGuarantorApplyQryBo);
        umcCreditApplyAllInfoQryBo.setUmcCreditContractApplyQryBo(umcCreditContractApplyQryBo);
        umcCreditApplyAllInfoQryBo.setUmcCreditInvoiceInfoApplyQryBo(umcCreditInvoiceInfoApplyQryBo);
        umcCreditApplyAllInfoQryBo.setUmcCreditRelatedCustomerApplyQryBos(umcCreditRelatedCustomerApplyQryBos);
        umcCreditApplyAllInfoQryBo.setUmcCreditAttachmentQryBos(umcCreditAttachmentQryBos);
        try {
            this.iUmcCreditApplyInfoModel.addCreditApplyAllInfo(umcCreditApplyAllInfoQryBo);
        }
        catch (Exception e) {
            log.debug("\u65b0\u589e\u6388\u4fe1\u5931\u8d25\uff0c{}", (Object)e.getMessage());
            throw new BaseBusinessException("100001", "\u65b0\u589e\u6388\u4fe1\u5931\u8d25");
        }
        if (umcQryVerifyCreditInfoExistsRspBo.getAddReject().booleanValue()) {
            BasePageRspBo<IUmcPurchaseLimitDo> rspDo = this.getiUmcPurchaseLimitDoBasePageRspBo(reqBo);
            if (CollectionUtils.isEmpty((Collection)rspDo.getRows())) {
                throw new BaseBusinessException("100001", "\u989d\u5ea6\u8868\u67e5\u8be2\u5931\u8d25");
            }
            if (rspDo.getRows().size() > 1) {
                throw new BaseBusinessException("100001", "\u989d\u5ea6\u8868\u4e2d\u5b58\u5728\u591a\u6761\u6570\u636e");
            }
            this.updatePurchaseLimit(umcCreditApplyInfoQryBo, rspDo);
        } else {
            this.addPurchaseLimit(reqBo, umcCreditApplyInfoQryBo);
        }
        rspBo.setApplyId(umcCreditCustomerApplyPo.getApplyId());
        return rspBo;
    }

    private static List<UmcCreditAttachmentQryBo> buildUmcCreditAttachmentQryBos(UmcAddCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        ArrayList<UmcCreditAttachmentQryBo> umcCreditAttachmentQryBos = new ArrayList<UmcCreditAttachmentQryBo>();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUmcCreditAttachmentBos())) {
            for (int i = 0; i < reqBo.getUmcCreditAttachmentBos().size(); ++i) {
                UmcCreditAttachmentQryBo umcCreditAttachmentQryBo = (UmcCreditAttachmentQryBo)UmcRu.js(reqBo.getUmcCreditAttachmentBos().get(i), UmcCreditAttachmentQryBo.class);
                umcCreditAttachmentQryBo.setAttachmentId(IdUtil.nextId());
                umcCreditAttachmentQryBo.setObjId(umcCreditApplyInfoQryBo.getApplyId());
                umcCreditAttachmentQryBo.setObjType(UmcCreditConstants.ObjType.APPROVE);
                umcCreditAttachmentQryBo.setSort(i);
                umcCreditAttachmentQryBo.setCreateTime(new Date());
                umcCreditAttachmentQryBos.add(umcCreditAttachmentQryBo);
            }
        }
        return umcCreditAttachmentQryBos;
    }

    private static List<UmcCreditRelatedCustomerApplyQryBo> buildCreditRelatedCustomerApply(UmcAddCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        List<UmcCreditRelatedCustomerApplyQryBo> umcCreditRelatedCustomerApplyQryBos = new ArrayList<UmcCreditRelatedCustomerApplyQryBo>();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUmcCreditRelatedCustomerApplyBos())) {
            umcCreditRelatedCustomerApplyQryBos = UmcRu.jsl((List)reqBo.getUmcCreditRelatedCustomerApplyBos(), UmcCreditRelatedCustomerApplyQryBo.class);
            for (UmcCreditRelatedCustomerApplyQryBo each : umcCreditRelatedCustomerApplyQryBos) {
                each.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
                each.setCreateOperId(umcCreditApplyInfoQryBo.getCreateOperId());
                each.setCreateTime(umcCreditApplyInfoQryBo.getCreateTime());
                each.setCreateOperName(umcCreditApplyInfoQryBo.getCreateOperName());
                each.setRelatedCustomerId(IdUtil.nextId());
            }
        }
        return umcCreditRelatedCustomerApplyQryBos;
    }

    private static UmcCreditInvoiceInfoApplyQryBo buildUmcCreditInvoiceInfoApplyQryBo(UmcAddCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        UmcCreditInvoiceInfoApplyQryBo umcCreditInvoiceInfoApplyQryBo = new UmcCreditInvoiceInfoApplyQryBo();
        if (reqBo.getUmcCreditInvoiceInfoApplyBo() != null) {
            umcCreditInvoiceInfoApplyQryBo = (UmcCreditInvoiceInfoApplyQryBo)UmcRu.js((Object)reqBo.getUmcCreditInvoiceInfoApplyBo(), UmcCreditInvoiceInfoApplyQryBo.class);
        }
        umcCreditInvoiceInfoApplyQryBo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        umcCreditInvoiceInfoApplyQryBo.setCreateOperId(umcCreditApplyInfoQryBo.getCreateOperId());
        umcCreditInvoiceInfoApplyQryBo.setCreateTime(umcCreditApplyInfoQryBo.getCreateTime());
        umcCreditInvoiceInfoApplyQryBo.setCreateOperName(umcCreditApplyInfoQryBo.getCreateOperName());
        umcCreditInvoiceInfoApplyQryBo.setInvoiceId(IdUtil.nextId());
        umcCreditInvoiceInfoApplyQryBo.setOrgId(reqBo.getOrgIdWeb());
        return umcCreditInvoiceInfoApplyQryBo;
    }

    private UmcQryVerifyCreditInfoExistsRspBo checkInfo(UmcAddCreditApplyInfoReqBo reqBo) {
        UmcQryVerifyCreditInfoExistsReqBo umcQryVerifyCreditInfoExistsReqBo = new UmcQryVerifyCreditInfoExistsReqBo();
        umcQryVerifyCreditInfoExistsReqBo.setOrgIdWeb(reqBo.getOrgIdWeb());
        UmcQryVerifyCreditInfoExistsRspBo umcQryVerifyCreditInfoExistsRspBo = this.umcQryVerifyCreditInfoExistsService.qryVerifyCreditInfoExists(umcQryVerifyCreditInfoExistsReqBo);
        if (!"0000".equals(umcQryVerifyCreditInfoExistsRspBo.getRespCode())) {
            throw new BaseBusinessException("100001", "\u6821\u9a8c\u5ba2\u6237\u662f\u5426\u5df2\u7ecf\u6dfb\u52a0\u4e86\u6388\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        if (!"7".equals(umcQryVerifyCreditInfoExistsRspBo.getApplyStatus()) && "2".equals(umcQryVerifyCreditInfoExistsRspBo.getVerifyStatus())) {
            throw new BaseBusinessException("100001", "\u8be5\u5ba2\u6237\u5df2\u7ecf\u6dfb\u52a0\u4e86\u6388\u4fe1");
        }
        return umcQryVerifyCreditInfoExistsRspBo;
    }

    private void updatePurchaseLimit(UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo, BasePageRspBo<IUmcPurchaseLimitDo> rspDo) {
        IUmcPurchaseLimitDo iUmcPurchaseLimitDo = (IUmcPurchaseLimitDo)rspDo.getRows().get(0);
        IUmcPurchaseLimitDo configQryBoSet = new IUmcPurchaseLimitDo();
        configQryBoSet.setLimitConfigId(iUmcPurchaseLimitDo.getLimitConfigId());
        configQryBoSet.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        configQryBoSet.setLimitAmount(umcCreditApplyInfoQryBo.getCreditLimit());
        configQryBoSet.setContractCreditLimit(umcCreditApplyInfoQryBo.getCreditLimit());
        UmcPurchaseLimitConfigQryBo configQryBoWhere = new UmcPurchaseLimitConfigQryBo();
        configQryBoWhere.setLimitConfigId(iUmcPurchaseLimitDo.getLimitConfigId());
        this.iUmcPurchaseLimitModel.updatePurchaseLimitConfig(configQryBoSet, configQryBoWhere);
    }

    private void addPurchaseLimit(UmcAddCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        IUmcPurchaseLimitDo umcPurchaseLimitDo = UmcAddCreditApplyInfoServiceImpl.buildUmcPurchaseLimitDo(reqBo, umcCreditApplyInfoQryBo);
        this.iUmcPurchaseLimitModel.createPurchaseLimitConfig(umcPurchaseLimitDo);
        UmcPurchaseLimitAmountSubDo amountSubDo = this.buildAmountDo(umcPurchaseLimitDo);
        this.iUmcPurchaseLimitModel.createPurchaseLimitAmount(amountSubDo);
        String redisKey = "UMC_PURCHASE_LIMIT_" + umcPurchaseLimitDo.getLimitObjType() + "_" + umcPurchaseLimitDo.getLimitObjCode();
        this.cacheClient.delete(redisKey);
        Long currenNum = this.cacheClient.incrBy(redisKey, 0L);
    }

    private BasePageRspBo<IUmcPurchaseLimitDo> getiUmcPurchaseLimitDoBasePageRspBo(UmcAddCreditApplyInfoReqBo reqBo) {
        UmcPurchaseLimitConfigQryBo configQryBo = new UmcPurchaseLimitConfigQryBo();
        configQryBo.setLimitObjCode(reqBo.getOrgIdWeb().toString());
        configQryBo.setLimitObjId(reqBo.getOrgIdWeb().toString());
        configQryBo.setLimitObjType("EXT");
        configQryBo.setExtField1("1");
        StrUtil.noNullStringAttr((Object)((Object)configQryBo));
        return this.iUmcPurchaseLimitModel.getPurchaseLimitConfigPageList(configQryBo);
    }

    private static IUmcPurchaseLimitDo buildUmcPurchaseLimitDo(UmcAddCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        IUmcPurchaseLimitDo umcPurchaseLimitDo = new IUmcPurchaseLimitDo();
        umcPurchaseLimitDo.setLimitConfigId(IdUtil.nextId());
        umcPurchaseLimitDo.setLimitObjType("EXT");
        umcPurchaseLimitDo.setLimitObjId(umcCreditApplyInfoQryBo.getOrgId().toString());
        umcPurchaseLimitDo.setLimitObjCode(umcCreditApplyInfoQryBo.getOrgId().toString());
        umcPurchaseLimitDo.setLimitObjName(umcCreditApplyInfoQryBo.getOrgName());
        umcPurchaseLimitDo.setIsLimit("1");
        umcPurchaseLimitDo.setLimitType("once");
        umcPurchaseLimitDo.setIsAccumulation("0");
        umcPurchaseLimitDo.setLimitAmount(reqBo.getCreditLimit());
        umcPurchaseLimitDo.setContractCreditLimit(reqBo.getCreditLimit());
        umcPurchaseLimitDo.setDelFlag("0");
        umcPurchaseLimitDo.setExtField1("1");
        umcPurchaseLimitDo.setCreateOperId(reqBo.getUserId());
        umcPurchaseLimitDo.setCreateOperName(reqBo.getName());
        umcPurchaseLimitDo.setCreateTime(new Date());
        umcPurchaseLimitDo.setUpdateTime(new Date());
        umcPurchaseLimitDo.setUpdateOperName(reqBo.getName());
        umcPurchaseLimitDo.setUpdateOperId(reqBo.getUserId());
        umcPurchaseLimitDo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        umcPurchaseLimitDo.setLimitTemporary(BigDecimal.ZERO);
        return umcPurchaseLimitDo;
    }

    private UmcPurchaseLimitAmountSubDo buildAmountDo(IUmcPurchaseLimitDo reqDo) {
        UmcPurchaseLimitAmountSubDo amountSubDo = new UmcPurchaseLimitAmountSubDo();
        amountSubDo.setLimitConfigId(reqDo.getLimitConfigId());
        SimpleDateFormat year = new SimpleDateFormat("yyyy");
        Date date = new Date();
        amountSubDo.setLimitYear(year.format(date));
        amountSubDo.setLimitType(reqDo.getLimitType());
        amountSubDo.setIsAccumulation(reqDo.getIsAccumulation());
        amountSubDo.setAccumulationAmount(BigDecimal.ZERO);
        amountSubDo.setLimitAmount(BigDecimal.ZERO);
        amountSubDo.setPurchaseAmount(BigDecimal.ZERO);
        amountSubDo.setLimitYear("0");
        amountSubDo.setLimitEffTime(DateUtil.getCurrentYearStartTime());
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getCurrentYearStartTime());
        cal.add(1, 100);
        amountSubDo.setLimitExpTime(cal.getTime());
        amountSubDo.setCreateOperId(reqDo.getCreateOperId());
        amountSubDo.setCreateOperName(reqDo.getCreateOperName());
        amountSubDo.setCreateTime(reqDo.getCreateTime());
        amountSubDo.setUpdateOperId(reqDo.getUpdateOperId());
        amountSubDo.setUpdateOperName(reqDo.getUpdateOperName());
        amountSubDo.setUpdateTime(reqDo.getUpdateTime());
        amountSubDo.setValId(IdUtil.nextId());
        amountSubDo.setLimitTemporary(reqDo.getLimitTemporary());
        return amountSubDo;
    }

    private static UmcCreditContractApplyQryBo buildUmcCreditContractApplyQryBo(UmcAddCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        UmcCreditContractApplyQryBo umcCreditContractApplyQryBo = new UmcCreditContractApplyQryBo();
        if (reqBo.getUmcCreditContractApplyBo() != null) {
            umcCreditContractApplyQryBo = (UmcCreditContractApplyQryBo)UmcRu.js((Object)reqBo.getUmcCreditContractApplyBo(), UmcCreditContractApplyQryBo.class);
        }
        umcCreditContractApplyQryBo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        umcCreditContractApplyQryBo.setCreateOperId(umcCreditApplyInfoQryBo.getCreateOperId());
        umcCreditContractApplyQryBo.setCreateTime(umcCreditApplyInfoQryBo.getCreateTime());
        umcCreditContractApplyQryBo.setCreateOperName(umcCreditApplyInfoQryBo.getCreateOperName());
        umcCreditContractApplyQryBo.setContractId(IdUtil.nextId());
        return umcCreditContractApplyQryBo;
    }

    private static UmcCreditGuarantorApplyQryBo buildUmcCreditGuarantorApplyQryBo(UmcAddCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        UmcCreditGuarantorApplyQryBo umcCreditGuarantorApplyQryBo = new UmcCreditGuarantorApplyQryBo();
        if (reqBo.getUmcCreditGuarantorApplyBo() != null) {
            umcCreditGuarantorApplyQryBo = (UmcCreditGuarantorApplyQryBo)UmcRu.js((Object)reqBo.getUmcCreditGuarantorApplyBo(), UmcCreditGuarantorApplyQryBo.class);
        }
        umcCreditGuarantorApplyQryBo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        umcCreditGuarantorApplyQryBo.setCreateOperId(umcCreditApplyInfoQryBo.getCreateOperId());
        umcCreditGuarantorApplyQryBo.setCreateTime(umcCreditApplyInfoQryBo.getCreateTime());
        umcCreditGuarantorApplyQryBo.setCreateOperName(umcCreditApplyInfoQryBo.getCreateOperName());
        umcCreditGuarantorApplyQryBo.setGuarantorId(IdUtil.nextId());
        return umcCreditGuarantorApplyQryBo;
    }

    private static UmcCreditAccountPeriodApplyQryBo buildUmcCreditAccountPeriodQryBo(UmcAddCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        UmcCreditAccountPeriodApplyQryBo umcCreditAccountPeriodApplyQryBo = new UmcCreditAccountPeriodApplyQryBo();
        if (reqBo.getUmcCreditAccountPeriodApplyBo() != null) {
            umcCreditAccountPeriodApplyQryBo = (UmcCreditAccountPeriodApplyQryBo)UmcRu.js((Object)reqBo.getUmcCreditAccountPeriodApplyBo(), UmcCreditAccountPeriodApplyQryBo.class);
        }
        umcCreditAccountPeriodApplyQryBo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        umcCreditAccountPeriodApplyQryBo.setCreateOperId(umcCreditApplyInfoQryBo.getCreateOperId());
        umcCreditAccountPeriodApplyQryBo.setCreateTime(umcCreditApplyInfoQryBo.getCreateTime());
        umcCreditAccountPeriodApplyQryBo.setCreateOperName(umcCreditApplyInfoQryBo.getCreateOperName());
        umcCreditAccountPeriodApplyQryBo.setAccountPeriodId(IdUtil.nextId());
        umcCreditAccountPeriodApplyQryBo.setCreditLimit(umcCreditApplyInfoQryBo.getCreditLimit());
        return umcCreditAccountPeriodApplyQryBo;
    }

    private static UmcCreditCustomerApplyQryBo buildUmcCreditCustomerApplyQryBo(UmcAddCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        UmcCreditCustomerApplyQryBo umcCreditCustomerApplyPo = new UmcCreditCustomerApplyQryBo();
        if (reqBo.getUmcCreditCustomerApplyBo() != null) {
            umcCreditCustomerApplyPo = (UmcCreditCustomerApplyQryBo)UmcRu.js((Object)reqBo.getUmcCreditCustomerApplyBo(), UmcCreditCustomerApplyQryBo.class);
        }
        umcCreditCustomerApplyPo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        umcCreditCustomerApplyPo.setCreateOperId(umcCreditApplyInfoQryBo.getCreateOperId());
        umcCreditCustomerApplyPo.setCreateTime(umcCreditApplyInfoQryBo.getCreateTime());
        umcCreditCustomerApplyPo.setCreateOperName(umcCreditApplyInfoQryBo.getCreateOperName());
        umcCreditCustomerApplyPo.setCustomerId(IdUtil.nextId());
        umcCreditCustomerApplyPo.setOrgId(reqBo.getOrgIdWeb());
        umcCreditCustomerApplyPo.setOrgName(reqBo.getOrgNameWeb());
        return umcCreditCustomerApplyPo;
    }

    private static UmcCreditApplyInfoQryBo buildUmcCreditApplyInfoQryBo(UmcAddCreditApplyInfoReqBo reqBo) {
        UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo = new UmcCreditApplyInfoQryBo();
        Date date = new Date();
        umcCreditApplyInfoQryBo.setApplyId(IdUtil.nextId());
        umcCreditApplyInfoQryBo.setApplyType("1");
        umcCreditApplyInfoQryBo.setOrgId(reqBo.getOrgIdWeb());
        umcCreditApplyInfoQryBo.setOrgName(reqBo.getOrgNameWeb());
        umcCreditApplyInfoQryBo.setIsAffiliate(reqBo.getIsAffiliate());
        umcCreditApplyInfoQryBo.setIsGuarantor(reqBo.getIsGuarantor());
        umcCreditApplyInfoQryBo.setCommitmentLetter(reqBo.getCommitmentLetter());
        umcCreditApplyInfoQryBo.setContractAppendices(reqBo.getContractAppendices());
        umcCreditApplyInfoQryBo.setCreditLimit(reqBo.getCreditLimit());
        umcCreditApplyInfoQryBo.setCreditLimitOld(new BigDecimal("0"));
        umcCreditApplyInfoQryBo.setCreateOperId(reqBo.getUserId());
        umcCreditApplyInfoQryBo.setCreateOperName(reqBo.getName());
        umcCreditApplyInfoQryBo.setCreateTime(date);
        umcCreditApplyInfoQryBo.setUpdateOperName(reqBo.getName());
        umcCreditApplyInfoQryBo.setUpdateOperId(reqBo.getUserId());
        umcCreditApplyInfoQryBo.setUpdateTime(new Date());
        umcCreditApplyInfoQryBo.setDelFlag("0");
        if ("1".equals(reqBo.getOperType())) {
            umcCreditApplyInfoQryBo.setApplyStatus("2");
        } else if ("2".equals(reqBo.getOperType())) {
            umcCreditApplyInfoQryBo.setApplyStatus("3");
        } else {
            throw new BaseBusinessException("100001", "\u4f20\u5165\u7684\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5bf9");
        }
        return umcCreditApplyInfoQryBo;
    }

    private void validate(UmcAddCreditApplyInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getApplyType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u7533\u8bf7\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOperType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u64cd\u4f5c\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOrgNameWeb())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u5ba2\u6237\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgIdWeb() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u5ba2\u6237ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

