/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.creditApply;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCreditConstants;
import com.tydic.dyc.umc.model.credit.IUmcCreditInfoModel;
import com.tydic.dyc.umc.model.credit.qrybo.UmcCreditAccountPeriodQryBo;
import com.tydic.dyc.umc.model.credit.qrybo.UmcCreditAllInfoQryBo;
import com.tydic.dyc.umc.model.credit.qrybo.UmcCreditContractQryBo;
import com.tydic.dyc.umc.model.credit.qrybo.UmcCreditCustomerQryBo;
import com.tydic.dyc.umc.model.creditApply.IUmcCreditApplyInfoModel;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditAccountPeriodApplyQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditApplyAllInfoQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditApplyInfoQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditAttachmentQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditContractApplyQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditCustomerApplyQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditGuarantorApplyQryBo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitDo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitAmountQryBo;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitConfigQryBo;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitAmountSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitHisSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitSubDo;
import com.tydic.dyc.umc.service.creditApply.UmcAdjustCreditApplyInfoService;
import com.tydic.dyc.umc.service.creditApply.bo.UmcAddCreditApplyInfoReqBo;
import com.tydic.dyc.umc.service.creditApply.bo.UmcAdjustCreditApplyInfoReqBo;
import com.tydic.dyc.umc.service.creditApply.bo.UmcAdjustCreditApplyInfoRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.creditApply.UmcAdjustCreditApplyInfoService"})
public class UmcAdjustCreditApplyInfoServiceImpl
implements UmcAdjustCreditApplyInfoService {
    private static final Logger log = LoggerFactory.getLogger(UmcAdjustCreditApplyInfoServiceImpl.class);
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;
    @Autowired
    private IUmcCreditApplyInfoModel iUmcCreditApplyInfoModel;
    @Autowired
    private IUmcCreditInfoModel iUmcCreditInfoModel;
    @Autowired
    private CacheClient cacheClient;

    @PostMapping(value={"saveAdjustCreditApplyInfo"})
    public UmcAdjustCreditApplyInfoRspBo saveAdjustCreditApplyInfo(@RequestBody UmcAdjustCreditApplyInfoReqBo reqBo) {
        UmcAdjustCreditApplyInfoRspBo rspBo = (UmcAdjustCreditApplyInfoRspBo)UmcRu.success(UmcAdjustCreditApplyInfoRspBo.class);
        this.validate(reqBo);
        UmcPurchaseLimitQryBo configQryBo = new UmcPurchaseLimitQryBo();
        configQryBo.setLimitConfigId(reqBo.getLimitConfigId());
        UmcPurchaseLimitSubDo rspDo = this.iUmcPurchaseLimitModel.getPurchaseLimitDetail(configQryBo);
        this.checkInfo(reqBo, rspDo);
        if (reqBo.getCreditLimit().compareTo(rspDo.getContractCreditLimit()) <= 0) {
            this.dealOriginal(reqBo, rspDo);
        } else {
            Long applyId = IdUtil.nextId();
            reqBo.setApplyId(applyId);
            rspBo.setApplyId(applyId);
            rspBo.setIsApprove(Boolean.valueOf(true));
            this.dealApply(reqBo, rspDo);
        }
        return rspBo;
    }

    private void dealApply(UmcAdjustCreditApplyInfoReqBo reqBo, UmcPurchaseLimitSubDo rspDo) {
        UmcCreditApplyAllInfoQryBo umcCreditApplyAllInfoQryBo = new UmcCreditApplyAllInfoQryBo();
        UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo = UmcAdjustCreditApplyInfoServiceImpl.buildUmcCreditApplyInfoQryBo(reqBo, rspDo);
        UmcCreditCustomerApplyQryBo umcCreditCustomerApplyPo = UmcAdjustCreditApplyInfoServiceImpl.buildUmcCreditCustomerApplyQryBo(reqBo, umcCreditApplyInfoQryBo);
        UmcCreditAccountPeriodApplyQryBo umcCreditAccountPeriodApplyQryBo = UmcAdjustCreditApplyInfoServiceImpl.buildUmcCreditAccountPeriodQryBo(reqBo, umcCreditApplyInfoQryBo);
        if (reqBo.getUmcCreditContractApplyBo() != null) {
            UmcCreditContractApplyQryBo umcCreditContractApplyQryBo = UmcAdjustCreditApplyInfoServiceImpl.buildUmcCreditContractApplyQryBo(reqBo, umcCreditApplyInfoQryBo);
            umcCreditApplyAllInfoQryBo.setUmcCreditContractApplyQryBo(umcCreditContractApplyQryBo);
        }
        List<UmcCreditAttachmentQryBo> umcCreditAttachmentQryBos = UmcAdjustCreditApplyInfoServiceImpl.buildUmcCreditAttachmentQryBos(reqBo, umcCreditApplyInfoQryBo);
        umcCreditApplyAllInfoQryBo.setUmcCreditAttachmentQryBos(umcCreditAttachmentQryBos);
        umcCreditApplyAllInfoQryBo.setUmcCreditApplyInfoQryBo(umcCreditApplyInfoQryBo);
        umcCreditApplyAllInfoQryBo.setUmcCreditCustomerApplyQryBo(umcCreditCustomerApplyPo);
        umcCreditApplyAllInfoQryBo.setUmcCreditAccountPeriodApplyQryBo(umcCreditAccountPeriodApplyQryBo);
        try {
            this.iUmcCreditApplyInfoModel.addCreditApplyAllInfo(umcCreditApplyAllInfoQryBo);
        }
        catch (Exception e) {
            log.debug("\u65b0\u589e\u6388\u4fe1\u5931\u8d25\uff0c{}", (Object)e.getMessage());
            throw new BaseBusinessException("100001", "\u65b0\u589e\u6388\u4fe1\u5931\u8d25");
        }
        IUmcPurchaseLimitDo configQryBoSet = new IUmcPurchaseLimitDo();
        configQryBoSet.setLimitConfigId(rspDo.getLimitConfigId());
        configQryBoSet.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        UmcPurchaseLimitConfigQryBo configQryBoWhere = new UmcPurchaseLimitConfigQryBo();
        configQryBoWhere.setLimitConfigId(rspDo.getLimitConfigId());
        this.iUmcPurchaseLimitModel.updatePurchaseLimitConfig(configQryBoSet, configQryBoWhere);
    }

    private static List<UmcCreditAttachmentQryBo> buildUmcCreditAttachmentQryBos(UmcAdjustCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        ArrayList<UmcCreditAttachmentQryBo> umcCreditAttachmentQryBos = new ArrayList<UmcCreditAttachmentQryBo>();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUmcCreditAttachmentBos())) {
            for (int i = 0; i < reqBo.getUmcCreditAttachmentBos().size(); ++i) {
                UmcCreditAttachmentQryBo umcCreditAttachmentQryBo = (UmcCreditAttachmentQryBo)UmcRu.js(reqBo.getUmcCreditAttachmentBos().get(i), UmcCreditAttachmentQryBo.class);
                umcCreditAttachmentQryBo.setAttachmentId(IdUtil.nextId());
                umcCreditAttachmentQryBo.setObjId(umcCreditApplyInfoQryBo.getApplyId());
                umcCreditAttachmentQryBo.setObjType(UmcCreditConstants.ObjType.APPROVE);
                umcCreditAttachmentQryBo.setSort(i);
                umcCreditAttachmentQryBo.setCreateTime(new Date());
                umcCreditAttachmentQryBos.add(umcCreditAttachmentQryBo);
            }
        }
        return umcCreditAttachmentQryBos;
    }

    private void dealOriginal(UmcAdjustCreditApplyInfoReqBo reqBo, UmcPurchaseLimitSubDo rspDo) {
        IUmcPurchaseLimitDo reqDo = this.buildDoByBO(reqBo);
        UmcPurchaseLimitConfigQryBo configQryBoWhere = new UmcPurchaseLimitConfigQryBo();
        configQryBoWhere.setLimitConfigId(reqBo.getLimitConfigId());
        this.iUmcPurchaseLimitModel.updatePurchaseLimitConfig(reqDo, configQryBoWhere);
        UmcPurchaseLimitAmountSubDo amountSubDo = this.buildAmountDo(reqDo);
        UmcPurchaseLimitAmountQryBo amountQryBo = new UmcPurchaseLimitAmountQryBo();
        amountQryBo.setValId(rspDo.getValId());
        this.iUmcPurchaseLimitModel.updatePurchaseLimitAmount(amountSubDo, amountQryBo);
        if (reqBo.getCreditLimit().compareTo(rspDo.getLimitAmount()) != 0) {
            UmcPurchaseLimitHisSubDo hisSubDo = this.buildHisDo(amountSubDo, rspDo);
            hisSubDo.setValId(amountQryBo.getValId());
            this.iUmcPurchaseLimitModel.createPurchaseLimitHis(hisSubDo);
        }
        UmcCreditAllInfoQryBo umcCreditAllInfoQryBo = new UmcCreditAllInfoQryBo();
        umcCreditAllInfoQryBo.setLimitConfigId(rspDo.getLimitConfigId());
        UmcCreditCustomerQryBo umcCreditCustomerQryBo = (UmcCreditCustomerQryBo)UmcRu.js((Object)reqBo.getUmcCreditCustomerApplyBo(), UmcCreditCustomerQryBo.class);
        umcCreditCustomerQryBo.setUpdateOperId(reqBo.getUserId());
        umcCreditCustomerQryBo.setUpdateOperName(reqBo.getName());
        umcCreditCustomerQryBo.setUpdateTime(new Date());
        UmcCreditAccountPeriodQryBo umcCreditAccountPeriodQryBo = (UmcCreditAccountPeriodQryBo)UmcRu.js((Object)reqBo.getUmcCreditAccountPeriodApplyBo(), UmcCreditAccountPeriodQryBo.class);
        umcCreditAccountPeriodQryBo.setUpdateOperId(reqBo.getUserId());
        umcCreditAccountPeriodQryBo.setUpdateOperName(reqBo.getName());
        umcCreditAccountPeriodQryBo.setUpdateTime(new Date());
        if (reqBo.getUmcCreditContractApplyBo() != null) {
            UmcCreditContractQryBo umcCreditContractQryBo = (UmcCreditContractQryBo)UmcRu.js((Object)reqBo.getUmcCreditContractApplyBo(), UmcCreditContractQryBo.class);
            umcCreditContractQryBo.setUpdateOperId(reqBo.getUserId());
            umcCreditContractQryBo.setUpdateOperName(reqBo.getName());
            umcCreditContractQryBo.setUpdateTime(new Date());
            umcCreditAllInfoQryBo.setUmcCreditContractQryBo(umcCreditContractQryBo);
        }
        ArrayList<UmcCreditAttachmentQryBo> umcCreditAttachmentQryBos = new ArrayList<UmcCreditAttachmentQryBo>();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUmcCreditAttachmentBos())) {
            for (int i = 0; i < reqBo.getUmcCreditAttachmentBos().size(); ++i) {
                UmcCreditAttachmentQryBo umcCreditAttachmentQryBo = (UmcCreditAttachmentQryBo)UmcRu.js(reqBo.getUmcCreditAttachmentBos().get(i), UmcCreditAttachmentQryBo.class);
                umcCreditAttachmentQryBo.setAttachmentId(IdUtil.nextId());
                umcCreditAttachmentQryBo.setObjId(umcCreditAllInfoQryBo.getLimitConfigId());
                umcCreditAttachmentQryBo.setObjType(UmcCreditConstants.ObjType.ORIGINAL);
                umcCreditAttachmentQryBo.setSort(i);
                umcCreditAttachmentQryBo.setCreateTime(new Date());
                umcCreditAttachmentQryBos.add(umcCreditAttachmentQryBo);
            }
        }
        umcCreditAllInfoQryBo.setUmcCreditAttachmentQryBos(umcCreditAttachmentQryBos);
        umcCreditAllInfoQryBo.setUmcCreditCustomerQryBo(umcCreditCustomerQryBo);
        umcCreditAllInfoQryBo.setUmcCreditAccountPeriodQryBo(umcCreditAccountPeriodQryBo);
        this.iUmcCreditInfoModel.updateCreditAllInfo(umcCreditAllInfoQryBo);
    }

    private void checkInfo(UmcAdjustCreditApplyInfoReqBo reqBo, UmcPurchaseLimitSubDo rspDo) {
        if (rspDo == null) {
            throw new BaseBusinessException("100001", "\u6ca1\u6709\u67e5\u8be2\u5230\u989d\u5ea6\u4fe1\u606f");
        }
        BigDecimal addLimitAmount = reqBo.getCreditLimit().add(rspDo.getAccumulationAmount());
        if (addLimitAmount.compareTo(rspDo.getPurchaseAmount()) < 0) {
            throw new BaseBusinessException("100001", "\u4fee\u6539\u9650\u989d\u540e\u7684\u53ef\u7528\u989d\u5ea6\u4e0d\u80fd\u5c0f\u4e8e\u5df2\u91c7\u8d2d\u91d1\u989d");
        }
        String redisKey = "UMC_PURCHASE_LIMIT_" + rspDo.getLimitObjType() + "_" + rspDo.getLimitObjCode();
        Long currenNum = this.cacheClient.incrBy(redisKey, 0L);
        BigDecimal currentLimit = BigDecimal.ZERO;
        try {
            currentLimit = MoneyUtils.Long2BigDecimal((Long)currenNum);
        }
        catch (Exception e) {
            throw new BaseBusinessException("100001", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
        if (addLimitAmount.compareTo(currentLimit) < 0) {
            throw new BaseBusinessException("100001", "\u4fee\u6539\u9650\u989d\u540e\u7684\u53ef\u7528\u989d\u5ea6\u4e0d\u80fd\u5c0f\u4e8e\u5df2\u91c7\u8d2d\u91d1\u989d");
        }
    }

    private static UmcCreditContractApplyQryBo buildUmcCreditContractApplyQryBo(UmcAdjustCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        UmcCreditContractApplyQryBo umcCreditContractApplyQryBo = (UmcCreditContractApplyQryBo)UmcRu.js((Object)reqBo.getUmcCreditContractApplyBo(), UmcCreditContractApplyQryBo.class);
        umcCreditContractApplyQryBo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        umcCreditContractApplyQryBo.setCreateOperId(umcCreditApplyInfoQryBo.getCreateOperId());
        umcCreditContractApplyQryBo.setCreateTime(umcCreditApplyInfoQryBo.getCreateTime());
        umcCreditContractApplyQryBo.setCreateOperName(umcCreditApplyInfoQryBo.getCreateOperName());
        umcCreditContractApplyQryBo.setContractId(IdUtil.nextId());
        return umcCreditContractApplyQryBo;
    }

    private static UmcCreditGuarantorApplyQryBo buildUmcCreditGuarantorApplyQryBo(UmcAddCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        UmcCreditGuarantorApplyQryBo umcCreditGuarantorApplyQryBo = new UmcCreditGuarantorApplyQryBo();
        if (reqBo.getUmcCreditGuarantorApplyBo() != null) {
            umcCreditGuarantorApplyQryBo = (UmcCreditGuarantorApplyQryBo)UmcRu.js((Object)reqBo.getUmcCreditGuarantorApplyBo(), UmcCreditGuarantorApplyQryBo.class);
        }
        umcCreditGuarantorApplyQryBo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        umcCreditGuarantorApplyQryBo.setCreateOperId(umcCreditApplyInfoQryBo.getCreateOperId());
        umcCreditGuarantorApplyQryBo.setCreateTime(umcCreditApplyInfoQryBo.getCreateTime());
        umcCreditGuarantorApplyQryBo.setCreateOperName(umcCreditApplyInfoQryBo.getCreateOperName());
        umcCreditGuarantorApplyQryBo.setGuarantorId(IdUtil.nextId());
        return umcCreditGuarantorApplyQryBo;
    }

    private static UmcCreditAccountPeriodApplyQryBo buildUmcCreditAccountPeriodQryBo(UmcAdjustCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        UmcCreditAccountPeriodApplyQryBo umcCreditAccountPeriodApplyQryBo = (UmcCreditAccountPeriodApplyQryBo)UmcRu.js((Object)reqBo.getUmcCreditAccountPeriodApplyBo(), UmcCreditAccountPeriodApplyQryBo.class);
        umcCreditAccountPeriodApplyQryBo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        umcCreditAccountPeriodApplyQryBo.setCreateOperId(umcCreditApplyInfoQryBo.getCreateOperId());
        umcCreditAccountPeriodApplyQryBo.setCreateTime(umcCreditApplyInfoQryBo.getCreateTime());
        umcCreditAccountPeriodApplyQryBo.setCreateOperName(umcCreditApplyInfoQryBo.getCreateOperName());
        umcCreditAccountPeriodApplyQryBo.setAccountPeriodId(IdUtil.nextId());
        umcCreditAccountPeriodApplyQryBo.setCreditLimit(umcCreditApplyInfoQryBo.getCreditLimit());
        return umcCreditAccountPeriodApplyQryBo;
    }

    private static UmcCreditCustomerApplyQryBo buildUmcCreditCustomerApplyQryBo(UmcAdjustCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        UmcCreditCustomerApplyQryBo umcCreditCustomerApplyPo = (UmcCreditCustomerApplyQryBo)UmcRu.js((Object)reqBo.getUmcCreditCustomerApplyBo(), UmcCreditCustomerApplyQryBo.class);
        umcCreditCustomerApplyPo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        umcCreditCustomerApplyPo.setCreateOperId(umcCreditApplyInfoQryBo.getCreateOperId());
        umcCreditCustomerApplyPo.setCreateTime(umcCreditApplyInfoQryBo.getCreateTime());
        umcCreditCustomerApplyPo.setCreateOperName(umcCreditApplyInfoQryBo.getCreateOperName());
        umcCreditCustomerApplyPo.setCustomerId(IdUtil.nextId());
        umcCreditCustomerApplyPo.setOrgId(umcCreditApplyInfoQryBo.getOrgId());
        umcCreditCustomerApplyPo.setOrgName(umcCreditApplyInfoQryBo.getOrgName());
        return umcCreditCustomerApplyPo;
    }

    private static UmcCreditApplyInfoQryBo buildUmcCreditApplyInfoQryBo(UmcAdjustCreditApplyInfoReqBo reqBo, UmcPurchaseLimitSubDo rspDo) {
        UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo = new UmcCreditApplyInfoQryBo();
        Date date = new Date();
        umcCreditApplyInfoQryBo.setApplyId(reqBo.getApplyId());
        umcCreditApplyInfoQryBo.setApplyType("2");
        umcCreditApplyInfoQryBo.setOrgId(Long.valueOf(rspDo.getLimitObjId()));
        umcCreditApplyInfoQryBo.setOrgName(rspDo.getLimitObjName());
        umcCreditApplyInfoQryBo.setIsAffiliate(reqBo.getIsAffiliate());
        umcCreditApplyInfoQryBo.setIsGuarantor(reqBo.getIsGuarantor());
        umcCreditApplyInfoQryBo.setCommitmentLetter(reqBo.getCommitmentLetter());
        umcCreditApplyInfoQryBo.setContractAppendices(reqBo.getContractAppendices());
        umcCreditApplyInfoQryBo.setCreditLimit(reqBo.getCreditLimit());
        umcCreditApplyInfoQryBo.setCreditLimitOld(rspDo.getLimitAmount());
        umcCreditApplyInfoQryBo.setCreateOperId(reqBo.getUserId());
        umcCreditApplyInfoQryBo.setCreateOperName(reqBo.getName());
        umcCreditApplyInfoQryBo.setCreateTime(date);
        umcCreditApplyInfoQryBo.setDelFlag("0");
        umcCreditApplyInfoQryBo.setApplyStatus("3");
        return umcCreditApplyInfoQryBo;
    }

    private UmcPurchaseLimitHisSubDo buildHisDo(UmcPurchaseLimitAmountSubDo reqDo, UmcPurchaseLimitSubDo rspDo) {
        UmcPurchaseLimitHisSubDo hisSubDo = new UmcPurchaseLimitHisSubDo();
        hisSubDo.setChngType("modify");
        hisSubDo.setValId(rspDo.getValId());
        hisSubDo.setLimitConfigId(rspDo.getLimitConfigId());
        hisSubDo.setLimitYear(rspDo.getLimitYear());
        hisSubDo.setChngRemark("\u5df2\u6388\u6388\u4fe1\u989d\u5ea6");
        BigDecimal beforMoney = rspDo.getLimitAmount().subtract(rspDo.getPurchaseAmount());
        BigDecimal afterMoney = reqDo.getLimitAmount().subtract(rspDo.getPurchaseAmount());
        hisSubDo.setPurchaseAmountBefore(beforMoney);
        hisSubDo.setChngPurchaseAmount(afterMoney.subtract(beforMoney));
        hisSubDo.setPurchaseAmountAfter(afterMoney);
        hisSubDo.setCreateOperId(reqDo.getUpdateOperId());
        hisSubDo.setCreateOperName(reqDo.getUpdateOperName());
        hisSubDo.setCreateTime(reqDo.getUpdateTime());
        hisSubDo.setHisId(IdUtil.nextId());
        return hisSubDo;
    }

    private UmcPurchaseLimitAmountSubDo buildAmountDo(IUmcPurchaseLimitDo reqDo) {
        UmcPurchaseLimitAmountSubDo amountSubDo = new UmcPurchaseLimitAmountSubDo();
        amountSubDo.setLimitAmount(reqDo.getLimitAmount());
        amountSubDo.setUpdateOperId(reqDo.getUpdateOperId());
        amountSubDo.setUpdateOperName(reqDo.getUpdateOperName());
        amountSubDo.setUpdateTime(reqDo.getUpdateTime());
        amountSubDo.setCreateOperId(reqDo.getCreateOperId());
        amountSubDo.setCreateOperName(reqDo.getCreateOperName());
        return amountSubDo;
    }

    private IUmcPurchaseLimitDo buildDoByBO(UmcAdjustCreditApplyInfoReqBo reqBo) {
        IUmcPurchaseLimitDo reqDo = new IUmcPurchaseLimitDo();
        reqDo.setLimitConfigId(reqBo.getLimitConfigId());
        reqDo.setLimitAmount(reqBo.getCreditLimit());
        reqDo.setUpdateOperId(reqBo.getUserId());
        reqDo.setUpdateOperName(reqBo.getName());
        reqDo.setUpdateTime(new Date());
        reqDo.setExtField3(reqBo.getCommitmentLetter());
        return reqDo;
    }

    private void validate(UmcAdjustCreditApplyInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getLimitConfigId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u989d\u5ea6id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getApplyType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u7533\u8bf7\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getCreditLimit() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u6388\u4fe1\u989d\u5ea6]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUmcCreditCustomerApplyBo() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u6388\u4fe1\u989d\u5ea6\u5ba2\u6237\u57fa\u672c\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUmcCreditAccountPeriodApplyBo() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u8d26\u671f\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

