/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.creditApply;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCreditConstants;
import com.tydic.dyc.umc.model.credit.IUmcCreditInfoModel;
import com.tydic.dyc.umc.model.credit.qrybo.UmcCreditAccountPeriodQryBo;
import com.tydic.dyc.umc.model.credit.qrybo.UmcCreditAllInfoQryBo;
import com.tydic.dyc.umc.model.credit.qrybo.UmcCreditContractQryBo;
import com.tydic.dyc.umc.model.credit.qrybo.UmcCreditCustomerQryBo;
import com.tydic.dyc.umc.model.creditApply.IUmcCreditApplyInfoModel;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditAccountPeriodApplyQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditApplyInfoQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditAttachmentQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditContractApplyQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditCustomerApplyQryBo;
import com.tydic.dyc.umc.model.creditApply.sub.UmcCreditAttachmentSubDo;
import com.tydic.dyc.umc.model.creditApply.sub.UmcCreditInfoApplySubDo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitDo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitAmountQryBo;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitConfigQryBo;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitAmountSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitHisSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitSubDo;
import com.tydic.dyc.umc.service.creditApply.UmcCreditAdjustApprovalCallBackService;
import com.tydic.dyc.umc.service.creditApply.bo.UmcCreditAdjustApprovalCallBackReqBo;
import com.tydic.dyc.umc.service.creditApply.bo.UmcCreditAdjustApprovalCallBackRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.creditApply.UmcCreditAdjustApprovalCallBackService"})
public class UmcCreditAdjustApprovalCallBackServiceImpl
implements UmcCreditAdjustApprovalCallBackService {
    private static final Logger log = LoggerFactory.getLogger(UmcCreditAdjustApprovalCallBackServiceImpl.class);
    @Autowired
    private IUmcCreditApplyInfoModel iUmcCreditApplyInfoModel;
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;
    @Autowired
    private IUmcCreditInfoModel iUmcCreditInfoModel;

    @PostMapping(value={"saveAdjustApprovalCallBack"})
    public UmcCreditAdjustApprovalCallBackRspBo saveAdjustApprovalCallBack(@RequestBody UmcCreditAdjustApprovalCallBackReqBo reqBo) {
        UmcCreditAdjustApprovalCallBackRspBo rspBo = (UmcCreditAdjustApprovalCallBackRspBo)UmcRu.success(UmcCreditAdjustApprovalCallBackRspBo.class);
        this.validate(reqBo);
        UmcCreditInfoApplySubDo qryBo = this.getUmcCreditApplyInfoQryBo(reqBo);
        reqBo.setUserId(qryBo.getCreateOperId());
        reqBo.setName(qryBo.getCreateOperName());
        UmcPurchaseLimitQryBo configQryBo = new UmcPurchaseLimitQryBo();
        configQryBo.setLimitObjId(qryBo.getOrgId().toString());
        configQryBo.setLimitObjType("EXT");
        configQryBo.setExtField1("1");
        UmcPurchaseLimitSubDo rspDo = this.iUmcPurchaseLimitModel.getPurchaseLimitDetail(configQryBo);
        if (rspDo == null) {
            throw new BaseBusinessException("100001", "\u9650\u989d\u6570\u636e\u4e0d\u5b58\u5728");
        }
        UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo = new UmcCreditApplyInfoQryBo();
        umcCreditApplyInfoQryBo.setApplyId(reqBo.getApplyId());
        umcCreditApplyInfoQryBo.setUpdateTime(new Date());
        umcCreditApplyInfoQryBo.setUpdateOperId(reqBo.getUserId());
        umcCreditApplyInfoQryBo.setUpdateOperName(reqBo.getName());
        if ("1".equals(reqBo.getApproval())) {
            umcCreditApplyInfoQryBo.setApplyStatus("5");
            this.dealLimit(reqBo, qryBo, rspDo);
            UmcCreditCustomerApplyQryBo qryUmcCreditCustomerApply = new UmcCreditCustomerApplyQryBo();
            qryUmcCreditCustomerApply.setApplyId(reqBo.getApplyId());
            UmcCreditCustomerApplyQryBo umcCreditCustomerApplyQryBo = this.iUmcCreditApplyInfoModel.qryCreditCustomerApply(qryUmcCreditCustomerApply);
            UmcCreditAccountPeriodApplyQryBo qryUmcCreditAccountPeriodApply = new UmcCreditAccountPeriodApplyQryBo();
            qryUmcCreditAccountPeriodApply.setApplyId(reqBo.getApplyId());
            UmcCreditAccountPeriodApplyQryBo umcCreditAccountPeriodApplyQryBo = this.iUmcCreditApplyInfoModel.qryCreditAccountPeriodApply(qryUmcCreditAccountPeriodApply);
            UmcCreditContractApplyQryBo qryUmcCreditContractApply = new UmcCreditContractApplyQryBo();
            qryUmcCreditContractApply.setApplyId(reqBo.getApplyId());
            UmcCreditContractApplyQryBo umcCreditContractApplyQryBo = this.iUmcCreditApplyInfoModel.qryCreditContractApply(qryUmcCreditContractApply);
            UmcCreditAttachmentQryBo umcCreditAttachmentQryBo = new UmcCreditAttachmentQryBo();
            umcCreditAttachmentQryBo.setObjId(reqBo.getApplyId());
            umcCreditAttachmentQryBo.setObjType(UmcCreditConstants.ObjType.APPROVE);
            umcCreditAttachmentQryBo.setOrderBy("sort asc");
            List<UmcCreditAttachmentSubDo> umcCreditAttachmentSubDos = this.iUmcCreditApplyInfoModel.qryCreditAttachmentList(umcCreditAttachmentQryBo);
            UmcCreditAllInfoQryBo umcCreditAllInfoQryBo = new UmcCreditAllInfoQryBo();
            umcCreditAllInfoQryBo.setLimitConfigId(rspDo.getLimitConfigId());
            UmcCreditCustomerQryBo umcCreditCustomerQryBo = (UmcCreditCustomerQryBo)UmcRu.js((Object)umcCreditCustomerApplyQryBo, UmcCreditCustomerQryBo.class);
            umcCreditCustomerQryBo.setUpdateTime(umcCreditApplyInfoQryBo.getUpdateTime());
            umcCreditCustomerQryBo.setUpdateOperId(umcCreditApplyInfoQryBo.getUpdateOperId());
            umcCreditCustomerQryBo.setUpdateOperName(umcCreditApplyInfoQryBo.getUpdateOperName());
            umcCreditAllInfoQryBo.setUmcCreditCustomerQryBo(umcCreditCustomerQryBo);
            UmcCreditAccountPeriodQryBo umcCreditAccountPeriodQryBo = (UmcCreditAccountPeriodQryBo)UmcRu.js((Object)umcCreditAccountPeriodApplyQryBo, UmcCreditAccountPeriodQryBo.class);
            umcCreditAccountPeriodQryBo.setUpdateTime(umcCreditApplyInfoQryBo.getUpdateTime());
            umcCreditAccountPeriodQryBo.setUpdateOperId(umcCreditApplyInfoQryBo.getUpdateOperId());
            umcCreditAccountPeriodQryBo.setUpdateOperName(umcCreditApplyInfoQryBo.getUpdateOperName());
            umcCreditAllInfoQryBo.setUmcCreditAccountPeriodQryBo(umcCreditAccountPeriodQryBo);
            if (umcCreditContractApplyQryBo != null) {
                UmcCreditContractQryBo umcCreditContractQryBo = (UmcCreditContractQryBo)UmcRu.js((Object)umcCreditContractApplyQryBo, UmcCreditContractQryBo.class);
                umcCreditContractQryBo.setUpdateTime(umcCreditApplyInfoQryBo.getUpdateTime());
                umcCreditContractQryBo.setUpdateOperId(umcCreditApplyInfoQryBo.getUpdateOperId());
                umcCreditContractQryBo.setUpdateOperName(umcCreditApplyInfoQryBo.getUpdateOperName());
                umcCreditAllInfoQryBo.setUmcCreditContractQryBo(umcCreditContractQryBo);
            }
            ArrayList<UmcCreditAttachmentQryBo> umcCreditAttachmentQryBos = new ArrayList<UmcCreditAttachmentQryBo>();
            for (UmcCreditAttachmentSubDo umcCreditAttachmentSubDo : umcCreditAttachmentSubDos) {
                UmcCreditAttachmentQryBo addUmcCreditAttachmentQryBo = (UmcCreditAttachmentQryBo)UmcRu.js((Object)umcCreditAttachmentSubDo, UmcCreditAttachmentQryBo.class);
                addUmcCreditAttachmentQryBo.setAttachmentId(IdUtil.nextId());
                addUmcCreditAttachmentQryBo.setObjId(rspDo.getLimitConfigId());
                addUmcCreditAttachmentQryBo.setObjType(UmcCreditConstants.ObjType.ORIGINAL);
                umcCreditAttachmentQryBos.add(addUmcCreditAttachmentQryBo);
            }
            umcCreditAllInfoQryBo.setUmcCreditAttachmentQryBos(umcCreditAttachmentQryBos);
            try {
                this.iUmcCreditInfoModel.updateCreditAllInfo(umcCreditAllInfoQryBo);
            }
            catch (Exception e) {
                log.debug("\u66f4\u65b0\u6388\u4fe1\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)e.getMessage());
                throw new BaseBusinessException("100001", "\u66f4\u65b0\u6388\u4fe1\u4fe1\u606f\u5931\u8d25");
            }
        } else if ("2".equals(reqBo.getApproval())) {
            umcCreditApplyInfoQryBo.setApplyStatus("6");
        } else {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[approval]\u4e0d\u5408\u6cd5");
        }
        UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBoWhere = new UmcCreditApplyInfoQryBo();
        umcCreditApplyInfoQryBoWhere.setApplyId(reqBo.getApplyId());
        this.iUmcCreditApplyInfoModel.updateCreditApplyInfo(umcCreditApplyInfoQryBo, umcCreditApplyInfoQryBoWhere);
        return rspBo;
    }

    private void dealLimit(UmcCreditAdjustApprovalCallBackReqBo reqBo, UmcCreditInfoApplySubDo qryBo, UmcPurchaseLimitSubDo rspDo) {
        IUmcPurchaseLimitDo reqDo = new IUmcPurchaseLimitDo();
        reqDo.setLimitConfigId(rspDo.getLimitConfigId());
        reqDo.setExtField3(qryBo.getCommitmentLetter());
        reqDo.setLimitAmount(qryBo.getCreditLimit());
        reqDo.setContractCreditLimit(qryBo.getCreditLimit());
        reqDo.setUpdateOperName(reqBo.getName());
        reqDo.setUpdateOperId(reqBo.getUserId());
        reqDo.setUpdateTime(new Date());
        UmcPurchaseLimitConfigQryBo configQryBoWhere = new UmcPurchaseLimitConfigQryBo();
        configQryBoWhere.setLimitConfigId(rspDo.getLimitConfigId());
        this.iUmcPurchaseLimitModel.updatePurchaseLimitConfig(reqDo, configQryBoWhere);
        UmcPurchaseLimitAmountSubDo amountSubDo = this.buildAmountDo(reqDo);
        UmcPurchaseLimitAmountQryBo amountQryBo = new UmcPurchaseLimitAmountQryBo();
        amountQryBo.setValId(rspDo.getValId());
        this.iUmcPurchaseLimitModel.updatePurchaseLimitAmount(amountSubDo, amountQryBo);
        UmcPurchaseLimitHisSubDo hisSubDo = this.buildHisDo(amountSubDo, rspDo);
        hisSubDo.setValId(amountQryBo.getValId());
        this.iUmcPurchaseLimitModel.createPurchaseLimitHis(hisSubDo);
    }

    private UmcCreditInfoApplySubDo getUmcCreditApplyInfoQryBo(UmcCreditAdjustApprovalCallBackReqBo reqBo) {
        UmcCreditApplyInfoQryBo qryUmcCreditApplyInfoQryBo = new UmcCreditApplyInfoQryBo();
        qryUmcCreditApplyInfoQryBo.setApplyId(reqBo.getApplyId());
        UmcCreditInfoApplySubDo qryBo = this.iUmcCreditApplyInfoModel.qryCreditApplyDetailInfo(qryUmcCreditApplyInfoQryBo);
        if (qryBo == null) {
            throw new BaseBusinessException("100001", "\u5ba1\u6279\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (!"4".equals(qryBo.getApplyStatus())) {
            throw new BaseBusinessException("100001", "\u5ba1\u6279\u72b6\u6001\u4e0d\u662f\u5f85\u5ba1\u6279");
        }
        return qryBo;
    }

    private UmcPurchaseLimitHisSubDo buildHisDo(UmcPurchaseLimitAmountSubDo reqDo, UmcPurchaseLimitSubDo rspDo) {
        UmcPurchaseLimitHisSubDo hisSubDo = new UmcPurchaseLimitHisSubDo();
        hisSubDo.setChngType("modify");
        hisSubDo.setValId(rspDo.getValId());
        hisSubDo.setLimitConfigId(rspDo.getLimitConfigId());
        hisSubDo.setLimitYear(rspDo.getLimitYear());
        hisSubDo.setChngRemark("\u5df2\u6388\u6388\u4fe1\u989d\u5ea6");
        BigDecimal beforMoney = rspDo.getLimitAmount().subtract(rspDo.getPurchaseAmount());
        BigDecimal afterMoney = reqDo.getLimitAmount().subtract(rspDo.getPurchaseAmount());
        hisSubDo.setPurchaseAmountBefore(beforMoney);
        hisSubDo.setChngPurchaseAmount(afterMoney.subtract(beforMoney));
        hisSubDo.setPurchaseAmountAfter(afterMoney);
        hisSubDo.setCreateOperId(reqDo.getUpdateOperId());
        hisSubDo.setCreateOperName(reqDo.getUpdateOperName());
        hisSubDo.setCreateTime(reqDo.getUpdateTime());
        hisSubDo.setHisId(IdUtil.nextId());
        return hisSubDo;
    }

    private UmcPurchaseLimitAmountSubDo buildAmountDo(IUmcPurchaseLimitDo reqDo) {
        UmcPurchaseLimitAmountSubDo amountSubDo = new UmcPurchaseLimitAmountSubDo();
        amountSubDo.setLimitAmount(reqDo.getLimitAmount());
        amountSubDo.setUpdateOperId(reqDo.getUpdateOperId());
        amountSubDo.setUpdateOperName(reqDo.getUpdateOperName());
        amountSubDo.setUpdateTime(reqDo.getUpdateTime());
        amountSubDo.setCreateOperId(reqDo.getCreateOperId());
        amountSubDo.setCreateOperName(reqDo.getCreateOperName());
        return amountSubDo;
    }

    private void validate(UmcCreditAdjustApprovalCallBackReqBo reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getApplyId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[applyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getApproval())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[approval]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

