/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.creditApply;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCreditConstants;
import com.tydic.dyc.umc.model.creditApply.IUmcCreditApplyInfoModel;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditAccountPeriodApplyQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditApplyAllInfoQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditApplyInfoQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditAttachmentQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditContractApplyQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditCustomerApplyQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditGuarantorApplyQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditInvoiceInfoApplyQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditRelatedCustomerApplyQryBo;
import com.tydic.dyc.umc.model.creditApply.sub.UmcCreditInfoApplySubDo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitDo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitConfigQryBo;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitSubDo;
import com.tydic.dyc.umc.service.creditApply.UmcUpdateCreditApplyInfoService;
import com.tydic.dyc.umc.service.creditApply.bo.UmcUpdateCreditApplyInfoReqBo;
import com.tydic.dyc.umc.service.creditApply.bo.UmcUpdateCreditApplyInfoRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.creditApply.UmcUpdateCreditApplyInfoService"})
public class UmcUpdateCreditApplyInfoServiceImpl
implements UmcUpdateCreditApplyInfoService {
    private static final Logger log = LoggerFactory.getLogger(UmcUpdateCreditApplyInfoServiceImpl.class);
    @Autowired
    private IUmcCreditApplyInfoModel iUmcCreditApplyInfoModel;
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;

    @PostMapping(value={"updateCreditApplyInfo"})
    public UmcUpdateCreditApplyInfoRspBo updateCreditApplyInfo(@RequestBody UmcUpdateCreditApplyInfoReqBo reqBo) {
        UmcUpdateCreditApplyInfoRspBo rspBo = (UmcUpdateCreditApplyInfoRspBo)UmcRu.success(UmcUpdateCreditApplyInfoRspBo.class);
        this.validate(reqBo);
        UmcCreditInfoApplySubDo applyInfoQryBo = this.checkInfo(reqBo);
        UmcCreditApplyAllInfoQryBo umcCreditApplyAllInfoQryBo = new UmcCreditApplyAllInfoQryBo();
        UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo = UmcUpdateCreditApplyInfoServiceImpl.buildUmcCreditApplyInfoQryBo(reqBo);
        UmcCreditCustomerApplyQryBo umcCreditCustomerApplyPo = UmcUpdateCreditApplyInfoServiceImpl.buildUmcCreditCustomerApplyQryBo(reqBo, umcCreditApplyInfoQryBo);
        UmcCreditAccountPeriodApplyQryBo umcCreditAccountPeriodApplyQryBo = UmcUpdateCreditApplyInfoServiceImpl.buildUmcCreditAccountPeriodQryBo(reqBo, umcCreditApplyInfoQryBo);
        UmcCreditGuarantorApplyQryBo umcCreditGuarantorApplyQryBo = UmcUpdateCreditApplyInfoServiceImpl.buildUmcCreditGuarantorApplyQryBo(reqBo, umcCreditApplyInfoQryBo);
        List<UmcCreditRelatedCustomerApplyQryBo> umcCreditRelatedCustomerApplyQryBos = UmcUpdateCreditApplyInfoServiceImpl.buildUmcCreditRelatedCustomerApplyQryBos(reqBo, umcCreditApplyInfoQryBo);
        UmcCreditContractApplyQryBo umcCreditContractApplyQryBo = UmcUpdateCreditApplyInfoServiceImpl.buildUmcCreditContractApplyQryBo(reqBo, umcCreditApplyInfoQryBo);
        UmcCreditInvoiceInfoApplyQryBo umcCreditInvoiceInfoApplyQryBo = UmcUpdateCreditApplyInfoServiceImpl.buildUmcCreditInvoiceInfoApplyQryBo(reqBo, umcCreditApplyInfoQryBo);
        List<UmcCreditAttachmentQryBo> umcCreditAttachmentQryBos = UmcUpdateCreditApplyInfoServiceImpl.buildUmcCreditAttachmentQryBos(reqBo, umcCreditApplyInfoQryBo);
        umcCreditApplyAllInfoQryBo.setUmcCreditRelatedCustomerApplyQryBos(umcCreditRelatedCustomerApplyQryBos);
        umcCreditApplyAllInfoQryBo.setUmcCreditContractApplyQryBo(umcCreditContractApplyQryBo);
        umcCreditApplyAllInfoQryBo.setUmcCreditApplyInfoQryBo(umcCreditApplyInfoQryBo);
        umcCreditApplyAllInfoQryBo.setUmcCreditCustomerApplyQryBo(umcCreditCustomerApplyPo);
        umcCreditApplyAllInfoQryBo.setUmcCreditAccountPeriodApplyQryBo(umcCreditAccountPeriodApplyQryBo);
        umcCreditApplyAllInfoQryBo.setUmcCreditGuarantorApplyQryBo(umcCreditGuarantorApplyQryBo);
        umcCreditApplyAllInfoQryBo.setUmcCreditInvoiceInfoApplyQryBo(umcCreditInvoiceInfoApplyQryBo);
        umcCreditApplyAllInfoQryBo.setUmcCreditAttachmentQryBos(umcCreditAttachmentQryBos);
        try {
            this.iUmcCreditApplyInfoModel.updateCreditApplyAllInfo(umcCreditApplyAllInfoQryBo);
        }
        catch (Exception e) {
            log.debug("\u4fee\u6539\u6388\u4fe1\u5931\u8d25{}", (Object)e.getMessage());
            throw new BaseBusinessException("100001", "\u4fee\u6539\u6388\u4fe1\u5931\u8d25");
        }
        this.updateLimit(applyInfoQryBo, umcCreditApplyInfoQryBo);
        rspBo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        return rspBo;
    }

    private static List<UmcCreditAttachmentQryBo> buildUmcCreditAttachmentQryBos(UmcUpdateCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        ArrayList<UmcCreditAttachmentQryBo> umcCreditAttachmentQryBos = new ArrayList<UmcCreditAttachmentQryBo>();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUmcCreditAttachmentBos())) {
            for (int i = 0; i < reqBo.getUmcCreditAttachmentBos().size(); ++i) {
                UmcCreditAttachmentQryBo umcCreditAttachmentQryBo = (UmcCreditAttachmentQryBo)UmcRu.js(reqBo.getUmcCreditAttachmentBos().get(i), UmcCreditAttachmentQryBo.class);
                umcCreditAttachmentQryBo.setAttachmentId(IdUtil.nextId());
                umcCreditAttachmentQryBo.setObjId(umcCreditApplyInfoQryBo.getApplyId());
                umcCreditAttachmentQryBo.setObjType(UmcCreditConstants.ObjType.APPROVE);
                umcCreditAttachmentQryBo.setSort(i);
                umcCreditAttachmentQryBo.setCreateTime(new Date());
                umcCreditAttachmentQryBos.add(umcCreditAttachmentQryBo);
            }
        }
        return umcCreditAttachmentQryBos;
    }

    private static List<UmcCreditRelatedCustomerApplyQryBo> buildUmcCreditRelatedCustomerApplyQryBos(UmcUpdateCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        List<UmcCreditRelatedCustomerApplyQryBo> umcCreditRelatedCustomerApplyQryBos = new ArrayList<UmcCreditRelatedCustomerApplyQryBo>();
        if (!com.alibaba.nacos.client.naming.utils.CollectionUtils.isEmpty((Collection)reqBo.getUmcCreditRelatedCustomerApplyBos())) {
            umcCreditRelatedCustomerApplyQryBos = UmcRu.jsl((List)reqBo.getUmcCreditRelatedCustomerApplyBos(), UmcCreditRelatedCustomerApplyQryBo.class);
            for (UmcCreditRelatedCustomerApplyQryBo each : umcCreditRelatedCustomerApplyQryBos) {
                each.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
                each.setCreateOperId(umcCreditApplyInfoQryBo.getCreateOperId());
                each.setCreateTime(umcCreditApplyInfoQryBo.getCreateTime());
                each.setCreateOperName(umcCreditApplyInfoQryBo.getCreateOperName());
                each.setRelatedCustomerId(IdUtil.nextId());
            }
        }
        return umcCreditRelatedCustomerApplyQryBos;
    }

    private static UmcCreditInvoiceInfoApplyQryBo buildUmcCreditInvoiceInfoApplyQryBo(UmcUpdateCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        UmcCreditInvoiceInfoApplyQryBo umcCreditInvoiceInfoApplyQryBo = new UmcCreditInvoiceInfoApplyQryBo();
        if (reqBo.getUmcCreditInvoiceInfoApplyBo() != null) {
            umcCreditInvoiceInfoApplyQryBo = (UmcCreditInvoiceInfoApplyQryBo)UmcRu.js((Object)reqBo.getUmcCreditInvoiceInfoApplyBo(), UmcCreditInvoiceInfoApplyQryBo.class);
        }
        umcCreditInvoiceInfoApplyQryBo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        umcCreditInvoiceInfoApplyQryBo.setUpdateOperId(umcCreditApplyInfoQryBo.getUpdateOperId());
        umcCreditInvoiceInfoApplyQryBo.setUpdateTime(umcCreditApplyInfoQryBo.getUpdateTime());
        umcCreditInvoiceInfoApplyQryBo.setUpdateOperName(umcCreditApplyInfoQryBo.getUpdateOperName());
        umcCreditInvoiceInfoApplyQryBo.setOrgId(umcCreditApplyInfoQryBo.getOrgId());
        umcCreditInvoiceInfoApplyQryBo.setInvoiceId(null);
        return umcCreditInvoiceInfoApplyQryBo;
    }

    private void updateLimit(UmcCreditInfoApplySubDo applyInfoQryBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        UmcPurchaseLimitQryBo configQryBo = new UmcPurchaseLimitQryBo();
        configQryBo.setLimitObjId(applyInfoQryBo.getOrgId().toString());
        configQryBo.setLimitObjType("EXT");
        configQryBo.setExtField1("1");
        UmcPurchaseLimitSubDo rspDo = this.iUmcPurchaseLimitModel.getPurchaseLimitDetail(configQryBo);
        if (rspDo == null) {
            throw new BaseBusinessException("100001", "\u989d\u5ea6\u8868\u67e5\u8be2\u4e3a\u7a7a");
        }
        IUmcPurchaseLimitDo configQryBoSet = new IUmcPurchaseLimitDo();
        configQryBoSet.setLimitConfigId(rspDo.getLimitConfigId());
        configQryBoSet.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        configQryBoSet.setLimitAmount(umcCreditApplyInfoQryBo.getCreditLimit());
        configQryBoSet.setContractCreditLimit(umcCreditApplyInfoQryBo.getCreditLimit());
        UmcPurchaseLimitConfigQryBo configQryBoWhere = new UmcPurchaseLimitConfigQryBo();
        configQryBoWhere.setLimitConfigId(rspDo.getLimitConfigId());
        try {
            this.iUmcPurchaseLimitModel.updatePurchaseLimitConfig(configQryBoSet, configQryBoWhere);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u989d\u5ea6\u914d\u7f6e\u8868\u5931\u8d25{}", (Object)e.getMessage());
            throw new BaseBusinessException("100001", "\u4fee\u6539\u989d\u5ea6\u914d\u7f6e\u8868\u5931\u8d25");
        }
    }

    private UmcCreditInfoApplySubDo checkInfo(UmcUpdateCreditApplyInfoReqBo reqBo) {
        UmcCreditApplyInfoQryBo qryBo = new UmcCreditApplyInfoQryBo();
        qryBo.setApplyId(reqBo.getApplyId());
        UmcCreditInfoApplySubDo umcCreditInfoApplySubDo = this.iUmcCreditApplyInfoModel.qryCreditApplyDetailInfo(qryBo);
        if (umcCreditInfoApplySubDo == null) {
            throw new BaseBusinessException("100001", "\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u6388\u4fe1\u4fe1\u606f");
        }
        if (!"2".equals(umcCreditInfoApplySubDo.getApplyStatus())) {
            throw new BaseBusinessException("100001", "\u8be5\u6761\u6388\u4fe1\u5df2\u7ecf\u4e0d\u662f\u8349\u7a3f\u72b6\u6001\u4e86\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
        return umcCreditInfoApplySubDo;
    }

    private static UmcCreditContractApplyQryBo buildUmcCreditContractApplyQryBo(UmcUpdateCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        UmcCreditContractApplyQryBo umcCreditContractApplyQryBo = new UmcCreditContractApplyQryBo();
        if (reqBo.getUmcCreditContractApplyBo() != null) {
            umcCreditContractApplyQryBo = (UmcCreditContractApplyQryBo)UmcRu.js((Object)reqBo.getUmcCreditContractApplyBo(), UmcCreditContractApplyQryBo.class);
        }
        umcCreditContractApplyQryBo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        umcCreditContractApplyQryBo.setUpdateOperId(umcCreditApplyInfoQryBo.getUpdateOperId());
        umcCreditContractApplyQryBo.setUpdateTime(umcCreditApplyInfoQryBo.getUpdateTime());
        umcCreditContractApplyQryBo.setUpdateOperName(umcCreditApplyInfoQryBo.getUpdateOperName());
        return umcCreditContractApplyQryBo;
    }

    private static UmcCreditGuarantorApplyQryBo buildUmcCreditGuarantorApplyQryBo(UmcUpdateCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        UmcCreditGuarantorApplyQryBo umcCreditGuarantorApplyQryBo = new UmcCreditGuarantorApplyQryBo();
        if (reqBo.getUmcCreditGuarantorApplyBo() != null) {
            umcCreditGuarantorApplyQryBo = (UmcCreditGuarantorApplyQryBo)UmcRu.js((Object)reqBo.getUmcCreditGuarantorApplyBo(), UmcCreditGuarantorApplyQryBo.class);
        }
        umcCreditGuarantorApplyQryBo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        umcCreditGuarantorApplyQryBo.setUpdateOperId(umcCreditApplyInfoQryBo.getUpdateOperId());
        umcCreditGuarantorApplyQryBo.setUpdateTime(umcCreditApplyInfoQryBo.getUpdateTime());
        umcCreditGuarantorApplyQryBo.setUpdateOperName(umcCreditApplyInfoQryBo.getUpdateOperName());
        return umcCreditGuarantorApplyQryBo;
    }

    private static UmcCreditAccountPeriodApplyQryBo buildUmcCreditAccountPeriodQryBo(UmcUpdateCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        UmcCreditAccountPeriodApplyQryBo umcCreditAccountPeriodApplyQryBo = new UmcCreditAccountPeriodApplyQryBo();
        if (reqBo.getUmcCreditAccountPeriodApplyBo() != null) {
            umcCreditAccountPeriodApplyQryBo = (UmcCreditAccountPeriodApplyQryBo)UmcRu.js((Object)reqBo.getUmcCreditAccountPeriodApplyBo(), UmcCreditAccountPeriodApplyQryBo.class);
        }
        umcCreditAccountPeriodApplyQryBo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        umcCreditAccountPeriodApplyQryBo.setUpdateOperId(umcCreditApplyInfoQryBo.getUpdateOperId());
        umcCreditAccountPeriodApplyQryBo.setUpdateTime(umcCreditApplyInfoQryBo.getUpdateTime());
        umcCreditAccountPeriodApplyQryBo.setUpdateOperName(umcCreditApplyInfoQryBo.getUpdateOperName());
        umcCreditAccountPeriodApplyQryBo.setCreditLimit(umcCreditApplyInfoQryBo.getCreditLimit());
        return umcCreditAccountPeriodApplyQryBo;
    }

    private static UmcCreditCustomerApplyQryBo buildUmcCreditCustomerApplyQryBo(UmcUpdateCreditApplyInfoReqBo reqBo, UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo) {
        UmcCreditCustomerApplyQryBo umcCreditCustomerApplyPo = new UmcCreditCustomerApplyQryBo();
        if (reqBo.getUmcCreditCustomerApplyBo() != null) {
            umcCreditCustomerApplyPo = (UmcCreditCustomerApplyQryBo)UmcRu.js((Object)reqBo.getUmcCreditCustomerApplyBo(), UmcCreditCustomerApplyQryBo.class);
        }
        umcCreditCustomerApplyPo.setApplyId(umcCreditApplyInfoQryBo.getApplyId());
        umcCreditCustomerApplyPo.setUpdateOperId(umcCreditApplyInfoQryBo.getUpdateOperId());
        umcCreditCustomerApplyPo.setUpdateOperName(umcCreditApplyInfoQryBo.getUpdateOperName());
        umcCreditCustomerApplyPo.setUpdateTime(umcCreditApplyInfoQryBo.getUpdateTime());
        return umcCreditCustomerApplyPo;
    }

    private static UmcCreditApplyInfoQryBo buildUmcCreditApplyInfoQryBo(UmcUpdateCreditApplyInfoReqBo reqBo) {
        UmcCreditApplyInfoQryBo umcCreditApplyInfoQryBo = new UmcCreditApplyInfoQryBo();
        Date date = new Date();
        umcCreditApplyInfoQryBo.setApplyId(reqBo.getApplyId());
        umcCreditApplyInfoQryBo.setIsAffiliate(reqBo.getIsAffiliate());
        umcCreditApplyInfoQryBo.setIsGuarantor(reqBo.getIsGuarantor());
        umcCreditApplyInfoQryBo.setCommitmentLetter(reqBo.getCommitmentLetter());
        umcCreditApplyInfoQryBo.setContractAppendices(reqBo.getContractAppendices());
        umcCreditApplyInfoQryBo.setCreditLimit(reqBo.getCreditLimit());
        umcCreditApplyInfoQryBo.setCreditLimitOld(reqBo.getCreditLimit());
        umcCreditApplyInfoQryBo.setUpdateOperId(reqBo.getUserId());
        umcCreditApplyInfoQryBo.setUpdateOperName(reqBo.getName());
        umcCreditApplyInfoQryBo.setUpdateTime(date);
        if ("1".equals(reqBo.getOperType())) {
            umcCreditApplyInfoQryBo.setApplyStatus("2");
        } else if ("2".equals(reqBo.getOperType())) {
            umcCreditApplyInfoQryBo.setApplyStatus("3");
        } else {
            throw new BaseBusinessException("100001", "\u4f20\u5165\u7684\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5bf9");
        }
        return umcCreditApplyInfoQryBo;
    }

    private void validate(UmcUpdateCreditApplyInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getApplyId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u7533\u8bf7\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getApplyType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u7533\u8bf7\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOperType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u64cd\u4f5c\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

