/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.creditApply;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.creditApply.IUmcCreditApplyInfoModel;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditApplyInfoQryBo;
import com.tydic.dyc.umc.model.creditApply.sub.UmcCreditInfoApplySubDo;
import com.tydic.dyc.umc.service.creditApply.UmcUpdateCreditApplyStatusService;
import com.tydic.dyc.umc.service.creditApply.bo.UmcUpdateCreditApplyStatusReqBo;
import com.tydic.dyc.umc.service.creditApply.bo.UmcUpdateCreditApplyStatusRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.creditApply.UmcUpdateCreditApplyStatusService"})
public class UmcUpdateCreditApplyStatusServiceImpl
implements UmcUpdateCreditApplyStatusService {
    private static final Logger log = LoggerFactory.getLogger(UmcUpdateCreditApplyStatusServiceImpl.class);
    @Autowired
    private IUmcCreditApplyInfoModel iUmcCreditApplyInfoModel;

    @PostMapping(value={"updateCreditApplyStatus"})
    public UmcUpdateCreditApplyStatusRspBo updateCreditApplyStatus(@RequestBody UmcUpdateCreditApplyStatusReqBo reqBo) {
        UmcUpdateCreditApplyStatusRspBo rspBo = (UmcUpdateCreditApplyStatusRspBo)UmcRu.success(UmcUpdateCreditApplyStatusRspBo.class);
        this.validate(reqBo);
        UmcCreditApplyInfoQryBo qryBo = new UmcCreditApplyInfoQryBo();
        qryBo.setApplyId(reqBo.getApplyId());
        UmcCreditInfoApplySubDo umcCreditInfoApplySubDo = this.iUmcCreditApplyInfoModel.qryCreditApplyDetailInfo(qryBo);
        if (umcCreditInfoApplySubDo == null) {
            throw new BaseBusinessException("100001", "\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u6388\u4fe1\u4fe1\u606f");
        }
        UmcCreditApplyInfoQryBo umcCreditApplyInfoSet = new UmcCreditApplyInfoQryBo();
        umcCreditApplyInfoSet.setApplyStatus(reqBo.getApplyStatus());
        umcCreditApplyInfoSet.setUpdateTime(new Date());
        umcCreditApplyInfoSet.setUpdateOperId(reqBo.getUpdateOperId());
        umcCreditApplyInfoSet.setUpdateOperName(reqBo.getUpdateOperName());
        UmcCreditApplyInfoQryBo umcCreditApplyInfoWhere = new UmcCreditApplyInfoQryBo();
        umcCreditApplyInfoWhere.setApplyId(reqBo.getApplyId());
        try {
            this.iUmcCreditApplyInfoModel.updateCreditApplyInfo(umcCreditApplyInfoSet, umcCreditApplyInfoWhere);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5ba1\u6279\u4e3b\u8868\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new BaseBusinessException("100001", "\u4fee\u6539\u5ba1\u6279\u4e3b\u8868\u6570\u636e\u5931\u8d25");
        }
        return rspBo;
    }

    private void validate(UmcUpdateCreditApplyStatusReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getApplyId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u7533\u8bf7\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getApplyStatus())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u7533\u8bf7\u5355\u72b6\u6001]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getUpdateOperName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u4fee\u6539\u4eba\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUpdateOperId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u4fee\u6539\u4eba]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

